/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.p;
import com.tencent.liteav.base.util.t;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.j;
import com.tencent.liteav.videobase.utils.k;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.decoder.ExternalDecodeFactoryManager;
import com.tencent.liteav.videoconsumer.decoder.SoftwareVideoDecoder;
import com.tencent.liteav.videoconsumer.decoder.SpsInfo;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.ac;
import com.tencent.liteav.videoconsumer.decoder.ad;
import com.tencent.liteav.videoconsumer.decoder.ae;
import com.tencent.liteav.videoconsumer.decoder.ag;
import com.tencent.liteav.videoconsumer.decoder.ah;
import com.tencent.liteav.videoconsumer.decoder.ai;
import com.tencent.liteav.videoconsumer.decoder.aj;
import com.tencent.liteav.videoconsumer.decoder.ak;
import com.tencent.liteav.videoconsumer.decoder.aq;
import com.tencent.liteav.videoconsumer.decoder.as;
import com.tencent.liteav.videoconsumer.decoder.at;
import com.tencent.liteav.videoconsumer.decoder.b;
import com.tencent.liteav.videoconsumer.decoder.d;
import com.tencent.liteav.videoconsumer.decoder.q;
import com.tencent.liteav.videoconsumer.decoder.x;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;

public final class VideoDecodeController
implements at {
    @NonNull
    final IVideoReporter a;
    @NonNull
    final d b;
    @NonNull
    final aq c;
    final boolean d;
    public com.tencent.liteav.base.util.b e;
    t f;
    a g;
    Object h;
    com.tencent.liteav.videobase.b.e i;
    boolean j = false;
    as k;
    JSONArray l;
    private VideoDecoderDef.ConsumerScene q = VideoDecoderDef.ConsumerScene.a;
    final AtomicInteger m = new AtomicInteger(0);
    final j n = new j(1);
    ServerVideoConsumerConfig o;
    final k p;
    private final d.d r = x.a();

    public VideoDecodeController(@NonNull IVideoReporter reporter) {
        this.a = reporter;
        this.d = false;
        b.a.a();
        boolean bl = ExternalDecodeFactoryManager.a();
        b.a.a();
        this.b = new d(this.r, reporter, bl, com.tencent.liteav.videoconsumer.decoder.b.b());
        this.c = new aq(reporter);
        this.p = new k("decoder" + this.hashCode());
    }

    final void f() {
        LiteavLog.i("VideoDecodeController", "initializeEGLCoreInternal()");
        this.i = new com.tencent.liteav.videobase.b.e();
        try {
            this.i.a(this.h, null, 128, 128);
            this.p.a((e)null);
            return;
        }
        catch (f f2) {
            LiteavLog.e("VideoDecodeController", "create egl core failed.", f2);
            this.a.notifyWarning(h.c.h, "VideoDecode: create EGLCore failed", new Object[0]);
            this.i = null;
            return;
        }
    }

    final void g() {
        LiteavLog.i("VideoDecodeController", "uninitializeEGLCoreInternal()");
        if (this.i == null) {
            return;
        }
        this.p.a();
        try {
            this.i.b();
            this.i.e();
        }
        catch (f f2) {
            LiteavLog.e("VideoDecodeController", "destroy egl core failed.", f2);
            this.a.notifyWarning(h.c.s, "VideoDecode: destroy EGLCore failed", new Object[0]);
        }
        this.i = null;
    }

    public final void a(Object object) {
        LiteavLog.i("VideoDecodeController", "setSharedEGLContext(object:" + object + ", mEGLCore: " + this.i + ")");
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ak.a(videoDecodeController, object));
    }

    public final void a(VideoDecoderDef.ConsumerScene consumerScene) {
        this.b.w = this.q = consumerScene;
    }

    final void a(EncodedVideoFrame encodedVideoFrame, as.a a2) {
        if (this.i == null) {
            LiteavLog.e("VideoDecodeController", "updateDecoderType mEGLCore is null");
            return;
        }
        long l2 = SystemClock.elapsedRealtime();
        this.i();
        SpsInfo spsInfo = this.r.a(encodedVideoFrame.isH265(), encodedVideoFrame.data);
        if (a2 == as.a.a) {
            this.k = new SoftwareVideoDecoder(this.a);
        } else {
            boolean bl = this.b.v;
            this.k = encodedVideoFrame.videoFormat != null ? new q(encodedVideoFrame.videoFormat, bl, this.l, this.a) : new q(new p(spsInfo.width, spsInfo.height), encodedVideoFrame.isH265(), bl, this.l, this.a);
        }
        this.k.initialize();
        this.k.setServerConfig(this.o);
        this.k.setScene(this.q);
        this.k.start(this.i.d(), this);
        this.m.set(0);
        LiteavLog.d("VideoDecodeController", "open decoder cost time: " + (SystemClock.elapsedRealtime() - l2));
        LiteavLog.i("VideoDecodeController", "update decoder type to " + (Object)((Object)a2) + ", video " + spsInfo);
        boolean bl = encodedVideoFrame.isH265();
        as.a a3 = this.k.getDecoderType();
        aq aq2 = this.c;
        this.c.e = a3;
        if (bl && a3 == as.a.a) {
            a3 = as.a.c;
        }
        VideoDecoderDef.DecoderProperty decoderProperty = new VideoDecoderDef.DecoderProperty(a3, bl ? CodecType.b : CodecType.a);
        aq2.a.updateStatus(com.tencent.liteav.videobase.videobase.i.L, decoderProperty);
    }

    final void a(EncodedVideoFrame encodedVideoFrame) {
        EncodedVideoFrame encodedVideoFrame2 = encodedVideoFrame;
        aq aq2 = this.c;
        if (!aq2.i && encodedVideoFrame2.isIDRFrame()) {
            aq2.g = SystemClock.elapsedRealtime();
            aq2.i = true;
            aq2.a.notifyEvent(h.b.A, "Start decode first frame", new Object[0]);
            LiteavLog.d("VideoDecodeControllerStatistics", "received first I frame.");
        }
        if (!aq2.f) {
            ++aq2.h;
        }
        long l2 = encodedVideoFrame2.pts;
        aq.a a2 = aq2.b;
        if (a2.e.isEmpty()) {
            a2.d = SystemClock.elapsedRealtime();
        }
        a2.e.addLast(l2);
        if (this.k != null) {
            this.m.incrementAndGet();
            this.k.decode(encodedVideoFrame);
        }
    }

    final as.a h() {
        if (this.k == null) {
            return null;
        }
        return this.k.getDecoderType();
    }

    final void i() {
        if (this.k != null) {
            this.k.stop();
            this.k.uninitialize();
            this.k = null;
        }
        this.n.b();
    }

    public final boolean a(Runnable runnable) {
        boolean bl = true;
        com.tencent.liteav.base.util.b b2 = this.e;
        if (b2 != null && b2.getLooper().getThread().isAlive()) {
            if (Looper.myLooper() == b2.getLooper()) {
                runnable.run();
            } else {
                bl = b2.post(runnable);
            }
        } else {
            bl = false;
        }
        if (!bl) {
            LiteavLog.w("VideoDecodeController", "runnable:" + runnable + " is failed to post, handler:" + (Object)((Object)b2));
        }
        return bl;
    }

    final boolean j() {
        try {
            this.i.a();
            return true;
        }
        catch (f f2) {
            LiteavLog.e("VideoDecodeController", "make current failed.", f2);
            return false;
        }
    }

    @Override
    public final void a(PixelFrame pixelFrame, long l2) {
        long l3 = pixelFrame.getTimestamp();
        this.n.a(pixelFrame);
        VideoDecodeController videoDecodeController = this;
        if (!videoDecodeController.a(ac.a(videoDecodeController, l3, l2))) {
            this.n.b(pixelFrame);
        }
    }

    @Override
    public final void a() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ad.a(videoDecodeController));
    }

    @Override
    public final void b() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ae.a(videoDecodeController));
    }

    @Override
    public final void c() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ag.a(videoDecodeController));
    }

    @Override
    public final void d() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ah.a(videoDecodeController));
    }

    @Override
    public final void e() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ai.a(videoDecodeController));
    }

    @Override
    public final void a(boolean bl) {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(aj.a(videoDecodeController, bl));
    }

    public static enum DecodeStrategy {
        a(0),
        b(1),
        c(2),
        d(3);

        private final int mValue;
        private static final DecodeStrategy[] e;

        private DecodeStrategy(int mValue) {
            this.mValue = mValue;
        }

        public static DecodeStrategy a(int n2) {
            DecodeStrategy[] decodeStrategyArray = e;
            int n3 = e.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                DecodeStrategy decodeStrategy = decodeStrategyArray[i2];
                if (decodeStrategy.mValue != n2) continue;
                return decodeStrategy;
            }
            return a;
        }

        static {
            e = DecodeStrategy.values();
        }
    }

    public static interface a
    extends at {
    }
}

