/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.c;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoconsumer.renderer.a;
import com.tencent.liteav.videoconsumer.renderer.h;
import com.tencent.liteav.videoconsumer.renderer.i;
import com.tencent.liteav.videoconsumer.renderer.j;
import com.tencent.liteav.videoconsumer.renderer.k;
import com.tencent.liteav.videoconsumer.renderer.l;
import com.tencent.liteav.videoconsumer.renderer.m;
import com.tencent.liteav.videoconsumer.renderer.n;
import com.tencent.liteav.videoconsumer.renderer.o;
import com.tencent.liteav.videoconsumer.renderer.p;
import com.tencent.liteav.videoconsumer.renderer.q;
import com.tencent.liteav.videoconsumer.renderer.r;
import com.tencent.liteav.videoconsumer.renderer.s;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class g
extends VideoRenderInterface
implements a.a {
    @NonNull
    private final b a;
    @NonNull
    private final IVideoReporter b;
    @NonNull
    private final a c;
    private DisplayTarget d;
    private Surface e = null;
    @NonNull
    private final com.tencent.liteav.base.util.p f = new com.tencent.liteav.base.util.p();
    private boolean g = false;
    private Object h;
    private com.tencent.liteav.videobase.b.e i = null;
    private final c j = new c();
    private com.tencent.liteav.videobase.frame.j k;
    private final com.tencent.liteav.videobase.utils.j l = new com.tencent.liteav.videobase.utils.j(1);
    private e m;
    private GLConstants.GLScaleType n = GLConstants.GLScaleType.b;
    private Rotation o = Rotation.a;
    private boolean p = false;
    private boolean q = false;
    private volatile boolean r = false;
    private boolean s = false;
    private TakeSnapshotListener t;
    private ExecutorService u;
    private VideoRenderListener v;
    private boolean w = false;

    public g(@NonNull Looper looper, @NonNull IVideoReporter iVideoReporter) {
        this.a = new b(looper);
        this.b = iVideoReporter;
        this.c = new a(this);
    }

    @Override
    public final void start(VideoRenderListener listener) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.h.a(g2, listener));
    }

    @Override
    public final void stop(boolean isNeedClear) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.l.a(g2, isNeedClear));
    }

    @Override
    public final void setDisplayView(DisplayTarget displayTarget, boolean isNeedClear) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.m.a(g2, displayTarget, isNeedClear));
    }

    @Override
    public final void takeSnapshot(TakeSnapshotListener listener) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.n.a(g2, listener));
    }

    @Override
    public final void setScaleType(GLConstants.GLScaleType scaleType) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.o.a(g2, scaleType));
    }

    @Override
    public final void setRenderRotation(Rotation rotation) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.p.a(g2, rotation));
    }

    @Override
    public final void setHorizontalMirror(boolean mirror) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.q.a(g2, mirror));
    }

    @Override
    public final void setVerticalMirror(boolean mirror) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.r.a(g2, mirror));
    }

    @Override
    public final void renderFrame(PixelFrame pixelFrame) {
        if (!this.r) {
            return;
        }
        if (pixelFrame == null) {
            LiteavLog.w("VideoRenderer", "renderFrame pixelFrame is null!");
            return;
        }
        if (!this.s) {
            this.s = true;
            LiteavLog.d("VideoRenderer", "VideoRender receive first frame!");
        }
        this.l.a(pixelFrame);
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.s.a(g2));
    }

    private void a(Runnable runnable) {
        if (Looper.myLooper() == this.a.getLooper()) {
            runnable.run();
            return;
        }
        this.a.post(runnable);
    }

    private void b() {
        if (this.i == null) {
            return;
        }
        LiteavLog.i("VideoRenderer", "uninitializeEGL %d %d*%d", this.e != null ? this.e.hashCode() : 0, this.f.a, this.f.b);
        try {
            this.i.a();
        }
        catch (f f2) {
            LiteavLog.e("VideoRenderer", "uninitializeEGL EGLCore makeCurrent failed.".concat(String.valueOf(f2)));
        }
        if (this.k != null) {
            this.k.a();
            this.k = null;
        }
        this.j.d();
        if (this.m != null) {
            this.m.a();
            this.m.b();
            this.m = null;
        }
        try {
            if (this.i != null) {
                this.i.e();
            }
        }
        catch (f f3) {
            LiteavLog.e("VideoRenderer", "uninitializeEGL error " + f3.toString());
            this.b.notifyWarning(h.c.f, "VideoRender: destroy EGLCore failed:" + f3.toString(), new Object[0]);
        }
        this.i = null;
    }

    private void a(PixelFrame pixelFrame, d d2, boolean bl, boolean bl2, Rotation rotation, GLConstants.GLScaleType gLScaleType) {
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        pixelFrame2.setRotation(Rotation.a((pixelFrame.getRotation().mValue + rotation.mValue) % 360));
        if (bl) {
            PixelFrame pixelFrame3 = pixelFrame2;
            pixelFrame3.setMirrorHorizontal(!pixelFrame3.isMirrorHorizontal());
        }
        if (bl2) {
            PixelFrame pixelFrame4 = pixelFrame2;
            pixelFrame4.setMirrorVertical(!pixelFrame4.isMirrorVertical());
        }
        if (rotation == Rotation.b || rotation == Rotation.d) {
            int n2 = pixelFrame2.getWidth();
            PixelFrame pixelFrame5 = pixelFrame2;
            pixelFrame5.setWidth(pixelFrame5.getHeight());
            pixelFrame2.setHeight(n2);
        }
        if (d2 == null) {
            PixelFrame pixelFrame6 = pixelFrame2;
            pixelFrame6.setMirrorVertical(!pixelFrame6.isMirrorVertical());
            if (pixelFrame2.getRotation() != Rotation.a && pixelFrame2.getRotation() != Rotation.c) {
                PixelFrame pixelFrame7 = pixelFrame2;
                pixelFrame7.setRotation(Rotation.a((pixelFrame7.getRotation().mValue + Rotation.c.mValue) % 360));
            }
        }
        this.k.a(pixelFrame2, gLScaleType, d2);
    }

    private void b(Surface surface, int n2, int n3, boolean bl) {
        this.b();
        if (bl && this.e != null) {
            this.e.release();
        }
        this.e = surface;
        this.f.b = n3;
        this.f.a = n2;
        if (this.e != null) {
            this.b.updateStatus(com.tencent.liteav.videobase.videobase.i.u, n2 << 16 | n3);
        }
        if (this.v != null) {
            this.v.onRenderTargetSizeChanged(n2, n3);
        }
    }

    @Override
    public final void a(Surface surface, int n2, int n3, boolean bl) {
        g g2 = this;
        g2.a(com.tencent.liteav.videoconsumer.renderer.j.a(g2, surface, n2, n3, bl));
    }

    @Override
    public final void a() {
        this.a.a(com.tencent.liteav.videoconsumer.renderer.k.a(this));
    }

    static /* synthetic */ void a(g g2) {
        LiteavLog.i("VideoRenderer", "onSurfaceDestroy " + g2.e);
        g2.b(null, 0, 0, g2.g);
    }

    static /* synthetic */ void a(g g2, Surface surface, int n2, int n3, boolean bl) {
        LiteavLog.i("VideoRenderer", "setDisplaySurface %s size: %dx%d, old_surface: %s", surface, n2, n3, g2.e);
        if (g2.e != surface || n2 != g2.f.a || n3 != g2.f.b) {
            g2.b(surface, n2, n3, g2.g);
            g2.g = bl;
            return;
        }
        LiteavLog.d("VideoRenderer", "setDisplaySurface same surface!");
    }

    static /* synthetic */ void a(ByteBuffer byteBuffer, int n2, int n3, TakeSnapshotListener takeSnapshotListener) {
        byteBuffer.position(0);
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        takeSnapshotListener.onComplete(bitmap);
    }

    static /* synthetic */ void a(g g2, boolean bl) {
        if (g2.q != bl) {
            LiteavLog.i("VideoRenderer", "setVerticalMirror ".concat(String.valueOf(bl)));
        }
        g2.q = bl;
    }

    static /* synthetic */ void b(g g2, boolean bl) {
        if (g2.p != bl) {
            LiteavLog.i("VideoRenderer", "setHorizontalMirror ".concat(String.valueOf(bl)));
        }
        g2.p = bl;
    }

    static /* synthetic */ void a(g g2, Rotation rotation) {
        LiteavLog.i("VideoRenderer", "setRenderRotation ".concat(String.valueOf((Object)rotation)));
        g2.o = rotation;
    }

    static /* synthetic */ void a(g g2, GLConstants.GLScaleType gLScaleType) {
        LiteavLog.i("VideoRenderer", "setScaleType ".concat(String.valueOf((Object)gLScaleType)));
        g2.n = gLScaleType;
    }

    static /* synthetic */ void a(g g2, TakeSnapshotListener takeSnapshotListener) {
        LiteavLog.i("VideoRenderer", "takeSnapshot ");
        g2.t = takeSnapshotListener;
    }

    static /* synthetic */ void a(g g2, DisplayTarget displayTarget, boolean bl) {
        LiteavLog.i("VideoRenderer", "setDisplayView=" + displayTarget + ",isNeedClear=" + bl);
        boolean bl2 = CommonUtil.equals(g2.d, displayTarget);
        if (!bl2) {
            g2.w = true;
        }
        if (bl && !bl2 && g2.d != null) {
            g2.d.hideAll();
        }
        g2.d = displayTarget;
        if (g2.d != null) {
            g2.d.showAll();
        }
        g2.c.a(displayTarget);
    }

    static /* synthetic */ void c(g g2, boolean bl) {
        LiteavLog.i("VideoRenderer", "Stop");
        if (!g2.r) {
            LiteavLog.w("VideoRenderer", "renderer is not started!");
            return;
        }
        g2.r = false;
        g2.t = null;
        g2.c.a((DisplayTarget)null);
        if (g2.d != null && bl) {
            g2.d.hideAll();
        }
        g2.l.b();
        g2.b();
        if (g2.g && g2.e != null) {
            g2.e.release();
            g2.g = false;
        }
        g2.e = null;
        g2.f.b = 0;
        g2.f.a = 0;
        if (g2.u != null) {
            g2.u.shutdown();
            g2.u = null;
        }
        g2.s = false;
    }

    static /* synthetic */ void a(g g2, VideoRenderListener videoRenderListener) {
        LiteavLog.i("VideoRenderer", "Start");
        if (g2.r) {
            LiteavLog.w("VideoRenderer", "renderer is started!");
            return;
        }
        g2.r = true;
        g2.v = videoRenderListener;
        g2.u = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        if (g2.d != null) {
            g g3 = g2;
            g3.setDisplayView(g3.d, true);
        }
    }

    static /* synthetic */ void b(g g2) {
        g g3 = g2;
        PixelFrame pixelFrame = g3.l.a();
        if (pixelFrame == null) {
            LiteavLog.d("VideoRenderer", "renderFrameInternal pixelFrame is null!");
            return;
        }
        Object object = pixelFrame;
        g g4 = g3;
        if (g4.i == null || !CommonUtil.equals(g4.h, ((PixelFrame)object).getGLContext())) {
            g3.b();
            object = pixelFrame.getGLContext();
            g4 = g3;
            if (g4.e != null) {
                try {
                    LiteavLog.i("VideoRenderer", "initializeEGL surface = " + g4.e + " ,mSurfaceSize = " + g4.f);
                    g4.i = new com.tencent.liteav.videobase.b.e();
                    g4.i.a(object, g4.e, g4.f.a, g4.f.b);
                    g4.h = object;
                    g4.i.a();
                    if (g4.k == null) {
                        g4.k = new com.tencent.liteav.videobase.frame.j(g4.f.a, g4.f.b);
                    }
                    if (g4.m == null) {
                        g4.m = new e();
                    }
                    g4.j.a();
                }
                catch (f f2) {
                    LiteavLog.e("VideoRenderer", "initializeEGL failed.", f2);
                    g4.i = null;
                    g4.b.notifyWarning(h.c.e, "VideoRender: create EGLCore fail:" + f2.toString(), new Object[0]);
                }
            }
        }
        if (g3.i == null) {
            pixelFrame.release();
            return;
        }
        try {
            g3.i.a();
        }
        catch (f f3) {
            LiteavLog.e("VideoRenderer", "EGLCore makeCurrent failed.".concat(String.valueOf(f3)));
        }
        OpenGlUtils.glViewport(0, 0, g3.f.a, g3.f.b);
        if (g3.t == null) {
            g3.a(pixelFrame, null, g3.p, g3.q, g3.o, g3.n);
        } else {
            d d2 = g3.m.a(g3.f.a, g3.f.b);
            if (d2 == null) {
                LiteavLog.w("VideoRenderer", "get FrameBuffer from pool return null!");
                pixelFrame.release();
                return;
            }
            g3.j.a(d2.a());
            g3.a(pixelFrame, d2, g3.p, g3.q, g3.o, g3.n);
            if (g3.f.a != 0 && g3.f.b != 0) {
                g3.j.b();
                g g5 = g3;
                int n2 = g3.f.b;
                int n3 = g5.f.a;
                g4 = g5;
                TakeSnapshotListener takeSnapshotListener = g5.t;
                if (takeSnapshotListener != null && g4.u != null) {
                    g4.t = null;
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3 * n2 * 4).order(ByteOrder.nativeOrder());
                    byteBuffer.position(0);
                    GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
                    try {
                        g4.u.execute(com.tencent.liteav.videoconsumer.renderer.i.a(byteBuffer, n3, n2, takeSnapshotListener));
                    }
                    catch (Exception exception) {
                        LiteavLog.w("VideoRenderer", "mExecutorService execute exception: " + exception.toString());
                    }
                }
                OpenGlUtils.bindFramebuffer(36160, 0);
            } else {
                LiteavLog.w("VideoRenderer", "snapshot when surface height or width is zero!");
            }
            g3.j.c();
            PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
            pixelFrame2.setPixelBufferType(GLConstants.PixelBufferType.b);
            pixelFrame2.setPixelFormatType(GLConstants.PixelFormatType.f);
            pixelFrame2.setTextureId(d2.a());
            g3.a(pixelFrame2, null, false, false, Rotation.a, GLConstants.GLScaleType.c);
            d2.release();
        }
        try {
            g3.i.c();
        }
        catch (f f4) {
            LiteavLog.e("VideoRenderer", "EGLCore swapBuffers failed.".concat(String.valueOf(f4)));
            g3.b.notifyWarning(h.c.g, "VideoRender: swapBuffer error:" + f4.toString(), new Object[0]);
        }
        if (g3.v != null) {
            g3.v.onRenderFrame(pixelFrame);
        }
        if (g3.w) {
            g3.b.notifyEvent(h.b.i, null, new Object[0]);
            g3.w = false;
        }
        pixelFrame.release();
    }
}

