/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.base.util.t;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.ar;
import java.util.Locale;
import java.util.Objects;

public final class VirtualCamera
extends ar {
    PixelFrame f;
    private t g;
    private VirtualCameraParams h;
    private boolean i = true;
    private boolean j = false;
    private final t.a k = new t.a(){

        @Override
        public final void a_() {
            CaptureSourceInterface.a a2 = VirtualCamera.this.d;
            if (a2 != null && VirtualCamera.this.c()) {
                if (VirtualCamera.this.f != null) {
                    VirtualCamera.this.f.setTimestamp(TimeUtil.a());
                }
                a2.a(VirtualCamera.this, VirtualCamera.this.f);
            }
        }
    };

    public VirtualCamera(@NonNull Looper looper, @NonNull IVideoReporter reporter) {
        super(looper, reporter);
    }

    @Override
    protected final void a(CaptureSourceInterface.CaptureParams captureParams) {
        this.h = new VirtualCameraParams((VirtualCameraParams)captureParams);
        this.a();
        this.b.notifyEvent(h.b.r, "Start virtual camera success params:" + this.h, new Object[0]);
    }

    private void a() {
        if (!this.i) {
            LiteavLog.e("VirtualCameraImpl", "virtual camera is started.");
            return;
        }
        this.i = false;
        Bitmap bitmap = this.h.a;
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)this.h.c, (int)this.h.d, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(bitmap).drawARGB(255, 0, 0, 0);
        }
        this.f = new PixelFrame();
        this.f.setPixelBufferType(GLConstants.PixelBufferType.b);
        this.f.setPixelFormatType(GLConstants.PixelFormatType.f);
        this.f.setWidth(bitmap.getWidth());
        this.f.setHeight(bitmap.getHeight());
        this.f.setTextureId(OpenGlUtils.loadTexture(bitmap, -1, false));
        if (bitmap != this.h.a) {
            bitmap.recycle();
        }
        this.g = new t(this.a.getLooper(), this.k);
        this.g.a(0, 1000 / this.h.b);
    }

    @Override
    protected final void b() {
        this.e();
        this.j = false;
        this.b.notifyEvent(h.b.s, "Stop virtual camera success", new Object[0]);
    }

    private void e() {
        if (this.g != null) {
            this.g.a();
            this.g = null;
        }
        if (this.f != null) {
            OpenGlUtils.deleteTexture(this.f.getTextureId());
            this.f = null;
        }
        this.i = true;
    }

    @Override
    public final void pause() {
        this.e();
    }

    @Override
    public final void resume() {
        this.a();
        if (this.j) {
            this.j = false;
            this.b.notifyEvent(h.b.q, "Start virtual camera success params:" + this.h, new Object[0]);
        }
    }

    @Override
    public final void updateParams(CaptureSourceInterface.CaptureParams params) {
        this.h = new VirtualCameraParams((VirtualCameraParams)params);
        if (this.i) {
            this.j = true;
            return;
        }
        this.e();
        this.a();
        this.b.notifyEvent(h.b.q, "Start virtual camera success params:" + this.h, new Object[0]);
    }

    public static class VirtualCameraParams
    extends CaptureSourceInterface.CaptureParams {
        public Bitmap a;

        public VirtualCameraParams() {
        }

        public VirtualCameraParams(VirtualCameraParams params) {
            super(params);
            this.a = params.a;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof VirtualCameraParams)) {
                return false;
            }
            VirtualCameraParams virtualCameraParams = (VirtualCameraParams)obj;
            return super.equals(obj) && Objects.equals(this.a, virtualCameraParams.a);
        }

        @Override
        @NonNull
        public String toString() {
            return String.format(Locale.ENGLISH, "%s, hasBitmap: %b", super.toString(), this.a != null);
        }
    }
}

