/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.consumer;

import android.os.HandlerThread;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.consumer.aa;
import com.tencent.liteav.videoconsumer.consumer.ab;
import com.tencent.liteav.videoconsumer.consumer.ac;
import com.tencent.liteav.videoconsumer.consumer.j;
import com.tencent.liteav.videoconsumer.consumer.l;
import com.tencent.liteav.videoconsumer.consumer.m;
import com.tencent.liteav.videoconsumer.consumer.n;
import com.tencent.liteav.videoconsumer.consumer.o;
import com.tencent.liteav.videoconsumer.consumer.p;
import com.tencent.liteav.videoconsumer.consumer.q;
import com.tencent.liteav.videoconsumer.consumer.r;
import com.tencent.liteav.videoconsumer.consumer.s;
import com.tencent.liteav.videoconsumer.consumer.t;
import com.tencent.liteav.videoconsumer.consumer.u;
import com.tencent.liteav.videoconsumer.consumer.v;
import com.tencent.liteav.videoconsumer.consumer.w;
import com.tencent.liteav.videoconsumer.consumer.y;
import com.tencent.liteav.videoconsumer.consumer.z;
import com.tencent.liteav.videoconsumer.decoder.VideoDecodeController;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.ad;
import com.tencent.liteav.videoconsumer.decoder.b;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;

@JNINamespace(value="liteav::video")
public class VideoConsumerProxy {
    private final j mConsumer;

    @CalledByNative
    public VideoConsumerProxy(@NonNull IVideoReporter reporter) {
        this.mConsumer = new j(reporter);
    }

    @CalledByNative
    public void setServerConfig(ServerVideoConsumerConfig config) {
        j j2 = this.mConsumer;
        ServerVideoConsumerConfig serverVideoConsumerConfig = config;
        j2.a(u.a(j2, serverVideoConsumerConfig), "setServerConfig", true);
    }

    @CalledByNative
    public void start() {
        j j2 = this.mConsumer;
        j2.a(w.a(j2), "Start", false);
    }

    @CalledByNative
    public void stop(boolean isNeedClear) {
        this.mConsumer.a(isNeedClear);
    }

    @CalledByNative
    public void pause() {
        j j2 = this.mConsumer;
        j2.a(y.a(j2), "pause", false);
    }

    @CalledByNative
    public void resume() {
        j j2 = this.mConsumer;
        j2.a(z.a(j2), "resume", false);
    }

    @CalledByNative
    public void appendNALPacket(EncodedVideoFrame packet) {
        EncodedVideoFrame encodedVideoFrame = packet;
        j j2 = this.mConsumer;
        if (encodedVideoFrame == null || encodedVideoFrame.data == null) {
            LiteavLog.w(j2.a, "packet or packet.data is null,packet={%s}", encodedVideoFrame);
            return;
        }
        j j3 = j2;
        j3.a(aa.a(j3, encodedVideoFrame), "appendNALPacket", false);
    }

    @CalledByNative
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
        j j2 = this.mConsumer;
        VideoDecoderDef.ConsumerScene consumerScene = scene;
        j2.a(ab.a(j2, consumerScene), "setScene", false);
    }

    @CalledByNative
    public void setRenderMirrorEnabled(boolean enabled) {
        j j2 = this.mConsumer;
        j2.a(ac.a(j2, enabled), "setRenderMirrorEnabled", true);
    }

    @CalledByNative
    public void setRenderRotation(Rotation rotation) {
        j j2 = this.mConsumer;
        Rotation rotation2 = rotation;
        j2.a(l.a(j2, rotation2), "setRenderRotation", true);
    }

    @CalledByNative
    public void setScaleType(GLConstants.GLScaleType scaleType) {
        j j2 = this.mConsumer;
        GLConstants.GLScaleType gLScaleType = scaleType;
        j2.a(m.a(j2, gLScaleType), "setScaleType", true);
    }

    @CalledByNative
    public void setDecoderStrategy(VideoDecodeController.DecodeStrategy decodeStrategy) {
        j j2 = this.mConsumer;
        VideoDecodeController.DecodeStrategy decodeStrategy2 = decodeStrategy;
        j2.a(n.a(j2, decodeStrategy2), "setDecoderType", true);
    }

    @CalledByNative
    public void setDisplayTarget(DisplayTarget target) {
        j j2 = this.mConsumer;
        DisplayTarget displayTarget = target;
        j2.a(o.a(j2, displayTarget), "setDisplayTarget", true);
    }

    @CalledByNative
    public void takeSnapshot(SnapshotSourceType sourceType, TakeSnapshotListener listener) {
        j j2 = this.mConsumer;
        TakeSnapshotListener takeSnapshotListener = listener;
        SnapshotSourceType snapshotSourceType = sourceType;
        j2.a(p.a(j2, snapshotSourceType, takeSnapshotListener), "takeSnapshot", true);
    }

    @CalledByNative
    public void setHWDecoderDeviceRelatedParams(String params) {
        String string = params;
        j j2 = this.mConsumer;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            j j3 = j2;
            j3.a(q.a(j3, string), "setHWDecoderDeviceRelatedParams", true);
        }
    }

    @CalledByNative
    public void setCustomRenderListener(GLConstants.PixelFormatType formatType, GLConstants.PixelBufferType bufferType, VideoRenderListener listener) {
        j j2 = this.mConsumer;
        VideoRenderListener videoRenderListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = formatType;
        j2.a(r.a(j2, pixelFormatType, pixelBufferType, videoRenderListener), "setCustomRenderListener", false);
    }

    @CalledByNative
    public void setSharedEGLContext(Object sharedContext) {
        Object object = sharedContext;
        j j2 = this.mConsumer;
        LiteavLog.i(j2.a, "setSharedEGLContext(object:" + object + ")");
        j j3 = j2;
        j3.a(s.a(j3, object), "setSharedEGLContext", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void initialize() {
        j j2;
        j j3 = j2 = this.mConsumer;
        synchronized (j2) {
            if (j2.b != null) {
                LiteavLog.w(j2.a, "videoConsumer is initialized!");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            LiteavLog.i(j2.a, "initialize videoConsumer");
            HandlerThread handlerThread = new HandlerThread("VideoConsumer_" + j2.hashCode());
            handlerThread.start();
            j2.b = new b(handlerThread.getLooper(), t.a(j2));
            j j4 = j2;
            j4.a(v.a(j4), "initialize", false);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @CalledByNative
    public void uninitialize() {
        j j2 = this.mConsumer;
        j2.a(false);
        j2.a(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                LiteavLog.i(j.this.a, "uninitialize videoConsumer");
                if (j.this.d != null) {
                    j.this.d.setDisplayView(null, false);
                    j.this.d = null;
                }
                j.this.e = null;
                if (j.this.f != null) {
                    VideoDecodeController videoDecodeController = j.this.f;
                    LiteavLog.i(videoDecodeController.a, "uninitialize");
                    VideoDecodeController videoDecodeController2 = videoDecodeController;
                    videoDecodeController2.a(new com.tencent.liteav.videoconsumer.decoder.ac(videoDecodeController2));
                    videoDecodeController2 = videoDecodeController;
                    videoDecodeController2.a(new ad(videoDecodeController2));
                    VideoDecodeController videoDecodeController3 = videoDecodeController;
                    synchronized (videoDecodeController3) {
                        if (videoDecodeController.f != null) {
                            videoDecodeController.f.a();
                            videoDecodeController.f = null;
                        }
                    }
                    j.this.f = null;
                }
                j.this.u = null;
                j.this.i = null;
                j.this.g = null;
                j.this.h = null;
                j.5 var1_5 = this;
                synchronized (var1_5) {
                    if (j.this.b != null) {
                        j.this.b.a();
                        j.this.b = null;
                    }
                    return;
                }
            }
        }, "uninitialize", false);
    }

    @CalledByNative
    public long getCurrentRenderTimeStamp() {
        return this.mConsumer.v.get();
    }

    @CalledByNative
    public static VideoDecoderDef.DecodeAbility getDecodeAbility() {
        return b.a.a().a;
    }
}

