/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.frame.k;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.au;
import com.tencent.liteav.videoconsumer.decoder.av;
import com.tencent.liteav.videoconsumer.decoder.p;
import com.tencent.liteav.videoconsumer.decoder.r;
import com.tencent.liteav.videoconsumer.decoder.s;
import com.tencent.liteav.videoconsumer.decoder.t;
import com.tencent.liteav.videoconsumer.decoder.u;
import com.tencent.liteav.videoconsumer.decoder.v;
import com.tencent.liteav.videoconsumer.decoder.w;
import com.tencent.liteav.videoconsumer.decoder.x;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class q
implements SurfaceTexture.OnFrameAvailableListener,
au {
    private String a = "HardwareVideoDecoder";
    @NonNull
    private final com.tencent.liteav.base.util.p b;
    @NonNull
    private final IVideoReporter c;
    private final JSONArray d;
    private final String e;
    private volatile b f;
    private MediaCodec g = null;
    private av h;
    private final MediaCodec.BufferInfo i = new MediaCodec.BufferInfo();
    private EncodedVideoFrame j = null;
    private boolean k = true;
    private com.tencent.liteav.videobase.b.e l;
    private int m = -1;
    private l n;
    private SurfaceTexture o;
    private Surface p;
    private VideoDecoderDef.ConsumerScene q = VideoDecoderDef.ConsumerScene.a;
    private boolean r = false;
    private final p s = new p();
    private boolean t = false;
    private MediaFormat u;
    private j v;
    private e w;
    private final boolean x;

    public q(@NonNull com.tencent.liteav.base.util.p p2, boolean bl, boolean bl2, @Nullable JSONArray jSONArray, @NonNull IVideoReporter iVideoReporter) {
        this(p2, bl ? "video/hevc" : "video/avc", bl2, jSONArray, iVideoReporter);
    }

    public q(@NonNull MediaFormat mediaFormat, boolean bl, @Nullable JSONArray jSONArray, @NonNull IVideoReporter iVideoReporter) {
        this(new com.tencent.liteav.base.util.p(mediaFormat.getInteger("width"), mediaFormat.getInteger("height")), mediaFormat.getString("mime"), bl, jSONArray, iVideoReporter);
        this.u = mediaFormat;
    }

    private q(@NonNull com.tencent.liteav.base.util.p p2, String string, boolean bl, @Nullable JSONArray jSONArray, @NonNull IVideoReporter iVideoReporter) {
        this.b = new com.tencent.liteav.base.util.p(p2);
        this.e = string;
        this.c = iVideoReporter;
        this.d = jSONArray;
        this.x = bl;
        this.a = this.a + "_" + this.hashCode();
        LiteavLog.i(this.a, "create decoder isLowLatencyEnabled:" + this.x + ", format: " + this.u + " , params: " + jSONArray);
    }

    @Override
    public final void initialize() {
        HandlerThread handlerThread = new HandlerThread("HardwareVideoDecoder_" + this.hashCode());
        handlerThread.start();
        this.f = new b(handlerThread.getLooper());
    }

    @Override
    public final void uninitialize() {
        if (this.f != null) {
            LiteavLog.i(this.a, "uninitialize quitLooper");
            this.f.a();
        }
    }

    @Override
    public final void setScene(VideoDecoderDef.ConsumerScene scene) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.r.a(q2, scene));
    }

    @Override
    public final void start(Object glContext, av listener) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.s.a(q2, glContext, listener));
    }

    private boolean a(Object object) {
        this.l = new com.tencent.liteav.videobase.b.e();
        try {
            this.l.a(object, null, 128, 128);
            this.l.a();
        }
        catch (f f2) {
            LiteavLog.e(this.a, "create EGLCore failed.", f2);
            this.a(h.c.h, "VideoDecode: create EGLCore failed errorCode:" + f2.mErrorCode, new Object[0]);
            return false;
        }
        this.m = OpenGlUtils.generateTextureOES();
        this.n = new l();
        try {
            this.o = new SurfaceTexture(this.m);
            this.p = new Surface(this.o);
            this.o.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            LiteavLog.e(this.a, "create SurfaceTexture failed.", outOfResourcesException);
            this.a(h.c.k, "VideoDecode: insufficient resource, Start decoder failed:" + outOfResourcesException.getMessage(), new Object[0]);
            return false;
        }
        LiteavLog.i(this.a, "initialize gl components");
        return true;
    }

    private boolean a(a a2, boolean bl) {
        MediaFormat mediaFormat;
        q q2 = this;
        MediaFormat mediaFormat2 = mediaFormat = q2.u == null ? MediaFormat.createVideoFormat((String)q2.e, (int)q2.b.a, (int)q2.b.b) : q2.u;
        if (bl) {
            q2 = mediaFormat;
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 30) {
                q2.setInteger("low-latency", 1);
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("qcom")) {
                q2.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
                q2.setInteger("vendor.qti-ext-dec-picture-order.enable", 1);
            } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 29 && LiteavSystemInfo.getHardware().toLowerCase().contains("kirin")) {
                q2.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-req", 1);
                q2.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-rdy", -1);
            } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("exynos")) {
                q2.setInteger("vendor.rtc-ext-dec-low-latency.enable", 1);
            }
        }
        JSONArray jSONArray = this.d;
        q2 = mediaFormat;
        if (jSONArray != null) {
            try {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i2);
                    q2.setInteger(jSONObject.optString("key"), jSONObject.optInt("value"));
                }
            }
            catch (JSONException jSONException) {
                LiteavLog.e("HardwareVideoDecoder", "set MediaCodec device related params failed.", jSONException);
            }
        }
        LiteavLog.i(this.a, "mediaFormat:".concat(String.valueOf(mediaFormat)));
        try {
            String string = mediaFormat.getString("mime");
            a2.a = MediaCodec.createDecoderByType((String)string);
            a2.a.configure(mediaFormat, this.p, null, 0);
            a2.a.setVideoScalingMode(1);
            a2.a.start();
            LiteavLog.i(this.a, "Start MediaCodec success.");
            return true;
        }
        catch (Exception exception) {
            LiteavLog.e(this.a, "Start MediaCodec failed.", exception);
            this.a(a2.a);
            a2.a = null;
            h.c c2 = h.c.m;
            String string = "VideoDecode: Start decoder failed";
            if (exception instanceof IllegalArgumentException) {
                c2 = h.c.i;
                string = "VideoDecode: illegal argument, Start decoder failed";
            } else if (exception instanceof IllegalStateException) {
                c2 = h.c.j;
                string = "VideoDecode: illegal state, Start decoder failed";
            }
            a2.b = c2;
            a2.c = string;
            a2.d = exception;
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private void a(MediaCodec mediaCodec) {
        if (mediaCodec != null) {
            LiteavLog.i(this.a, "mediaCodec stop");
            mediaCodec.stop();
            try {
                LiteavLog.i(this.a, "mediaCodec release");
                mediaCodec.release();
                return;
            }
            catch (Exception exception) {
                LiteavLog.e(this.a, "release MediaCodec failed.", exception);
                return;
            }
            catch (Exception exception) {
                try {
                    LiteavLog.e(this.a, "Stop MediaCodec failed." + exception.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        LiteavLog.i(this.a, "mediaCodec release");
                        mediaCodec.release();
                    }
                    catch (Exception exception2) {
                        LiteavLog.e(this.a, "release MediaCodec failed.", exception2);
                    }
                    throw throwable;
                }
                try {
                    LiteavLog.i(this.a, "mediaCodec release");
                    mediaCodec.release();
                    return;
                }
                catch (Exception exception3) {
                    LiteavLog.e(this.a, "release MediaCodec failed.", exception3);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean decode(EncodedVideoFrame frame) {
        q q2 = this;
        synchronized (q2) {
            if (this.j != null || frame == null) {
                q q3 = this;
                q3.a(com.tencent.liteav.videoconsumer.decoder.t.a(q3));
                return false;
            }
            this.j = frame;
            q q4 = this;
            q4.a(com.tencent.liteav.videoconsumer.decoder.u.a(q4));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a() {
        if (this.g == null) {
            LiteavLog.w(this.a, "MediaCodec is stopped.");
            return;
        }
        try {
            EncodedVideoFrame encodedVideoFrame;
            MediaFormat mediaFormat;
            int n2;
            q q2;
            while (this.k) {
                boolean bl;
                block43: {
                    q2 = this;
                    for (int i2 = 0; i2 < 3 && (n2 = q2.g.dequeueOutputBuffer(q2.i, TimeUnit.MILLISECONDS.toMicros(10L))) != -1; ++i2) {
                        q q3;
                        if (n2 == -3) {
                            LiteavLog.i(q2.a, "on output buffers changed");
                            continue;
                        }
                        if (n2 == -2) {
                            q3 = q2;
                            mediaFormat = q3.g.getOutputFormat();
                            LiteavLog.i(q3.a, "decode output format changed: ".concat(String.valueOf(mediaFormat)));
                            int n3 = Math.abs(mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left")) + 1;
                            int n4 = Math.abs(mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top")) + 1;
                            int n5 = mediaFormat.getInteger("width");
                            int n6 = mediaFormat.getInteger("height");
                            LiteavLog.i(q3.a, "cropWidth: %d, cropHeight: %d, frameWidth: %d, frameHeight: %d", n3, n4, n5, n6);
                            continue;
                        }
                        if (n2 >= 0) {
                            q2.k = false;
                            q2.g.releaseOutputBuffer(n2, true);
                            if ((q2.i.flags & 4) != 0) {
                                LiteavLog.i(q2.a, "meet end of stream.");
                                q3 = q2;
                                if (q3.h != null) {
                                    q3.h.e();
                                }
                                q2.k = true;
                            }
                            bl = true;
                            break block43;
                        }
                        LiteavLog.d(q2.a, "dequeueOutputBuffer get invalid index: %d", n2);
                        break;
                    }
                    bl = false;
                }
                if (bl) continue;
            }
            q q4 = this;
            synchronized (q4) {
                encodedVideoFrame = this.j;
            }
            if (encodedVideoFrame == null) return;
            EncodedVideoFrame encodedVideoFrame2 = encodedVideoFrame;
            q2 = this;
            if (encodedVideoFrame2 == null || !encodedVideoFrame2.isEosFrame && (encodedVideoFrame2.data == null || encodedVideoFrame2.data.remaining() == 0)) {
                LiteavLog.w(q2.a, "receive empty buffer.");
            } else {
                MediaFormat mediaFormat2;
                mediaFormat = mediaFormat2 = q2.g.getInputBuffers();
                if (mediaFormat2 == null || ((MediaFormat)mediaFormat).length == 0) {
                    LiteavLog.e(q2.a, "get invalid input buffers.");
                    return;
                }
                n2 = q2.g.dequeueInputBuffer(10000L);
                if (n2 < 0) {
                    return;
                }
                if (!encodedVideoFrame2.isEosFrame) {
                    EncodedVideoFrame encodedVideoFrame3 = encodedVideoFrame2;
                    q q5 = q2;
                    if (encodedVideoFrame3.isIDRFrame() && encodedVideoFrame3.codecType == CodecType.a && q5.r && q5.q == VideoDecoderDef.ConsumerScene.c) {
                        byte[] byArray;
                        byte[] byArray2;
                        int[] nArray;
                        byte[] byArray3 = new byte[encodedVideoFrame3.data.remaining()];
                        encodedVideoFrame3.data.get(byArray3);
                        encodedVideoFrame3.data.rewind();
                        int[] nArray2 = nArray = new int[]{-1};
                        Object object = byArray3;
                        int n7 = 0;
                        while (n7 + 4 < ((byte[])object).length && (n7 = EncodedVideoFrame.getNextNALHeaderPos(n7, ByteBuffer.wrap((byte[])object))) >= 0) {
                            if ((object[n7] & 0x1F) != 7) continue;
                            nArray2[0] = n7;
                            break;
                        }
                        if (nArray2[0] < 0) {
                            byArray2 = null;
                        } else {
                            void var25_25;
                            n7 = ((byte[])object).length - nArray2[0];
                            int n8 = nArray2[0];
                            while (var25_25 + 3 < ((byte[])object).length) {
                                if (object[var25_25] == 0 && object[var25_25 + true] == 0 && object[var25_25 + 2] == 1 || object[var25_25] == 0 && object[var25_25 + true] == 0 && object[var25_25 + 2] == 0 && object[var25_25 + 3] == 1) {
                                    n7 = var25_25 - nArray2[0];
                                    break;
                                }
                                ++var25_25;
                            }
                            byte[] byArray4 = new byte[n7];
                            System.arraycopy(object, nArray2[0], byArray4, 0, byArray4.length);
                            byArray2 = byArray = byArray4;
                        }
                        if (byArray2 != null && nArray[0] >= 0) {
                            void var20_36;
                            Object var20_34 = null;
                            try {
                                void var25_32;
                                void var25_29;
                                byte[] byArray5;
                                nArray2 = byArray;
                                object = q5.s;
                                n7 = 0;
                                int[] nArray3 = nArray2;
                                byte[] byArray6 = new byte[nArray2.length];
                                int n9 = 0;
                                int n10 = 0;
                                while (n10 < nArray3.length) {
                                    if (n10 < nArray3.length - 3 && nArray3[n10] == 0 && nArray3[n10 + 1] == 0 && nArray3[n10 + 2] == 3 && nArray3[n10 + 3] <= 3) {
                                        byArray6[n9++] = nArray3[n10];
                                        byArray6[n9++] = nArray3[n10 + 1];
                                        n10 += 3;
                                        continue;
                                    }
                                    byArray6[n9++] = nArray3[n10];
                                    ++n10;
                                }
                                if (n9 != nArray3.length) {
                                    byte[] byArray7 = new byte[n9];
                                    System.arraycopy(byArray6, 0, byArray7, 0, n9);
                                    byArray5 = byArray7;
                                } else {
                                    byte[] byArray8;
                                    byArray5 = byArray8 = null;
                                }
                                if (byArray5 != null) {
                                    n7 = 1;
                                } else {
                                    int[] nArray4 = nArray2;
                                }
                                byte[] byArray9 = ((p)object).a(new ByteArrayInputStream((byte[])var25_29));
                                if (byArray9 != null && n7 != 0) {
                                    byte[] byArray10 = com.tencent.liteav.videoconsumer.decoder.p.a(byArray9);
                                }
                                void var20_35 = var25_32;
                            }
                            catch (Exception exception) {
                                LiteavLog.e(q5.a, "modify dec buffer error ", exception);
                            }
                            if (var20_36 != null) {
                                encodedVideoFrame3.data = ByteBuffer.allocateDirect(byArray3.length - byArray.length + ((void)var20_36).length);
                                if (nArray[0] > 0) {
                                    encodedVideoFrame3.data.put(byArray3, 0, nArray[0]);
                                }
                                encodedVideoFrame3.data.put((byte[])var20_36);
                                encodedVideoFrame3.data.put(byArray3, nArray[0] + byArray.length, byArray3.length - nArray[0] - byArray.length);
                                encodedVideoFrame3.data.rewind();
                            }
                        }
                    }
                    int n11 = encodedVideoFrame2.data.remaining();
                    mediaFormat2[n2].put(encodedVideoFrame2.data);
                    q2.g.queueInputBuffer(n2, 0, n11, TimeUnit.MILLISECONDS.toMicros(encodedVideoFrame2.pts), 0);
                    if (q2.h != null) {
                        q2.h.d();
                    }
                } else {
                    LiteavLog.i(q2.a, "feedDataToMediaCodec BUFFER_FLAG_END_OF_STREAM");
                    q2.g.queueInputBuffer(n2, 0, 0, 0L, 4);
                }
            }
            boolean bl = true;
            if (!bl) {
                return;
            }
            q4 = this;
            synchronized (q4) {
                if (this.j == encodedVideoFrame) {
                    this.j = null;
                }
            }
            com.tencent.liteav.videoconsumer.decoder.q.a(encodedVideoFrame);
            return;
        }
        catch (Exception exception) {
            LiteavLog.e(this.a, "decode failed.", exception);
            this.a(h.c.n, "VideoDecode: decode error, restart decoder message:" + exception.getMessage(), new Object[0]);
            return;
        }
    }

    private static void a(EncodedVideoFrame encodedVideoFrame) {
        if (encodedVideoFrame == null) {
            return;
        }
        encodedVideoFrame.release();
    }

    @Override
    public final void stop() {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.v.a(q2));
    }

    @Override
    public final au.a getDecoderType() {
        return au.a.b;
    }

    @Override
    public final void setServerConfig(ServerVideoConsumerConfig config) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.w.a(q2, config));
    }

    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.x.a(q2, surfaceTexture));
    }

    private PixelFrame a(PixelFrame pixelFrame) {
        Object object;
        int n2 = pixelFrame.getWidth();
        int n3 = pixelFrame.getHeight();
        if (this.v != null) {
            j j2 = this.v;
            object = new com.tencent.liteav.base.util.p(j2.a, j2.b);
            if (((com.tencent.liteav.base.util.p)object).a != n2 || ((com.tencent.liteav.base.util.p)object).b != n3) {
                this.v.a();
                this.v = null;
            }
        }
        if (this.v == null) {
            this.v = new j(n2, n3);
        }
        if (this.w == null) {
            this.w = new e();
        }
        OpenGlUtils.glViewport(0, 0, n2, n3);
        object = this.w.a(n2, n3);
        this.v.a(pixelFrame, GLConstants.GLScaleType.a, (d)object);
        PixelFrame pixelFrame2 = ((d)object).a(this.l.d());
        GLES20.glFinish();
        ((k)object).release();
        pixelFrame.release();
        return pixelFrame2;
    }

    private boolean b() {
        try {
            if (this.l != null) {
                this.l.a();
            }
            return true;
        }
        catch (f f2) {
            LiteavLog.e(this.a, "makeCurrent failed.", f2);
            return false;
        }
    }

    private void a(h.c c2, String string, Object ... objectArray) {
        this.c.notifyWarning(c2, string, objectArray);
        if (this.h != null) {
            this.h.a();
        }
    }

    private void a(Runnable runnable) {
        b b2 = this.f;
        if (b2 != null) {
            if (b2.getLooper() == Looper.myLooper()) {
                runnable.run();
                return;
            }
            b2.post(runnable);
        }
    }

    static /* synthetic */ void a(q q2, SurfaceTexture surfaceTexture) {
        if (q2.o == null || surfaceTexture != q2.o) {
            LiteavLog.i(q2.a, "mSurfaceTexture= " + q2.o + " ,surfaceTexture= " + surfaceTexture);
            return;
        }
        q2.b();
        l.b b2 = null;
        try {
            b2 = (l.b)q2.n.a();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w(q2.a, "textureholderpool obtain interrupted.");
        }
        b2.a(36197, q2.m, q2.b.a, q2.b.b);
        PixelFrame pixelFrame = b2.a(q2.l.d());
        if (pixelFrame.getMatrix() == null) {
            pixelFrame.setMatrix(new float[16]);
        }
        try {
            surfaceTexture.updateTexImage();
            surfaceTexture.getTransformMatrix(pixelFrame.getMatrix());
        }
        catch (Exception exception) {
            LiteavLog.w(q2.a, "updateTexImage exception: ".concat(String.valueOf(exception)));
        }
        q2.k = true;
        long l2 = TimeUnit.NANOSECONDS.toMillis(surfaceTexture.getTimestamp());
        if (l2 == 0L) {
            l2 = TimeUnit.MICROSECONDS.toMillis(q2.i.presentationTimeUs);
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() <= 22) {
            pixelFrame = q2.a(pixelFrame);
        }
        pixelFrame.setTimestamp(l2);
        q2.h.a(pixelFrame, l2);
        b2.release();
        pixelFrame.release();
        if (q2.t) {
            q q3 = q2;
            if (q3.h != null) {
                q3.h.c();
            }
            q2.t = false;
        }
    }

    static /* synthetic */ void a(q q2, ServerVideoConsumerConfig serverVideoConsumerConfig) {
        if (serverVideoConsumerConfig == null) {
            return;
        }
        q2.r = serverVideoConsumerConfig.enableVui;
    }

    static /* synthetic */ void a(q q2, Object object, av av2) {
        av av3 = av2;
        Object object2 = object;
        q q3 = q2;
        LiteavLog.i(q3.a, "Start internal");
        if (q3.l != null) {
            LiteavLog.w(q3.a, "Decoder already started.");
            return;
        }
        q3.h = av3;
        if (q3.a(object2)) {
            a a2 = new a(0);
            boolean bl = q3.a(a2, q3.x);
            if (bl || q3.a(a2, false)) {
                q3.g = a2.a;
                if (q3.h != null) {
                    q3.h.a(q3.x && bl);
                }
                q3.c.notifyEvent(h.b.B, "Start decoder success", new Object[0]);
                return;
            }
            q3.a(a2.b, "decoder config fail, message:" + a2.c + " exception:" + a2.d.getMessage(), new Object[0]);
        }
    }

    static /* synthetic */ void a(q q2, VideoDecoderDef.ConsumerScene consumerScene) {
        q2.q = consumerScene;
    }

    static /* synthetic */ void a(q q2) {
        q2.a();
    }

    static /* synthetic */ void b(q q2) {
        q2.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void c(q q2) {
        q q3;
        q q4 = q2;
        LiteavLog.i(q4.a, "Stop internal");
        if (q4.g != null) {
            q q5 = q4;
            q5.a(q5.g);
            q4.g = null;
        }
        q q6 = q3 = q4;
        synchronized (q3) {
            EncodedVideoFrame encodedVideoFrame = q3.j;
            q3.j = null;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            com.tencent.liteav.videoconsumer.decoder.q.a(encodedVideoFrame);
            q3 = q4;
            LiteavLog.i(q3.a, "uninitialize gl components");
            if (q3.b()) {
                if (q3.n != null) {
                    q3.n.b();
                }
                if (q3.p != null) {
                    q3.p.release();
                    q3.p = null;
                }
                if (q3.o != null) {
                    q3.o.release();
                    q3.o = null;
                }
                if (q3.w != null) {
                    q3.w.b();
                    q3.w = null;
                }
                if (q3.v != null) {
                    q3.v.a();
                    q3.v = null;
                }
                OpenGlUtils.deleteTexture(q3.m);
                q3.m = -1;
                try {
                    if (q3.l != null) {
                        q3.l.b();
                        q3.l.e();
                    }
                }
                catch (f f2) {
                    LiteavLog.e(q3.a, "destroy EGLCore failed.", f2);
                }
                q3.l = null;
            }
            q4.k = true;
            return;
        }
    }

    static final class a {
        public MediaCodec a = null;
        public h.c b = null;
        public String c = null;
        public Exception d = null;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

