/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;

@JNINamespace(value="liteav::video")
class NativeVideoRenderListener
implements VideoRenderListener {
    private long mNativeHandler;

    @CalledByNative
    public NativeVideoRenderListener(long nativeHandler) {
        this.mNativeHandler = nativeHandler;
    }

    @CalledByNative
    public synchronized void reset() {
        this.mNativeHandler = 0L;
    }

    @Override
    public synchronized void onRenderFrame(PixelFrame frame) {
        if (this.mNativeHandler != 0L) {
            NativeVideoRenderListener.nativeOnRenderFrame(this.mNativeHandler, frame);
        }
    }

    @Override
    public synchronized void onRenderTargetSizeChanged(int width, int height) {
        if (this.mNativeHandler != 0L) {
            NativeVideoRenderListener.nativeOnRenderTargetSizeChanged(this.mNativeHandler, width, height);
        }
    }

    private static native void nativeOnRenderFrame(long var0, PixelFrame var2);

    private static native void nativeOnRenderTargetSizeChanged(long var0, int var2, int var3);
}

