/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.producer;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.HandlerThread;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoproducer.capture.CameraCaptureParams;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.ScreenCapturer;
import com.tencent.liteav.videoproducer.capture.VirtualCamera;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.preprocessor.BeautyProcessor;
import com.tencent.liteav.videoproducer.preprocessor.VideoPreprocessor;
import com.tencent.liteav.videoproducer.producer.CustomVideoProcessListener;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import com.tencent.liteav.videoproducer.producer.aa;
import com.tencent.liteav.videoproducer.producer.ab;
import com.tencent.liteav.videoproducer.producer.ac;
import com.tencent.liteav.videoproducer.producer.ad;
import com.tencent.liteav.videoproducer.producer.ae;
import com.tencent.liteav.videoproducer.producer.af;
import com.tencent.liteav.videoproducer.producer.ag;
import com.tencent.liteav.videoproducer.producer.ah;
import com.tencent.liteav.videoproducer.producer.an;
import com.tencent.liteav.videoproducer.producer.as;
import com.tencent.liteav.videoproducer.producer.at;
import com.tencent.liteav.videoproducer.producer.au;
import com.tencent.liteav.videoproducer.producer.av;
import com.tencent.liteav.videoproducer.producer.aw;
import com.tencent.liteav.videoproducer.producer.f;
import com.tencent.liteav.videoproducer.producer.g;
import com.tencent.liteav.videoproducer.producer.h;
import com.tencent.liteav.videoproducer.producer.i;
import com.tencent.liteav.videoproducer.producer.j;
import com.tencent.liteav.videoproducer.producer.k;
import com.tencent.liteav.videoproducer.producer.l;
import com.tencent.liteav.videoproducer.producer.m;
import com.tencent.liteav.videoproducer.producer.n;
import com.tencent.liteav.videoproducer.producer.o;
import com.tencent.liteav.videoproducer.producer.p;
import com.tencent.liteav.videoproducer.producer.q;
import com.tencent.liteav.videoproducer.producer.r;
import com.tencent.liteav.videoproducer.producer.s;
import com.tencent.liteav.videoproducer.producer.t;
import com.tencent.liteav.videoproducer.producer.u;
import com.tencent.liteav.videoproducer.producer.v;
import com.tencent.liteav.videoproducer.producer.w;
import com.tencent.liteav.videoproducer.producer.x;
import com.tencent.liteav.videoproducer.producer.y;
import com.tencent.liteav.videoproducer.producer.z;

@JNINamespace(value="liteav::video")
public class VideoProducerProxy {
    private final f mProducer;

    @CalledByNative
    public VideoProducerProxy(boolean isEnterpriseProEnabled, @NonNull IVideoReporter reporter) {
        this(ContextUtils.getApplicationContext(), isEnterpriseProEnabled, reporter);
    }

    public VideoProducerProxy(@NonNull Context context, boolean isEnterpriseProEnabled, @NonNull IVideoReporter reporter) {
        this.mProducer = new f(context, isEnterpriseProEnabled, reporter);
    }

    @CalledByNative
    public static VideoEncoderDef.EncodeAbility getEncodeAbility() {
        return f.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void initialize() {
        f f2;
        f f3 = f2 = this.mProducer;
        synchronized (f2) {
            if (f2.f) {
                LiteavLog.w(f2.a, "videoproducer already initialized.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HandlerThread handlerThread = new HandlerThread("videoProducer_" + f2.hashCode());
            handlerThread.start();
            f2.e = new b(handlerThread.getLooper());
            f2.f = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            f2.e.a(g.a(f2));
            return;
        }
    }

    @CalledByNative
    public void uninitialize() {
        f f2 = this.mProducer;
        f2.a(r.a(f2));
    }

    @CalledByNative
    public BeautyProcessor getBeautyProcessor() {
        return this.mProducer.d;
    }

    @CalledByNative
    public void setServerConfig(ServerVideoProducerConfig serverConfig) {
        f f2 = this.mProducer;
        ServerVideoProducerConfig serverVideoProducerConfig = serverConfig;
        f2.a(ac.a(f2, serverVideoProducerConfig));
    }

    @CalledByNative
    public void startCapture(CaptureSourceInterface.SourceType sourceType, VideoProducerDef.ProducerMode mode, CaptureSourceInterface.CaptureParams captureParams) {
        CaptureSourceInterface.CaptureParams captureParams2 = captureParams;
        VideoProducerDef.ProducerMode producerMode = mode;
        CaptureSourceInterface.SourceType sourceType2 = sourceType;
        f f2 = this.mProducer;
        if (sourceType2 != CaptureSourceInterface.SourceType.b && sourceType2 != CaptureSourceInterface.SourceType.c && sourceType2 != CaptureSourceInterface.SourceType.d) {
            throw new IllegalArgumentException("type: ".concat(String.valueOf((Object)sourceType2)));
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.b && !(captureParams2 instanceof CameraCaptureParams)) {
            throw new IllegalArgumentException("CaptureParams is not CameraCaptureParams");
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.c) {
            if (!(captureParams2 instanceof ScreenCapturer.ScreenCaptureParams)) {
                throw new IllegalArgumentException("CaptureParams is not ScreenCaptureParams");
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
                f2.b.notifyError(h.a.g, "not support screen capture", new Object[0]);
            }
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.d && !(captureParams2 instanceof VirtualCamera.VirtualCameraParams)) {
            throw new IllegalArgumentException("CaptureParams is not VirtualCameraParams");
        }
        f f3 = f2;
        f3.a(an.a(f3, sourceType2, producerMode, captureParams2));
    }

    @CalledByNative
    public void stopCapture() {
        f f2 = this.mProducer;
        f2.a(as.a(f2));
    }

    @CalledByNative
    public void setCaptureParams(CaptureSourceInterface.SourceType sourceType, VideoProducerDef.ProducerMode mode, CaptureSourceInterface.CaptureParams captureParams) {
        f f2 = this.mProducer;
        CaptureSourceInterface.CaptureParams captureParams2 = captureParams;
        VideoProducerDef.ProducerMode producerMode = mode;
        CaptureSourceInterface.SourceType sourceType2 = sourceType;
        f2.a(at.a(f2, sourceType2, producerMode, captureParams2));
    }

    @CalledByNative
    public void setPausedImage(Bitmap bitmap, int framerate) {
        f f2 = this.mProducer;
        Bitmap bitmap2 = bitmap;
        f2.a(au.a(f2, bitmap2, framerate));
    }

    @CalledByNative
    public void pauseCapture() {
        f f2 = this.mProducer;
        f2.a(av.a(f2));
    }

    @CalledByNative
    public void resumeCapture() {
        f f2 = this.mProducer;
        f2.a(aw.a(f2));
    }

    @CalledByNative
    public void setDisplayView(DisplayTarget displayTarget) {
        f f2 = this.mProducer;
        DisplayTarget displayTarget2 = displayTarget;
        f2.a(h.a(f2, displayTarget2));
    }

    @CalledByNative
    public void startEncodeStream(VideoProducerDef.StreamType streamType, VideoEncodeParams params, VideoEncoderDef.VideoEncoderDataListener listener) {
        f f2 = this.mProducer;
        VideoEncoderDef.VideoEncoderDataListener videoEncoderDataListener = listener;
        VideoEncodeParams videoEncodeParams = params;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(i.a(f2, streamType2, videoEncodeParams, videoEncoderDataListener));
    }

    @CalledByNative
    public void stopEncodeStream(VideoProducerDef.StreamType streamType) {
        f f2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(j.a(f2, streamType2));
    }

    @CalledByNative
    public VideoPreprocessor getVideoPreprocessor() {
        return this.mProducer.c;
    }

    @CalledByNative
    public void setEncodeStrategy(VideoProducerDef.StreamType streamType, VideoEncoderDef.EncodeStrategy encodeStrategy) {
        f f2 = this.mProducer;
        VideoEncoderDef.EncodeStrategy encodeStrategy2 = encodeStrategy;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(k.a(f2, streamType2, encodeStrategy2));
    }

    @CalledByNative
    public void setEncodeMirrorEnabled(boolean enable) {
        f f2 = this.mProducer;
        f2.a(l.a(f2, enable));
    }

    @CalledByNative
    public void setEncodeRotation(Rotation rotation) {
        f f2 = this.mProducer;
        Rotation rotation2 = rotation;
        f2.a(m.a(f2, rotation2));
    }

    @CalledByNative
    public void setHWEncoderDeviceRelatedParams(String params) {
        String string = params;
        f f2 = this.mProducer;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            f f3 = f2;
            f3.a(n.a(f3, string));
        }
    }

    @CalledByNative
    public int setCameraFocusPosition(int x2, int y2) {
        f f2 = this.mProducer;
        f2.a(o.a(f2, x2, y2));
        return 0;
    }

    @CalledByNative
    public void setGSensorMode(VideoProducerDef.GSensorMode mode) {
        f f2 = this.mProducer;
        VideoProducerDef.GSensorMode gSensorMode = mode;
        f2.a(p.a(f2, gSensorMode));
    }

    @CalledByNative
    public void setHomeOrientation(VideoProducerDef.HomeOrientation mode) {
        f f2 = this.mProducer;
        VideoProducerDef.HomeOrientation homeOrientation = mode;
        f2.a(q.a(f2, homeOrientation));
    }

    @CalledByNative
    public void setEncodeParams(VideoProducerDef.StreamType streamType, VideoEncodeParams params, GLConstants.Orientation orientation) {
        f f2 = this.mProducer;
        GLConstants.Orientation orientation2 = orientation;
        VideoEncodeParams videoEncodeParams = params;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(s.a(f2, streamType2, orientation2, videoEncodeParams));
    }

    @CalledByNative
    public void setRPSIFrameFPS(VideoProducerDef.StreamType streamType, int fps) {
        f f2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(t.a(f2, fps, streamType2));
    }

    @CalledByNative
    public void setRPSNearestREFSize(VideoProducerDef.StreamType streamType, int referenceSize) {
        f f2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(u.a(f2, referenceSize, streamType2));
    }

    @CalledByNative
    public void ackRPSRecvFrameIndex(VideoProducerDef.StreamType streamType, int ackedFrameId, int bitmap) {
        f f2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(v.a(f2, streamType2, ackedFrameId, bitmap));
    }

    @CalledByNative
    public void requestKeyFrame(VideoProducerDef.StreamType streamType) {
        f f2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        f2.a(w.a(f2, streamType2));
    }

    @CalledByNative
    public void setRenderMirrorMode(GLConstants.MirrorMode mirrorMode) {
        f f2 = this.mProducer;
        GLConstants.MirrorMode mirrorMode2 = mirrorMode;
        f2.a(x.a(f2, mirrorMode2));
    }

    @CalledByNative
    public void setRenderScaleType(GLConstants.GLScaleType scaleType) {
        f f2 = this.mProducer;
        GLConstants.GLScaleType gLScaleType = scaleType;
        f2.a(y.a(f2, gLScaleType));
    }

    @CalledByNative
    public void setRenderRotation(Rotation rotation) {
        f f2 = this.mProducer;
        Rotation rotation2 = rotation;
        f2.a(z.a(f2, rotation2));
    }

    @CalledByNative
    public void takeSnapshot(SnapshotSourceType sourceType, TakeSnapshotListener listener) {
        f f2 = this.mProducer;
        TakeSnapshotListener takeSnapshotListener = listener;
        SnapshotSourceType snapshotSourceType = sourceType;
        f2.a(aa.a(f2, takeSnapshotListener, snapshotSourceType));
    }

    @CalledByNative
    public void startCustomCapture() {
        f f2 = this.mProducer;
        f2.a(ab.a(f2));
    }

    @CalledByNative
    public void appendCustomCaptureFrame(PixelFrame frame) {
        PixelFrame pixelFrame = frame;
        f f2 = this.mProducer;
        if (pixelFrame == null || !pixelFrame.isFrameDataValid()) {
            LiteavLog.w(f2.a, "appendCustomCaptureFrame: frame is not valid.");
            return;
        }
        int n2 = pixelFrame.getWidth();
        int n3 = pixelFrame.getHeight();
        pixelFrame.retain();
        f f3 = f2;
        if (!f3.a(ad.a(f3, pixelFrame, n2, n3))) {
            pixelFrame.release();
        }
    }

    @CalledByNative
    public void stopCustomCapture() {
        f f2 = this.mProducer;
        f2.a(ae.a(f2));
    }

    @CalledByNative
    public void setCustomRenderListener(GLConstants.PixelFormatType pixelFormat, GLConstants.PixelBufferType bufferType, VideoRenderListener listener) {
        f f2 = this.mProducer;
        VideoRenderListener videoRenderListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = pixelFormat;
        f2.a(af.a(f2, pixelFormatType, pixelBufferType, videoRenderListener));
    }

    @CalledByNative
    public void setWatermark(Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        f f2 = this.mProducer;
        Bitmap bitmap = watermark;
        f2.a(ag.a(f2, bitmap, xOffsetRatio, yOffsetRatio, widthRatio));
    }

    @CalledByNative
    public void setCustomVideoProcessListener(GLConstants.PixelFormatType pixelFormat, GLConstants.PixelBufferType bufferType, CustomVideoProcessListener listener) {
        f f2 = this.mProducer;
        CustomVideoProcessListener customVideoProcessListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = pixelFormat;
        f2.a(ah.a(f2, pixelFormatType, pixelBufferType, customVideoProcessListener));
    }
}

