/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.live2;

import com.tencent.live2.impl.V2TXLiveUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGLContext;

public class V2TXLiveDef {

    public static final class V2TXLiveLogConfig {
        public int logLevel = 0;
        public boolean enableObserver = false;
        public boolean enableConsole = false;
        public boolean enableLogFile = true;
        public String logPath;
    }

    public static final class V2TXLiveLogLevel {
        public static final int V2TXLiveLogLevelAll = 0;
        public static final int V2TXLiveLogLevelDebug = 1;
        public static final int V2TXLiveLogLevelInfo = 2;
        public static final int V2TXLiveLogLevelWarning = 3;
        public static final int V2TXLiveLogLevelError = 4;
        public static final int V2TXLiveLogLevelFatal = 5;
        public static final int V2TXLiveLogLevelNULL = 6;
    }

    public static final class V2TXLiveTranscodingConfig {
        public int videoWidth;
        public int videoHeight;
        public int videoBitrate;
        public int videoFramerate;
        public int videoGOP;
        public int backgroundColor;
        public String backgroundImage;
        public int audioSampleRate;
        public int audioBitrate;
        public int audioChannels;
        public ArrayList<V2TXLiveMixStream> mixStreams;
        public String outputStreamId;

        public V2TXLiveTranscodingConfig() {
            this.videoWidth = 0;
            this.videoHeight = 0;
            this.videoBitrate = 0;
            this.videoFramerate = 15;
            this.videoGOP = 2;
            this.backgroundColor = 0;
            this.audioSampleRate = 48000;
            this.audioChannels = 1;
            this.outputStreamId = null;
        }

        public V2TXLiveTranscodingConfig(V2TXLiveTranscodingConfig original) {
            this.videoWidth = original.videoWidth;
            this.videoHeight = original.videoHeight;
            this.videoBitrate = original.videoBitrate;
            this.videoFramerate = original.videoFramerate;
            this.videoGOP = original.videoGOP;
            this.backgroundColor = original.backgroundColor;
            this.backgroundImage = original.backgroundImage;
            this.audioSampleRate = original.audioSampleRate;
            this.audioBitrate = original.audioBitrate;
            this.audioChannels = original.audioChannels;
            this.outputStreamId = original.outputStreamId;
            this.mixStreams = new ArrayList<V2TXLiveMixStream>(original.mixStreams);
        }

        public final String toString() {
            return "[videoWidth=" + this.videoWidth + "][videoHeight=" + this.videoHeight + "][videoBitrate=" + this.videoBitrate + "][videoFramerate=" + this.videoFramerate + "][videoGOP=" + this.videoGOP + "][backgroundColor=" + this.backgroundColor + "][backgroundImage='" + this.backgroundImage + '\'' + "][audioSampleRate=" + this.audioSampleRate + "][audioBitrate=" + this.audioBitrate + "][audioChannels=" + this.audioChannels + "][mixStreams=" + this.mixStreams + "][outputStreamId='" + this.outputStreamId + '\'' + ']';
        }
    }

    public static class V2TXLiveMixStream {
        public String userId;
        public String streamId;
        public int x;
        public int y;
        public int width;
        public int height;
        public int zOrder;
        public V2TXLiveMixInputType inputType;

        public V2TXLiveMixStream() {
            this.userId = "";
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
            this.zOrder = 0;
            this.inputType = V2TXLiveMixInputType.V2TXLiveMixInputTypeAudioVideo;
        }

        public V2TXLiveMixStream(String userId, int x2, int y2, int width, int height, int zOrder) {
            this.userId = userId;
            this.x = x2;
            this.y = y2;
            this.width = width;
            this.height = height;
            this.zOrder = zOrder;
            this.inputType = V2TXLiveMixInputType.V2TXLiveMixInputTypeAudioVideo;
        }

        public V2TXLiveMixStream(V2TXLiveMixStream original) {
            this.userId = original.userId;
            this.streamId = original.streamId;
            this.x = original.x;
            this.y = original.y;
            this.width = original.width;
            this.height = original.height;
            this.zOrder = original.zOrder;
            this.inputType = original.inputType;
        }

        public String toString() {
            return "[userId='" + this.userId + '\'' + "][streamId='" + this.streamId + '\'' + "][x=" + this.x + "][y=" + this.y + "][width=" + this.width + "][height=" + this.height + "][zOrder=" + this.zOrder + "][inputType=" + (Object)((Object)this.inputType) + ']';
        }
    }

    public static enum V2TXLiveMixInputType {
        V2TXLiveMixInputTypeAudioVideo,
        V2TXLiveMixInputTypePureVideo,
        V2TXLiveMixInputTypePureAudio;

    }

    public static enum V2TXLivePushStatus {
        V2TXLivePushStatusDisconnected,
        V2TXLivePushStatusConnecting,
        V2TXLivePushStatusConnectSuccess,
        V2TXLivePushStatusReconnecting;

    }

    public static final class V2TXLivePlayerStatistics {
        public int appCpu;
        public int systemCpu;
        public int width;
        public int height;
        public int fps;
        public int videoBitrate;
        public int audioBitrate;
    }

    public static final class V2TXLivePusherStatistics {
        public int appCpu;
        public int systemCpu;
        public int width;
        public int height;
        public int fps;
        public int videoBitrate;
        public int audioBitrate;
    }

    public static final class V2TXLiveAudioFrame {
        public byte[] data;
        public int sampleRate;
        public int channel;
    }

    public static enum V2TXLiveAudioQuality {
        V2TXLiveAudioQualitySpeech,
        V2TXLiveAudioQualityDefault,
        V2TXLiveAudioQualityMusic;

    }

    public static final class V2TXLiveVideoFrame {
        public V2TXLivePixelFormat pixelFormat = V2TXLivePixelFormat.V2TXLivePixelFormatUnknown;
        public V2TXLiveBufferType bufferType = V2TXLiveBufferType.V2TXLiveBufferTypeUnknown;
        public V2TXLiveTexture texture;
        public byte[] data;
        public ByteBuffer buffer;
        public int width;
        public int height;
        public int rotation;
    }

    public static final class V2TXLiveTexture {
        public int textureId;
        public EGLContext eglContext10;
        public android.opengl.EGLContext eglContext14;
    }

    public static enum V2TXLiveBufferType {
        V2TXLiveBufferTypeUnknown,
        V2TXLiveBufferTypeByteBuffer,
        V2TXLiveBufferTypeByteArray,
        V2TXLiveBufferTypeTexture;

    }

    public static enum V2TXLivePixelFormat {
        V2TXLivePixelFormatUnknown,
        V2TXLivePixelFormatI420,
        V2TXLivePixelFormatTexture2D;

    }

    public static enum V2TXLiveRotation {
        V2TXLiveRotation0,
        V2TXLiveRotation90,
        V2TXLiveRotation180,
        V2TXLiveRotation270;

    }

    public static enum V2TXLiveFillMode {
        V2TXLiveFillModeFill,
        V2TXLiveFillModeFit,
        V2TXLiveFillModeScaleFill;

    }

    public static enum V2TXLiveMirrorType {
        V2TXLiveMirrorTypeAuto,
        V2TXLiveMirrorTypeEnable,
        V2TXLiveMirrorTypeDisable;

    }

    public static final class V2TXLiveVideoEncoderParam {
        public V2TXLiveVideoResolution videoResolution;
        public V2TXLiveVideoResolutionMode videoResolutionMode;
        public int videoFps;
        public int videoBitrate;
        public int minVideoBitrate;

        public V2TXLiveVideoEncoderParam(V2TXLiveVideoResolution videoResolution) {
            this.videoResolution = videoResolution;
            this.videoResolutionMode = V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait;
            this.videoFps = 15;
            V2TXLiveUtils.a a2 = V2TXLiveUtils.getBitrateByResolution(videoResolution);
            this.videoBitrate = a2.b;
            this.minVideoBitrate = a2.a;
        }

        public final String toString() {
            return "V2TXLiveVideoEncoderParam{videoResolution=" + (Object)((Object)this.videoResolution) + ", videoResolutionMode=" + (Object)((Object)this.videoResolutionMode) + ", videoFps=" + this.videoFps + ", videoBitrate=" + this.videoBitrate + ", minVideoBitrate=" + this.minVideoBitrate + '}';
        }
    }

    public static enum V2TXLiveVideoResolutionMode {
        V2TXLiveVideoResolutionModeLandscape,
        V2TXLiveVideoResolutionModePortrait;

    }

    public static enum V2TXLiveVideoResolution {
        V2TXLiveVideoResolution160x160,
        V2TXLiveVideoResolution270x270,
        V2TXLiveVideoResolution480x480,
        V2TXLiveVideoResolution320x240,
        V2TXLiveVideoResolution480x360,
        V2TXLiveVideoResolution640x480,
        V2TXLiveVideoResolution320x180,
        V2TXLiveVideoResolution480x270,
        V2TXLiveVideoResolution640x360,
        V2TXLiveVideoResolution960x540,
        V2TXLiveVideoResolution1280x720,
        V2TXLiveVideoResolution1920x1080;

    }

    public static enum V2TXLiveMode {
        TXLiveMode_RTMP,
        TXLiveMode_RTC;

    }
}

