/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeFormat {
    @CalledByNative
    public static long fromString(String time, String pattern) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = simpleDateFormat.parse(time);
            if (date == null) {
                return 0L;
            }
            return date.getTime();
        }
        catch (Exception exception) {
            Log.i("TimeFormat", "formString: Date conversion failed.", exception);
            return 0L;
        }
    }

    @CalledByNative
    public static String format(long unixTimestampMs, String pattern) {
        try {
            Date date = new Date(unixTimestampMs);
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception exception) {
            Log.i("TimeFormat", "toString: Date conversion failed.", exception);
            return "";
        }
    }
}

