/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.o;
import com.tencent.liteav.videobase.a.e;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer2.a;
import com.tencent.liteav.videoproducer2.c;
import com.tencent.liteav.videoproducer2.f;
import com.tencent.liteav.videoproducer2.g;
import com.tencent.liteav.videoproducer2.i;
import com.tencent.liteav.videoproducer2.j;
import com.tencent.liteav.videoproducer2.m;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav::video")
@TargetApi(value=18)
public class HardwareVideoEncoder2
implements m {
    private final String mTAG;
    private static final int VIDEO_ENCODE_SUCCESS = 0;
    private static final int VIDEO_ENCODE_INIT_FAILED = -3;
    private static final int VIDEO_ENCODE_FAILED = -4;
    @NonNull
    private final o mSurfaceSize = new o(0, 0);
    private final a mSurfaceInputVideoEncoder;
    private final com.tencent.liteav.videobase.a.c mEGLContextChecker;
    private long mNativeHandler;
    private Surface mInputSurface;
    private e mEGLCore;
    private com.tencent.liteav.videobase.frame.j mPixelFrameRenderer;
    private VideoEncodeParams mVideoEncodeParams;
    private long mPreFrameTimeStamp = 0L;
    Bundle mSessionStates = new Bundle();

    @CalledByNative
    public HardwareVideoEncoder2(long nativeHandler, VideoEncodeParams params, ServerVideoProducerConfig serverConfig) {
        this.mTAG = "HardwareVideoEncoder_" + this.hashCode();
        this.mNativeHandler = nativeHandler;
        this.mSurfaceInputVideoEncoder = new a(this.mSessionStates);
        Looper looper = Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper();
        this.mEGLContextChecker = new com.tencent.liteav.videobase.a.c(looper);
        a a2 = this.mSurfaceInputVideoEncoder;
        LiteavLog.d(a2.a, "initialize");
        Object object = new HandlerThread("hw-video-encoder");
        object.start();
        a2.c = new CustomHandler(object.getLooper());
        object = serverConfig;
        a2 = this.mSurfaceInputVideoEncoder;
        a2.c.post(f.a(a2, (ServerVideoProducerConfig)object));
        this.start(params);
    }

    private void start(VideoEncodeParams params) {
        LiteavLog.i(this.mTAG, "Start hw video encoder. %s", params);
        HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
        VideoEncodeParams videoEncodeParams = params;
        a a2 = this.mSurfaceInputVideoEncoder;
        LiteavLog.d(a2.a, "start");
        Surface[] surfaceArray = new Surface[1];
        boolean bl2 = a2.c.a(g.a(a2, hardwareVideoEncoder2, surfaceArray, videoEncodeParams), 5000L);
        LiteavLog.i(a2.a, "startCodecInternal success: ".concat(String.valueOf(bl2)));
        o o2 = new o(720, 1280);
        if (a2.f != null) {
            o2.a(a2.f.width, a2.f.height);
        }
        Pair pair = new Pair((Object)surfaceArray[0], (Object)o2);
        this.mInputSurface = (Surface)pair.first;
        this.mSurfaceSize.a((o)pair.second);
        this.mVideoEncodeParams = new VideoEncodeParams(params);
    }

    @CalledByNative
    public void encodeFrame(PixelFrame frame) {
        if (frame == null) {
            return;
        }
        if (!this.mEGLContextChecker.a(frame.getGLContext())) {
            this.uninitOpenGLComponents();
        }
        if (this.mEGLCore == null && !this.initOpenGLComponents(frame.getGLContext(), this.mInputSurface)) {
            return;
        }
        try {
            this.mEGLCore.a();
            if (frame.getRotation() == Rotation.b || frame.getRotation() == Rotation.d) {
                PixelFrame pixelFrame = frame;
                pixelFrame.setMirrorHorizontal(!pixelFrame.isMirrorHorizontal());
            } else {
                PixelFrame pixelFrame = frame;
                pixelFrame.setMirrorVertical(!pixelFrame.isMirrorVertical());
            }
            OpenGlUtils.glViewport(0, 0, this.mSurfaceSize.a, this.mSurfaceSize.b);
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a(frame, GLConstants.GLScaleType.a, null);
            }
            this.mSurfaceInputVideoEncoder.a(frame.getTimestamp());
            if (frame.getTimestamp() < this.mPreFrameTimeStamp) {
                LiteavLog.e(this.mTAG, "timestamp is not increase. pre: " + this.mPreFrameTimeStamp + ", cur: " + frame.getTimestamp());
            }
            this.mPreFrameTimeStamp = frame.getTimestamp();
            this.mEGLCore.a(TimeUnit.MILLISECONDS.toNanos(frame.getTimestamp()));
            this.mEGLCore.c();
            return;
        }
        catch (com.tencent.liteav.videobase.a.f f2) {
            String string = "VideoEncode: swapBuffer error, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage();
            LiteavLog.e(this.mTAG, "makeCurrent failed. error = ".concat(String.valueOf(string)), f2);
            this.mSurfaceInputVideoEncoder.a();
            return;
        }
    }

    private boolean initOpenGLComponents(Object sharedContext, Surface surface) {
        if (surface == null) {
            LiteavLog.w(this.mTAG, "init opengl: surface is null.");
            return false;
        }
        LiteavLog.d(this.mTAG, "initOpenGLComponents");
        this.mEGLCore = new e();
        try {
            this.mEGLCore.a(sharedContext, surface, this.mSurfaceSize.a, this.mSurfaceSize.b);
        }
        catch (com.tencent.liteav.videobase.a.f f2) {
            String string = "VideoEncode: create EGLCore failed, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage();
            LiteavLog.e(this.mTAG, "create EGLCore failed. error = ".concat(String.valueOf(string)), f2);
            this.mSurfaceInputVideoEncoder.b();
            this.mEGLCore = null;
            return false;
        }
        this.mPixelFrameRenderer = new com.tencent.liteav.videobase.frame.j(this.mSurfaceSize.a, this.mSurfaceSize.b);
        return true;
    }

    @CalledByNative
    public void signalEndOfStream() {
        a a2 = this.mSurfaceInputVideoEncoder;
        a2.c.post(j.a(a2));
    }

    @CalledByNative
    public synchronized void release() {
        LiteavLog.d(this.mTAG, "release");
        this.mNativeHandler = 0L;
        this.uninitOpenGLComponents();
        if (this.mInputSurface != null) {
            this.mInputSurface.release();
            this.mInputSurface = null;
        }
        a a2 = this.mSurfaceInputVideoEncoder;
        LiteavLog.d(a2.a, "stop");
        a2.c.post(c.a(a2));
        a2 = this.mSurfaceInputVideoEncoder;
        LiteavLog.d(a2.a, "uninitialize");
        a2.c.a();
        this.mEGLContextChecker.a();
    }

    private void uninitOpenGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        LiteavLog.d(this.mTAG, "uninitOpenGLComponents");
        try {
            this.mEGLCore.a();
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a();
                this.mPixelFrameRenderer = null;
            }
            this.mEGLCore.e();
        }
        catch (com.tencent.liteav.videobase.a.f f2) {
            LiteavLog.e(this.mTAG, "makeCurrent failed.", f2);
        }
        this.mEGLCore = null;
    }

    @CalledByNative
    public void setBitrate(int bitrate) {
        LiteavLog.i(this.mTAG, "SetBitrate ".concat(String.valueOf(bitrate)));
        if (this.mVideoEncodeParams != null) {
            this.mVideoEncodeParams.bitrate = bitrate;
        }
        a a2 = this.mSurfaceInputVideoEncoder;
        a2.c.post(i.a(a2, bitrate));
    }

    @CalledByNative
    public void setFps(int fps) {
    }

    @Override
    public void onRequestRestart() {
    }

    @Override
    public synchronized void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            EncodedVideoFrame encodedVideoFrame = nal;
            hardwareVideoEncoder2.nativeOnEncodedNAL(hardwareVideoEncoder2.mNativeHandler, encodedVideoFrame, encodedVideoFrame.data, nal.nalType.mValue, nal.profileType.mValue, nal.codecType.mValue, nal.rotation, nal.dts, nal.pts, nal.gopIndex, nal.gopFrameIndex, nal.frameIndex, nal.refFrameIndex, nal.width, nal.height, nal.svcInfo != null, nal.svcInfo == null ? 0 : nal.svcInfo);
            return;
        }
        LiteavLog.d(this.mTAG, "onEncodedNAL mNativeHandler is zero.");
    }

    @Override
    public synchronized void onEncodedFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    @Override
    public synchronized void onStartEncodedFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    private native void nativeOnEncodedNAL(long var1, EncodedVideoFrame var3, ByteBuffer var4, int var5, int var6, int var7, int var8, long var9, long var11, long var13, long var15, long var17, long var19, int var21, int var22, boolean var23, int var24);

    private native void nativeOnEncodedFail(long var1);

    private native void nativeOnStartEncodedFail(long var1);
}

