/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.consumer;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;

@JNINamespace(value="liteav::video")
public class NativeCustomRenderListener
implements VideoRenderListener {
    public static final String TAG = "NativeCustomRenderListener";
    private long mNativeVideoCustomRenderListener = 0L;

    @CalledByNative
    private NativeCustomRenderListener(long listener) {
        this.mNativeVideoCustomRenderListener = listener;
    }

    @Override
    public synchronized void onRenderFrame(PixelFrame frame) {
        if (this.mNativeVideoCustomRenderListener != 0L) {
            if (frame.getPixelFormatType() == null) {
                LiteavLog.i(TAG, "PixelFrame PixelFormatType is null.");
                return;
            }
            NativeCustomRenderListener nativeCustomRenderListener = this;
            PixelFrame pixelFrame = frame;
            nativeCustomRenderListener.nativeOnCustomRenderFrame(nativeCustomRenderListener.mNativeVideoCustomRenderListener, pixelFrame, pixelFrame.getWidth(), frame.getHeight(), frame.getTimestamp(), frame.getPixelFormatType().getValue());
        }
    }

    @Override
    public void onRenderTargetSizeChanged(int width, int height) {
    }

    @Override
    public void onRenderFirstFrameOnView() {
    }

    @CalledByNative
    private synchronized void reset() {
        this.mNativeVideoCustomRenderListener = 0L;
    }

    private native void nativeOnCustomRenderFrame(long var1, PixelFrame var3, int var4, int var5, long var6, int var8);
}

