/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.projection.MediaProjection;
import android.opengl.Matrix;
import android.os.Looper;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.base.util.s;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.frame.k;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.d;
import com.tencent.liteav.videobase.utils.f;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.at;
import com.tencent.liteav.videoproducer.capture.ay;
import com.tencent.liteav.videoproducer.capture.az;
import com.tencent.liteav.videoproducer.capture.ba;
import com.tencent.liteav.videoproducer.capture.bb;
import com.tencent.liteav.videoproducer.capture.bc;
import com.tencent.liteav.videoproducer.capture.bd;
import com.tencent.liteav.videoproducer.capture.be;
import com.tencent.liteav.videoproducer.capture.bf;
import java.util.Locale;

public final class ScreenCapturer
extends at
implements SurfaceTexture.OnFrameAvailableListener,
s.a,
bf.b {
    private final Context g;
    @NonNull
    private final IVideoReporter h;
    @NonNull
    private final CustomHandler i;
    private int j = 720;
    private int k = 1080;
    private ScreenCaptureParams l;
    private int m = -1;
    private SurfaceTexture n;
    private Surface o;
    private PixelFrame p;
    private j q;
    protected l f;
    private int r = 0;
    private int s = 0;
    private boolean t = false;
    private f u;
    private s v;
    private boolean w = false;
    private MediaProjection x;
    private boolean y = true;

    public ScreenCapturer(@NonNull Context context, @NonNull Looper looper, @NonNull IVideoReporter reporter) {
        super(looper, reporter);
        this.g = context;
        this.h = reporter;
        this.i = new CustomHandler(Looper.getMainLooper());
        try {
            WindowManager windowManager = (WindowManager)this.g.getSystemService("window");
            if (windowManager != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
                this.j = displayMetrics.widthPixels;
                this.k = displayMetrics.heightPixels;
                LiteavLog.i("ScreenCapturer", "DeviceScreen:[width:%d][height:%d]", this.j, this.k);
            }
            return;
        }
        catch (Exception exception) {
            LiteavLog.e("ScreenCapturer", "get screen resolution failed.", exception);
            return;
        }
    }

    @Override
    protected final void a(CaptureSourceInterface.CaptureParams captureParams) {
        if (!this.y) {
            LiteavLog.e("ScreenCapturer", "Start capture %s, capturer already started", captureParams);
            return;
        }
        if (this.c == null) {
            LiteavLog.e("ScreenCapturer", "Start capture %s, mEGLCore is null", captureParams);
            this.a(false);
            return;
        }
        LiteavLog.i("ScreenCapturer", "Start capture %s", captureParams);
        this.l = new ScreenCaptureParams((ScreenCaptureParams)captureParams);
        this.x = this.l.f;
        if (!this.c()) {
            this.h.notifyError(i.a.e, "Start screen capture failed, params:" + this.l, new Object[0]);
            this.a(false);
            return;
        }
        this.f();
        this.y = false;
    }

    private void f() {
        int n2;
        if (this.f == null) {
            this.f = new l();
        }
        if (this.j == 0 || this.k == 0) {
            this.j = this.l.c;
            this.k = this.l.d;
        }
        int n3 = this.j;
        int n4 = this.k;
        if (this.l.a) {
            n2 = ((WindowManager)this.g.getSystemService("window")).getDefaultDisplay().getRotation();
            if (n2 == 0 || n2 == 2) {
                n3 = Math.min(this.j, this.k);
                n4 = Math.max(this.j, this.k);
            } else {
                n3 = Math.max(this.j, this.k);
                n4 = Math.min(this.j, this.k);
            }
        }
        this.m = OpenGlUtils.generateTextureOES();
        this.n = new SurfaceTexture(this.m);
        this.n.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.n.setDefaultBufferSize(n3, n4);
        this.o = new Surface(this.n);
        int n5 = n3;
        n2 = n4;
        bf.a(this.g).a(this.o, n5, n2, this.x, this);
        LiteavLog.i("ScreenCapturer", "Start virtual display, size: %dx%d", n3, n4);
        this.s = n4;
        this.r = n3;
        this.p = new PixelFrame();
        this.p.setPixelFormatType(GLConstants.PixelFormatType.f);
        this.p.setPixelBufferType(GLConstants.PixelBufferType.c);
        this.p.setTextureId(this.m);
        this.p.setWidth(n3);
        this.p.setHeight(n4);
        this.p.setMatrix(new float[16]);
    }

    @Override
    protected final void b() {
        if (this.y) {
            LiteavLog.i("ScreenCapturer", "Stop capture, capturer already stopped");
            return;
        }
        LiteavLog.i("ScreenCapturer", "Stop capture");
        this.g();
        this.h.notifyEvent(i.b.m, "Stop screen capture success", new Object[0]);
        this.y = true;
    }

    private void g() {
        this.x = null;
        bf.a(this.g).a(this.o);
        if (this.o != null) {
            this.o.release();
            this.o = null;
        }
        if (!this.c()) {
            LiteavLog.w("ScreenCapturer", "makeCurrent error!");
            this.d();
            return;
        }
        if (this.f != null) {
            this.f.b();
            this.f = null;
        }
        if (this.q != null) {
            this.q.a();
            this.q = null;
        }
        if (this.n != null) {
            this.n.setOnFrameAvailableListener(null);
            this.n.release();
            this.n = null;
        }
        OpenGlUtils.deleteTexture(this.m);
        this.m = -1;
        if (this.v != null) {
            this.v.a();
            this.v = null;
        }
    }

    @Override
    public final void updateParams(CaptureSourceInterface.CaptureParams params) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(ay.a(screenCapturer, params));
    }

    @Override
    public final void pause() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(az.a(screenCapturer));
    }

    @Override
    public final void resume() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(ba.a(screenCapturer));
    }

    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bb.a(screenCapturer));
    }

    @Override
    public final void a_() {
        Object object;
        if (this.n == null || this.t) {
            return;
        }
        if (!this.c()) {
            this.d();
            return;
        }
        Object object2 = this.u;
        long l2 = SystemClock.elapsedRealtime();
        if (!(((f)object2).a == 0 ? true : ((f)object2).b == -1L || l2 - ((f)object2).b >= (((f)object2).c + 1L) * 1000L / (long)((f)object2).a)) {
            return;
        }
        object2 = this.u;
        if (((f)object2).b == -1L) {
            ((f)object2).b = SystemClock.elapsedRealtime();
        }
        ++((f)object2).c;
        object2 = this;
        if (((ScreenCapturer)object2).f == null || ((ScreenCapturer)object2).l == null || ((ScreenCapturer)object2).c == null) {
            LiteavLog.w("ScreenCapturer", "onScreenFrameAvailable mTextureHolderPool = " + ((ScreenCapturer)object2).f + ", mCaptureParams = " + ((ScreenCapturer)object2).l + ", mEGLCore = " + ((ScreenCapturer)object2).c);
            return;
        }
        l.b b2 = null;
        try {
            b2 = (l.b)((ScreenCapturer)object2).f.a();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w("ScreenCapturer", "textureholderpool obtain interrupted.");
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (((ScreenCapturer)object2).l.e != null && !((ScreenCapturer)object2).l.e.isEmpty()) {
            object = ((ScreenCapturer)object2).l.e;
            f2 = (float)((Rect)object).left * 1.0f / (float)((ScreenCapturer)object2).r;
            f3 = (float)((Rect)object).top * 1.0f / (float)((ScreenCapturer)object2).s;
            int n2 = Math.min(((ScreenCapturer)object2).r - ((Rect)object).left, object.width());
            int n3 = Math.min(((ScreenCapturer)object2).s - ((Rect)object).top, object.height());
            f4 = (float)n2 * 1.0f / (float)((ScreenCapturer)object2).r;
            f5 = (float)n3 * 1.0f / (float)((ScreenCapturer)object2).s;
        }
        b2.a(36197, ((ScreenCapturer)object2).m, ((ScreenCapturer)object2).r, ((ScreenCapturer)object2).s);
        object = b2.a(((ScreenCapturer)object2).c.d());
        if (((PixelFrame)object).getMatrix() == null) {
            ((PixelFrame)object).setMatrix(new float[16]);
        }
        ((ScreenCapturer)object2).n.updateTexImage();
        ((ScreenCapturer)object2).n.getTransformMatrix(((PixelFrame)object).getMatrix());
        ((PixelFrame)object).setTimestamp(TimeUtil.a());
        if (!com.tencent.liteav.videobase.utils.d.a(f2, 0.0f) || !com.tencent.liteav.videobase.utils.d.a(f3, 0.0f)) {
            Matrix.translateM((float[])((PixelFrame)object).getMatrix(), (int)0, (float)f2, (float)f3, (float)0.0f);
        }
        if (!com.tencent.liteav.videobase.utils.d.a(f4, 1.0f) || !com.tencent.liteav.videobase.utils.d.a(f5, 1.0f)) {
            Matrix.scaleM((float[])((PixelFrame)object).getMatrix(), (int)0, (float)f4, (float)f5, (float)1.0f);
        }
        if (((ScreenCapturer)object2).d != null) {
            ((ScreenCapturer)object2).d.onFrameAvailable((CaptureSourceInterface)object2, (PixelFrame)object);
        }
        b2.release();
        ((k)object).release();
    }

    @Override
    public final void a(boolean bl2, boolean bl3) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bc.a(screenCapturer, bl2, bl3));
    }

    @Override
    public final void e() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bd.a(screenCapturer));
    }

    @Override
    public final void b(boolean bl2) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(be.a(screenCapturer, bl2));
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, boolean bl2) {
        LiteavLog.d("ScreenCapturer", "display orientation changed, isPortrait: %b", bl2);
        if (!screenCapturer.y && screenCapturer.l.a) {
            screenCapturer.g();
            screenCapturer.f();
            if (screenCapturer.d != null) {
                screenCapturer.d.onScreenDisplayOrientationChanged(bl2);
            }
        }
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer) {
        LiteavLog.e("ScreenCapturer", "capture error");
        if (screenCapturer.d != null) {
            screenCapturer.d.onCaptureError();
        }
        screenCapturer.h.notifyEvent(i.b.n, "screen capture has been interrupted", new Object[0]);
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, boolean bl2, boolean bl3) {
        LiteavLog.i("ScreenCapturer", "on Start finish, success: %b, isPermissionDenied: %b", bl2, bl3);
        screenCapturer.a(bl2);
        if (bl2) {
            if (!screenCapturer.w) {
                screenCapturer.w = true;
                screenCapturer.h.notifyEvent(i.b.l, "Start screen capture success params:" + screenCapturer.l, new Object[0]);
                return;
            }
        } else {
            if (bl3) {
                screenCapturer.h.notifyError(i.a.f, "permission denied, Start screen capture failed, params:" + screenCapturer.l, new Object[0]);
                return;
            }
            screenCapturer.h.notifyError(i.a.e, "Start screen capture failed, params:" + screenCapturer.l, new Object[0]);
        }
    }

    static /* synthetic */ void b(ScreenCapturer screenCapturer) {
        if (screenCapturer.n == null) {
            return;
        }
        screenCapturer.u = new f(screenCapturer.l.b);
        screenCapturer.v = new s(screenCapturer.a.getLooper(), screenCapturer);
        screenCapturer.v.a(0, 5);
        screenCapturer.n.setOnFrameAvailableListener(null);
        screenCapturer.q = new j(screenCapturer.r, screenCapturer.s);
    }

    static /* synthetic */ void c(ScreenCapturer screenCapturer) {
        LiteavLog.i("ScreenCapturer", "resume capture");
        if (screenCapturer.t) {
            screenCapturer.h.notifyEvent(i.b.o, "screen capture has been resumed", new Object[0]);
        }
        screenCapturer.t = false;
        if (screenCapturer.u != null) {
            screenCapturer.u.a();
        }
    }

    static /* synthetic */ void d(ScreenCapturer screenCapturer) {
        LiteavLog.i("ScreenCapturer", "pause capture");
        if (!screenCapturer.t) {
            screenCapturer.h.notifyEvent(i.b.n, "screen capture has been interrupted", new Object[0]);
        }
        screenCapturer.t = true;
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, CaptureSourceInterface.CaptureParams captureParams) {
        if (screenCapturer.l != null && screenCapturer.l.equals(captureParams)) {
            LiteavLog.i("ScreenCapturer", "updateParams %s is the same ", captureParams);
            return;
        }
        LiteavLog.i("ScreenCapturer", "updateParams %s", captureParams);
        screenCapturer.l = new ScreenCaptureParams((ScreenCaptureParams)captureParams);
        if (screenCapturer.n == null) {
            LiteavLog.e("ScreenCapturer", "capturer not started");
            return;
        }
        screenCapturer.x = screenCapturer.l.f;
        screenCapturer.g();
        screenCapturer.f();
    }

    public static class ScreenCaptureParams
    extends CaptureSourceInterface.CaptureParams {
        public boolean a;
        public MediaProjection f;

        public ScreenCaptureParams() {
        }

        public ScreenCaptureParams(ScreenCaptureParams params) {
            super(params);
            this.a = params.a;
            this.f = params.f;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ScreenCaptureParams)) {
                return false;
            }
            ScreenCaptureParams screenCaptureParams = (ScreenCaptureParams)obj;
            return super.equals(obj) && this.a == screenCaptureParams.a && this.f == screenCaptureParams.f;
        }

        @Override
        @NonNull
        public String toString() {
            return String.format(Locale.ENGLISH, "%s, autoRotate: %b, mediaProjcetion: %s", super.toString(), this.a, this.f);
        }
    }
}

