/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.a;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;

@JNINamespace(value="liteav::video")
public class CustomFrameToPixelFrameConverter {
    private static final String TAG = "CustomFrameToPixelFrameConverter";
    private static final int PRINT_LOG_TIME_MS = 3000;
    private final a mPrintLogThrottler = new a(3000L);
    @Nullable
    private com.tencent.liteav.videobase.b.e mEGLCore = null;
    @Nullable
    private j mPixelFrameRenderer = null;
    @Nullable
    private e mGLTexturePool = null;
    @Nullable
    private final Object mSharedContext;
    private int mWidth = 0;
    private int mHeight = 0;

    @CalledByNative
    public CustomFrameToPixelFrameConverter(@Nullable Object sharedContext) {
        this.mSharedContext = sharedContext;
    }

    @CalledByNative
    public void release() {
        this.uninitializedGLComponents();
    }

    @CalledByNative
    public PixelFrame convertFrame(@Nullable PixelFrame pixelFrame) {
        if (pixelFrame == null) {
            LiteavLog.w(TAG, "convertFrame: pixelFrame is null.");
            return null;
        }
        if (this.mEGLCore == null || this.isNeedRecreateEGL(pixelFrame, this.mEGLCore)) {
            this.mWidth = pixelFrame.getWidth();
            this.mHeight = pixelFrame.getHeight();
            this.uninitializedGLComponents();
            CustomFrameToPixelFrameConverter customFrameToPixelFrameConverter = this;
            customFrameToPixelFrameConverter.initializeGLComponents(customFrameToPixelFrameConverter.mWidth, this.mHeight, pixelFrame);
        }
        if (this.mEGLCore == null || this.mGLTexturePool == null || this.mPixelFrameRenderer == null) {
            return null;
        }
        try {
            this.mEGLCore.a();
        }
        catch (f f2) {
            LiteavLog.e(TAG, "EGL makeCurrent error ", f2);
        }
        OpenGlUtils.glViewport(0, 0, this.mWidth, this.mHeight);
        d d2 = this.mGLTexturePool.a(this.mWidth, this.mHeight);
        GLConstants.GLScaleType gLScaleType = GLConstants.GLScaleType.a;
        this.mPixelFrameRenderer.a(pixelFrame, gLScaleType, d2);
        GLES20.glFinish();
        PixelFrame pixelFrame2 = d2.a(this.mEGLCore.d());
        pixelFrame2.setTimestamp(pixelFrame.getTimestamp());
        d2.release();
        return pixelFrame2;
    }

    @CalledByNative
    public void releaseFrame(PixelFrame pixelFrame) {
        if (pixelFrame != null) {
            pixelFrame.release();
        }
    }

    private void initializeGLComponents(int width, int height, @NonNull PixelFrame frame) {
        if (this.mEGLCore != null) {
            if (this.mPrintLogThrottler.a()) {
                LiteavLog.w(TAG, "egl is initialized!");
            }
            return;
        }
        Object object = frame.getGLContext() != null ? frame.getGLContext() : this.mSharedContext;
        try {
            this.mEGLCore = new com.tencent.liteav.videobase.b.e();
            this.mEGLCore.a(object, null, width, height);
            this.mEGLCore.a();
            LiteavLog.i(TAG, "initialize egl, width: " + width + ", height: " + height + ", sharedContext: " + object);
        }
        catch (f f2) {
            if (this.mPrintLogThrottler.a()) {
                LiteavLog.e(TAG, "initialize egl failed.", f2);
            }
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            this.mGLTexturePool = new e();
            if (this.mPixelFrameRenderer == null) {
                this.mPixelFrameRenderer = new j(width, height);
            }
        }
    }

    private void uninitializedGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.a();
        }
        catch (f f2) {
            LiteavLog.e(TAG, "uninitialize egl, make current error ", f2);
        }
        LiteavLog.i(TAG, "uninitialize egl");
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.a();
            this.mPixelFrameRenderer = null;
        }
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.a();
            this.mGLTexturePool.b();
            this.mGLTexturePool = null;
        }
        try {
            if (this.mEGLCore != null) {
                this.mEGLCore.e();
            }
        }
        catch (f f3) {
            LiteavLog.e(TAG, "uninitialized egl error ", f3);
        }
        this.mEGLCore = null;
    }

    private boolean isNeedRecreateEGL(@NonNull PixelFrame renderFrame, @NonNull com.tencent.liteav.videobase.b.e eglCore) {
        boolean bl2;
        boolean bl3 = bl2 = renderFrame.getGLContext() != null && !CommonUtil.equals(renderFrame.getGLContext(), eglCore.a);
        return renderFrame.getHeight() != this.mHeight || renderFrame.getWidth() != this.mWidth || bl2;
    }
}

