/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;

@JNINamespace(value="liteav::video")
public class VirtualCameraPixelFrameCreator {
    private static final String TAG = "VirtualCameraPixelFrameCreator";
    private com.tencent.liteav.videobase.b.e mEGLCore;
    private e mGLTexturePool;

    @CalledByNative
    public VirtualCameraPixelFrameCreator(Object glContext) {
        this.initGLComponents(glContext);
    }

    private void initGLComponents(Object sharedContext) {
        this.mEGLCore = new com.tencent.liteav.videobase.b.e();
        try {
            this.mEGLCore.a(sharedContext, null, 128, 128);
            this.mEGLCore.a();
        }
        catch (f f2) {
            LiteavLog.e(TAG, "initializeEGL failed.", f2);
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            this.mGLTexturePool = new e();
        }
    }

    private void uninitGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.a();
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.b();
                this.mGLTexturePool = null;
            }
            this.mEGLCore.e();
        }
        catch (f f2) {
            LiteavLog.e(TAG, "EGLCore destroy failed.", f2);
        }
        this.mEGLCore = null;
    }

    @CalledByNative
    public PixelFrame createPixelFrame(Bitmap bitmap, int width, int height) {
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(bitmap).drawARGB(255, 0, 0, 0);
        }
        d d2 = this.mGLTexturePool.a(bitmap.getWidth(), bitmap.getHeight());
        OpenGlUtils.loadTexture(bitmap, d2.a(), false);
        PixelFrame pixelFrame = d2.a(this.mEGLCore.d());
        pixelFrame.setTimestamp(TimeUtil.a());
        d2.release();
        return pixelFrame;
    }

    @CalledByNative
    public void releasePixelFrame(@NonNull PixelFrame pixelFrame) {
        if (this.mEGLCore != null) {
            try {
                this.mEGLCore.a();
            }
            catch (f f2) {
                LiteavLog.e(TAG, "EGLCore make current failed.", f2);
            }
        }
        pixelFrame.release();
    }

    @CalledByNative
    private void release() {
        this.uninitGLComponents();
    }
}

