/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.producer;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.utils.Rotation;

@JNINamespace(value="liteav::video")
public class ServerVideoProducerConfig {
    private int hardwareEncodeType = 2;
    private boolean hardwareEncoderHighProfileEnable = true;
    private boolean hardwareEncoderHighProfileSupport = true;
    private int camera2SupportMinApiLevel = Integer.MAX_VALUE;
    private Rotation frontCameraRealRotation = null;
    private Rotation backCameraRealRotation = null;

    public static boolean isHWHevcEncodeAllowed() {
        return ServerVideoProducerConfig.nativeIsHardwareHevcEncodeAllowed();
    }

    @CalledByNative
    public ServerVideoProducerConfig() {
    }

    @CalledByNative
    public void setHardwareEncodeType(int value) {
        this.hardwareEncodeType = value;
    }

    @CalledByNative
    public void setCamera2SupportMinApiLevel(int value) {
        this.camera2SupportMinApiLevel = value;
    }

    @CalledByNative
    public void setHardwareEncoderHighProfileEnable(boolean value) {
        this.hardwareEncoderHighProfileEnable = value;
    }

    @CalledByNative
    public void setHardwareEncoderHighProfileSupport(boolean value) {
        this.hardwareEncoderHighProfileSupport = value;
    }

    @CalledByNative
    public void setCameraRealRotation(int frontRotation, int backRotation) {
        this.frontCameraRealRotation = Rotation.b(frontRotation) ? Rotation.a(frontRotation) : null;
        this.backCameraRealRotation = Rotation.b(backRotation) ? Rotation.a(backRotation) : null;
    }

    public int getCamera2SupportMinApiLevel() {
        return this.camera2SupportMinApiLevel;
    }

    public boolean isHardwareEncoderAllowed() {
        return this.hardwareEncodeType != 0;
    }

    public boolean isHardwareEncoderHighProfileAllowed() {
        return this.hardwareEncodeType == 2 && this.hardwareEncoderHighProfileEnable && this.hardwareEncoderHighProfileSupport;
    }

    public Rotation getCameraRealRotation(boolean frontCamera) {
        if (frontCamera) {
            return this.frontCameraRealRotation;
        }
        return this.backCameraRealRotation;
    }

    private static native boolean nativeIsHardwareHevcEncodeAllowed();
}

