/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.base.util.q;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.at;
import java.util.Locale;
import java.util.Objects;

public final class VirtualCamera
extends at {
    private PixelFrame f;
    private q g;
    private VirtualCameraParams h;
    private boolean i = true;
    private boolean j = false;
    private final q.a k = new q.a(){

        @Override
        public final void onTimeout() {
            CaptureSourceInterface.CaptureSourceListener captureSourceListener = VirtualCamera.this.d;
            if (captureSourceListener != null && VirtualCamera.this.c()) {
                if (VirtualCamera.this.f != null) {
                    VirtualCamera.this.f.setTimestamp(TimeUtil.a());
                }
                captureSourceListener.onFrameAvailable(VirtualCamera.this, VirtualCamera.this.f);
            }
        }
    };

    public VirtualCamera(@NonNull Looper looper, @NonNull IVideoReporter reporter) {
        super(looper, reporter);
    }

    @Override
    protected final void a(CaptureSourceInterface.CaptureParams captureParams) {
        this.h = new VirtualCameraParams((VirtualCameraParams)captureParams);
        this.e();
        this.b.notifyEvent(i.b.r, "Start virtual camera success params:" + this.h, new Object[0]);
    }

    private void e() {
        if (!this.i) {
            LiteavLog.e("VirtualCameraImpl", "virtual camera is started.");
            return;
        }
        this.i = false;
        Bitmap bitmap = this.h.a;
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)this.h.c, (int)this.h.d, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(bitmap).drawARGB(255, 0, 0, 0);
        }
        this.f = new PixelFrame();
        this.f.setPixelBufferType(GLConstants.PixelBufferType.b);
        this.f.setPixelFormatType(GLConstants.PixelFormatType.f);
        this.f.setWidth(bitmap.getWidth());
        this.f.setHeight(bitmap.getHeight());
        this.f.setGLContext(this.c.d());
        this.f.setTextureId(OpenGlUtils.loadTexture(bitmap, -1, false));
        if (bitmap != this.h.a) {
            bitmap.recycle();
        }
        this.g = new q(this.a.getLooper(), this.k);
        int n2 = Math.max(this.h.b, 1);
        this.g.a(0, 1000 / n2);
    }

    @Override
    protected final void b() {
        this.f();
        this.j = false;
        this.b.notifyEvent(i.b.s, "Stop virtual camera success", new Object[0]);
    }

    private void f() {
        if (this.g != null) {
            this.g.a();
            this.g = null;
        }
        if (this.f != null) {
            OpenGlUtils.deleteTexture(this.f.getTextureId());
            this.f = null;
        }
        this.i = true;
    }

    @Override
    public final void pause() {
        this.f();
    }

    @Override
    public final void resume() {
        this.e();
        if (this.j) {
            this.j = false;
            this.b.notifyEvent(i.b.q, "Start virtual camera success params:" + this.h, new Object[0]);
        }
    }

    @Override
    public final void updateParams(CaptureSourceInterface.CaptureParams params) {
        this.h = new VirtualCameraParams((VirtualCameraParams)params);
        if (this.i) {
            this.j = true;
            return;
        }
        this.f();
        this.e();
        this.b.notifyEvent(i.b.q, "Start virtual camera success params:" + this.h, new Object[0]);
    }

    public static class VirtualCameraParams
    extends CaptureSourceInterface.CaptureParams {
        public Bitmap a;

        public VirtualCameraParams() {
        }

        public VirtualCameraParams(VirtualCameraParams params) {
            super(params);
            this.a = params.a;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof VirtualCameraParams)) {
                return false;
            }
            VirtualCameraParams virtualCameraParams = (VirtualCameraParams)obj;
            return super.equals(obj) && Objects.equals(this.a, virtualCameraParams.a);
        }

        @Override
        @NonNull
        public String toString() {
            return String.format(Locale.ENGLISH, "%s, hasBitmap: %b", super.toString(), this.a != null);
        }
    }
}

