/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.os.Bundle;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.m;
import com.tencent.liteav.videobase.b.c;
import com.tencent.liteav.videobase.b.e;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.bf;
import com.tencent.liteav.videoproducer.encoder.x;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import com.tencent.liteav.videoproducer2.HWEncoderServerConfig;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@JNINamespace(value="liteav::video")
@TargetApi(value=18)
public class HardwareVideoEncoder2
implements bf.a {
    private final String mTAG;
    @NonNull
    private final m mSurfaceSize = new m(0, 0);
    private final AtomicBoolean mNeedRestart = new AtomicBoolean(false);
    private final VideoEncodeParams mParams;
    private final HWEncoderServerConfig mServerConfig;
    private final Bundle mSessionStates = new Bundle();
    private c mEGLContextChecker;
    private long mNativeHandler;
    private Surface mInputSurface;
    private e mEGLCore;
    private j mPixelFrameRenderer;
    private x mSurfaceInputVideoEncoder;
    private long mPreFrameTimeStamp = 0L;
    private Object mSharedContext;

    @CalledByNative
    public HardwareVideoEncoder2(long nativeHandler, VideoEncodeParams params, HWEncoderServerConfig serverConfig) {
        this.mTAG = "HardwareVideoEncoder2_" + this.hashCode();
        this.mNativeHandler = nativeHandler;
        this.mParams = params;
        this.mServerConfig = serverConfig;
    }

    private ServerVideoProducerConfig getServerVideoProducerConfig(HWEncoderServerConfig hwEncoderServerConfig) {
        ServerVideoProducerConfig serverVideoProducerConfig = new ServerVideoProducerConfig();
        serverVideoProducerConfig.setHardwareEncodeType(hwEncoderServerConfig.getHardwareEncodeType());
        serverVideoProducerConfig.setHardwareEncoderHighProfileEnable(hwEncoderServerConfig.getHardwareEncoderHighProfileEnable());
        serverVideoProducerConfig.setHardwareEncoderHighProfileSupport(hwEncoderServerConfig.getHardwareEncoderHighProfileSupport());
        return serverVideoProducerConfig;
    }

    private boolean start() {
        if (this.mSurfaceInputVideoEncoder != null) {
            return this.mInputSurface != null;
        }
        LiteavLog.i(this.mTAG, "Start hw video encoder. %s", this.mParams);
        this.mSurfaceInputVideoEncoder = new x(this.mSessionStates, new g(), VideoProducerDef.StreamType.a);
        this.mSurfaceInputVideoEncoder.a();
        HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
        this.mSurfaceInputVideoEncoder.a(hardwareVideoEncoder2.getServerVideoProducerConfig(hardwareVideoEncoder2.mServerConfig));
        Pair<Surface, m> pair = this.mSurfaceInputVideoEncoder.a(this.mParams, this);
        this.mInputSurface = (Surface)pair.first;
        this.mSurfaceSize.a((m)pair.second);
        if (this.mInputSurface == null) {
            this.notifyStartEncodedFail();
            return false;
        }
        return true;
    }

    private boolean restart() {
        LiteavLog.d(this.mTAG, "reStart");
        this.stop();
        return this.start();
    }

    @CalledByNative
    public void encodeFrame(PixelFrame frame) {
        if (frame == null) {
            return;
        }
        if (this.mNeedRestart.getAndSet(false) && !this.restart()) {
            return;
        }
        if (this.mSurfaceInputVideoEncoder == null && !this.start()) {
            return;
        }
        frame.getGLContext();
        if (!CommonUtil.equals(frame.getGLContext(), this.mSharedContext)) {
            this.uninitOpenGLComponents();
        }
        if (this.mEGLCore == null && !this.initOpenGLComponents(frame.getGLContext(), this.mInputSurface)) {
            return;
        }
        try {
            this.mEGLCore.a();
            if (frame.getRotation() == Rotation.b || frame.getRotation() == Rotation.d) {
                PixelFrame pixelFrame = frame;
                pixelFrame.setMirrorHorizontal(!pixelFrame.isMirrorHorizontal());
            } else {
                PixelFrame pixelFrame = frame;
                pixelFrame.setMirrorVertical(!pixelFrame.isMirrorVertical());
            }
            OpenGlUtils.glViewport(0, 0, this.mSurfaceSize.a, this.mSurfaceSize.b);
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a(frame, GLConstants.GLScaleType.a, null);
            }
            this.mSurfaceInputVideoEncoder.a(frame.getTimestamp());
            if (frame.getTimestamp() < this.mPreFrameTimeStamp) {
                LiteavLog.e(this.mTAG, "timestamp is not increase. pre: " + this.mPreFrameTimeStamp + ", cur: " + frame.getTimestamp());
            }
            this.mPreFrameTimeStamp = frame.getTimestamp();
            this.mEGLCore.a(TimeUnit.MILLISECONDS.toNanos(frame.getTimestamp()));
            this.mEGLCore.c();
            return;
        }
        catch (f f2) {
            String string = "VideoEncode: swapBuffer error, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage();
            LiteavLog.e(this.mTAG, "makeCurrent failed. error = ".concat(String.valueOf(string)), f2);
            this.notifyEncodedFail();
            return;
        }
    }

    private boolean initOpenGLComponents(Object sharedContext, Surface surface) {
        if (surface == null) {
            LiteavLog.w(this.mTAG, "init opengl: surface is null.");
            return false;
        }
        LiteavLog.d(this.mTAG, "initOpenGLComponents");
        this.mEGLCore = new e();
        try {
            this.mEGLCore.a(sharedContext, surface, this.mSurfaceSize.a, this.mSurfaceSize.b);
        }
        catch (f f2) {
            String string = "VideoEncode: create EGLCore failed, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage();
            LiteavLog.e(this.mTAG, "create EGLCore failed. error = ".concat(String.valueOf(string)), f2);
            this.notifyStartEncodedFail();
            this.mEGLCore = null;
            return false;
        }
        this.mSharedContext = sharedContext;
        this.mPixelFrameRenderer = new j(this.mSurfaceSize.a, this.mSurfaceSize.b);
        return true;
    }

    @CalledByNative
    public void signalEndOfStream() {
        if (this.mSurfaceInputVideoEncoder != null) {
            this.mSurfaceInputVideoEncoder.b();
        }
    }

    @CalledByNative
    public synchronized void release() {
        LiteavLog.d(this.mTAG, "release");
        this.mNativeHandler = 0L;
        this.stop();
    }

    private void stop() {
        if (this.mEGLContextChecker != null) {
            this.mEGLContextChecker.a();
        }
        this.uninitOpenGLComponents();
        if (this.mInputSurface != null) {
            this.mInputSurface.release();
            this.mInputSurface = null;
        }
        if (this.mSurfaceInputVideoEncoder != null) {
            this.mSurfaceInputVideoEncoder.c();
            this.mSurfaceInputVideoEncoder.d();
            this.mSurfaceInputVideoEncoder = null;
        }
    }

    private void uninitOpenGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        LiteavLog.d(this.mTAG, "uninitOpenGLComponents");
        try {
            this.mEGLCore.a();
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a();
                this.mPixelFrameRenderer = null;
            }
            this.mEGLCore.e();
        }
        catch (f f2) {
            LiteavLog.e(this.mTAG, "makeCurrent failed.", f2);
        }
        this.mEGLCore = null;
    }

    @CalledByNative
    public void setBitrate(int bitrate) {
        LiteavLog.i(this.mTAG, "SetBitrate ".concat(String.valueOf(bitrate)));
        if (this.mSurfaceInputVideoEncoder == null) {
            this.mParams.bitrate = bitrate;
            return;
        }
        this.mSurfaceInputVideoEncoder.a(bitrate);
    }

    @Override
    public void onRequestRestart() {
        this.mNeedRestart.set(true);
    }

    @Override
    public void onEncodeError(String message) {
        this.notifyEncodedFail();
    }

    @Override
    public void onRpsFrameRateChanged(boolean isRpsIDRMode, int idrFps) {
    }

    @Override
    public void onOutputFormatChanged(MediaFormat format) {
    }

    @Override
    public synchronized void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            EncodedVideoFrame encodedVideoFrame = nal;
            hardwareVideoEncoder2.nativeOnEncodedNAL(hardwareVideoEncoder2.mNativeHandler, encodedVideoFrame, encodedVideoFrame.data, nal.nalType.mValue, nal.profileType.mValue, nal.codecType.mValue, nal.rotation, nal.dts, nal.pts, nal.gopIndex, nal.gopFrameIndex, nal.frameIndex, nal.refFrameIndex, nal.width, nal.height, nal.svcInfo != null, nal.svcInfo == null ? 0 : nal.svcInfo);
            return;
        }
        LiteavLog.d(this.mTAG, "onEncodedNAL mNativeHandler is zero.");
    }

    @Override
    public void onEncodedFail(i.a code) {
    }

    public synchronized void notifyEncodedFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    public synchronized void notifyStartEncodedFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnStartEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    private native void nativeOnEncodedNAL(long var1, EncodedVideoFrame var3, ByteBuffer var4, int var5, int var6, int var7, int var8, long var9, long var11, long var13, long var15, long var17, long var19, int var21, int var22, boolean var23, int var24);

    private native void nativeOnEncodedFail(long var1);

    private native void nativeOnStartEncodedFail(long var1);
}

