/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.common;

import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.a;
import com.tencent.liteav.videobase.common.b;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class EncodedVideoFrame {
    private static final String TAG = "EncodedVideoFrame";
    public ByteBuffer data;
    public long nativePtr = 0L;
    public a nalType;
    public b profileType;
    public CodecType codecType = CodecType.a;
    public int rotation;
    public long dts;
    public long pts;
    public int width;
    public int height;
    public long gopIndex = 0L;
    public long gopFrameIndex = 0L;
    public long frameIndex = 0L;
    public long refFrameIndex = 0L;
    public MediaFormat videoFormat;
    public Integer svcInfo = null;
    public boolean isEosFrame = false;
    public MediaCodec.BufferInfo info = null;

    public void release() {
        if (this.nativePtr != 0L) {
            EncodedVideoFrame encodedVideoFrame = this;
            encodedVideoFrame.nativeRelease(encodedVideoFrame.nativePtr);
            this.nativePtr = 0L;
        }
    }

    private native void nativeRelease(long var1);

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.nativePtr != 0L) {
            LiteavLog.w(TAG, "nativePtr != 0, must call release before finalize ");
            this.release();
        }
    }

    @CalledByNative
    public static long resetEncodedVideoFrame(EncodedVideoFrame videoFrame) {
        long l2 = 0L;
        if (videoFrame.nativePtr != 0L && videoFrame.data != null) {
            videoFrame.data = null;
            l2 = videoFrame.nativePtr;
            videoFrame.nativePtr = 0L;
        }
        return l2;
    }

    @CalledByNative
    public static EncodedVideoFrame createEncodedVideoFrame(ByteBuffer data, int nalType, int profileType, int rotation, long dts, long pts, long gopIndex, long gopFrameIndex, long frameIndex, long refFrameIndex, int codecType, long nativePtr, int width, int height, boolean hasSVCInfo, int svcInfo) {
        EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
        new EncodedVideoFrame().data = data;
        encodedVideoFrame.nativePtr = nativePtr;
        encodedVideoFrame.nalType = a.a(nalType);
        encodedVideoFrame.profileType = b.a(profileType);
        encodedVideoFrame.codecType = CodecType.a(codecType);
        encodedVideoFrame.rotation = rotation;
        encodedVideoFrame.dts = dts;
        encodedVideoFrame.pts = pts;
        encodedVideoFrame.gopIndex = gopIndex;
        encodedVideoFrame.gopFrameIndex = gopFrameIndex;
        encodedVideoFrame.frameIndex = frameIndex;
        encodedVideoFrame.refFrameIndex = refFrameIndex;
        encodedVideoFrame.info = null;
        encodedVideoFrame.width = width;
        encodedVideoFrame.height = height;
        encodedVideoFrame.svcInfo = hasSVCInfo ? Integer.valueOf(svcInfo) : null;
        return encodedVideoFrame;
    }

    public boolean isIDRFrame() {
        return this.nalType != null && this.nalType == a.b;
    }

    public boolean isRPSEnable() {
        return this.profileType == b.e || this.profileType == b.f || this.profileType == b.g;
    }

    public boolean isSVCEnable() {
        return this.svcInfo != null;
    }

    public boolean isH265() {
        return this.codecType == CodecType.b;
    }

    public void updateNALTypeAccordingNALHeader() {
        if (this.data == null || this.nalType != null && this.nalType != a.a) {
            return;
        }
        int n2 = 0;
        while ((n2 = EncodedVideoFrame.getNextNALHeaderPos(n2, this.data)) != -1 && n2 < this.data.remaining()) {
            a a2;
            if (this.isH265()) {
                EncodedVideoFrame encodedVideoFrame = this;
                a2 = encodedVideoFrame.getNalTypeFromH265NALHeader(encodedVideoFrame.data, n2);
            } else {
                EncodedVideoFrame encodedVideoFrame = this;
                a2 = encodedVideoFrame.getNalTypeFromH264NALHeader(encodedVideoFrame.data, n2);
            }
            if (this.nalType == null || this.nalType == a.a || a2 == a.b) {
                this.nalType = a2;
            }
            if (this.nalType == a.h || this.nalType == a.i || this.nalType == a.j || this.nalType == a.e) continue;
        }
    }

    private a getNalTypeFromH264NALHeader(ByteBuffer data, int firstNALHeaderPos) {
        switch (data.get(firstNALHeaderPos) & 0x1F) {
            case 5: {
                return a.b;
            }
            case 6: {
                return a.e;
            }
            case 7: {
                return a.h;
            }
            case 8: {
                return a.i;
            }
        }
        return a.a;
    }

    private a getNalTypeFromH265NALHeader(ByteBuffer data, int firstNALHeaderPos) {
        switch ((data.get(firstNALHeaderPos) & 0x7E) >> 1) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return a.b;
            }
            case 32: {
                return a.j;
            }
            case 33: {
                return a.h;
            }
            case 34: {
                return a.i;
            }
            case 39: {
                return a.e;
            }
        }
        return a.a;
    }

    public static int getNextNALHeaderPos(int startPos, ByteBuffer data) {
        int n2 = startPos;
        while (n2 + 3 < data.remaining()) {
            if (data.get(n2) == 0 && data.get(n2 + 1) == 0 && data.get(n2 + 2) == 0 && data.get(n2 + 3) == 1) {
                return n2 + 4;
            }
            if (data.get(n2) == 0 && data.get(n2 + 1) == 0 && data.get(n2 + 2) == 1) {
                return n2 + 3;
            }
            ++n2;
        }
        return -1;
    }

    @NonNull
    public String toString() {
        return "nalType = " + (Object)((Object)this.nalType) + ", profiletype=" + (Object)((Object)this.profileType) + ", rotation=" + this.rotation + ", codecType=" + (Object)((Object)this.codecType) + ", dts=" + this.dts + ", pts=" + this.pts + ", gopIndex=" + this.gopIndex + ", gopFrameIndex=" + this.gopFrameIndex + ", frameIndex=" + this.frameIndex;
    }
}

