/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.b.g;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.c;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.utils.b;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoconsumer.renderer.a;
import com.tencent.liteav.videoconsumer.renderer.i;
import com.tencent.liteav.videoconsumer.renderer.j;
import com.tencent.liteav.videoconsumer.renderer.k;
import com.tencent.liteav.videoconsumer.renderer.l;
import com.tencent.liteav.videoconsumer.renderer.m;
import com.tencent.liteav.videoconsumer.renderer.n;
import com.tencent.liteav.videoconsumer.renderer.o;
import com.tencent.liteav.videoconsumer.renderer.p;
import com.tencent.liteav.videoconsumer.renderer.q;
import com.tencent.liteav.videoconsumer.renderer.r;
import com.tencent.liteav.videoconsumer.renderer.s;
import com.tencent.liteav.videoconsumer.renderer.t;
import com.tencent.liteav.videoconsumer.renderer.u;
import com.tencent.liteav.videoconsumer.renderer.v;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class h
extends VideoRenderInterface
implements a.a {
    @NonNull
    private final Handler a = new Handler(Looper.getMainLooper());
    @NonNull
    private final CustomHandler b;
    @NonNull
    private final IVideoReporter c;
    @NonNull
    private final a d;
    @NonNull
    private final com.tencent.liteav.base.util.j e = new com.tencent.liteav.base.util.j(5);
    @Nullable
    private DisplayTarget f;
    private Surface g = null;
    @NonNull
    private final com.tencent.liteav.base.util.n h = new com.tencent.liteav.base.util.n();
    private boolean i = false;
    private boolean j = false;
    private Object k;
    private com.tencent.liteav.videobase.b.e l = null;
    private final c m = new c();
    private com.tencent.liteav.videobase.frame.j n;
    private final com.tencent.liteav.videobase.utils.k o = new com.tencent.liteav.videobase.utils.k(1);
    private e p;
    private GLConstants.GLScaleType q = GLConstants.GLScaleType.b;
    private Rotation r = Rotation.a;
    private boolean s = false;
    private boolean t = false;
    private volatile boolean u = false;
    private boolean v = false;
    private TakeSnapshotListener w;
    private VideoRenderListener x;
    private boolean y = false;
    private Bitmap z;

    public h(@NonNull Looper looper, @NonNull IVideoReporter iVideoReporter) {
        this.b = new CustomHandler(looper);
        this.c = iVideoReporter;
        this.d = new a(this);
    }

    @Override
    public final void start(VideoRenderListener listener) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.i.a(h2, listener));
    }

    @Override
    public final void stop(boolean clearLastImage) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.o.a(h2, clearLastImage));
    }

    @Override
    public final void setDisplayView(DisplayTarget displayTarget, boolean clearLastImage) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.p.a(h2, displayTarget, clearLastImage));
    }

    @Override
    public final void takeSnapshot(TakeSnapshotListener listener) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.q.a(h2, listener));
    }

    @Override
    public final void enableTapToFocusGesture(boolean enable) {
    }

    @Override
    public final void enableZoomGesture(boolean enable) {
    }

    @Override
    public final void setScaleType(GLConstants.GLScaleType scaleType) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.r.a(h2, scaleType));
    }

    @Override
    public final void setRenderRotation(Rotation rotation) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.s.a(h2, rotation));
    }

    @Override
    public final void setHorizontalMirror(boolean mirror) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.t.a(h2, mirror));
    }

    @Override
    public final void setVerticalMirror(boolean mirror) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.u.a(h2, mirror));
    }

    @Override
    public final void renderFrame(PixelFrame pixelFrame) {
        if (!this.u) {
            return;
        }
        if (pixelFrame == null) {
            LiteavLog.w("VideoRenderer", "renderFrame pixelFrame is null!");
            return;
        }
        if (!this.v) {
            this.v = true;
            LiteavLog.d("VideoRenderer", "VideoRender receive first frame!");
        }
        pixelFrame.getGLContext();
        this.o.a(pixelFrame);
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.v.a(h2));
    }

    private void a(Runnable runnable) {
        if (Looper.myLooper() == this.b.getLooper()) {
            runnable.run();
            return;
        }
        this.b.post(runnable);
    }

    private void b() {
        if (this.l == null) {
            return;
        }
        LiteavLog.i("VideoRenderer", "uninitializeEGL %d %d*%d", this.g != null ? this.g.hashCode() : 0, this.h.a, this.h.b);
        try {
            this.l.a();
        }
        catch (g g2) {
            LiteavLog.e("VideoRenderer", "uninitializeEGL EGLCore makeCurrent failed.".concat(String.valueOf(g2)));
        }
        if (this.n != null) {
            this.n.a();
            this.n = null;
        }
        this.m.d();
        if (this.p != null) {
            this.p.a();
            this.p.b();
            this.p = null;
        }
        com.tencent.liteav.videobase.b.e.a(this.l);
        this.l = null;
    }

    private boolean a(@NonNull PixelFrame pixelFrame) {
        Object object = pixelFrame.getGLContext();
        if (this.l == null || object != null && !CommonUtil.equals(this.k, object)) {
            this.b();
            Object object2 = pixelFrame.getGLContext();
            h h2 = this;
            if (h2.g != null) {
                try {
                    LiteavLog.i("VideoRenderer", "initializeEGL surface = " + h2.g + " ,mSurfaceSize = " + h2.h);
                    h2.l = new com.tencent.liteav.videobase.b.e();
                    h2.l.a(object2, h2.g, h2.h.a, h2.h.b);
                    h2.k = object2;
                    h2.l.a();
                    if (h2.n == null) {
                        h2.n = new com.tencent.liteav.videobase.frame.j(h2.h.a, h2.h.b);
                    }
                    if (h2.p == null) {
                        h2.p = new e();
                    }
                    h2.m.a();
                }
                catch (g g2) {
                    LiteavLog.e("VideoRenderer", "initializeEGL failed.", g2);
                    h2.l = null;
                    h2.c.notifyWarning(i.c.e, "VideoRender: create EGLCore fail:".concat(String.valueOf(g2)), new Object[0]);
                }
            }
        }
        if (this.l == null) {
            return false;
        }
        try {
            this.l.a();
            return true;
        }
        catch (g g3) {
            LiteavLog.e("VideoRenderer", "EGLCore makeCurrent failed.".concat(String.valueOf(g3)));
            return false;
        }
    }

    private void c() {
        try {
            this.l.b();
            return;
        }
        catch (g g2) {
            LiteavLog.e("VideoRenderer", "EGLCore swapBuffers failed.".concat(String.valueOf(g2)));
            this.c.notifyWarning(i.c.g, "VideoRender: swapBuffer error:".concat(String.valueOf(g2)), new Object[0]);
            return;
        }
    }

    private void a(PixelFrame pixelFrame, boolean bl2, boolean bl3, Rotation rotation, GLConstants.GLScaleType gLScaleType, boolean bl4) {
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        pixelFrame2.setRotation(Rotation.a((pixelFrame.getRotation().mValue + rotation.mValue) % 360));
        if (bl2) {
            PixelFrame pixelFrame3 = pixelFrame2;
            pixelFrame3.setMirrorHorizontal(!pixelFrame3.isMirrorHorizontal());
        }
        if (bl3) {
            PixelFrame pixelFrame4 = pixelFrame2;
            pixelFrame4.setMirrorVertical(!pixelFrame4.isMirrorVertical());
        }
        if (rotation == Rotation.b || rotation == Rotation.d) {
            int n2 = pixelFrame2.getWidth();
            PixelFrame pixelFrame5 = pixelFrame2;
            pixelFrame5.setWidth(pixelFrame5.getHeight());
            pixelFrame2.setHeight(n2);
        }
        PixelFrame pixelFrame6 = pixelFrame2;
        pixelFrame6.setMirrorVertical(!pixelFrame6.isMirrorVertical());
        if (pixelFrame2.getRotation() != Rotation.a && pixelFrame2.getRotation() != Rotation.c) {
            PixelFrame pixelFrame7 = pixelFrame2;
            pixelFrame7.setRotation(Rotation.a((pixelFrame7.getRotation().mValue + Rotation.c.mValue) % 360));
        }
        if (this.j) {
            this.n.a(pixelFrame2, GLConstants.GLScaleType.c, null);
        } else {
            this.n.a(pixelFrame2, gLScaleType, null);
        }
        if (bl4) {
            this.d.a(this.q, pixelFrame2.getWidth(), pixelFrame2.getHeight());
        }
    }

    private void a(Surface surface, int n2, int n3, boolean bl2) {
        this.b();
        if (bl2 && this.g != null) {
            this.g.release();
        }
        this.g = surface;
        this.h.b = n3;
        this.h.a = n2;
        if (this.g != null) {
            this.c.updateStatus(com.tencent.liteav.videobase.videobase.j.u, n2 << 16 | n3);
        }
        if (this.x != null) {
            this.x.onRenderTargetSizeChanged(n2, n3);
        }
    }

    @Override
    public final void a(Surface surface, int n2, int n3, boolean bl2, boolean bl3) {
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.k.a(h2, surface, n2, n3, bl3, bl2));
    }

    @Override
    public final void a(@NonNull Bitmap bitmap) {
        this.b(bitmap);
        h h2 = this;
        h2.a(com.tencent.liteav.videoconsumer.renderer.l.a(h2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap b(Bitmap bitmap) {
        h h2 = this;
        synchronized (h2) {
            Bitmap bitmap2 = this.z;
            this.z = bitmap;
            return bitmap2;
        }
    }

    @Override
    public final void a() {
        this.b.a(com.tencent.liteav.videoconsumer.renderer.m.a(this));
    }

    static /* synthetic */ void a(h h2) {
        LiteavLog.i("VideoRenderer", "onSurfaceDestroy " + h2.g);
        h2.a(null, 0, 0, h2.i);
    }

    static /* synthetic */ void b(h h2) {
        Bitmap bitmap = h2.b(null);
        if (bitmap == null) {
            return;
        }
        PixelFrame pixelFrame = PixelFrame.createFromBitmap(bitmap);
        if (!h2.a(pixelFrame)) {
            pixelFrame.release();
            return;
        }
        OpenGlUtils.glViewport(0, 0, h2.h.a, h2.h.b);
        h2.a(pixelFrame, false, false, Rotation.a, h2.q, false);
        h2.c();
    }

    static /* synthetic */ void a(h h2, Surface surface, int n2, int n3, boolean bl2, boolean bl3) {
        LiteavLog.i("VideoRenderer", "onSurfaceChanged %s size: %dx%d, old_surface: %s, isSurfaceFromTextureView: %b", surface, n2, n3, h2.g, bl2);
        if (h2.g != surface || n2 != h2.h.a || n3 != h2.h.b) {
            h2.a(surface, n2, n3, h2.i);
            h2.i = bl3;
            h2.j = bl2;
            return;
        }
        LiteavLog.d("VideoRenderer", "setDisplaySurface same surface!");
    }

    static /* synthetic */ void a(@NonNull h h2, a a2, ByteBuffer byteBuffer, int n2, int n3, TakeSnapshotListener takeSnapshotListener) {
        TextureView textureView = a2.d();
        Matrix matrix = textureView == null ? null : textureView.getTransform(new Matrix());
        h2.e.a(com.tencent.liteav.videoconsumer.renderer.n.a(h2, byteBuffer, n2, n3, matrix, takeSnapshotListener));
    }

    static /* synthetic */ void a(ByteBuffer byteBuffer, int n2, int n3, Matrix matrix, TakeSnapshotListener takeSnapshotListener) {
        TakeSnapshotListener takeSnapshotListener2 = takeSnapshotListener;
        Matrix matrix2 = matrix;
        int n4 = n3;
        int n5 = n2;
        ByteBuffer byteBuffer2 = byteBuffer;
        try {
            byteBuffer2.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer2);
            Matrix matrix3 = matrix2 == null ? new Matrix() : matrix2;
            matrix3.postScale(1.0f, -1.0f, (float)n5 / 2.0f, (float)n4 / 2.0f);
            bitmap = com.tencent.liteav.videobase.utils.b.a(bitmap, matrix3);
            takeSnapshotListener2.onComplete(bitmap);
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e("VideoRenderer", "build snapshot bitmap failed.", throwable);
            takeSnapshotListener2.onComplete(null);
            return;
        }
    }

    static /* synthetic */ void a(h h2, boolean bl2) {
        if (h2.t != bl2) {
            LiteavLog.i("VideoRenderer", "setVerticalMirror ".concat(String.valueOf(bl2)));
        }
        h2.t = bl2;
    }

    static /* synthetic */ void b(h h2, boolean bl2) {
        if (h2.s != bl2) {
            LiteavLog.i("VideoRenderer", "setHorizontalMirror ".concat(String.valueOf(bl2)));
        }
        h2.s = bl2;
    }

    static /* synthetic */ void a(h h2, Rotation rotation) {
        LiteavLog.i("VideoRenderer", "setRenderRotation ".concat(String.valueOf((Object)rotation)));
        h2.r = rotation;
    }

    static /* synthetic */ void a(h h2, GLConstants.GLScaleType gLScaleType) {
        LiteavLog.i("VideoRenderer", "setScaleType ".concat(String.valueOf((Object)gLScaleType)));
        h2.q = gLScaleType;
    }

    static /* synthetic */ void a(h h2, TakeSnapshotListener takeSnapshotListener) {
        LiteavLog.i("VideoRenderer", "takeSnapshot ");
        h2.w = takeSnapshotListener;
    }

    static /* synthetic */ void a(h h2, DisplayTarget displayTarget, boolean bl2) {
        LiteavLog.i("VideoRenderer", "setDisplayView=" + displayTarget + ",clearLastImage=" + bl2);
        boolean bl3 = CommonUtil.equals(h2.f, displayTarget);
        if (!bl3) {
            h2.y = true;
        }
        if (bl2 && !bl3 && h2.f != null) {
            h2.f.hideAll();
        }
        h2.f = displayTarget;
        if (h2.f != null) {
            h2.f.showAll();
        }
        h2.d.a(displayTarget);
    }

    static /* synthetic */ void c(h h2, boolean bl2) {
        LiteavLog.i("VideoRenderer", "Stop");
        if (!h2.u) {
            LiteavLog.w("VideoRenderer", "renderer is not started!");
            return;
        }
        h2.u = false;
        h2.w = null;
        h2.d.a((DisplayTarget)null);
        if (h2.f != null && bl2) {
            h2.f.hideAll();
        }
        h2.o.b();
        h2.b();
        if (h2.i && h2.g != null) {
            h2.g.release();
            h2.i = false;
        }
        h2.g = null;
        h2.h.b = 0;
        h2.h.a = 0;
        h2.v = false;
    }

    static /* synthetic */ void a(h h2, VideoRenderListener videoRenderListener) {
        LiteavLog.i("VideoRenderer", "Start");
        if (h2.u) {
            LiteavLog.w("VideoRenderer", "renderer is started!");
            return;
        }
        h2.u = true;
        h2.x = videoRenderListener;
        if (h2.f != null) {
            h h3 = h2;
            h3.setDisplayView(h3.f, true);
        }
    }

    static /* synthetic */ void c(h h2) {
        PixelFrame pixelFrame;
        h h3;
        block8: {
            h3 = h2;
            pixelFrame = h3.o.a();
            if (pixelFrame == null) {
                LiteavLog.d("VideoRenderer", "renderFrameInternal pixelFrame is null!");
                return;
            }
            if (!h3.a(pixelFrame)) {
                pixelFrame.release();
                return;
            }
            OpenGlUtils.glViewport(0, 0, h3.h.a, h3.h.b);
            h3.a(pixelFrame, h3.s, h3.t, h3.r, h3.q, true);
            if (h3.w != null) {
                OpenGlUtils.bindFramebuffer(36160, 0);
                h h4 = h3;
                int n2 = h3.h.b;
                int n3 = h4.h.a;
                h h5 = h4;
                TakeSnapshotListener takeSnapshotListener = h4.w;
                if (takeSnapshotListener != null) {
                    ByteBuffer byteBuffer;
                    h5.w = null;
                    try {
                        byteBuffer = ByteBuffer.allocateDirect(n3 * n2 * 4).order(ByteOrder.nativeOrder());
                        byteBuffer.position(0);
                    }
                    catch (Throwable throwable) {
                        LiteavLog.e("VideoRenderer", "can't alloc buffer, size: " + n3 * n2 * 4);
                        takeSnapshotListener.onComplete(null);
                        break block8;
                    }
                    GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
                    a a2 = h5.d;
                    h5.a.post(com.tencent.liteav.videoconsumer.renderer.j.a(h5, a2, byteBuffer, n3, n2, takeSnapshotListener));
                }
            }
        }
        h3.c();
        if (h3.x != null) {
            h3.x.onRenderFrame(pixelFrame);
        }
        if (h3.y) {
            h3.c.notifyEvent(i.b.i, null, new Object[0]);
            h3.y = false;
        }
        pixelFrame.release();
    }
}

