/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.os.Looper;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.s;
import com.tencent.liteav.videobase.utils.Rotation;

@JNINamespace(value="liteav::video")
public class SystemNotificationMonitor
extends OrientationEventListener
implements s.a {
    private final Display mDisplay;
    private volatile s mTimer = null;
    private volatile long mListenerPtr = 0L;
    private Rotation mSensorRotation = Rotation.a;
    private Rotation mDisplayRotation = Rotation.a;

    @CalledByNative
    public SystemNotificationMonitor() {
        super(ContextUtils.getApplicationContext());
        Object object = ContextUtils.getApplicationContext().getSystemService("window");
        this.mDisplay = ((WindowManager)object).getDefaultDisplay();
    }

    @CalledByNative
    public synchronized void initialize(long listenerPtr) {
        this.mListenerPtr = listenerPtr;
        if (this.mTimer != null) {
            return;
        }
        this.mTimer = new s(Looper.getMainLooper(), this);
        this.mTimer.a(0, 1000);
        super.enable();
    }

    @CalledByNative
    public synchronized void uninitialize() {
        super.disable();
        this.mListenerPtr = 0L;
        if (this.mTimer != null) {
            this.mTimer.a();
            this.mTimer = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onOrientationChanged(int orientation) {
        if (orientation == -1) {
            return;
        }
        if (orientation <= 45) ** GOTO lbl-1000
        if (orientation <= 135) {
            var2_2 = Rotation.b;
        } else if (orientation <= 225) {
            var2_2 = Rotation.c;
        } else if (orientation <= 315) {
            var2_2 = Rotation.d;
        } else lbl-1000:
        // 2 sources

        {
            var2_2 = Rotation.a;
        }
        if (this.mSensorRotation == var2_2) {
            return;
        }
        this.mSensorRotation = var2_2;
        this.mDisplayRotation = this.getDisplayRotation(this.mDisplay.getRotation());
        this.notifyOrientationChanged();
    }

    @Override
    public void onTimeout() {
        SystemNotificationMonitor systemNotificationMonitor = this;
        Rotation rotation = systemNotificationMonitor.getDisplayRotation(systemNotificationMonitor.mDisplay.getRotation());
        if (this.mDisplayRotation == rotation) {
            return;
        }
        this.mDisplayRotation = rotation;
        this.notifyOrientationChanged();
    }

    private synchronized void notifyOrientationChanged() {
        if (this.mListenerPtr == 0L) {
            return;
        }
        int n2 = this.mSensorRotation != null ? this.mSensorRotation.mValue : 0;
        int n3 = this.mDisplayRotation != null ? this.mDisplayRotation.mValue : 0;
        SystemNotificationMonitor.nativeSensorChanged(this.mListenerPtr, n2, n3);
    }

    private Rotation getDisplayRotation(int surfaceRotationEnum) {
        switch (surfaceRotationEnum) {
            case 0: {
                return Rotation.a;
            }
            case 1: {
                return Rotation.b;
            }
            case 2: {
                return Rotation.c;
            }
            case 3: {
                return Rotation.d;
            }
        }
        return Rotation.a;
    }

    private static native void nativeSensorChanged(long var0, int var2, int var3);
}

