/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.projection.MediaProjection;
import android.opengl.Matrix;
import android.os.Looper;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.base.util.s;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.f;
import com.tencent.liteav.videobase.utils.h;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.at;
import com.tencent.liteav.videoproducer.capture.ay;
import com.tencent.liteav.videoproducer.capture.az;
import com.tencent.liteav.videoproducer.capture.ba;
import com.tencent.liteav.videoproducer.capture.bb;
import com.tencent.liteav.videoproducer.capture.bc;
import com.tencent.liteav.videoproducer.capture.bd;
import com.tencent.liteav.videoproducer.capture.be;
import com.tencent.liteav.videoproducer.capture.bf;
import com.tencent.liteav.videoproducer.capture.bg;
import java.util.Locale;

public final class ScreenCapturer
extends at
implements SurfaceTexture.OnFrameAvailableListener,
s.a,
bg.b {
    private final Context g;
    @NonNull
    private final IVideoReporter h;
    @NonNull
    private final CustomHandler i;
    private int j = 720;
    private int k = 1080;
    private ScreenCaptureParams l;
    private int m = -1;
    private SurfaceTexture n;
    private Surface o;
    private PixelFrame p;
    private j q;
    protected l f;
    private boolean r = false;
    private h s;
    private s t;
    private boolean u = false;
    private MediaProjection v;
    private boolean w = true;
    private boolean x = false;

    public ScreenCapturer(@NonNull Context context, @NonNull Looper looper, @NonNull IVideoReporter reporter) {
        super(looper, reporter);
        this.g = context;
        this.h = reporter;
        this.i = new CustomHandler(Looper.getMainLooper());
        this.g();
    }

    @Override
    public final void stop() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.b(ay.a(screenCapturer));
    }

    @Override
    protected final void a(CaptureSourceInterface.CaptureParams captureParams) {
        if (!this.w) {
            LiteavLog.e("ScreenCapturer", "Start capture %s, capturer already started", captureParams);
            return;
        }
        if (this.c == null) {
            LiteavLog.e("ScreenCapturer", "Start capture %s, mEGLCore is null", captureParams);
            this.a(false);
            return;
        }
        LiteavLog.i("ScreenCapturer", "Start capture %s", captureParams);
        this.l = new ScreenCaptureParams((ScreenCaptureParams)captureParams);
        this.v = this.l.f;
        if (!this.c()) {
            this.h.notifyError(i.a.e, "Start screen capture failed, params:" + this.l, new Object[0]);
            this.a(false);
            return;
        }
        this.f();
        this.w = false;
    }

    private void f() {
        if (this.f == null) {
            this.f = new l();
        }
        if (this.j == 0 || this.k == 0) {
            this.j = this.l.c;
            this.k = this.l.d;
        }
        if (this.l.a) {
            this.g();
        }
        this.m = OpenGlUtils.generateTextureOES();
        this.n = new SurfaceTexture(this.m);
        this.n.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.n.setDefaultBufferSize(this.j, this.k);
        this.o = new Surface(this.n);
        bg.a(this.g).a(this.o, this.j, this.k, this.v, this);
        LiteavLog.i("ScreenCapturer", "Start virtual display, size: %dx%d", this.j, this.k);
        this.p = new PixelFrame();
        this.p.setPixelFormatType(GLConstants.PixelFormatType.f);
        this.p.setPixelBufferType(GLConstants.PixelBufferType.c);
        this.p.setTextureId(this.m);
        this.p.setWidth(this.j);
        this.p.setHeight(this.k);
        this.p.setMatrix(new float[16]);
    }

    @SuppressLint(value={"NewApi"})
    private void g() {
        try {
            WindowManager windowManager = (WindowManager)this.g.getSystemService("window");
            if (windowManager != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
                this.j = displayMetrics.widthPixels;
                this.k = displayMetrics.heightPixels;
                int n2 = windowManager.getDefaultDisplay().getRotation();
                LiteavLog.i("ScreenCapturer", "updateDeviceScreenSize width:" + displayMetrics.widthPixels + " height:" + displayMetrics.heightPixels + " rotation:" + n2);
            }
            return;
        }
        catch (Exception exception) {
            LiteavLog.e("ScreenCapturer", "get screen resolution failed.", exception);
            return;
        }
    }

    @Override
    protected final void b() {
        if (this.w) {
            LiteavLog.i("ScreenCapturer", "Stop capture, capturer already stopped");
            return;
        }
        LiteavLog.i("ScreenCapturer", "Stop capture");
        this.h();
        this.h.notifyEvent(i.b.m, "Stop screen capture success", new Object[0]);
        this.w = true;
        this.x = false;
    }

    private void h() {
        this.v = null;
        bg.a(this.g).a(this.o);
        if (this.o != null) {
            this.o.release();
            this.o = null;
        }
        if (!this.c()) {
            LiteavLog.w("ScreenCapturer", "makeCurrent error!");
            this.d();
            return;
        }
        if (this.f != null) {
            this.f.b();
            this.f = null;
        }
        if (this.q != null) {
            this.q.a();
            this.q = null;
        }
        if (this.n != null) {
            this.n.setOnFrameAvailableListener(null);
            this.n.release();
            this.n = null;
        }
        OpenGlUtils.deleteTexture(this.m);
        this.m = -1;
        if (this.t != null) {
            this.t.a();
            this.t = null;
        }
    }

    @Override
    public final void updateParams(CaptureSourceInterface.CaptureParams params) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(az.a(screenCapturer, params));
    }

    @Override
    public final void pause() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(ba.a(screenCapturer));
    }

    @Override
    public final void resume() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bb.a(screenCapturer));
    }

    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bc.a(screenCapturer));
    }

    @Override
    public final void onTimeout() {
        Object object;
        if (this.n == null || this.r) {
            return;
        }
        if (!this.c()) {
            this.d();
            return;
        }
        Object object2 = this.s;
        long l2 = SystemClock.elapsedRealtime();
        if (!(((h)object2).a == 0 ? true : ((h)object2).b == -1L || l2 - ((h)object2).b >= (((h)object2).c + 1L) * 1000L / (long)((h)object2).a)) {
            return;
        }
        object2 = this.s;
        if (((h)object2).b == -1L) {
            ((h)object2).b = SystemClock.elapsedRealtime();
        }
        ++((h)object2).c;
        object2 = this;
        if (((ScreenCapturer)object2).f == null || ((ScreenCapturer)object2).l == null || ((ScreenCapturer)object2).c == null) {
            LiteavLog.w("ScreenCapturer", "onScreenFrameAvailable mTextureHolderPool = " + ((ScreenCapturer)object2).f + ", mCaptureParams = " + ((ScreenCapturer)object2).l + ", mEGLCore = " + ((ScreenCapturer)object2).c);
            return;
        }
        l.b b2 = null;
        try {
            b2 = (l.b)((ScreenCapturer)object2).f.a();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w("ScreenCapturer", "textureholderpool obtain interrupted.");
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (((ScreenCapturer)object2).l.e != null && !((ScreenCapturer)object2).l.e.isEmpty()) {
            object = ((ScreenCapturer)object2).l.e;
            f2 = (float)((Rect)object).left * 1.0f / (float)((ScreenCapturer)object2).j;
            f3 = (float)((Rect)object).top * 1.0f / (float)((ScreenCapturer)object2).k;
            int n2 = Math.min(((ScreenCapturer)object2).j - ((Rect)object).left, object.width());
            int n3 = Math.min(((ScreenCapturer)object2).k - ((Rect)object).top, object.height());
            f4 = (float)n2 * 1.0f / (float)((ScreenCapturer)object2).j;
            f5 = (float)n3 * 1.0f / (float)((ScreenCapturer)object2).k;
        }
        b2.a(36197, ((ScreenCapturer)object2).m, ((ScreenCapturer)object2).j, ((ScreenCapturer)object2).k);
        object = b2.a(((ScreenCapturer)object2).c.c());
        if (((PixelFrame)object).getMatrix() == null) {
            ((PixelFrame)object).setMatrix(new float[16]);
        }
        ((ScreenCapturer)object2).n.updateTexImage();
        ((ScreenCapturer)object2).n.getTransformMatrix(((PixelFrame)object).getMatrix());
        ((PixelFrame)object).setTimestamp(TimeUtil.a());
        if (!com.tencent.liteav.videobase.utils.f.a(f2, 0.0f) || !com.tencent.liteav.videobase.utils.f.a(f3, 0.0f)) {
            Matrix.translateM((float[])((PixelFrame)object).getMatrix(), (int)0, (float)f2, (float)f3, (float)0.0f);
        }
        if (!com.tencent.liteav.videobase.utils.f.a(f4, 1.0f) || !com.tencent.liteav.videobase.utils.f.a(f5, 1.0f)) {
            Matrix.scaleM((float[])((PixelFrame)object).getMatrix(), (int)0, (float)f4, (float)f5, (float)1.0f);
        }
        if (((ScreenCapturer)object2).d != null) {
            if (!((ScreenCapturer)object2).x) {
                ((ScreenCapturer)object2).x = true;
                ((ScreenCapturer)object2).d.onCaptureFirstFrame();
            }
            ((ScreenCapturer)object2).d.onFrameAvailable((CaptureSourceInterface)object2, (PixelFrame)object);
        }
        b2.release();
        ((PixelFrame)object).release();
    }

    @Override
    public final void a(boolean bl2, boolean bl3) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bd.a(screenCapturer, bl2, bl3));
    }

    @Override
    public final void e() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(be.a(screenCapturer));
    }

    @Override
    public final void b(boolean bl2) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bf.a(screenCapturer, bl2));
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, boolean bl2) {
        LiteavLog.d("ScreenCapturer", "display orientation changed, isPortrait: %b", bl2);
        if (!screenCapturer.w && screenCapturer.l.a) {
            screenCapturer.h();
            screenCapturer.f();
            if (screenCapturer.d != null) {
                screenCapturer.d.onScreenDisplayOrientationChanged(bl2);
            }
        }
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer) {
        LiteavLog.e("ScreenCapturer", "capture error");
        if (screenCapturer.d != null) {
            screenCapturer.d.onCaptureError();
        }
        screenCapturer.h.notifyEvent(i.b.n, "screen capture has been interrupted", new Object[0]);
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, boolean bl2, boolean bl3) {
        LiteavLog.i("ScreenCapturer", "on Start finish, success: %b, isPermissionDenied: %b", bl2, bl3);
        screenCapturer.a(bl2);
        if (bl2) {
            if (!screenCapturer.u) {
                screenCapturer.u = true;
                screenCapturer.h.notifyEvent(i.b.l, "Start screen capture success params:" + screenCapturer.l, new Object[0]);
                return;
            }
        } else {
            if (bl3) {
                screenCapturer.h.notifyError(i.a.f, "permission denied, Start screen capture failed, params:" + screenCapturer.l, new Object[0]);
                return;
            }
            screenCapturer.h.notifyError(i.a.e, "Start screen capture failed, params:" + screenCapturer.l, new Object[0]);
        }
    }

    static /* synthetic */ void b(ScreenCapturer screenCapturer) {
        if (screenCapturer.n == null) {
            return;
        }
        screenCapturer.s = new h(screenCapturer.l.b);
        screenCapturer.t = new s(screenCapturer.a.getLooper(), screenCapturer);
        screenCapturer.t.a(0, 5);
        screenCapturer.n.setOnFrameAvailableListener(null);
        screenCapturer.q = new j(screenCapturer.j, screenCapturer.k);
    }

    static /* synthetic */ void c(ScreenCapturer screenCapturer) {
        LiteavLog.i("ScreenCapturer", "resume capture");
        if (screenCapturer.r) {
            screenCapturer.h.notifyEvent(i.b.o, "screen capture has been resumed", new Object[0]);
        }
        screenCapturer.r = false;
        if (screenCapturer.s != null) {
            screenCapturer.s.a();
        }
    }

    static /* synthetic */ void d(ScreenCapturer screenCapturer) {
        LiteavLog.i("ScreenCapturer", "pause capture");
        if (!screenCapturer.r) {
            screenCapturer.h.notifyEvent(i.b.n, "screen capture has been interrupted", new Object[0]);
        }
        screenCapturer.r = true;
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, CaptureSourceInterface.CaptureParams captureParams) {
        if (screenCapturer.l != null && screenCapturer.l.equals(captureParams)) {
            LiteavLog.i("ScreenCapturer", "updateParams %s is the same ", captureParams);
            return;
        }
        LiteavLog.i("ScreenCapturer", "updateParams %s", captureParams);
        screenCapturer.l = new ScreenCaptureParams((ScreenCaptureParams)captureParams);
        if (screenCapturer.n == null) {
            LiteavLog.e("ScreenCapturer", "capturer not started");
            return;
        }
        screenCapturer.v = screenCapturer.l.f;
        screenCapturer.h();
        screenCapturer.f();
    }

    public static class ScreenCaptureParams
    extends CaptureSourceInterface.CaptureParams {
        public boolean a;
        public MediaProjection f;

        public ScreenCaptureParams() {
        }

        public ScreenCaptureParams(ScreenCaptureParams params) {
            super(params);
            this.a = params.a;
            this.f = params.f;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ScreenCaptureParams)) {
                return false;
            }
            ScreenCaptureParams screenCaptureParams = (ScreenCaptureParams)obj;
            return super.equals(obj) && this.a == screenCaptureParams.a && this.f == screenCaptureParams.f;
        }

        @Override
        @NonNull
        public String toString() {
            return String.format(Locale.ENGLISH, "%s, autoRotate: %b, mediaProjcetion: %s", super.toString(), this.a, this.f);
        }
    }
}

