/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2.preprocessor;

import android.opengl.GLES20;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.b;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videoproducer.preprocessor.ag;
import com.tencent.liteav.videoproducer.producer.CustomVideoProcessListener;
import com.tencent.liteav.videoproducer2.preprocessor.CustomProcessParams;

@JNINamespace(value="liteav::video")
public class VideoPreprocessorListenerProxy
implements ag,
CustomVideoProcessListener {
    private long mNativeVideoPreprocessorListener = 0L;
    private final CustomProcessParams mParams;

    @CalledByNative
    private VideoPreprocessorListenerProxy(long listener, CustomProcessParams params) {
        this.mNativeVideoPreprocessorListener = listener;
        this.mParams = params;
    }

    @CalledByNative
    private synchronized void reset() {
        this.mNativeVideoPreprocessorListener = 0L;
    }

    public CustomProcessParams getCustomProcessParams() {
        return this.mParams;
    }

    public synchronized void didDetectFacePoints(int identity, b detectResult) {
    }

    @Override
    public synchronized void didProcessFrame(int identity, PixelFrame pixelFrame) {
        if (this.mNativeVideoPreprocessorListener != 0L) {
            if (pixelFrame.getPixelBufferType() == GLConstants.PixelBufferType.b) {
                GLES20.glFinish();
            }
            VideoPreprocessorListenerProxy.nativeOnProcessFrame(this.mNativeVideoPreprocessorListener, identity, pixelFrame, null);
        }
    }

    @Override
    public synchronized void onProcessFrame(PixelFrame srcFrame, PixelFrame dstFrame) {
        if (this.mNativeVideoPreprocessorListener != 0L) {
            VideoPreprocessorListenerProxy.nativeOnProcessFrame(this.mNativeVideoPreprocessorListener, 0, srcFrame, dstFrame);
        }
    }

    @Override
    public synchronized void onGLContextCreated() {
        if (this.mNativeVideoPreprocessorListener != 0L) {
            VideoPreprocessorListenerProxy.nativeOnGLContextCreated(this.mNativeVideoPreprocessorListener);
        }
    }

    @Override
    public synchronized void onGLContextDestroy() {
        if (this.mNativeVideoPreprocessorListener != 0L) {
            VideoPreprocessorListenerProxy.nativeOnGLContextDestroy(this.mNativeVideoPreprocessorListener);
        }
    }

    private static native void nativeOnProcessFrame(long var0, int var2, PixelFrame var3, PixelFrame var4);

    private static native void nativeOnGLContextCreated(long var0);

    private static native void nativeOnGLContextDestroy(long var0);
}

