/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.ui;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.g;
import com.tencent.rtmp.ui.DashBoard;
import com.tencent.rtmp.ui.FocusIndicatorView;
import com.tencent.rtmp.ui.c;
import com.tencent.rtmp.ui.d;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public class TXCloudVideoView
extends FrameLayout
implements ScaleGestureDetector.OnScaleGestureListener {
    private final String mTAG = "TXCloudVideoView_" + ((Object)((Object)this)).hashCode();
    private static final int FOCUS_AREA_SIZE_IN_DP = 70;
    private final DashBoard mDashBoard;
    private final Rect mDashMargin = new Rect();
    private final WeakReference<SurfaceView> mSurfaceView;
    private TextureView mVideoView;
    protected Object mGLContext;
    private FocusIndicatorView mFocusIndicatorView;
    private boolean mEnableTouchToFocus = false;
    private final a mDelayedTapRunnable = new a(0);
    private com.tencent.rtmp.ui.a mTapListener;
    private final ScaleGestureDetector mScaleGestureDetector;
    private boolean mEnableZoom = false;
    private com.tencent.rtmp.ui.b mZoomListener;
    private float mLastScaleFactor;
    private float mScaleFactor;
    private String mUserId = "";
    private WeakReference<b> mCallback;
    private boolean mEnableShowLog;
    private final Runnable mHideIndicatorViewRunnable = c.a(this);

    public TXCloudVideoView(Context context) {
        this(context, null);
    }

    public TXCloudVideoView(SurfaceView surfaceView) {
        this(surfaceView.getContext(), null, surfaceView);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs, SurfaceView surfaceView) {
        super(context, attrs);
        this.mDashBoard = new DashBoard(context);
        this.mSurfaceView = surfaceView != null ? new WeakReference<SurfaceView>(surfaceView) : null;
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
    }

    public void addVideoView(TextureView view) {
        if (this.mVideoView != null) {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeView((View)tXCloudVideoView.mVideoView);
        }
        this.mVideoView = view;
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.addView((View)tXCloudVideoView.mVideoView);
        this.repositionDashBoard();
    }

    public void removeVideoView() {
        if (this.mVideoView != null) {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeView((View)tXCloudVideoView.mVideoView);
            this.mVideoView = null;
        }
    }

    public void setTouchToFocusEnabled(boolean enabled, com.tencent.rtmp.ui.a listener) {
        this.mEnableTouchToFocus = enabled;
        this.mTapListener = listener;
    }

    public void setZoomEnabled(boolean enabled, com.tencent.rtmp.ui.b listener) {
        LiteavLog.i(this.mTAG, "setZoomEnabled: ".concat(String.valueOf(enabled)));
        this.mEnableZoom = enabled;
        this.mZoomListener = listener;
    }

    public TextureView getVideoView() {
        return this.mVideoView;
    }

    public SurfaceView getSurfaceView() {
        if (this.mSurfaceView == null) {
            return null;
        }
        SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
        if (surfaceView == null) {
            LiteavLog.w(this.mTAG, "surfaceView is null.");
        }
        return surfaceView;
    }

    public void setOpenGLContext(Object glContext) {
        this.mGLContext = glContext;
    }

    public Object getOpenGLContext() {
        return this.mGLContext;
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    public void clearLastFrame(boolean clear) {
        if (clear) {
            this.setVisibility(8);
        }
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public TextureView getHWVideoView() {
        return this.mVideoView;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getPointerCount() == 1 && event.getAction() == 0) {
            if (this.mEnableTouchToFocus) {
                int n2 = this.getHeight();
                int n3 = this.getWidth();
                int n4 = (int)event.getY();
                int n5 = (int)event.getX();
                a a2 = this.mDelayedTapRunnable;
                this.mDelayedTapRunnable.a.x = n5;
                a2.a.y = n4;
                a2.b = n3;
                a2.c = n2;
                TXCloudVideoView tXCloudVideoView = this;
                tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
                TXCloudVideoView tXCloudVideoView2 = this;
                tXCloudVideoView2.postDelayed(tXCloudVideoView2.mDelayedTapRunnable, 100L);
            }
        } else if (event.getPointerCount() > 1 && event.getAction() == 2 && this.mEnableZoom) {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
            this.hideIndicatorView();
            this.mScaleGestureDetector.onTouchEvent(event);
        }
        if (this.mEnableZoom) {
            if (event.getAction() == 0) {
                this.performClick();
            }
            return true;
        }
        return super.onTouchEvent(event);
    }

    public void showFocusView(int x2, int y2, int width, int height) {
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.post(d.a(tXCloudVideoView, x2, y2, width, height));
    }

    private void showFocusViewInternal(int x2, int y2, int width, int height) {
        int n2;
        if (width != this.getWidth() || height != this.getHeight()) {
            LiteavLog.i(this.mTAG, "ignore show indicator view when view size changed");
            return;
        }
        LiteavLog.v(this.mTAG, "show indicator view at (%d,%d)", x2, y2);
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeCallbacks(tXCloudVideoView.mHideIndicatorViewRunnable);
        int n3 = n2 = (int)(70.0f * this.getResources().getDisplayMetrics().density + 0.5f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n3);
        new FrameLayout.LayoutParams(n3, n3).leftMargin = g.a(x2 - n2 / 2, 0, this.getWidth() - n2);
        layoutParams.topMargin = g.a(y2 - n2 / 2, 0, this.getHeight() - n2);
        if (this.mFocusIndicatorView == null) {
            this.mFocusIndicatorView = new FocusIndicatorView(this.getContext());
            TXCloudVideoView tXCloudVideoView2 = this;
            tXCloudVideoView2.addView(tXCloudVideoView2.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            TXCloudVideoView tXCloudVideoView3 = this;
            if (tXCloudVideoView3.indexOfChild(tXCloudVideoView3.mFocusIndicatorView) != this.getChildCount() - 1) {
                TXCloudVideoView tXCloudVideoView4 = this;
                tXCloudVideoView4.removeView(tXCloudVideoView4.mFocusIndicatorView);
                TXCloudVideoView tXCloudVideoView5 = this;
                tXCloudVideoView5.addView(tXCloudVideoView5.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                this.mFocusIndicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.mFocusIndicatorView.setVisibility(0);
        FocusIndicatorView focusIndicatorView = this.mFocusIndicatorView;
        focusIndicatorView.startAnimation((Animation)focusIndicatorView.a);
        TXCloudVideoView tXCloudVideoView6 = this;
        tXCloudVideoView6.postDelayed(tXCloudVideoView6.mHideIndicatorViewRunnable, TimeUnit.SECONDS.toMillis(1L));
    }

    private void hideIndicatorView() {
        if (this.mFocusIndicatorView != null) {
            this.mFocusIndicatorView.setVisibility(8);
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (!this.mEnableZoom) {
            return false;
        }
        float f2 = detector.getScaleFactor() - this.mLastScaleFactor;
        this.mLastScaleFactor = detector.getScaleFactor();
        this.mScaleFactor = g.a(this.mScaleFactor + f2, 0.0f, 1.0f);
        if (this.mZoomListener != null) {
            this.mZoomListener.a(this.mScaleFactor);
        }
        return false;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.mLastScaleFactor = detector.getScaleFactor();
        return this.mEnableZoom;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }

    public void setLogMargin(float leftMarginInDp, float rightMarginInDp, float topMarginInDp, float bottomMarginInDp) {
        this.setDashBoardMarginInPx((int)leftMarginInDp, (int)rightMarginInDp, (int)topMarginInDp, (int)bottomMarginInDp);
    }

    public void setDashBoardMarginInPx(int left, int right, int top, int bottom) {
        this.mDashMargin.left = left;
        this.mDashMargin.right = right;
        this.mDashMargin.top = top;
        this.mDashMargin.bottom = bottom;
        this.mDashBoard.a(left, top, right, bottom);
    }

    public void setDashBoardMarginInRatio(final float leftRatio, final float rightRatio, final float topRatio, final float bottomRatio) {
        this.postDelayed(new Runnable(){

            @Override
            public final void run() {
                TXCloudVideoView.this.setDashBoardMarginInPx((int)((float)TXCloudVideoView.this.getWidth() * leftRatio), (int)((float)TXCloudVideoView.this.getWidth() * rightRatio), (int)((float)TXCloudVideoView.this.getHeight() * topRatio), (int)((float)TXCloudVideoView.this.getHeight() * bottomRatio));
            }
        }, 100L);
    }

    public void disableLog(boolean enable) {
    }

    public void showLog(boolean enable) {
        this.mEnableShowLog = enable;
        b b2 = this.mCallback == null ? null : (b)this.mCallback.get();
        if (b2 != null) {
            b2.onShowLog(enable);
        }
    }

    public void clearLog() {
        if (this.mDashBoard != null) {
            DashBoard dashBoard = this.mDashBoard;
            dashBoard.a.setLength(0);
            if (dashBoard.b != null) {
                dashBoard.b.setText((CharSequence)"");
            }
            if (dashBoard.c != null) {
                dashBoard.c.setText((CharSequence)"");
            }
        }
    }

    private void repositionDashBoard() {
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeView((View)tXCloudVideoView.mDashBoard);
        TXCloudVideoView tXCloudVideoView2 = this;
        tXCloudVideoView2.addView((View)tXCloudVideoView2.mDashBoard);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mDashBoard.a(this.mDashMargin.left, this.mDashMargin.top, this.mDashMargin.right, this.mDashMargin.bottom);
        this.mDashBoard.setStatusTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 30.0));
        this.mDashBoard.setEventTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 25.0));
    }

    private static int px2dip(Context context, float pxValue) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / f2 + 0.5f);
    }

    private void setShowLogCallback(WeakReference<b> callback) {
        this.mCallback = callback;
    }

    private boolean isShowLogEnabled() {
        return this.mEnableShowLog;
    }

    static /* synthetic */ void lambda$showFocusView$0(TXCloudVideoView this_, int x2, int y2, int width, int height) {
        this_.showFocusViewInternal(x2, y2, width, height);
    }

    static /* synthetic */ void access$lambda$0(TXCloudVideoView tXCloudVideoView) {
        tXCloudVideoView.hideIndicatorView();
    }

    public static interface b {
        public void onShowLog(boolean var1);
    }

    final class a
    implements Runnable {
        final Point a = new Point();
        int b = 0;
        int c = 0;

        private a() {
        }

        @Override
        public final void run() {
            if (TXCloudVideoView.this.mTapListener != null) {
                TXCloudVideoView.this.mTapListener.a(this.a.x, this.a.y, this.b, this.c);
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

