/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.sdkcommon;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.sdkcommon.a;
import com.tencent.liteav.sdkcommon.b;
import com.tencent.liteav.sdkcommon.c;
import com.tencent.liteav.sdkcommon.d;
import com.tencent.liteav.sdkcommon.e;
import com.tencent.liteav.sdkcommon.f;
import com.tencent.liteav.sdkcommon.g;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@JNINamespace(value="liteav::dashboard")
public class DashboardManager {
    private static final String TAG = "DashboardManager";
    private final Context mAppContext;
    private final g mDashboardManagerView;
    private final Handler mUIHandler;
    private final ArrayList<String> mDashboards = new ArrayList();
    private final Map<String, String> mDashboardStatus = new HashMap<String, String>();
    private final Map<String, StringBuilder> mDashboardLogs = new HashMap<String, StringBuilder>();
    private boolean mIsInit;
    private String mSelectedDashboardId;
    private static final int LOG_MAX_SIZE = 15000;
    private final g.a mSelectedDashboardChangeListener = new g.a(){

        @Override
        public final void a(int n2) {
            if (DashboardManager.this.mDashboards.size() <= n2) {
                return;
            }
            DashboardManager.this.mSelectedDashboardId = (String)DashboardManager.this.mDashboards.get(n2);
            if (!DashboardManager.this.mDashboards.contains(DashboardManager.this.mSelectedDashboardId)) {
                return;
            }
            DashboardManager.this.mDashboardManagerView.b((String)DashboardManager.this.mDashboardStatus.get(DashboardManager.this.mSelectedDashboardId));
            StringBuilder stringBuilder = (StringBuilder)DashboardManager.this.mDashboardLogs.get(DashboardManager.this.mSelectedDashboardId);
            if (stringBuilder != null) {
                DashboardManager.this.mDashboardManagerView.a(stringBuilder.toString());
                return;
            }
            DashboardManager.this.mDashboardManagerView.a("");
        }
    };

    @CalledByNative
    public DashboardManager() {
        LiteavLog.i(TAG, "java DashBoardManager Construct");
        this.mIsInit = false;
        this.mAppContext = ContextUtils.getApplicationContext();
        this.mDashboardManagerView = new g(this.mAppContext, this.mSelectedDashboardChangeListener);
        this.mUIHandler = new Handler(Looper.getMainLooper());
    }

    @CalledByNative
    public int showDashboard(boolean isShow) {
        LiteavLog.i(TAG, "showDashBoard isShow = ".concat(String.valueOf(isShow)));
        this.mUIHandler.post(a.a(this, isShow));
        return 0;
    }

    @CalledByNative
    public int addDashboard(String dashboardId) {
        LiteavLog.i(TAG, "addDashboard dashboardId = ".concat(String.valueOf(dashboardId)));
        this.mUIHandler.post(b.a(this, dashboardId));
        return 0;
    }

    @CalledByNative
    public int removeDashboard(String dashboardId) {
        LiteavLog.i(TAG, "removeDashboard dashboardId = ".concat(String.valueOf(dashboardId)));
        this.mUIHandler.post(c.a(this, dashboardId));
        return 0;
    }

    @CalledByNative
    public int removeAllDashboard() {
        LiteavLog.i(TAG, "removeAllDashboard ");
        this.mUIHandler.post(d.a(this));
        return 0;
    }

    @CalledByNative
    public int setStatus(String dashboardId, String status) {
        this.mUIHandler.post(e.a(this, dashboardId, status));
        return 0;
    }

    @CalledByNative
    public int appendLog(String dashboardId, String log) {
        this.mUIHandler.post(f.a(this, dashboardId, log));
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    private boolean checkPermission() {
        if (LiteavSystemInfo.getSystemOSVersionInt() > 23 && !Settings.canDrawOverlays((Context)this.mAppContext)) {
            Toast.makeText((Context)this.mAppContext, (CharSequence)"no system alert window permission, please authorize", (int)0).show();
            return false;
        }
        return true;
    }

    private boolean init() {
        boolean bl2;
        if (this.mIsInit) {
            return true;
        }
        g g2 = this.mDashboardManagerView;
        if (g2.b == null) {
            Log.e("DashboardManagerView", "dashBoardManagerView context is null", new Object[0]);
            bl2 = false;
        } else {
            g2.c = (WindowManager)g2.b.getSystemService("window");
            if (g2.c == null) {
                Log.e("DashboardManagerView", "get windowManager is fail", new Object[0]);
                bl2 = false;
            } else {
                g2.c.getDefaultDisplay().getMetrics(g2.a);
                if (g2.o.right <= 0) {
                    g2.o.right = g2.a.widthPixels;
                }
                if (g2.o.bottom <= 0) {
                    g2.o.bottom = g2.a.heightPixels - 100;
                }
                bl2 = true;
            }
        }
        if (!bl2) {
            return false;
        }
        g2 = this.mDashboardManagerView;
        this.mDashboardManagerView.d = new WindowManager.LayoutParams();
        g2.d.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        g2.d.format = 1;
        g2.d.gravity = 0x800033;
        g2.d.flags = 40;
        g2.d.width = g2.o.right;
        g2.d.height = g2.o.bottom;
        g2.d.x = g2.o.left;
        g2.d.y = g2.o.top;
        g2.e = new WindowManager.LayoutParams();
        g2.e.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        g2.e.format = 1;
        g2.e.gravity = 0x800033;
        g2.e.flags = 56;
        g2.e.width = g2.o.right;
        g2.e.height = g2.o.bottom;
        g2.e.x = g2.o.left;
        g2.e.y = g2.d.y + g2.d.height;
        g g3 = g2;
        LinearLayout linearLayout = new LinearLayout(g3.b);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        linearLayout.setLayoutParams(layoutParams);
        linearLayout.setOrientation(1);
        linearLayout.setBackgroundColor(-7829368);
        linearLayout.setAlpha(0.5f);
        g3.j = new Spinner(g3.b);
        g3.j.setAdapter(g3.k);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
        new LinearLayout.LayoutParams(-2, -2).leftMargin = g3.a(10);
        layoutParams2.topMargin = g3.a(6);
        g3.j.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        g3.j.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new g.c(g3, 0));
        linearLayout.addView((View)g3.j);
        g2.f = linearLayout;
        g3 = g2;
        linearLayout = new LinearLayout(g3.b);
        layoutParams = new ViewGroup.LayoutParams(-1, -1);
        linearLayout.setLayoutParams(layoutParams);
        linearLayout.setOrientation(1);
        g3.h = new TextView(g3.b);
        int n2 = g3.o.bottom / 5;
        if (n2 < 200) {
            n2 = 200;
        }
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(-1, n2);
        new LinearLayout.LayoutParams(-1, n2).leftMargin = g3.a(10);
        layoutParams3.topMargin = g3.a(30);
        layoutParams3.rightMargin = g3.a(10);
        g3.h.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        g3.h.setTextColor(-65536);
        linearLayout.addView((View)g3.h);
        g3.l = new ScrollView(g3.b);
        int n3 = g3.o.bottom - n2 - g3.a(20);
        LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(-1, n3);
        new LinearLayout.LayoutParams(-1, n3).leftMargin = g3.a(10);
        layoutParams4.topMargin = g3.a(10);
        layoutParams4.rightMargin = g3.a(10);
        layoutParams4.bottomMargin = g3.a(20);
        g3.l.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
        g3.l.fullScroll(130);
        g3.l.setVerticalScrollBarEnabled(false);
        g3.i = new TextView(g3.b);
        LinearLayout.LayoutParams layoutParams5 = new LinearLayout.LayoutParams(-1, -2);
        g3.i.setLayoutParams((ViewGroup.LayoutParams)layoutParams5);
        g3.i.setTextColor(-65536);
        g3.l.addView((View)g3.i);
        linearLayout.addView((View)g3.l);
        g2.g = linearLayout;
        g2.f.setOnTouchListener((View.OnTouchListener)new g.b(g2, 0));
        g2.p.a(0);
        this.mIsInit = true;
        return true;
    }

    private void showDashboardInternal(boolean isShow) {
        if (!(!isShow || this.checkPermission() && this.init())) {
            LiteavLog.i(TAG, "init or check permission is fail");
            return;
        }
        g g2 = this.mDashboardManagerView;
        if (isShow != g2.m) {
            if (isShow) {
                if (g2.c != null && g2.f != null) {
                    g2.c.addView(g2.f, (ViewGroup.LayoutParams)g2.d);
                    g2.c.addView(g2.g, (ViewGroup.LayoutParams)g2.e);
                }
            } else {
                g2.c.removeView(g2.f);
                g2.c.removeView(g2.g);
            }
            g2.m = isShow;
        }
    }

    private void addDashboardInternal(String dashboardId) {
        if (!this.mDashboards.contains(dashboardId)) {
            this.mDashboards.add(dashboardId);
            String string = dashboardId;
            g g2 = this.mDashboardManagerView;
            g2.k.add((Object)string);
            if (g2.n == null) {
                g2.n = (String)g2.k.getItem(0);
                g2.p.a(0);
            }
            g2.a();
        }
    }

    private void removeDashboardInternal(String dashboardId) {
        if (this.mDashboards.contains(dashboardId)) {
            this.mDashboards.remove(dashboardId);
            this.mDashboardStatus.remove(dashboardId);
            this.mDashboardLogs.remove(dashboardId);
            String string = dashboardId;
            g g2 = this.mDashboardManagerView;
            if (string.equals(g2.n)) {
                int n2 = g2.k.getPosition((Object)g2.n);
                if (n2 != g2.k.getCount() - 1) {
                    g2.n = (String)g2.k.getItem(++n2);
                    g2.p.a(n2 - 1);
                }
                if (g2.k.getCount() == 1) {
                    g2.n = null;
                }
            }
            g2.k.remove((Object)string);
            g2.a();
        }
    }

    private void removeAllDashboardInternal() {
        this.mDashboards.clear();
        this.mDashboardStatus.clear();
        this.mDashboardLogs.clear();
        g g2 = this.mDashboardManagerView;
        g2.k.clear();
        if (g2.h != null) {
            g2.h.setText((CharSequence)"");
        }
        if (g2.i != null) {
            g2.i.setText((CharSequence)"");
        }
    }

    private void setStatusInternal(String dashboardId, String status) {
        if (this.mDashboards.contains(dashboardId)) {
            this.mDashboardStatus.put(dashboardId, status);
            if (dashboardId.equals(this.mSelectedDashboardId)) {
                this.mDashboardManagerView.b(status);
            }
        }
    }

    private void appendLogInternal(String dashboardId, String log) {
        if (this.mDashboards.contains(dashboardId)) {
            StringBuilder stringBuilder = this.mDashboardLogs.get(dashboardId);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                this.mDashboardLogs.put(dashboardId, stringBuilder);
            }
            stringBuilder.append(log);
            stringBuilder.append("\n");
            if (stringBuilder.length() > 15000) {
                stringBuilder.delete(0, stringBuilder.length() / 2);
            }
            if (dashboardId.equals(this.mSelectedDashboardId)) {
                String string = log;
                g g2 = this.mDashboardManagerView;
                if (g2.i != null) {
                    g2.i.append((CharSequence)(string + "\n"));
                }
                if (g2.l != null) {
                    g2.l.fullScroll(130);
                }
            }
        }
    }

    static /* synthetic */ void lambda$appendLog$5(DashboardManager this_, String dashboardId, String log) {
        this_.appendLogInternal(dashboardId, log);
    }

    static /* synthetic */ void lambda$setStatus$4(DashboardManager this_, String dashboardId, String status) {
        this_.setStatusInternal(dashboardId, status);
    }

    static /* synthetic */ void lambda$removeAllDashboard$3(DashboardManager this_) {
        this_.removeAllDashboardInternal();
    }

    static /* synthetic */ void lambda$removeDashboard$2(DashboardManager this_, String dashboardId) {
        this_.removeDashboardInternal(dashboardId);
    }

    static /* synthetic */ void lambda$addDashboard$1(DashboardManager this_, String dashboardId) {
        this_.addDashboardInternal(dashboardId);
    }

    static /* synthetic */ void lambda$showDashboard$0(DashboardManager this_, boolean isShow) {
        this_.showDashboardInternal(isShow);
    }
}

