/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.a;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.n;
import com.tencent.liteav.videobase.a.c;
import com.tencent.liteav.videobase.a.d;
import com.tencent.liteav.videobase.a.e;
import com.tencent.liteav.videobase.a.f;
import com.tencent.liteav.videobase.a.g;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.j;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class b {
    private static final String TAG = "TXCGPUImageFilter";
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public static final String NO_FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    private static final AtomicInteger sFilterCount = new AtomicInteger();
    private final com.tencent.liteav.videobase.utils.e mRunOnDrawQueue;
    private final j mProgram;
    public final n mOutputSize = new n(-1, -1);
    protected int mGLAttribPosition;
    protected int mGLUniformTexture;
    protected int mGLAttribTextureCoord;
    private int mUniformTextureTransform;
    protected com.tencent.liteav.videobase.frame.e mTexturePool;
    private int mProgramId = -1;
    private final com.tencent.liteav.videobase.frame.c mGLFrameBuffer = new com.tencent.liteav.videobase.frame.c();
    private boolean mIsInitialized;
    private float[] mTextureMatrix;

    public b() {
        this(NO_FILTER_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
    }

    public b(String string, String string2) {
        this.mRunOnDrawQueue = new com.tencent.liteav.videobase.utils.e();
        this.mProgram = new j(string, string2);
    }

    public final void initialize(com.tencent.liteav.videobase.frame.e texturePool) {
        if (this.mIsInitialized) {
            return;
        }
        this.mGLFrameBuffer.a();
        this.mProgramId = this.buildProgram();
        this.mGLAttribPosition = GLES20.glGetAttribLocation((int)this.getProgramId(), (String)"position");
        this.mGLUniformTexture = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"inputImageTexture");
        this.mGLAttribTextureCoord = GLES20.glGetAttribLocation((int)this.getProgramId(), (String)"inputTextureCoordinate");
        this.mUniformTextureTransform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"textureTransform");
        this.onInit(texturePool);
        this.mIsInitialized = true;
        LiteavLog.d(TAG, "%s initialized, count: %d", this, sFilterCount.incrementAndGet());
    }

    public final void runOnDraw(Runnable runnable) {
        this.mRunOnDrawQueue.a(runnable);
    }

    public void onOutputSizeChanged(int width, int height) {
        this.mOutputSize.a = width;
        this.mOutputSize.b = height;
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public int getTarget() {
        return 3553;
    }

    public n getOutputSize() {
        return this.mOutputSize;
    }

    public boolean canBeSkipped() {
        return false;
    }

    public void onFilterBeenSkipped() {
        if (!this.mIsInitialized) {
            return;
        }
        GLES20.glUseProgram((int)this.getProgramId());
        this.runPendingOnDrawTasks();
    }

    public void setTexutreTransform(float[] matrix) {
        this.mTextureMatrix = matrix;
    }

    public void onDraw(int inTextureId, com.tencent.liteav.videobase.frame.d outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.mIsInitialized) {
            return;
        }
        GLES20.glUseProgram((int)this.getProgramId());
        this.runPendingOnDrawTasks();
        cubeCoordsBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)cubeCoordsBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
        textureCoordsBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoord, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureCoordsBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoord);
        if (inTextureId != -1) {
            GLES20.glActiveTexture((int)33984);
            OpenGlUtils.bindTexture(this.getTarget(), inTextureId);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
        }
        if (outTexture != null) {
            this.mGLFrameBuffer.a(outTexture.a());
            this.mGLFrameBuffer.b();
        } else {
            OpenGlUtils.bindFramebuffer(36160, 0);
        }
        float[] fArray = this.mTextureMatrix == null ? IDENTITY_MATRIX : this.mTextureMatrix;
        GLES20.glUniformMatrix4fv((int)this.mUniformTextureTransform, (int)1, (boolean)false, (float[])fArray, (int)0);
        this.beforeDrawArrays(inTextureId);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoord);
        this.afterDrawArrays();
        GLES20.glActiveTexture((int)33984);
        OpenGlUtils.bindTexture(this.getTarget(), 0);
        if (outTexture != null) {
            OpenGlUtils.bindFramebuffer(36160, 0);
            this.mGLFrameBuffer.c();
        }
    }

    public final void uninitialize() {
        if (!this.mIsInitialized) {
            return;
        }
        this.runPendingOnDrawTasks();
        this.onUninit();
        this.mIsInitialized = false;
        this.mGLFrameBuffer.d();
        if (this.mProgramId != -1) {
            GLES20.glDeleteProgram((int)this.mProgramId);
            this.mProgramId = -1;
        }
        LiteavLog.d(TAG, "%s uninitialized, count: %d", this, sFilterCount.decrementAndGet());
    }

    protected void onInit(com.tencent.liteav.videobase.frame.e texturePool) {
        this.mTexturePool = texturePool;
    }

    protected int buildProgram() {
        j j2 = this.mProgram;
        int n2 = j.a(j2.a, 35633);
        if (n2 == 0) {
            LiteavLog.e("Program", "load vertex shader failed.");
            return -1;
        }
        int n3 = j.a(j2.b, 35632);
        if (n3 == 0) {
            LiteavLog.e("Program", "load fragment shader failed.");
            GLES20.glDeleteShader((int)n2);
            return -1;
        }
        int n4 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n4, (int)n2);
        GLES20.glAttachShader((int)n4, (int)n3);
        GLES20.glLinkProgram((int)n4);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            LiteavLog.e("Program", "link program failed. status: " + nArray[0]);
            GLES20.glDeleteShader((int)n2);
            GLES20.glDeleteShader((int)n3);
            GLES20.glDeleteProgram((int)n4);
            return -1;
        }
        GLES20.glDeleteShader((int)n2);
        GLES20.glDeleteShader((int)n3);
        return n4;
    }

    public final int getProgramId() {
        return this.mProgramId;
    }

    protected void beforeDrawArrays(int textureId) {
    }

    protected void afterDrawArrays() {
    }

    protected void runPendingOnDrawTasks() {
        this.mRunOnDrawQueue.a();
    }

    protected void onUninit() {
    }

    protected boolean isLessOrEqualZero(float value) {
        return (double)value < 1.0E-5;
    }

    public void setFloatOnDraw(int location, float floatValue) {
        b b2 = this;
        b2.runOnDraw(c.a(b2, location, floatValue));
    }

    public void setFloatVec3OnDraw(int location, float[] arrayValue) {
        b b2 = this;
        b2.runOnDraw(d.a(b2, location, arrayValue));
    }

    public void setFloatVec2OnDraw(int location, float[] arrayValue) {
        b b2 = this;
        b2.runOnDraw(e.a(b2, location, arrayValue));
    }

    public void setFloatVec4OnDraw(int location, float[] arrayValue) {
        b b2 = this;
        b2.runOnDraw(f.a(b2, location, arrayValue));
    }

    protected void runOnDrawAndWaitDone(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.mRunOnDrawQueue.a(g.a(runnable, countDownLatch));
        try {
            countDownLatch.await();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    static /* synthetic */ void lambda$runOnDrawAndWaitDone$4(Runnable runnable, CountDownLatch countDownLatch) {
        runnable.run();
        countDownLatch.countDown();
    }

    static /* synthetic */ void lambda$setFloatVec4OnDraw$3(b this_, int location, float[] arrayValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform4fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
    }

    static /* synthetic */ void lambda$setFloatVec2OnDraw$2(b this_, int location, float[] arrayValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform2fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
    }

    static /* synthetic */ void lambda$setFloatVec3OnDraw$1(b this_, int location, float[] arrayValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform3fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
    }

    static /* synthetic */ void lambda$setFloatOnDraw$0(b this_, int location, float floatValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform1f((int)location, (float)floatValue);
    }
}

