/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videoproducer.capture.CaptureCloudConfig;
import com.tencent.liteav.videoproducer.capture.ScreenCapturer;
import com.tencent.liteav.videoproducer.capture.VirtualCamera;
import com.tencent.liteav.videoproducer.capture.t;
import java.util.Locale;

@JNINamespace(value="liteav::video")
public abstract class CaptureSourceInterface {
    private static final String TAG = "CaptureSourceInterface";

    @CalledByNative
    static CaptureSourceInterface create(SourceType sourceType, IVideoReporter reporter, Handler handler) {
        if (handler == null || handler.getLooper() == null) {
            LiteavLog.e(TAG, "create capture source instance with invalid handler ".concat(String.valueOf(handler)));
            return null;
        }
        Looper looper = handler.getLooper();
        Context context = ContextUtils.getApplicationContext();
        switch (sourceType) {
            case b: {
                return new t(reporter, looper);
            }
            case c: {
                return new ScreenCapturer(context, looper, reporter);
            }
            case d: {
                return new VirtualCamera(looper, reporter);
            }
        }
        return null;
    }

    @CalledByNative
    public abstract void start(Object var1, CaptureParams var2, CaptureSourceListener var3);

    @CalledByNative
    public abstract void pause();

    @CalledByNative
    public abstract void resume();

    @CalledByNative
    public abstract void updateParams(CaptureParams var1);

    @CalledByNative
    public abstract void stop();

    @CalledByNative
    public abstract void setCaptureCloudConfig(CaptureCloudConfig var1);

    public static interface CaptureSourceListener {
        public void onStartFinish(boolean var1);

        public void onFrameAvailable(CaptureSourceInterface var1, PixelFrame var2);

        public void onCaptureError();

        public void onScreenDisplayOrientationChanged(boolean var1);

        public void onCameraTouchEnable(boolean var1);

        public void onCameraZoomEnable(boolean var1);

        public void onCaptureFirstFrame();
    }

    public static class CaptureParams {
        public int b;
        public int c;
        public int d;
        public Rect e;

        public CaptureParams() {
        }

        public CaptureParams(CaptureParams params) {
            this.b = params.b;
            this.c = params.c;
            this.d = params.d;
            this.e = params.e;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof CaptureParams)) {
                return false;
            }
            CaptureParams captureParams = (CaptureParams)obj;
            return this.b == captureParams.b && this.c == captureParams.c && this.d == captureParams.d;
        }

        @NonNull
        public String toString() {
            return String.format(Locale.ENGLISH, "size: %dx%d, fps: %d", this.c, this.d, this.b);
        }
    }

    public static enum SourceType {
        a(0),
        b(1),
        c(2),
        d(3),
        e(4);

        private final int mValue;
        private static final SourceType[] f;

        private SourceType(int mValue) {
            this.mValue = mValue;
        }

        public static SourceType a(int n2) {
            SourceType[] sourceTypeArray = f;
            int n3 = f.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                SourceType sourceType = sourceTypeArray[i2];
                if (sourceType.mValue != n2) continue;
                return sourceType;
            }
            return a;
        }

        static {
            f = SourceType.values();
        }
    }
}

