/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.http;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;

@JNINamespace(value="liteav")
public class HttpClientAndroid {
    private static final String TAG = "HttpClientAndroid";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final int ERROR_CODE_INVALID_REQUEST = 0;
    private static final int READ_STREAM_SIZE = 1388;
    private static final int REDIRECT_REQUEST_MAX = 1;
    private final ConcurrentHashMap<Long, d> mRunningRequestMap = new ConcurrentHashMap();
    private final Handler mHttpHandler;
    private b mHttpConfig;
    private String mLastRequestURL;
    private HttpURLConnection mConnection;
    private final Object mLocker = new Object();
    private long mNativeHttpClientAndroidJni;
    private volatile c mInternalState = c.a;
    private long mTotalReadBytes = 0L;
    private long mStartReadTime = 0L;

    @CalledByNative
    public HttpClientAndroid(int connectTimeoutMs, int readTimeoutMs, int writeTimeoutMs, boolean isKeepAlive, int maxRecvSpeed, int socks5Port, String socks5Ip, String socks5User, String socks5Password, long nativeHttpClientAndroidJni) {
        this.mHttpConfig = new b(connectTimeoutMs, readTimeoutMs, writeTimeoutMs, isKeepAlive, maxRecvSpeed, socks5Port, socks5Ip, socks5User, socks5Password);
        this.mNativeHttpClientAndroidJni = nativeHttpClientAndroidJni;
        HandlerThread handlerThread = new HandlerThread("HttpClient_" + this.hashCode());
        handlerThread.start();
        LiteavLog.i(TAG, "Create http client(" + this.hashCode() + "). [ThreadName:" + handlerThread.getName() + "][ThreadId:" + handlerThread.getId() + "]");
        this.mHttpHandler = new Handler(handlerThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public long send(long requestId, String url, String method, byte[] body, Map<String, String> headers, boolean isRepeat) {
        if (!this.checkNativeValid()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Invalid native handle.");
            return 0L;
        }
        d d2 = new d(url, method, body, headers);
        if (!d2.a()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Invalid request url(" + d2.b + ").");
            return 0L;
        }
        if (!(!TextUtils.isEmpty((CharSequence)d2.d()))) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Request method(" + d2.c + ") is not supported.");
            return 0L;
        }
        Object object = this.mLocker;
        synchronized (object) {
            boolean bl2 = false;
            if (this.mInternalState == c.a) {
                this.mInternalState = isRepeat ? c.b : c.c;
                bl2 = true;
            } else if (this.mInternalState == c.c) {
                bl2 = true;
            }
            if (bl2) {
                d2.a = requestId;
                this.mRunningRequestMap.put(requestId, d2);
                this.mHttpHandler.post(com.tencent.liteav.base.http.a.a(this, d2));
                return d2.a;
            }
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Invalid state:" + (Object)((Object)this.mInternalState));
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void cancel(long requestId) {
        Object object = this.mLocker;
        synchronized (object) {
            if (!this.checkNativeValid()) {
                LiteavLog.e(TAG, "(" + this.hashCode() + ")Cancel request failed. Invalid native handle.");
                return;
            }
            if (this.mRunningRequestMap.size() == 0) {
                return;
            }
            d d2 = this.mRunningRequestMap.remove(requestId);
            LiteavLog.i(TAG, "(" + this.hashCode() + ")Cancel request. request:" + d2);
            if (this.mRunningRequestMap.size() == 0) {
                this.mInternalState = c.a;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void cancelAll() {
        Object object = this.mLocker;
        synchronized (object) {
            if (!this.checkNativeValid()) {
                LiteavLog.e(TAG, "(" + this.hashCode() + ")Cancel all request failed. Invalid native handle.");
                return;
            }
            if (this.mInternalState == c.a) {
                return;
            }
            this.mInternalState = c.a;
            LiteavLog.i(TAG, "(" + this.hashCode() + ")Cancel all. size:" + this.mRunningRequestMap.size());
            this.mRunningRequestMap.clear();
            this.mHttpHandler.post(com.tencent.liteav.base.http.b.a(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public void destroy() {
        Object object = this.mLocker;
        synchronized (object) {
            this.mRunningRequestMap.clear();
            this.mNativeHttpClientAndroidJni = -1L;
            LiteavLog.i(TAG, "(" + this.hashCode() + ")Destroy http client.");
            this.mHttpHandler.post(com.tencent.liteav.base.http.c.a(this));
            return;
        }
    }

    @CalledByNative
    public void updateConfig(final int connectTimeoutMs, final int readTimeoutMs, final int writeTimeoutMs, final boolean isKeepAlive, final int maxRecvSpeed, final int socks5Port, final String socks5Ip, final String socks5User, final String socks5Password, long nativeHttpClientAndroidJni) {
        this.mHttpHandler.post(new Runnable(){

            @Override
            public final void run() {
                HttpClientAndroid.this.mHttpConfig = new b(connectTimeoutMs, readTimeoutMs, writeTimeoutMs, isKeepAlive, maxRecvSpeed, socks5Port, socks5Ip, socks5User, socks5Password);
                if (maxRecvSpeed > 0) {
                    HttpClientAndroid.this.mTotalReadBytes = 0L;
                    HttpClientAndroid.this.mStartReadTime = SystemClock.elapsedRealtime();
                }
            }
        });
    }

    private boolean checkRequestValid(long requestId) {
        return this.mRunningRequestMap.containsKey(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNativeValid() {
        Object object = this.mLocker;
        synchronized (object) {
            return this.mNativeHttpClientAndroidJni != -1L;
        }
    }

    private HttpURLConnection createConnection(d request) throws Exception {
        Proxy proxy = null;
        if (TextUtils.isEmpty((CharSequence)this.mHttpConfig.g) && this.mHttpConfig.f > 0) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.mHttpConfig.g, this.mHttpConfig.f));
            Authenticator.setDefault(new a(this.mHttpConfig.h, this.mHttpConfig.i));
        }
        URL uRL = new URL(request.b.replace(" ", "%20"));
        HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)uRL.openConnection(proxy) : (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setConnectTimeout(this.mHttpConfig.a);
        httpURLConnection.setReadTimeout(this.mHttpConfig.b);
        httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        httpURLConnection.setRequestMethod(request.d());
        if (request.c()) {
            httpURLConnection.setDoOutput(true);
        }
        if (this.mHttpConfig.d) {
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        } else {
            httpURLConnection.setRequestProperty("Connection", "close");
        }
        if (request.e != null && !request.e.isEmpty()) {
            for (Map.Entry<String, String> entry : request.e.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return httpURLConnection;
    }

    private void closeConnectionSafely(HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanById(long requestId, boolean closeConnection) {
        this.mRunningRequestMap.remove(requestId);
        if (this.mRunningRequestMap.size() == 0) {
            Object object = this.mLocker;
            synchronized (object) {
                this.mInternalState = c.a;
            }
        }
        if (closeConnection) {
            HttpClientAndroid httpClientAndroid = this;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this.mConnection = null;
        }
    }

    private void doRequest(d request) {
        e e2 = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            e2 = this.internalRequest(request);
            if (e2 == null) {
                return;
            }
            if (e2.a != g.d && e2.a != g.e) break;
            request.b = this.mConnection.getHeaderField("Location");
        }
        this.mTotalReadBytes = 0L;
        this.mStartReadTime = SystemClock.elapsedRealtime();
        this.doReadData(request.a, e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private e internalRequest(d request) {
        boolean bl2;
        if (!request.a()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Invalid request url(" + request.b + ").");
            return null;
        }
        if (!this.checkRequestValid(request.a)) {
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Do send failed. ignore request when cancelled. request:" + request);
            return null;
        }
        e e2 = new e();
        Object object = this.mLocker;
        synchronized (object) {
            bl2 = this.mInternalState == c.c;
        }
        if (bl2 && this.mConnection != null && !request.b.equals(this.mLastRequestURL)) {
            HttpClientAndroid httpClientAndroid = this;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this.mConnection = null;
        }
        this.mLastRequestURL = request.b;
        try {
            this.mConnection = this.createConnection(request);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Do send failed. Fail to create http connection.");
            e2.a = this.getStatusCode((Exception)object);
            e2.b = ((Throwable)object).toString();
            this.doOnCallback(f.b, request.a, e2);
            this.doCleanById(request.a, true);
            return null;
        }
        if (request.c() && request.b()) {
            object = null;
            try {
                object = this.mConnection.getOutputStream();
                ((OutputStream)object).write(request.d);
                ((OutputStream)object).flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LiteavLog.w(TAG, "(" + this.hashCode() + ")Do send body failed.");
                try {
                    if (object != null) {
                        ((OutputStream)object).close();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        try {
            HttpClientAndroid httpClientAndroid = this;
            e2.a = httpClientAndroid.getStatusCode(httpClientAndroid.mConnection.getResponseCode());
            e2.b = this.mConnection.getResponseMessage();
            HttpClientAndroid httpClientAndroid2 = this;
            e2.e = httpClientAndroid2.parseHostAddress(httpClientAndroid2.mConnection.getURL().getHost());
            e2.g = this.mConnection.getURL().getPort();
            HttpClientAndroid httpClientAndroid3 = this;
            e2.f = httpClientAndroid3.getResponseHeaders(httpClientAndroid3.mConnection.getHeaderFields());
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Do send failed. Catch error.");
            e2.a = this.getStatusCode((Exception)object);
            e2.b = ((Throwable)object).toString();
            this.doOnCallback(f.b, request.a, e2);
            this.doCleanById(request.a, true);
            return null;
        }
        if (!this.checkRequestValid(request.a)) {
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Do send failed. Invalid request, abort request.");
            return null;
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadData(long requestId, e response) {
        Object object;
        boolean bl2;
        InputStream inputStream;
        if (!this.checkRequestValid(requestId)) {
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Do read data failed. Invalid request id. id:" + requestId);
            return;
        }
        try {
            inputStream = this.mConnection.getInputStream();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Do read data failed. Fail to get InputStream.");
            response.a = this.getStatusCode(exception2);
            response.b = exception2.toString();
            this.doOnCallback(f.b, requestId, response);
            this.doCleanById(requestId, true);
            return;
        }
        Object object2 = this.mLocker;
        synchronized (object2) {
            bl2 = this.mInternalState == c.c;
        }
        long l2 = 0L;
        if (bl2) {
            int n2;
            boolean bl3;
            object = new ByteArrayOutputStream();
            byte[] byArray = new byte[1388];
            do {
                try {
                    n2 = inputStream.read(byArray);
                    if (n2 > 0) {
                        ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                    }
                    bl3 = n2 > 0 && this.checkRequestValid(requestId);
                }
                catch (Exception exception) {
                    Exception exception3 = exception;
                    exception.printStackTrace();
                    LiteavLog.e(TAG, "(" + this.hashCode() + ")Do read data failed. Catch error when reading.");
                    response.a = this.getStatusCode(exception3);
                    response.b = exception3.toString();
                    this.doOnCallback(f.b, requestId, response);
                    this.doCleanById(requestId, true);
                    return;
                }
            } while (bl3);
            n2 = ((ByteArrayOutputStream)object).size();
            if (n2 > 0) {
                response.c = ByteBuffer.allocateDirect(n2);
                response.c.put(((ByteArrayOutputStream)object).toByteArray(), 0, n2);
                response.d = n2;
            }
        } else {
            int n3;
            object = new byte[1388];
            try {
                n3 = inputStream.read((byte[])object);
                this.mTotalReadBytes += (long)n3;
                l2 = SystemClock.elapsedRealtime();
            }
            catch (Exception exception) {
                Exception exception4 = exception;
                exception.printStackTrace();
                LiteavLog.e(TAG, "(" + this.hashCode() + ")Do read data failed. Catch error when reading.");
                response.a = this.getStatusCode(exception4);
                response.b = exception4.toString();
                this.doOnCallback(f.b, requestId, response);
                this.doCleanById(requestId, true);
                return;
            }
            if (n3 > 0) {
                response.c = ByteBuffer.allocateDirect(n3);
                response.c.put((byte[])object, 0, n3);
                response.d = n3;
            }
        }
        if (response.d == 0 && !bl2) {
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Do read data failed. Rsp size is 0.");
            this.doOnCallback(f.c, requestId, response);
            this.doCleanById(requestId, true);
            return;
        }
        if (bl2) {
            this.doOnCallback(f.c, requestId, response);
            this.doCleanById(requestId, !this.mHttpConfig.d);
            return;
        }
        this.doOnCallback(f.a, requestId, response);
        long l3 = 0L;
        if (this.mHttpConfig.e > 0) {
            long l4;
            long l5 = l4 = l2 - this.mStartReadTime == 0L ? 1L : l2 - this.mStartReadTime;
            if (this.mTotalReadBytes / l4 > (long)(this.mHttpConfig.e / 1000)) {
                l3 = this.mTotalReadBytes * 1000L / (long)this.mHttpConfig.e - l4;
            }
        }
        this.mHttpHandler.postDelayed(com.tencent.liteav.base.http.d.a(this, response, requestId), l3);
    }

    private String parseHostAddress(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Parse host error. host:" + host);
            return "";
        }
    }

    private Map<String, String> getResponseHeaders(Map<String, List<String>> headerFields) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnCallback(f state, long requestId, e response) {
        Object object = this.mLocker;
        synchronized (object) {
            if (this.checkNativeValid() && this.checkRequestValid(requestId) && response != null) {
                boolean bl2 = c.b == this.mInternalState;
                HttpClientAndroid.nativeOnCallback(this.mNativeHttpClientAndroidJni, bl2, state.nativeValue, requestId, response.a.nativeValue, response.b, response.g, response.c, response.e, response.f, response.d);
            }
            return;
        }
    }

    private static native void nativeOnCallback(long var0, boolean var2, int var3, long var4, int var6, String var7, int var8, ByteBuffer var9, String var10, Map var11, int var12);

    @CalledByNative
    public static String[] getMapKeys(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return new String[0];
        }
        Set<String> set = map.keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    @CalledByNative
    public static String[] getMapValue(Map<String, String> map, String[] keys) {
        if (map == null || map.isEmpty() || keys == null || keys.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[keys.length];
        for (int i2 = 0; i2 < keys.length; ++i2) {
            stringArray[i2] = map.get(keys[i2]);
        }
        return stringArray;
    }

    @CalledByNative
    public static HashMap getJavaHashMap(String[] keys, String[] values) {
        if (keys == null || keys.length == 0 || values == null || values.length == 0) {
            return new HashMap();
        }
        if (keys.length != values.length) {
            LiteavLog.w(TAG, "Invalid parameter, keys and values do not match.");
            return new HashMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            hashMap.put(keys[i2], values[i2]);
        }
        return hashMap;
    }

    private g getStatusCode(int code) {
        g g2 = g.x;
        if (code == 200) {
            g2 = g.a;
        } else if (code == 204) {
            g2 = g.b;
        } else if (code == 206) {
            g2 = g.c;
        } else if (code == 301) {
            g2 = g.d;
        } else if (code == 302) {
            g2 = g.e;
        } else if (code == 303) {
            g2 = g.f;
        } else if (code == 304) {
            g2 = g.g;
        } else if (code == 307) {
            g2 = g.h;
        } else if (code == 308) {
            g2 = g.i;
        } else if (code == 403) {
            g2 = g.j;
        } else if (code == 404) {
            g2 = g.k;
        } else if (code == 405) {
            g2 = g.l;
        } else if (code == 503) {
            g2 = g.m;
        } else {
            Log.w(TAG, "(" + this.hashCode() + ")Failed to convert status code\uff1a", code);
        }
        return g2;
    }

    private g getStatusCode(Exception e2) {
        g g2 = g.x;
        if (e2 instanceof FileNotFoundException) {
            g2 = g.n;
        } else if (e2 instanceof EOFException) {
            g2 = g.o;
        } else if (e2 instanceof UnknownHostException) {
            g2 = g.p;
        } else if (e2 instanceof NoRouteToHostException) {
            g2 = g.q;
        } else if (e2 instanceof SocketException || e2 instanceof MalformedURLException) {
            g2 = g.r;
        } else if (e2 instanceof SocketTimeoutException) {
            g2 = g.t;
        } else if (e2 instanceof ConnectException) {
            g2 = g.u;
        } else if (e2 instanceof ProtocolException) {
            g2 = g.v;
        } else if (e2 instanceof SSLException) {
            g2 = g.w;
        } else {
            Log.w(TAG, "(" + this.hashCode() + ")Failed to convert status code, exception\uff1a", e2.toString());
        }
        return g2;
    }

    static /* synthetic */ void lambda$doReadData$3(HttpClientAndroid this_, e response, long requestId) {
        e e2 = new e();
        new e().a = response.a;
        this_.doReadData(requestId, e2);
    }

    static /* synthetic */ void lambda$destroy$2(HttpClientAndroid this_) {
        HttpClientAndroid httpClientAndroid = this_;
        httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
        this_.mConnection = null;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
            this_.mHttpHandler.getLooper().quitSafely();
        } else {
            this_.mHttpHandler.getLooper().quit();
        }
        LiteavLog.i(TAG, "(" + this_.hashCode() + ")Quit looper finish.");
    }

    static /* synthetic */ void lambda$cancelAll$1(HttpClientAndroid this_) {
        HttpClientAndroid httpClientAndroid = this_;
        httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
        this_.mConnection = null;
        LiteavLog.i(TAG, "(" + this_.hashCode() + ")Cancel all finish.");
    }

    static /* synthetic */ void lambda$send$0(HttpClientAndroid this_, d request) {
        this_.doRequest(request);
    }

    static final class a
    extends Authenticator {
        String a;
        String b;

        a(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        @Override
        protected final PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.a, this.b.toCharArray());
        }
    }

    static enum c {
        a,
        b,
        c;

    }

    public static enum f {
        a(0),
        b(1),
        c(2);

        int nativeValue;

        private f(int n3) {
            this.nativeValue = n3;
        }
    }

    public static final class e {
        g a = com.tencent.liteav.base.http.HttpClientAndroid$g.x;
        String b = "";
        ByteBuffer c;
        int d = 0;
        String e = "";
        Map<String, String> f = null;
        int g = 0;
    }

    public static final class d {
        long a;
        String b;
        String c;
        byte[] d;
        Map<String, String> e;

        d(String string, String string2, byte[] byArray, Map<String, String> map) {
            this.b = string;
            this.c = string2;
            this.d = byArray;
            this.e = map;
        }

        final boolean a() {
            if (TextUtils.isEmpty((CharSequence)this.b)) {
                return false;
            }
            return this.b.startsWith(HttpClientAndroid.HTTP_PREFIX) || this.b.startsWith(HttpClientAndroid.HTTPS_PREFIX);
        }

        final boolean b() {
            return this.d != null && this.d.length > 0;
        }

        final boolean c() {
            return HttpClientAndroid.METHOD_POST.equals(this.d());
        }

        final String d() {
            if (TextUtils.isEmpty((CharSequence)this.c)) {
                return "";
            }
            if (HttpClientAndroid.METHOD_POST.equalsIgnoreCase(this.c)) {
                return HttpClientAndroid.METHOD_POST;
            }
            if (HttpClientAndroid.METHOD_GET.equalsIgnoreCase(this.c)) {
                return HttpClientAndroid.METHOD_GET;
            }
            return "";
        }

        public final String toString() {
            return "Request{requestId=" + this.a + ", url='" + this.b + '\'' + ", method='" + this.c + '\'' + ", body.size=" + (this.b() ? this.d.length : 0) + ", headers=" + this.e + '}';
        }
    }

    public static final class b {
        int a;
        int b;
        int c;
        boolean d;
        int e;
        int f;
        String g;
        String h;
        String i;

        b(int n2, int n3, int n4, boolean bl2, int n5, int n6, String string, String string2, String string3) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = bl2;
            this.e = n5;
            this.f = n6;
            this.g = string;
            this.h = string2;
            this.i = string3;
        }
    }

    static enum g {
        a(200),
        b(204),
        c(206),
        d(301),
        e(302),
        f(303),
        g(304),
        h(307),
        i(308),
        j(403),
        k(404),
        l(405),
        m(503),
        n(1001),
        o(1002),
        p(1003),
        q(1004),
        r(1005),
        s(1006),
        t(1007),
        u(1008),
        v(1009),
        w(1010),
        x(1999);

        final int nativeValue;

        private g(int n3) {
            this.nativeValue = n3;
        }
    }
}

