/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.opengl.GLES20;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.b.g;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;

@JNINamespace(value="liteav::video")
public class VirtualCameraPixelFrameCreator {
    private final String mTAG = "VirtualCameraPixelFrameCreator_" + this.hashCode();
    private final b mThrottlers = new b();
    private com.tencent.liteav.videobase.b.e mEGLCore;
    private e mGLTexturePool;

    @CalledByNative
    public VirtualCameraPixelFrameCreator(Object glContext) {
        this.initGLComponents(glContext);
    }

    private void initGLComponents(Object sharedContext) {
        LiteavLog.i(this.mTAG, "initGLComponents");
        this.mEGLCore = new com.tencent.liteav.videobase.b.e();
        try {
            this.mEGLCore.a(sharedContext, null, 128, 128);
            this.mEGLCore.a();
        }
        catch (g g2) {
            LiteavLog.e(this.mTAG, "initializeEGL failed.", g2);
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            this.mGLTexturePool = new e();
        }
    }

    private void uninitGLComponents() {
        LiteavLog.i(this.mTAG, "uninitGLComponents");
        if (this.mEGLCore == null) {
            return;
        }
        this.makeCurrent();
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.b();
            this.mGLTexturePool = null;
        }
        com.tencent.liteav.videobase.b.e.a(this.mEGLCore);
        this.mEGLCore = null;
    }

    @CalledByNative
    public PixelFrame createPixelFrame(Bitmap bitmap, int width, int height) {
        int n2;
        int n3;
        if (!this.makeCurrent()) {
            return null;
        }
        if (bitmap == null) {
            LiteavLog.i(this.mThrottlers.a("Bitmap.createBitmap"), this.mTAG, "bitmap is null. input size=" + width + "x" + height, new Object[0]);
            n3 = Math.max(width / 2 * 2, 2);
            n2 = Math.max(height / 2 * 2, 2);
            bitmap = Bitmap.createBitmap((int)n3, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(bitmap).drawARGB(255, 0, 0, 0);
        } else if (bitmap.getWidth() % 2 == 1 || bitmap.getHeight() % 2 == 1) {
            LiteavLog.i(this.mThrottlers.a("Bitmap.createBitmap"), this.mTAG, "original bitmap:" + bitmap.getWidth() + "x" + bitmap.getHeight(), new Object[0]);
            n3 = Math.max(bitmap.getWidth() / 2 * 2, 2);
            n2 = Math.max(bitmap.getHeight() / 2 * 2, 2);
            Bitmap bitmap2 = Bitmap.createBitmap((int)n3, (int)n2, (Bitmap.Config)bitmap.getConfig());
            Canvas canvas = new Canvas(bitmap2);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
            bitmap = bitmap2;
        }
        LiteavLog.i(this.mThrottlers.a("createPixelFrame"), this.mTAG, "createPixelFrame,bitmap:" + bitmap.getWidth() + "x" + bitmap.getHeight(), new Object[0]);
        d d2 = this.mGLTexturePool.a(bitmap.getWidth(), bitmap.getHeight());
        OpenGlUtils.loadTexture(bitmap, d2.a(), false);
        PixelFrame pixelFrame = d2.a(this.mEGLCore.c());
        pixelFrame.setTimestamp(TimeUtil.a());
        d2.release();
        GLES20.glFinish();
        return pixelFrame;
    }

    @CalledByNative
    public void releasePixelFrame(PixelFrame pixelFrame) {
        LiteavLog.i(this.mThrottlers.a("releasePixelFrame"), this.mTAG, "releasePixelFrame", new Object[0]);
        if (pixelFrame == null) {
            return;
        }
        this.makeCurrent();
        pixelFrame.release();
    }

    @CalledByNative
    private void release() {
        this.uninitGLComponents();
    }

    private boolean makeCurrent() {
        if (this.mEGLCore == null) {
            return false;
        }
        try {
            this.mEGLCore.a();
            return true;
        }
        catch (g g2) {
            LiteavLog.e(this.mThrottlers.a("makeCurrent"), this.mTAG, "EGLCore make current failed.", g2);
            return false;
        }
    }
}

