/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.i;
import com.tencent.liteav.base.util.k;
import com.tencent.liteav.base.util.n;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.c;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.BitmapUtils;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.utils.j;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.TXCCloudVideoViewMethodInvoker;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videoconsumer.renderer.RenderViewHelperInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoconsumer.renderer.aa;
import com.tencent.liteav.videoconsumer.renderer.ab;
import com.tencent.liteav.videoconsumer.renderer.ac;
import com.tencent.liteav.videoconsumer.renderer.ad;
import com.tencent.liteav.videoconsumer.renderer.ae;
import com.tencent.liteav.videoconsumer.renderer.af;
import com.tencent.liteav.videoconsumer.renderer.ag;
import com.tencent.liteav.videoconsumer.renderer.h;
import com.tencent.liteav.videoconsumer.renderer.p;
import com.tencent.liteav.videoconsumer.renderer.q;
import com.tencent.liteav.videoconsumer.renderer.r;
import com.tencent.liteav.videoconsumer.renderer.s;
import com.tencent.liteav.videoconsumer.renderer.t;
import com.tencent.liteav.videoconsumer.renderer.u;
import com.tencent.liteav.videoconsumer.renderer.v;
import com.tencent.liteav.videoconsumer.renderer.w;
import com.tencent.liteav.videoconsumer.renderer.x;
import com.tencent.liteav.videoconsumer.renderer.y;
import com.tencent.liteav.videoconsumer.renderer.z;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.rtmp.ui.a;
import com.tencent.rtmp.ui.b;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class o
extends VideoRenderInterface
implements RenderViewHelperInterface.RenderViewListener,
a,
b {
    private final String a = "VideoRenderer_" + this.hashCode();
    @NonNull
    private final Handler b = new Handler(Looper.getMainLooper());
    private final CustomHandler c;
    @NonNull
    private final IVideoReporter d;
    private final k e;
    @NonNull
    private final k f = new k(5);
    private final com.tencent.liteav.base.b.b g = new com.tencent.liteav.base.b.b();
    @NonNull
    private final Size h = new Size();
    private Surface i = null;
    private boolean j = false;
    private Object k;
    private EGLCore l = null;
    private final c m = new c();
    private com.tencent.liteav.videobase.frame.j n;
    private final j o = new j();
    private e p;
    private GLConstants.GLScaleType q = GLConstants.GLScaleType.a;
    private Rotation r = Rotation.a;
    private boolean s = false;
    private boolean t = false;
    @Nullable
    private DisplayTarget u;
    private RenderViewHelperInterface v;
    private final Size w = new Size();
    private Rotation x = Rotation.a;
    private volatile boolean y = false;
    private boolean z = false;
    private TakeSnapshotListener A;
    private VideoRenderListener B;
    private boolean C = false;
    private Bitmap D;
    private boolean E = false;
    private boolean F = false;

    public o(@NonNull Looper looper, @NonNull IVideoReporter iVideoReporter) {
        this.c = new CustomHandler(looper);
        this.e = null;
        this.d = iVideoReporter;
    }

    public o(@NonNull k k2, @NonNull IVideoReporter iVideoReporter) {
        this.c = null;
        this.e = k2;
        this.d = iVideoReporter;
    }

    @Override
    public final void start(VideoRenderListener listener) {
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.p.a(o2, listener));
    }

    @Override
    public final void stop(boolean clearLastImage) {
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.z.a(o2, clearLastImage));
    }

    @Override
    public final void setDisplayView(DisplayTarget displayTarget, boolean clearLastImage) {
        o o2 = this;
        o2.a(aa.a(o2, displayTarget, clearLastImage));
    }

    @Override
    public final void takeSnapshot(TakeSnapshotListener listener) {
        o o2 = this;
        o2.a(ab.a(o2, listener));
    }

    @Override
    public final void onTap(int x2, int y2, int width, int height) {
        o o2 = this;
        o2.a(ac.a(o2, x2, y2, width, height));
    }

    @Override
    public final void onZoom(float scale) {
        o o2 = this;
        o2.a(ad.a(o2, scale));
    }

    @Override
    public final void enableTapToFocusGesture(boolean enable) {
        o o2 = this;
        o2.a(ae.a(o2, enable));
    }

    @Override
    public final void enableZoomGesture(boolean enable) {
        o o2 = this;
        o2.a(af.a(o2, enable));
    }

    @Override
    public final void setScaleType(GLConstants.GLScaleType scaleType) {
        o o2 = this;
        o2.a(ag.a(o2, scaleType));
    }

    @Override
    public final void setRenderRotation(Rotation rotation) {
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.q.a(o2, rotation));
    }

    @Override
    public final void setHorizontalMirror(boolean mirror) {
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.r.a(o2, mirror));
    }

    @Override
    public final void setVerticalMirror(boolean mirror) {
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.s.a(o2, mirror));
    }

    @Override
    public final void renderFrame(PixelFrame pixelFrame) {
        if (!this.y) {
            return;
        }
        if (pixelFrame == null) {
            LiteavLog.w(this.a, "renderFrame pixelFrame is null!");
            return;
        }
        if (!this.z) {
            this.z = true;
            LiteavLog.d(this.a, "VideoRender receive first frame!");
        }
        pixelFrame.getGLContext();
        this.o.a(pixelFrame);
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.t.a(o2));
    }

    private void a(Runnable runnable) {
        if (this.e != null) {
            this.e.a(runnable);
            return;
        }
        if (Looper.myLooper() == this.c.getLooper()) {
            runnable.run();
            return;
        }
        this.c.post(runnable);
    }

    private void a() {
        if (this.l == null) {
            return;
        }
        LiteavLog.i(this.g.a("uninitGL"), this.a, "uninitializeEGL %d %s", this.i != null ? this.i.hashCode() : 0, this.h);
        try {
            this.l.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.g.a("makeCurrentError"), this.a, "uninitializeEGL EGLCore makeCurrent failed.".concat(String.valueOf(f2)), new Object[0]);
        }
        this.d();
        this.m.d();
        if (this.p != null) {
            this.p.a();
            this.p.b();
            this.p = null;
        }
        EGLCore.destroy(this.l);
        this.l = null;
    }

    private void a(DisplayTarget displayTarget, boolean bl) {
        LiteavLog.i(this.a, "setDisplayViewInternal=" + displayTarget + ",clearLastImage=" + bl);
        boolean bl2 = CommonUtil.equals(this.u, displayTarget);
        if (bl2 && displayTarget != null && this.v != null) {
            LiteavLog.w(this.a, "view is equal and RenderViewHelper is created.");
            return;
        }
        if (!bl2) {
            this.C = true;
            if (this.u != null && bl) {
                this.u.hideAll();
            }
        }
        this.a(bl);
        this.u = displayTarget;
        if (displayTarget == null) {
            return;
        }
        displayTarget.showAll();
        this.v = RenderViewHelperInterface.create(displayTarget, this);
    }

    private TXCloudVideoView b() {
        if (this.u == null) {
            return null;
        }
        return this.u.getTXCloudVideoView();
    }

    private void a(PixelFrame pixelFrame) {
        if (this.B != null) {
            this.B.onRenderFrame(pixelFrame);
        }
    }

    private boolean b(@NonNull PixelFrame pixelFrame) {
        Object object = pixelFrame.getGLContext();
        if (this.l == null || object != null && !CommonUtil.equals(this.k, object)) {
            this.a();
            Object object2 = pixelFrame.getGLContext();
            o o2 = this;
            if (o2.i != null) {
                try {
                    LiteavLog.i(o2.g.a("initGL"), o2.a, "initializeEGL surface=" + o2.i + ",size=" + o2.h, new Object[0]);
                    o2.l = new EGLCore();
                    o2.l.initialize(object2, o2.i, o2.h.width, o2.h.height);
                    o2.k = object2;
                    o2.l.makeCurrent();
                    if (o2.p == null) {
                        o2.p = new e();
                    }
                    o2.m.a();
                }
                catch (f f2) {
                    LiteavLog.e(o2.g.a("initGLError"), o2.a, "initializeEGL failed.", f2);
                    o2.l = null;
                    o2.d.notifyWarning(g.c.e, "VideoRender: create EGLCore fail:".concat(String.valueOf(f2)), new Object[0]);
                }
            }
        }
        if (this.l == null) {
            return false;
        }
        try {
            this.l.makeCurrent();
            return true;
        }
        catch (f f3) {
            LiteavLog.e(this.g.a("makeCurrentForFrameError"), this.a, "EGLCore makeCurrent failed.".concat(String.valueOf(f3)), new Object[0]);
            return false;
        }
    }

    private void c() {
        try {
            this.l.swapBuffers();
            return;
        }
        catch (f f2) {
            LiteavLog.e(this.g.a("swapBuffers"), this.a, "EGLCore swapBuffers failed.".concat(String.valueOf(f2)), new Object[0]);
            this.d.notifyWarning(g.c.g, "VideoRender: swapBuffer error:".concat(String.valueOf(f2)), new Object[0]);
            return;
        }
    }

    private void a(PixelFrame pixelFrame, boolean bl, boolean bl2, Rotation rotation, GLConstants.GLScaleType gLScaleType, boolean bl3) {
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        pixelFrame2.setRotation(Rotation.a((pixelFrame.getRotation().mValue + rotation.mValue) % 360));
        if (bl) {
            PixelFrame pixelFrame3 = pixelFrame2;
            pixelFrame3.setMirrorHorizontal(!pixelFrame3.isMirrorHorizontal());
        }
        if (bl2) {
            PixelFrame pixelFrame4 = pixelFrame2;
            pixelFrame4.setMirrorVertical(!pixelFrame4.isMirrorVertical());
        }
        if (rotation == Rotation.b || rotation == Rotation.d) {
            int n2 = pixelFrame2.getWidth();
            PixelFrame pixelFrame5 = pixelFrame2;
            pixelFrame5.setWidth(pixelFrame5.getHeight());
            pixelFrame2.setHeight(n2);
        }
        PixelFrame pixelFrame6 = pixelFrame2;
        pixelFrame6.setMirrorVertical(!pixelFrame6.isMirrorVertical());
        if (pixelFrame2.getRotation() != Rotation.a && pixelFrame2.getRotation() != Rotation.c) {
            PixelFrame pixelFrame7 = pixelFrame2;
            pixelFrame7.setRotation(Rotation.a((pixelFrame7.getRotation().mValue + Rotation.c.mValue) % 360));
        }
        if (bl3 && this.v != null) {
            this.v.updateVideoFrameInfo(this.q, pixelFrame2.getWidth(), pixelFrame2.getHeight());
        }
        if (this.n != null) {
            if (this.v instanceof h) {
                this.n.a(pixelFrame2, GLConstants.GLScaleType.c, null);
                return;
            }
            this.n.a(pixelFrame2, gLScaleType, null);
        }
    }

    private void a(Surface surface, boolean bl) {
        if (com.tencent.liteav.base.util.i.a(this.i, surface)) {
            LiteavLog.d(this.a, "updateSurface same surface!");
            return;
        }
        this.a();
        if (this.j && this.i != null) {
            this.i.release();
        }
        this.i = surface;
        if (this.i == null) {
            this.h.set(0, 0);
        }
        this.j = bl;
    }

    private void a(boolean bl) {
        if (this.v != null) {
            this.v.release(bl);
            this.v = null;
        }
    }

    @Override
    public final void onSurfaceChanged(Surface surface, boolean isNeedRelease) {
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.v.a(o2, surface, isNeedRelease));
    }

    @Override
    public final void onRequestRedraw(@NonNull Bitmap bitmap) {
        this.a(bitmap);
        o o2 = this;
        o2.a(com.tencent.liteav.videoconsumer.renderer.w.a(o2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap a(Bitmap bitmap) {
        o o2 = this;
        synchronized (o2) {
            Bitmap bitmap2 = this.D;
            this.D = bitmap;
            return bitmap2;
        }
    }

    @Override
    public final void onSurfaceDestroy() {
        o o2 = this;
        Runnable runnable = com.tencent.liteav.videoconsumer.renderer.x.a(o2);
        o o3 = o2;
        if (o2.e != null) {
            Runnable runnable2 = runnable;
            k k2 = o3.e;
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable runnable3 = com.tencent.liteav.base.util.n.a(runnable2, countDownLatch);
            k2.a.execute(runnable3);
            try {
                countDownLatch.await(2000L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (Looper.myLooper() == o3.c.getLooper()) {
            runnable.run();
            return;
        }
        o3.c.runAndWaitDone(runnable, 2000L);
    }

    private void d() {
        if (this.n != null) {
            this.n.a();
            this.n = null;
        }
    }

    static /* synthetic */ void a(o o2) {
        LiteavLog.i(o2.a, "onSurfaceDestroy " + o2.i);
        o2.a((Surface)null, o2.j);
    }

    static /* synthetic */ void b(o o2) {
        Bitmap bitmap = o2.a((Bitmap)null);
        if (bitmap == null) {
            return;
        }
        PixelFrame pixelFrame = PixelFrame.createFromBitmap(bitmap);
        if (!o2.b(pixelFrame)) {
            pixelFrame.release();
            return;
        }
        OpenGlUtils.glViewport(0, 0, o2.h.width, o2.h.height);
        o2.a(pixelFrame, false, false, Rotation.a, o2.q, false);
        o2.c();
    }

    static /* synthetic */ void a(o o2, Surface surface, boolean bl) {
        LiteavLog.i(o2.a, "onSurfaceChanged surface: %s, oldSurface: %s, isNeedRelease: %b", surface, o2.i, bl);
        o2.a(surface, bl);
    }

    static /* synthetic */ void a(o o2, RenderViewHelperInterface renderViewHelperInterface, ByteBuffer byteBuffer, int n2, int n3, TakeSnapshotListener takeSnapshotListener) {
        TextureView textureView = null;
        if (renderViewHelperInterface instanceof h) {
            textureView = ((h)renderViewHelperInterface).a;
        }
        Matrix matrix = textureView == null ? null : textureView.getTransform(new Matrix());
        o2.f.a(com.tencent.liteav.videoconsumer.renderer.y.a(o2, byteBuffer, n2, n3, matrix, takeSnapshotListener));
    }

    static /* synthetic */ void a(o o2, ByteBuffer byteBuffer, int n2, int n3, Matrix matrix, TakeSnapshotListener takeSnapshotListener) {
        TakeSnapshotListener takeSnapshotListener2 = takeSnapshotListener;
        Matrix matrix2 = matrix;
        int n4 = n3;
        int n5 = n2;
        ByteBuffer byteBuffer2 = byteBuffer;
        o o3 = o2;
        try {
            byteBuffer2.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer2);
            Matrix matrix3 = matrix2 == null ? new Matrix() : matrix2;
            matrix3.postScale(1.0f, -1.0f, (float)n5 / 2.0f, (float)n4 / 2.0f);
            bitmap = BitmapUtils.createBitmap(bitmap, matrix3, true);
            takeSnapshotListener2.onComplete(bitmap);
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(o3.a, "build snapshot bitmap failed.", throwable);
            takeSnapshotListener2.onComplete(null);
            return;
        }
    }

    static /* synthetic */ void a(o o2, boolean bl) {
        if (o2.t != bl) {
            LiteavLog.i(o2.a, "setVerticalMirror ".concat(String.valueOf(bl)));
        }
        o2.t = bl;
    }

    static /* synthetic */ void b(o o2, boolean bl) {
        if (o2.s != bl) {
            LiteavLog.i(o2.a, "setHorizontalMirror ".concat(String.valueOf(bl)));
        }
        o2.s = bl;
    }

    static /* synthetic */ void a(o o2, Rotation rotation) {
        if (o2.r != rotation) {
            LiteavLog.i(o2.a, "setRenderRotation ".concat(String.valueOf((Object)rotation)));
            o2.r = rotation;
        }
    }

    static /* synthetic */ void a(o o2, GLConstants.GLScaleType gLScaleType) {
        if (o2.q != gLScaleType) {
            LiteavLog.i(o2.a, "setScaleType ".concat(String.valueOf((Object)gLScaleType)));
            o2.q = gLScaleType;
        }
    }

    static /* synthetic */ void c(o o2, boolean bl) {
        LiteavLog.i(o2.a, "enableZoomGesture enable:".concat(String.valueOf(bl)));
        TXCloudVideoView tXCloudVideoView = o2.b();
        if (tXCloudVideoView != null) {
            boolean bl2 = bl;
            TXCCloudVideoViewMethodInvoker.setZoomEnabled(tXCloudVideoView, bl2, bl2 ? o2 : null);
        }
        o2.F = bl;
    }

    static /* synthetic */ void d(o o2, boolean bl) {
        LiteavLog.i(o2.a, "enableTapToFocusGesture enable:".concat(String.valueOf(bl)));
        TXCloudVideoView tXCloudVideoView = o2.b();
        if (tXCloudVideoView != null) {
            boolean bl2 = bl;
            TXCCloudVideoViewMethodInvoker.setTouchToFocusEnabled(tXCloudVideoView, bl2, bl2 ? o2 : null);
        }
        o2.E = bl;
    }

    static /* synthetic */ void a(o o2, float f2) {
        if (!o2.F) {
            return;
        }
        if (o2.B != null) {
            o2.B.onZoom(f2);
        }
    }

    static /* synthetic */ void a(o o2, int n2, int n3, int n4, int n5) {
        TXCloudVideoView tXCloudVideoView;
        if (!o2.E) {
            return;
        }
        Point point = OpenGlUtils.reverseMappingPoint(GLConstants.GLScaleType.a, o2.x, new Point(n2, n3), new Size(n4, n5), o2.w);
        if (o2.B != null) {
            o2.B.onFocusAtPoint(point.x, point.y, n4, n5);
        }
        if ((tXCloudVideoView = o2.b()) != null) {
            TXCCloudVideoViewMethodInvoker.showFocusView(tXCloudVideoView, n2, n3, n4, n5);
        }
    }

    static /* synthetic */ void a(o o2, TakeSnapshotListener takeSnapshotListener) {
        LiteavLog.i(o2.a, "takeSnapshot ");
        o2.A = takeSnapshotListener;
    }

    static /* synthetic */ void a(o o2, DisplayTarget displayTarget, boolean bl) {
        o2.a(displayTarget, bl);
    }

    static /* synthetic */ void e(o o2, boolean bl) {
        LiteavLog.i(o2.a, "Stop,clearLastImage=".concat(String.valueOf(bl)));
        if (!o2.y) {
            LiteavLog.w(o2.a, "renderer is not started!");
            return;
        }
        o2.y = false;
        o2.A = null;
        o2.a(bl);
        if (o2.u != null && bl) {
            o2.u.hideAll();
        }
        o2.o.b();
        o2.a();
        if (o2.j && o2.i != null) {
            o2.i.release();
            o2.j = false;
        }
        o2.i = null;
        o2.h.set(0, 0);
        o2.w.set(0, 0);
        o2.z = false;
    }

    static /* synthetic */ void a(o o2, VideoRenderListener videoRenderListener) {
        LiteavLog.i(o2.a, "Start");
        if (o2.y) {
            LiteavLog.w(o2.a, "renderer is started!");
            return;
        }
        o2.y = true;
        o2.B = videoRenderListener;
        if (o2.u != null) {
            o o3 = o2;
            o3.a(o3.u, true);
        }
    }

    static /* synthetic */ void c(o o2) {
        PixelFrame pixelFrame;
        o o3;
        block13: {
            Size size;
            o3 = o2;
            pixelFrame = o3.o.a();
            if (pixelFrame == null) {
                LiteavLog.d(o3.a, "renderFrameInternal pixelFrame is null!");
                return;
            }
            o3.w.set(pixelFrame.getWidth(), pixelFrame.getHeight());
            FrameMetaData frameMetaData = pixelFrame.getMetaData();
            if (frameMetaData != null) {
                o3.r = frameMetaData.getRenderRotation();
                o3.s = frameMetaData.isRenderMirrorHorizontal();
                o3.t = frameMetaData.isRenderMirrorVertical();
                o3.w.set(frameMetaData.getCaptureRealSize());
                o3.x = Rotation.a(frameMetaData.getCaptureRotation());
            }
            if (!o3.b(pixelFrame)) {
                o3.a(pixelFrame);
                pixelFrame.release();
                return;
            }
            o o4 = o3;
            if (o4.l != null && !o4.h.equals(size = o4.l.getSurfaceSize())) {
                LiteavLog.i(o4.a, "surface size changed,old size=" + o4.h + ",new size=" + size);
                o4.h.set(size);
                o4.d();
                if (o4.i != null) {
                    o4.d.updateStatus(com.tencent.liteav.videobase.videobase.h.u, o4.h.width << 16 | o4.h.height);
                }
                if (o4.B != null) {
                    o4.B.onRenderTargetSizeChanged(o4.h.width, o4.h.height);
                }
            }
            if (o3.n == null) {
                LiteavLog.i(o3.a, "create PixelFrameRenderer,surfaceSize=" + o3.h);
                o3.n = new com.tencent.liteav.videobase.frame.j(o3.h.width, o3.h.height);
            }
            OpenGlUtils.glViewport(0, 0, o3.h.width, o3.h.height);
            o3.a(pixelFrame, o3.s, o3.t, o3.r, o3.q, true);
            if (o3.A != null) {
                OpenGlUtils.bindFramebuffer(36160, 0);
                o o5 = o3;
                int n2 = o3.h.height;
                int n3 = o5.h.width;
                o4 = o5;
                TakeSnapshotListener takeSnapshotListener = o5.A;
                if (takeSnapshotListener != null) {
                    ByteBuffer byteBuffer;
                    o4.A = null;
                    try {
                        byteBuffer = ByteBuffer.allocateDirect(n3 * n2 * 4).order(ByteOrder.nativeOrder());
                        byteBuffer.position(0);
                    }
                    catch (Throwable throwable) {
                        LiteavLog.e(o4.a, "can't alloc buffer, size: " + n3 * n2 * 4);
                        takeSnapshotListener.onComplete(null);
                        break block13;
                    }
                    GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
                    RenderViewHelperInterface renderViewHelperInterface = o4.v;
                    o4.b.post(com.tencent.liteav.videoconsumer.renderer.u.a(o4, renderViewHelperInterface, byteBuffer, n3, n2, takeSnapshotListener));
                }
            }
        }
        o3.c();
        o3.a(pixelFrame);
        if (o3.C) {
            o3.d.notifyEvent(g.b.i, null, new Object[0]);
            if (o3.B != null) {
                o3.B.onRenderFirstFrameOnView(o3.h.width, o3.h.height);
            }
            o3.C = false;
        }
        pixelFrame.release();
    }
}

