/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;

@JNINamespace(value="liteav::video")
public class CustomFrameToPixelFrameConverter {
    private static final String TAG = "CustomFrameToPixelFrameConverter";
    private final b mThrottlers = new b();
    @Nullable
    private EGLCore mEGLCore = null;
    @Nullable
    private j mPixelFrameRenderer = null;
    @Nullable
    private e mGLTexturePool = null;
    @Nullable
    private final Object mSharedContext;
    private int mWidth = 0;
    private int mHeight = 0;

    @CalledByNative
    public CustomFrameToPixelFrameConverter(@Nullable Object sharedContext) {
        this.mSharedContext = sharedContext;
    }

    @CalledByNative
    public void release() {
        this.uninitializedGLComponents();
    }

    @CalledByNative
    public PixelFrame convertFrame(@Nullable PixelFrame pixelFrame) {
        if (pixelFrame == null) {
            LiteavLog.w(TAG, "convertFrame: pixelFrame is null.");
            return null;
        }
        if (this.mEGLCore == null || this.isNeedRecreateEGL(pixelFrame, this.mEGLCore)) {
            this.mWidth = pixelFrame.getWidth();
            this.mHeight = pixelFrame.getHeight();
            this.uninitializedGLComponents();
            CustomFrameToPixelFrameConverter customFrameToPixelFrameConverter = this;
            customFrameToPixelFrameConverter.initializeGLComponents(customFrameToPixelFrameConverter.mWidth, this.mHeight, pixelFrame);
        }
        if (this.mEGLCore == null || this.mGLTexturePool == null || this.mPixelFrameRenderer == null) {
            return null;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(TAG, "EGL makeCurrent error ", f2);
        }
        OpenGlUtils.glViewport(0, 0, this.mWidth, this.mHeight);
        d d2 = this.mGLTexturePool.a(this.mWidth, this.mHeight);
        GLConstants.GLScaleType gLScaleType = GLConstants.GLScaleType.a;
        this.mPixelFrameRenderer.a(pixelFrame, gLScaleType, d2);
        GLES20.glFinish();
        PixelFrame pixelFrame2 = d2.a(this.mEGLCore.getEglContext());
        pixelFrame2.setTimestamp(pixelFrame.getTimestamp());
        d2.release();
        return pixelFrame2;
    }

    @CalledByNative
    public void releaseFrame(PixelFrame pixelFrame) {
        if (pixelFrame != null) {
            pixelFrame.release();
        }
    }

    private void initializeGLComponents(int width, int height, @NonNull PixelFrame frame) {
        if (this.mEGLCore != null) {
            LiteavLog.w(this.mThrottlers.a("initGL"), TAG, "egl is initialized!", new Object[0]);
            return;
        }
        Object object = frame.getGLContext() != null ? frame.getGLContext() : this.mSharedContext;
        try {
            this.mEGLCore = new EGLCore();
            this.mEGLCore.initialize(object, null, width, height);
            this.mEGLCore.makeCurrent();
            LiteavLog.i(this.mThrottlers.a("initSuccess"), TAG, "initialize egl, width: " + width + ", height: " + height + ", sharedContext: " + object, new Object[0]);
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("initError"), TAG, "initialize egl failed.", f2);
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            this.mGLTexturePool = new e();
            if (this.mPixelFrameRenderer == null) {
                this.mPixelFrameRenderer = new j(width, height);
            }
        }
    }

    private void uninitializedGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("make"), TAG, "uninitialize egl, make current error ", f2);
        }
        LiteavLog.i(this.mThrottlers.a("uninitGL"), TAG, "uninitialize egl", new Object[0]);
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.a();
            this.mPixelFrameRenderer = null;
        }
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.a();
            this.mGLTexturePool.b();
            this.mGLTexturePool = null;
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private boolean isNeedRecreateEGL(@NonNull PixelFrame renderFrame, @NonNull EGLCore eglCore) {
        boolean bl;
        boolean bl2 = bl = renderFrame.getGLContext() != null && !CommonUtil.equals(renderFrame.getGLContext(), eglCore.getSharedContext());
        return renderFrame.getHeight() != this.mHeight || renderFrame.getWidth() != this.mWidth || bl;
    }
}

