/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture.b;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.SystemUtil;
import com.tencent.liteav.base.util.h;
import com.tencent.liteav.base.util.u;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videoproducer.capture.CameraCaptureParams;
import com.tencent.liteav.videoproducer.capture.CameraControllerInterface;
import com.tencent.liteav.videoproducer.capture.CameraEventCallback;
import com.tencent.liteav.videoproducer.capture.CaptureCloudConfig;
import com.tencent.liteav.videoproducer.capture.ah;
import com.tencent.liteav.videoproducer.capture.b.b;
import com.tencent.liteav.videoproducer.capture.b.c;
import com.tencent.liteav.videoproducer.capture.b.d;
import com.tencent.liteav.videoproducer.capture.b.e;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@TargetApi(value=21)
public final class a
extends CameraControllerInterface {
    private static final HashMap<String, CameraCharacteristics> b = new HashMap();
    private static boolean c;
    private static String d;
    private static String e;
    private final Handler f = new Handler(Looper.getMainLooper());
    private final u g;
    private final AtomicBoolean h = new AtomicBoolean(false);
    private final AtomicReference<CameraDevice> i = new AtomicReference();
    private final AtomicBoolean j = new AtomicBoolean(false);
    private final AtomicReference<CameraCaptureSession> k = new AtomicReference();
    private CaptureRequest l;
    private CaptureRequest.Builder m;
    private com.tencent.liteav.base.util.Size n;
    private Rotation o = Rotation.a;
    private SurfaceTexture p;
    private boolean q = true;
    private boolean r = true;
    private boolean s = true;
    private int t = -1;
    private a u = com.tencent.liteav.videoproducer.capture.b.a$a.a;
    private boolean v = false;
    public boolean a = false;
    private CountDownLatch w;
    private CountDownLatch x;
    private CameraEventCallback y;
    private float z = 0.0f;
    private final CameraDevice.StateCallback A = new CameraDevice.StateCallback(){

        public final void onOpened(@NonNull CameraDevice cameraDevice) {
            LiteavLog.i("Camera2Controller", "CameraDevice onOpen!");
            a.this.a(true, cameraDevice);
        }

        public final void onDisconnected(@NonNull CameraDevice cameraDevice) {
            LiteavLog.e("Camera2Controller", "CameraDevice onDisconnected!");
            a.this.a(false, cameraDevice);
            com.tencent.liteav.videoproducer.capture.b.a.b(a.this);
        }

        public final void onError(@NonNull CameraDevice cameraDevice, int error) {
            LiteavLog.e("Camera2Controller", "CameraDevice onError, error:".concat(String.valueOf(error)));
            a.this.a(false, cameraDevice);
        }

        public final void onClosed(@NonNull CameraDevice camera) {
            LiteavLog.i("Camera2Controller", "CameraDevice onClosed");
        }
    };
    private final CameraCaptureSession.StateCallback B = new CameraCaptureSession.StateCallback(){

        public final void onConfigured(@NonNull CameraCaptureSession session) {
            LiteavLog.i("Camera2Controller", "CameraCaptureSession onConfigured!");
            a.this.a(true, session);
        }

        public final void onConfigureFailed(@NonNull CameraCaptureSession session) {
            LiteavLog.e("Camera2Controller", "CameraCaptureSession onConfigureFailed!");
            a.this.a(false, session);
        }
    };
    private final CameraManager.AvailabilityCallback C = new CameraManager.AvailabilityCallback(){

        public final void onCameraAvailable(@NonNull String cameraId) {
            super.onCameraAvailable(cameraId);
            LiteavLog.i("Camera2Controller", "onCameraAvailable: ".concat(String.valueOf(cameraId)));
            if (!a.this.g() && com.tencent.liteav.videoproducer.capture.b.a.b(a.this.q).equals(cameraId) && a.this.h.get()) {
                LiteavLog.w("Camera2Controller", "Current camera is available, it could be interrupted by system app.");
                a.this.a(false, (CameraDevice)a.this.i.get());
                com.tencent.liteav.videoproducer.capture.b.a.b(a.this);
            }
        }

        public final void onCameraUnavailable(@NonNull String cameraId) {
            super.onCameraUnavailable(cameraId);
            LiteavLog.i("Camera2Controller", "onCameraUnavailable: ".concat(String.valueOf(cameraId)));
        }

        public final void onCameraAccessPrioritiesChanged() {
            super.onCameraAccessPrioritiesChanged();
        }
    };
    private final CameraCaptureSession.CaptureCallback D = new CameraCaptureSession.CaptureCallback(){

        private static boolean a(CaptureRequest captureRequest) {
            return captureRequest.getTag() instanceof a && !((a)captureRequest.getTag()).a;
        }

        private void a(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, boolean bl) {
            if (a.this.g()) {
                return;
            }
            com.tencent.liteav.videoproducer.capture.b.a.g(a.this);
            try {
                a.this.m.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                a.this.m.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                cameraCaptureSession.setRepeatingRequest(captureRequest, null, null);
                if (captureRequest.getTag() instanceof a) {
                    com.tencent.liteav.videoproducer.capture.b.a.a((a)captureRequest.getTag(), bl);
                }
                return;
            }
            catch (Exception exception) {
                LiteavLog.e("Camera2Controller", "mAfCaptureCallback exception:".concat(String.valueOf(exception)));
                return;
            }
        }

        public final void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
        }

        public final void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            a.this.g.a(com.tencent.liteav.videoproducer.capture.b.d.a(this, result, session, request));
        }

        public final void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
            LiteavLog.e("Camera2Controller", "onCaptureFailed failure reason:" + failure.getReason());
            a.this.g.a(com.tencent.liteav.videoproducer.capture.b.e.a(this, request, session));
        }

        static /* synthetic */ void a(@NonNull 4 var0, @NonNull CaptureRequest captureRequest, CameraCaptureSession cameraCaptureSession) {
            if (!4.a(captureRequest)) {
                com.tencent.liteav.videoproducer.capture.b.a.g(var0.a.this);
                return;
            }
            var0.a(cameraCaptureSession, captureRequest, false);
        }

        static /* synthetic */ void a(@NonNull 4 var0, @NonNull TotalCaptureResult totalCaptureResult, @NonNull CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest) {
            CaptureRequest captureRequest2 = captureRequest;
            CameraCaptureSession cameraCaptureSession2 = cameraCaptureSession;
            TotalCaptureResult totalCaptureResult2 = totalCaptureResult;
            4 var4_7 = var0;
            if (!4.a(captureRequest2)) {
                com.tencent.liteav.videoproducer.capture.b.a.g(var4_7.a.this);
                return;
            }
            Integer n2 = (Integer)totalCaptureResult2.get(CaptureResult.CONTROL_AF_STATE);
            if (n2 == null) {
                LiteavLog.e("Camera2Controller", "handleCaptureCompleted get afState fail");
                var4_7.a(cameraCaptureSession2, captureRequest2, false);
                return;
            }
            if (4 == n2 || 5 == n2) {
                var4_7.a(cameraCaptureSession2, captureRequest2, true);
            }
        }
    };

    public a(u u2) {
        this.g = u2;
    }

    @Override
    public final boolean startCapture(CameraCaptureParams captureParams, SurfaceTexture surfaceTexture, CameraEventCallback eventCallback) {
        boolean bl;
        Range<Integer> range;
        Object object;
        this.y = eventCallback;
        if (!c) {
            try {
                object = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
                for (String string : object.getCameraIdList()) {
                    CameraCharacteristics cameraCharacteristics = object.getCameraCharacteristics(string);
                    range = (Range<Integer>)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                    if (range != null && range.intValue() == 0 && "1".equals(string)) {
                        b.put(string, cameraCharacteristics);
                        e = string;
                        continue;
                    }
                    if (range == null || range.intValue() != 1 || !"0".equals(string)) continue;
                    b.put(string, cameraCharacteristics);
                    d = string;
                }
                LiteavLog.i("Camera2Controller", "initCamera2Ability front:" + e + ", back:" + d);
            }
            catch (Exception exception) {
                e = "1";
                LiteavLog.e("Camera2Controller", "initCamera2Ability exception!".concat(String.valueOf(exception)));
            }
            c = true;
        }
        if (captureParams == null || surfaceTexture == null) {
            LiteavLog.e("Camera2Controller", "captureParams or surfaceTexture is null");
            return false;
        }
        if (this.u != com.tencent.liteav.videoproducer.capture.b.a$a.a) {
            LiteavLog.e("Camera2Controller", "it's capturing, you should Stop first.");
            return false;
        }
        SurfaceTexture surfaceTexture2 = surfaceTexture;
        CameraCaptureParams cameraCaptureParams = captureParams;
        object = this;
        this.p = surfaceTexture2;
        ((a)object).q = cameraCaptureParams.a;
        Object object2 = object;
        if (super.a() == null) {
            bl = false;
        } else {
            int[] nArray = (int[])super.a().get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            if (nArray.length == 0 || nArray.length == 1 && nArray[0] == 0) {
                LiteavLog.w("Camera2Controller", "Current " + (((a)object2).q ? "front camera " : "back camera ") + " is not support auto focus.");
                bl = false;
            } else {
                bl = true;
            }
        }
        ((a)object2).s = bl;
        ((CameraManager)ContextUtils.getApplicationContext().getSystemService("camera")).registerAvailabilityCallback(((a)object).C, ((a)object).f);
        if (!super.a(cameraCaptureParams.c, cameraCaptureParams.d)) {
            LiteavLog.e("Camera2Controller", "openCamera failed.");
            super.c();
            ((a)object).u = com.tencent.liteav.videoproducer.capture.b.a$a.a;
            return false;
        }
        if (!super.a(surfaceTexture2)) {
            LiteavLog.e("Camera2Controller", "startPreview failed.");
            super.b();
            ((a)object).u = com.tencent.liteav.videoproducer.capture.b.a$a.a;
            return false;
        }
        ((a)object).m.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        range = super.a(cameraCaptureParams.b);
        ((a)object).m.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, range);
        Object object3 = object;
        super.c(((a)object3).r);
        Object object4 = object;
        ((a)object4).setZoom(((a)object4).z);
        ((a)object).l = ((a)object).m.build();
        super.d();
        ((a)object).u = com.tencent.liteav.videoproducer.capture.b.a$a.b;
        LiteavLog.i("Camera2Controller", "startCaptureInternal ok.");
        return true;
    }

    @Override
    public final void stopCapture() {
        a a2 = this;
        CountDownLatch countDownLatch = a2.w;
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
        a2.w = null;
        CountDownLatch countDownLatch2 = a2.x;
        if (countDownLatch2 != null) {
            countDownLatch2.countDown();
        }
        a2.x = null;
        try {
            this.b();
            this.c();
        }
        catch (Exception exception) {
            LiteavLog.e("Camera2Controller", "closeCamera fail, Exception:".concat(String.valueOf(exception)));
        }
        this.l = null;
        this.a = false;
        this.p = null;
        this.t = -1;
        this.u = com.tencent.liteav.videoproducer.capture.b.a$a.a;
        LiteavLog.i("Camera2Controller", "stopCapture success");
    }

    @Override
    public final void startAutoFocusAtPosition(int x2, int y2) {
        int n2;
        int n3;
        double d2;
        if (!this.r || !this.s) {
            return;
        }
        if (this.g() || this.v) {
            LiteavLog.e("Camera2Controller", "autoFocus not preview, mCameraStatus:" + (Object)((Object)this.u) + " mIsAutoFocusing:" + this.v);
            return;
        }
        CameraCaptureSession cameraCaptureSession = this.k.get();
        if (cameraCaptureSession == null) {
            LiteavLog.e("Camera2Controller", "CameraCaptureSession get fail");
            return;
        }
        if (x2 < 0 || x2 >= this.n.width || y2 < 0 || y2 >= this.n.height) {
            LiteavLog.w("Camera2Controller", "Start auto focus at (%d, %d) invalid ", x2, y2);
            return;
        }
        LiteavLog.i("Camera2Controller", "Start auto focus at (%d, %d)", x2, y2);
        double d3 = y2;
        double d4 = x2;
        a a2 = this;
        int n4 = a2.n.width;
        int n5 = a2.n.height;
        if (a2.o == Rotation.b || a2.o == Rotation.d) {
            n4 = a2.n.height;
            n5 = a2.n.width;
        }
        com.tencent.liteav.base.util.Size size = SystemUtil.getDisplaySize(ContextUtils.getApplicationContext());
        double d5 = 0.0;
        double d6 = 0.0;
        if (n5 * size.width > n4 * size.height) {
            d2 = (double)size.width * 1.0 / (double)n4;
            d5 = ((double)n5 - (double)size.height / d2) / 2.0;
        } else {
            d2 = (double)size.height * 1.0 / (double)n5;
            d6 = ((double)n4 - (double)size.width / d2) / 2.0;
        }
        d4 = d4 / d2 + d6;
        d3 = d3 / d2 + d5;
        if (a2.o == Rotation.b) {
            double d7 = d4;
            d4 = d3;
            d3 = (double)a2.n.height - d7;
        } else if (a2.o == Rotation.d) {
            double d8 = d4;
            d4 = (double)a2.n.width - d3;
            d3 = d8;
        }
        Rect rect = (Rect)a2.l.get(CaptureRequest.SCALER_CROP_REGION);
        if (rect == null) {
            LiteavLog.e("Camera2Controller", "getMeteringRect can't get crop region");
            rect = (Rect)a2.a().get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        }
        if (a2.n.height * (n3 = rect.width()) > a2.n.width * (n2 = rect.height())) {
            d2 = (double)n2 * 1.0 / (double)a2.n.height;
            d5 = 0.0;
            d6 = ((double)n3 - d2 * (double)a2.n.width) / 2.0;
        } else {
            d2 = (double)n3 * 1.0 / (double)a2.n.width;
            d6 = 0.0;
            d5 = ((double)n2 - d2 * (double)a2.n.height) / 2.0;
        }
        d4 = d4 * d2 + d6 + (double)rect.left;
        d3 = d3 * d2 + d5 + (double)rect.top;
        Rect rect2 = new Rect();
        new Rect().left = com.tencent.liteav.base.util.h.a((int)(d4 - 0.05 * (double)rect.width()), 0, rect.width());
        rect2.right = com.tencent.liteav.base.util.h.a((int)(d4 + 0.05 * (double)rect.width()), 0, rect.width());
        rect2.top = com.tencent.liteav.base.util.h.a((int)(d3 - 0.05 * (double)rect.height()), 0, rect.height());
        rect2.bottom = com.tencent.liteav.base.util.h.a((int)(d3 + 0.05 * (double)rect.height()), 0, rect.height());
        Rect rect3 = rect2;
        try {
            this.m.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect3, 1000)});
            this.m.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect3, 1000)});
            this.m.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            this.m.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.m.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.v = true;
            this.a = false;
            this.m.setTag((Object)this);
            cameraCaptureSession.setRepeatingRequest(this.m.build(), this.D, this.f);
            return;
        }
        catch (Exception exception) {
            LiteavLog.e("Camera2Controller", "startAutoFocusAtPosition exception:".concat(String.valueOf(exception)));
            return;
        }
    }

    @Override
    public final void setZoom(float scale) {
        this.z = scale;
        if (this.m == null) {
            LiteavLog.e("Camera2Controller", "setZoom fail, scale:" + scale + " mPreviewBuilder is null.");
            return;
        }
        a a2 = this;
        Rect rect = (Rect)a2.a().get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        float f2 = ((Float)a2.a().get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        float f3 = com.tencent.liteav.base.util.h.a(scale, 0.0f, 1.0f) * (f2 - 1.0f) + 1.0f;
        int n2 = (int)((float)rect.width() / f2);
        int n3 = (int)((float)rect.height() / f2);
        int n4 = rect.width() - n2;
        int n5 = rect.height() - n3;
        int n6 = (int)((float)n4 * (f3 - 1.0f) / (f2 - 1.0f) / 2.0f);
        int n7 = (int)((float)n5 * (f3 - 1.0f) / (f2 - 1.0f) / 2.0f);
        Rect rect2 = new Rect(n6, n7, rect.width() - n6, rect.height() - n7);
        LiteavLog.i("Camera2Controller", "calculateZoomRect calculatedZoomLevel:" + f3 + " rect:" + rect + " newRect2:" + rect2);
        this.m.set(CaptureRequest.SCALER_CROP_REGION, (Object)rect2);
        this.d();
    }

    @Override
    public final void setExposureCompensation(float value) {
        if (this.g()) {
            LiteavLog.e("Camera2Controller", "setExposureCompensation fail, value:" + value + " mCameraStatus:" + (Object)((Object)this.u));
            return;
        }
        Range range = (Range)this.a().get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        int n2 = (Integer)range.getLower();
        int n3 = (Integer)range.getUpper();
        if (n2 == 0 && n3 == 0) {
            LiteavLog.i("Camera2Controller", "camera doesn't support exposure compensation");
            return;
        }
        float f2 = com.tencent.liteav.base.util.h.a(value, -1.0f, 1.0f);
        int n4 = n2 + (int)((float)(n3 - n2) * (f2 - -1.0f) / 2.0f);
        this.m.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)com.tencent.liteav.base.util.h.a(n4, n2, n3));
        this.d();
    }

    @Override
    public final Rotation getCameraRotation() {
        return this.o;
    }

    @Override
    public final int getCameraRotationValue() {
        return this.o.mValue;
    }

    @Override
    public final int getMaxZoom() {
        return 100;
    }

    @Override
    public final com.tencent.liteav.base.util.Size getPreviewSize() {
        return this.n;
    }

    @Override
    public final void turnOnTorch(boolean enable) {
        if (this.g()) {
            LiteavLog.e("Camera2Controller", "turnOnTorch error mCameraStatus:" + (Object)((Object)this.u));
            return;
        }
        boolean bl = false;
        if (enable && this.t != 2) {
            this.t = 2;
            bl = true;
        } else if (!enable) {
            this.t = 0;
            bl = true;
        }
        LiteavLog.i("Camera2Controller", "turnOnTorch:" + enable + ", mode:" + this.t + ", updateView:" + bl);
        if (bl) {
            this.m.set(CaptureRequest.FLASH_MODE, (Object)this.t);
            this.d();
        }
    }

    @Override
    public final void enableTapToFocus(boolean enable) {
        this.r = enable;
        a a2 = this;
        a2.c(a2.r);
        this.d();
    }

    @Override
    public final boolean isZoomSupported() {
        return this.a() != null && ((Float)this.a().get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue() > 0.0f;
    }

    @Override
    public final boolean isTorchSupported() {
        return this.a() != null && (Boolean)this.a().get(CameraCharacteristics.FLASH_INFO_AVAILABLE) != false;
    }

    @Override
    public final boolean isCameraAutoFocusFaceModeSupported() {
        return this.a() != null && (Integer)this.a().get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT) > 0;
    }

    @Override
    public final boolean isCameraFocusPositionInPreviewSupported() {
        return this.a() != null && (Integer)this.a().get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) > 0;
    }

    @Override
    public final boolean isCurrentPreviewSizeAspectRatioMatch(int width, int height, boolean isAspectRatio) {
        boolean bl = true;
        com.tencent.liteav.base.util.Size size = ah.a(this.e(), this.o, width, height);
        if (size.getArea() > this.n.getArea()) {
            bl = false;
        }
        if (isAspectRatio && Math.abs(size.aspectRatio() - this.n.aspectRatio()) > 0.001) {
            bl = false;
        }
        LiteavLog.i("Camera2Controller", "isCurrentPreviewSizeAspectRatioMatch:".concat(String.valueOf(bl)));
        return bl;
    }

    @Override
    public final void setServerConfig(ServerVideoProducerConfig serverConfig) {
    }

    @Override
    public final void setCloudConfig(CaptureCloudConfig cloudConfig) {
    }

    private void a(boolean bl, CameraDevice cameraDevice) {
        CountDownLatch countDownLatch = this.w;
        this.h.set(bl);
        this.i.set(cameraDevice);
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
    }

    private void a(boolean bl, CameraCaptureSession cameraCaptureSession) {
        CountDownLatch countDownLatch = this.x;
        this.j.set(bl);
        this.k.set(cameraCaptureSession);
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
    }

    private static String b(boolean bl) {
        String string = bl ? (!TextUtils.isEmpty((CharSequence)e) ? e : d) : (!TextUtils.isEmpty((CharSequence)d) ? d : e);
        return string;
    }

    private CameraCharacteristics a() {
        String string = com.tencent.liteav.videoproducer.capture.b.a.b(this.q);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return b.get(string);
        }
        return null;
    }

    private boolean a(int n2, int n3) {
        String string = com.tencent.liteav.videoproducer.capture.b.a.b(this.q);
        if (this.a() == null) {
            LiteavLog.e("Camera2Controller", "openCamera fail getCameraCharacteristics null");
            return false;
        }
        this.o = Rotation.a((Integer)this.a().get(CameraCharacteristics.SENSOR_ORIENTATION));
        this.n = ah.a(this.e(), this.o, n2, n3);
        LiteavLog.i("Camera2Controller", "openCamera " + (this.q ? "front camera" : "back camera") + " mPreviewSize " + this.n + " mCameraRotation " + (Object)((Object)this.o) + " mIsCameraSupportAutoFocus " + this.s);
        try {
            this.w = new CountDownLatch(1);
            ((CameraManager)ContextUtils.getApplicationContext().getSystemService("camera")).openCamera(string, this.A, this.f);
            this.w.await();
        }
        catch (Exception exception) {
            LiteavLog.e("Camera2Controller", "openCamera exception:".concat(String.valueOf(exception)));
            this.a(false, (CameraDevice)null);
        }
        return this.h.get();
    }

    private boolean a(SurfaceTexture surfaceTexture) {
        try {
            CameraDevice cameraDevice = this.i.get();
            if (cameraDevice == null || surfaceTexture == null) {
                throw new IOException("startPreview cameraDevice null!");
            }
            this.b();
            this.p.setDefaultBufferSize(this.n.width, this.n.height);
            Surface surface = new Surface(this.p);
            this.m = cameraDevice.createCaptureRequest(3);
            this.m.addTarget(surface);
            List<Surface> list = Collections.singletonList(surface);
            this.x = new CountDownLatch(1);
            cameraDevice.createCaptureSession(list, this.B, this.f);
            this.x.await();
        }
        catch (Exception exception) {
            LiteavLog.e("Camera2Controller", "startPreview exception", exception);
            this.a(false, (CameraCaptureSession)null);
        }
        return this.j.get();
    }

    private void b() {
        CameraCaptureSession cameraCaptureSession = this.k.getAndSet(null);
        if (cameraCaptureSession != null) {
            cameraCaptureSession.close();
        }
    }

    private void c() {
        CameraDevice cameraDevice = this.i.getAndSet(null);
        if (cameraDevice != null) {
            cameraDevice.close();
        }
        ((CameraManager)ContextUtils.getApplicationContext().getSystemService("camera")).unregisterAvailabilityCallback(this.C);
    }

    private void d() {
        CameraCaptureSession cameraCaptureSession = this.k.get();
        if (cameraCaptureSession == null || this.m == null) {
            return;
        }
        try {
            cameraCaptureSession.setRepeatingRequest(this.m.build(), null, null);
            return;
        }
        catch (Exception exception) {
            LiteavLog.e("Camera2Controller", "updatePreview exception:".concat(String.valueOf(exception)));
            return;
        }
    }

    private void c(boolean bl) {
        if (this.m == null) {
            return;
        }
        int n2 = bl ? 1 : 3;
        this.m.set(CaptureRequest.CONTROL_AF_MODE, (Object)n2);
        LiteavLog.i("Camera2Controller", "setFocusMode to ".concat(String.valueOf(n2)));
    }

    private List<com.tencent.liteav.base.util.Size> e() {
        if (this.a() == null) {
            LiteavLog.e("Camera2Controller", "getPreviewSizes error, Characteristics is null");
            return null;
        }
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)this.a().get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (streamConfigurationMap == null) {
            LiteavLog.e("Camera2Controller", "getPreviewSizes map null");
            return null;
        }
        Size[] sizeArray = streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        if (sizeArray == null) {
            LiteavLog.e("Camera2Controller", "getPreviewSizes choices is null");
            return null;
        }
        ArrayList<com.tencent.liteav.base.util.Size> arrayList = new ArrayList<com.tencent.liteav.base.util.Size>();
        Size[] sizeArray2 = sizeArray;
        int n2 = sizeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Size size = sizeArray2[i2];
            com.tencent.liteav.base.util.Size size2 = new com.tencent.liteav.base.util.Size(size.getWidth(), size.getHeight());
            arrayList.add(size2);
        }
        return arrayList;
    }

    private Range<Integer> a(int n2) {
        LiteavLog.i("Camera2Controller", "preferred fps: ".concat(String.valueOf(n2)));
        Range range = new Range((Comparable)Integer.valueOf(n2), (Comparable)Integer.valueOf(n2));
        List<int[]> list = this.f();
        if (com.tencent.liteav.videobase.utils.c.a(list)) {
            return range;
        }
        Collections.sort(list, com.tencent.liteav.videoproducer.capture.b.c.a());
        int[] nArray = null;
        for (int[] nArray2 : list) {
            if (nArray2[0] > n2 || n2 > nArray2[1]) continue;
            nArray = nArray2;
            break;
        }
        if (nArray != null && nArray.length >= 2) {
            range = new Range((Comparable)Integer.valueOf((int)nArray[0]), (Comparable)Integer.valueOf((int)nArray[1]));
        }
        return range;
    }

    private List<int[]> f() {
        if (this.a() == null) {
            LiteavLog.e("Camera2Controller", "getPreviewFps error, Characteristics: ", this.a());
            return null;
        }
        Range[] rangeArray = (Range[])this.a().get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (rangeArray != null) {
            Range[] rangeArray2 = rangeArray;
            int n2 = rangeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Range range = rangeArray2[i2];
                int[] nArray = new int[]{(Integer)range.getLower(), (Integer)range.getUpper()};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    private boolean g() {
        return this.a() == null || this.m == null || this.u != com.tencent.liteav.videoproducer.capture.b.a$a.b;
    }

    static /* synthetic */ int a(int[] nArray, int[] nArray2) {
        return nArray[1] - nArray2[1];
    }

    static /* synthetic */ void a(a a2) {
        if (a2.g()) {
            LiteavLog.e("Camera2Controller", "onCameraError, but camera is invalid, do not send camera error.");
            return;
        }
        CameraEventCallback cameraEventCallback = a2.y;
        if (cameraEventCallback != null) {
            cameraEventCallback.onCameraError(a2);
        }
    }

    static /* synthetic */ void b(a a2) {
        a a3 = a2;
        a3.g.a(com.tencent.liteav.videoproducer.capture.b.b.a(a3));
    }

    static /* synthetic */ boolean g(a a2) {
        a2.v = false;
        return false;
    }

    static /* synthetic */ void a(a a2, boolean bl) {
        boolean bl2 = bl;
        a a3 = a2;
        LiteavLog.i("Camera2Controller", "onFocusCallback success:".concat(String.valueOf(bl2)));
        a3.a = true;
    }

    static {
        d = "";
        e = "";
    }

    static enum a {
        a,
        b;

    }
}

