/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.i;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videoconsumer.consumer.VideoConsumerServerConfig;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.ay;
import com.tencent.liteav.videoconsumer.decoder.az;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class SoftwareVideoDecoder
implements ay {
    private static final String TAG = "SoftwareVideoDecoder";
    private long mNativeVideoDecoderWrapper = 0L;
    @NonNull
    private final IVideoReporter mReporter;
    private az mListener;
    private i mPixelFramePool;

    public SoftwareVideoDecoder(@NonNull IVideoReporter reporter) {
        this.mReporter = reporter;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
    }

    @Override
    public void start(Object glContext, az listener) {
        if (this.mNativeVideoDecoderWrapper != 0L) {
            LiteavLog.w(TAG, "decoder is already started!");
            return;
        }
        this.mPixelFramePool = new i();
        this.mListener = listener;
        this.mNativeVideoDecoderWrapper = SoftwareVideoDecoder.nativeCreate(this);
        if (this.mNativeVideoDecoderWrapper == 0L) {
            this.handleDecoderError(g.c.l, "VideoDecode: out of memory, Start decoder failed", new Object[0]);
            LiteavLog.e(TAG, "create native instance failed.");
            return;
        }
        if (SoftwareVideoDecoder.nativeStart(this.mNativeVideoDecoderWrapper) != 0) {
            this.handleDecoderError(g.c.m, "VideoDecode: Start decoder failed", new Object[0]);
            LiteavLog.e(TAG, "Start software decoder failed.");
            return;
        }
        this.mReporter.notifyEvent(g.b.E, "Start decoder success", new Object[0]);
        LiteavLog.i(TAG, "decoder Start success.");
    }

    @Override
    public boolean decode(EncodedVideoFrame frame) {
        if (frame == null || frame.data == null || frame.data.remaining() == 0) {
            return false;
        }
        if (frame.isEosFrame && this.mListener != null) {
            this.mListener.e();
            return true;
        }
        EncodedVideoFrame encodedVideoFrame = frame;
        SoftwareVideoDecoder.nativeDecodeFrame(this.mNativeVideoDecoderWrapper, encodedVideoFrame, encodedVideoFrame.data, frame.nalType.mValue, frame.codecType.mValue, frame.rotation, frame.pts, frame.dts);
        frame.release();
        if (this.mListener != null) {
            this.mListener.d();
        }
        return true;
    }

    @Override
    public void stop() {
        if (this.mNativeVideoDecoderWrapper == 0L) {
            LiteavLog.w(TAG, "decoder has already stopped");
            return;
        }
        if (this.mPixelFramePool != null) {
            this.mPixelFramePool.b();
        }
        SoftwareVideoDecoder.nativeStop(this.mNativeVideoDecoderWrapper);
        SoftwareVideoDecoder.nativeDestroy(this.mNativeVideoDecoderWrapper);
        this.mNativeVideoDecoderWrapper = 0L;
        LiteavLog.i(TAG, "decoder stop.");
    }

    public void abandonDecodingFrames() {
        if (this.mNativeVideoDecoderWrapper == 0L) {
            LiteavLog.w(TAG, "decoder has already stopped");
            return;
        }
        SoftwareVideoDecoder.nativeAbandonDecodingFrames(this.mNativeVideoDecoderWrapper);
        if (this.mListener != null) {
            this.mListener.c();
        }
    }

    @Override
    public ay.a getDecoderType() {
        return ay.a.a;
    }

    @Override
    public void setServerConfig(VideoConsumerServerConfig config) {
    }

    private void handleDecoderError(g.c code, String format, Object ... args) {
        this.mReporter.notifyWarning(code, format, args);
        if (this.mListener != null) {
            this.mListener.a();
        }
    }

    @CalledByNative
    private void onDecodedFrame(PixelFrame frame, long errCode) {
        if (errCode != 0L) {
            this.handleDecoderError(g.c.n, "VideoDecode: decode error, errCode:".concat(String.valueOf(errCode)), new Object[0]);
            LiteavLog.e(TAG, "decode failed.".concat(String.valueOf(errCode)));
            if (frame != null) {
                frame.release();
            }
            return;
        }
        if (frame != null) {
            if (this.mListener != null) {
                PixelFrame pixelFrame = frame;
                this.mListener.a(pixelFrame, pixelFrame.getTimestamp());
            }
            frame.release();
        }
    }

    @CalledByNative
    private PixelFrame obtainPixelFrame(int formatType, int width, int height, int rotation, long timestamp) {
        GLConstants.PixelFormatType pixelFormatType = GLConstants.PixelFormatType.a(formatType);
        if (pixelFormatType == null) {
            this.handleDecoderError(g.c.o, "unknown format:".concat(String.valueOf(formatType)), new Object[0]);
            LiteavLog.e(TAG, "obtainPixelFrame formatType: ".concat(String.valueOf(formatType)));
            return null;
        }
        if (this.mPixelFramePool == null) {
            LiteavLog.i(TAG, "obtainPixelFrame mPixelFramePool is null.");
            return null;
        }
        PixelFrame pixelFrame = this.mPixelFramePool.a(width, height, GLConstants.PixelBufferType.a, pixelFormatType);
        pixelFrame.setRotation(Rotation.a(rotation));
        pixelFrame.setTimestamp(timestamp);
        return pixelFrame;
    }

    @CalledByNative
    private ByteBuffer getByteBufferFromPixelFrame(PixelFrame frame) {
        return frame.getBuffer();
    }

    private static native long nativeCreate(SoftwareVideoDecoder var0);

    private static native void nativeDestroy(long var0);

    private static native int nativeStart(long var0);

    private static native int nativeStop(long var0);

    private static native int nativeDecodeFrame(long var0, EncodedVideoFrame var2, ByteBuffer var3, int var4, int var5, int var6, long var7, long var9);

    private static native void nativeAbandonDecodingFrames(long var0);
}

