/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.i;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.base.util.o;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.c;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.BitmapUtils;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.TXCCloudVideoViewMethodInvoker;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.renderer.RenderViewHelperInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoconsumer.renderer.aa;
import com.tencent.liteav.videoconsumer.renderer.ab;
import com.tencent.liteav.videoconsumer.renderer.ac;
import com.tencent.liteav.videoconsumer.renderer.ad;
import com.tencent.liteav.videoconsumer.renderer.ae;
import com.tencent.liteav.videoconsumer.renderer.af;
import com.tencent.liteav.videoconsumer.renderer.ag;
import com.tencent.liteav.videoconsumer.renderer.ah;
import com.tencent.liteav.videoconsumer.renderer.ai;
import com.tencent.liteav.videoconsumer.renderer.aj;
import com.tencent.liteav.videoconsumer.renderer.j;
import com.tencent.liteav.videoconsumer.renderer.s;
import com.tencent.liteav.videoconsumer.renderer.t;
import com.tencent.liteav.videoconsumer.renderer.u;
import com.tencent.liteav.videoconsumer.renderer.v;
import com.tencent.liteav.videoconsumer.renderer.w;
import com.tencent.liteav.videoconsumer.renderer.x;
import com.tencent.liteav.videoconsumer.renderer.y;
import com.tencent.liteav.videoconsumer.renderer.z;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.rtmp.ui.a;
import com.tencent.rtmp.ui.b;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class r
extends VideoRenderInterface
implements RenderViewHelperInterface.RenderViewListener,
a,
b {
    private final String a = "VideoRenderer_" + this.hashCode();
    @NonNull
    private final Handler b = new Handler(Looper.getMainLooper());
    private final CustomHandler c;
    @NonNull
    private final IVideoReporter d;
    private final l e;
    @NonNull
    private final l f = new l(5);
    private final com.tencent.liteav.base.b.b g = new com.tencent.liteav.base.b.b();
    @NonNull
    private final Size h = new Size();
    private Surface i = null;
    private boolean j = false;
    private Object k;
    private EGLCore l = null;
    private final c m = new c();
    private com.tencent.liteav.videobase.frame.j n;
    private final com.tencent.liteav.videobase.utils.j o = new com.tencent.liteav.videobase.utils.j();
    private e p;
    private GLConstants.GLScaleType q = GLConstants.GLScaleType.a;
    private Rotation r = Rotation.a;
    private boolean s = false;
    private boolean t = false;
    @Nullable
    private DisplayTarget u;
    private RenderViewHelperInterface v;
    private final Size w = new Size();
    private Rotation x = Rotation.a;
    private volatile boolean y = false;
    private boolean z = false;
    private TakeSnapshotListener A;
    private VideoRenderListener B;
    private boolean C = false;
    private Bitmap D;
    private boolean E = false;
    private boolean F = false;
    private final com.tencent.liteav.base.b.a G = new com.tencent.liteav.base.b.a(5000L);

    public r(@NonNull Looper looper, @NonNull IVideoReporter iVideoReporter) {
        this.c = new CustomHandler(looper);
        this.e = null;
        this.d = iVideoReporter;
    }

    public r(@NonNull l l2, @NonNull IVideoReporter iVideoReporter) {
        this.c = null;
        this.e = l2;
        this.d = iVideoReporter;
    }

    @Override
    public final void start(VideoRenderListener listener) {
        r r2 = this;
        r2.a(com.tencent.liteav.videoconsumer.renderer.s.a(r2, listener));
    }

    @Override
    public final void stop(boolean clearLastImage) {
        r r2 = this;
        r2.a(ac.a(r2, clearLastImage));
    }

    @Override
    public final void setDisplayView(DisplayTarget displayTarget, boolean clearLastImage) {
        r r2 = this;
        r2.a(ad.a(r2, displayTarget, clearLastImage));
    }

    @Override
    public final void takeSnapshot(TakeSnapshotListener listener) {
        r r2 = this;
        r2.a(ae.a(r2, listener));
    }

    @Override
    public final void onTap(int x2, int y2, int width, int height) {
        r r2 = this;
        r2.a(af.a(r2, x2, y2, width, height));
    }

    @Override
    public final void onZoom(float scale) {
        r r2 = this;
        r2.a(ag.a(r2, scale));
    }

    @Override
    public final void enableTapToFocusGesture(boolean enable) {
        r r2 = this;
        r2.a(ah.a(r2, enable));
    }

    @Override
    public final void enableZoomGesture(boolean enable) {
        r r2 = this;
        r2.a(ai.a(r2, enable));
    }

    @Override
    public final void setScaleType(GLConstants.GLScaleType scaleType) {
        r r2 = this;
        r2.a(aj.a(r2, scaleType));
    }

    @Override
    public final void setRenderRotation(Rotation rotation) {
        r r2 = this;
        r2.a(com.tencent.liteav.videoconsumer.renderer.t.a(r2, rotation));
    }

    @Override
    public final void setHorizontalMirror(boolean mirror) {
        r r2 = this;
        r2.a(com.tencent.liteav.videoconsumer.renderer.u.a(r2, mirror));
    }

    @Override
    public final void setVerticalMirror(boolean mirror) {
        r r2 = this;
        r2.a(com.tencent.liteav.videoconsumer.renderer.v.a(r2, mirror));
    }

    @Override
    public final void renderFrame(PixelFrame pixelFrame) {
        if (!this.y) {
            return;
        }
        if (pixelFrame == null) {
            LiteavLog.w(this.a, "renderFrame pixelFrame is null!");
            return;
        }
        if (!this.z) {
            this.z = true;
            LiteavLog.d(this.a, "VideoRender receive first frame!");
        }
        pixelFrame.getGLContext();
        this.o.a(pixelFrame);
        r r2 = this;
        r2.a(com.tencent.liteav.videoconsumer.renderer.w.a(r2));
    }

    private void a(Runnable runnable) {
        if (this.e != null) {
            this.e.a(runnable);
            return;
        }
        if (Looper.myLooper() == this.c.getLooper()) {
            runnable.run();
            return;
        }
        this.c.post(runnable);
    }

    private void a() {
        if (this.l == null) {
            return;
        }
        LiteavLog.i(this.g.a("uninitGL"), this.a, "uninitializeEGL %d %s", this.i != null ? this.i.hashCode() : 0, this.h);
        try {
            this.l.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.g.a("makeCurrentError"), this.a, "uninitializeEGL EGLCore makeCurrent failed.".concat(String.valueOf(f2)), new Object[0]);
        }
        this.e();
        this.m.d();
        if (this.p != null) {
            this.p.a();
            this.p.b();
            this.p = null;
        }
        EGLCore.destroy(this.l);
        this.l = null;
    }

    private void a(DisplayTarget displayTarget, boolean bl2) {
        LiteavLog.i(this.a, "setDisplayViewInternal=" + displayTarget + ",clearLastImage=" + bl2);
        boolean bl3 = CommonUtil.equals(this.u, displayTarget);
        if (bl3 && displayTarget != null && this.v != null) {
            LiteavLog.w(this.a, "view is equal and RenderViewHelper is created.");
            return;
        }
        if (!bl3) {
            this.C = true;
            if (this.u != null && bl2) {
                this.u.hideAll();
            }
        }
        this.a(bl2);
        this.u = displayTarget;
        if (displayTarget == null) {
            return;
        }
        displayTarget.showAll();
        this.v = RenderViewHelperInterface.create(displayTarget, this);
    }

    private TXCloudVideoView b() {
        if (this.u == null) {
            return null;
        }
        return this.u.getTXCloudVideoView();
    }

    private void c() {
        if (this.l == null) {
            return;
        }
        Size size = this.l.getSurfaceSize();
        if (this.h.equals(size)) {
            return;
        }
        LiteavLog.i(this.a, "surface size changed,old size=" + this.h + ",new size=" + size);
        this.h.set(size);
        this.e();
        if (this.i != null) {
            this.d.updateStatus(com.tencent.liteav.videobase.videobase.h.u, this.h.width << 16 | this.h.height);
        }
        if (this.B != null) {
            this.B.onRenderTargetSizeChanged(this.h.width, this.h.height);
        }
    }

    private boolean a(@NonNull PixelFrame pixelFrame) {
        Object object = pixelFrame.getGLContext();
        if (this.l == null || object != null && !CommonUtil.equals(this.k, object)) {
            this.a();
            Object object2 = pixelFrame.getGLContext();
            r r2 = this;
            if (r2.i != null) {
                try {
                    LiteavLog.i(r2.g.a("initGL"), r2.a, "initializeEGL surface=" + r2.i + ",size=" + r2.h, new Object[0]);
                    r2.l = new EGLCore();
                    r2.l.initialize(object2, r2.i, r2.h.width, r2.h.height);
                    r2.k = object2;
                    r2.l.makeCurrent();
                    if (r2.p == null) {
                        r2.p = new e();
                    }
                    r2.m.a();
                }
                catch (f f2) {
                    LiteavLog.e(r2.g.a("initGLError"), r2.a, "initializeEGL failed.", f2);
                    r2.l = null;
                    r2.d.notifyWarning(g.c.e, "VideoRender: create EGLCore fail:".concat(String.valueOf(f2)), new Object[0]);
                }
            }
        }
        if (this.l == null) {
            return false;
        }
        try {
            this.l.makeCurrent();
            return true;
        }
        catch (f f3) {
            LiteavLog.e(this.g.a("makeCurrentForFrameError"), this.a, "EGLCore makeCurrent failed.".concat(String.valueOf(f3)), new Object[0]);
            return false;
        }
    }

    private void d() {
        try {
            this.l.swapBuffers();
            return;
        }
        catch (f f2) {
            LiteavLog.e(this.g.a("swapBuffers"), this.a, "EGLCore swapBuffers failed.".concat(String.valueOf(f2)), new Object[0]);
            this.d.notifyWarning(g.c.g, "VideoRender: swapBuffer error:".concat(String.valueOf(f2)), new Object[0]);
            return;
        }
    }

    private void a(PixelFrame pixelFrame, boolean bl2, boolean bl3, Rotation rotation, GLConstants.GLScaleType gLScaleType, boolean bl4) {
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        pixelFrame2.setRotation(Rotation.a((pixelFrame.getRotation().mValue + rotation.mValue) % 360));
        if (bl2) {
            PixelFrame pixelFrame3 = pixelFrame2;
            pixelFrame3.setMirrorHorizontal(!pixelFrame3.isMirrorHorizontal());
        }
        if (bl3) {
            PixelFrame pixelFrame4 = pixelFrame2;
            pixelFrame4.setMirrorVertical(!pixelFrame4.isMirrorVertical());
        }
        if (rotation == Rotation.b || rotation == Rotation.d) {
            int n2 = pixelFrame2.getWidth();
            PixelFrame pixelFrame5 = pixelFrame2;
            pixelFrame5.setWidth(pixelFrame5.getHeight());
            pixelFrame2.setHeight(n2);
        }
        PixelFrame pixelFrame6 = pixelFrame2;
        pixelFrame6.setMirrorVertical(!pixelFrame6.isMirrorVertical());
        if (pixelFrame2.getRotation() != Rotation.a && pixelFrame2.getRotation() != Rotation.c) {
            PixelFrame pixelFrame7 = pixelFrame2;
            pixelFrame7.setRotation(Rotation.a((pixelFrame7.getRotation().mValue + Rotation.c.mValue) % 360));
        }
        OpenGlUtils.glViewport(0, 0, this.h.width, this.h.height);
        if (bl4 && this.v != null) {
            this.v.updateVideoFrameInfo(this.q, pixelFrame2.getWidth(), pixelFrame2.getHeight());
        }
        if (this.n == null && this.h.isValid()) {
            LiteavLog.i(this.a, "create PixelFrameRenderer,surfaceSize=" + this.h);
            this.n = new com.tencent.liteav.videobase.frame.j(this.h.width, this.h.height);
        }
        if (this.n != null) {
            if (this.v instanceof j) {
                this.n.a(pixelFrame2, GLConstants.GLScaleType.c, null);
                return;
            }
            this.n.a(pixelFrame2, gLScaleType, null);
        }
    }

    private void a(Surface surface, boolean bl2) {
        if (com.tencent.liteav.base.util.i.a(this.i, surface)) {
            LiteavLog.d(this.a, "updateSurface same surface!");
            return;
        }
        this.a();
        if (this.j && this.i != null) {
            this.i.release();
        }
        this.i = surface;
        if (this.i == null) {
            this.h.set(0, 0);
        }
        this.j = bl2;
    }

    private void a(boolean bl2) {
        if (this.v != null) {
            this.v.release(bl2);
            this.v = null;
        }
    }

    @Override
    public final void onSurfaceChanged(Surface surface, boolean isNeedRelease) {
        r r2 = this;
        r2.a(com.tencent.liteav.videoconsumer.renderer.y.a(r2, surface, isNeedRelease));
    }

    @Override
    public final void onRequestRedraw(@NonNull Bitmap bitmap) {
        this.a(bitmap);
        r r2 = this;
        r2.a(com.tencent.liteav.videoconsumer.renderer.z.a(r2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap a(Bitmap bitmap) {
        r r2 = this;
        synchronized (r2) {
            Bitmap bitmap2 = this.D;
            this.D = bitmap;
            return bitmap2;
        }
    }

    @Override
    public final void onSurfaceDestroy() {
        r r2 = this;
        Runnable runnable = aa.a(r2);
        r r3 = r2;
        if (r2.e != null) {
            Runnable runnable2 = runnable;
            l l2 = r3.e;
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable runnable3 = com.tencent.liteav.base.util.o.a(runnable2, countDownLatch);
            l2.a.execute(runnable3);
            try {
                countDownLatch.await(2000L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (Looper.myLooper() == r3.c.getLooper()) {
            runnable.run();
            return;
        }
        r3.c.runAndWaitDone(runnable, 2000L);
    }

    private void e() {
        if (this.n != null) {
            this.n.a();
            this.n = null;
        }
    }

    static /* synthetic */ void a(r r2) {
        LiteavLog.i(r2.a, "onSurfaceDestroy " + r2.i);
        r2.a((Surface)null, r2.j);
    }

    static /* synthetic */ void b(r r2) {
        Bitmap bitmap = r2.a((Bitmap)null);
        if (bitmap == null) {
            return;
        }
        PixelFrame pixelFrame = PixelFrame.createFromBitmap(bitmap);
        if (!r2.a(pixelFrame)) {
            pixelFrame.release();
            return;
        }
        r2.c();
        r2.a(pixelFrame, false, false, Rotation.a, r2.q, false);
        r2.d();
    }

    static /* synthetic */ void a(r r2, Surface surface, boolean bl2) {
        LiteavLog.i(r2.a, "onSurfaceChanged surface: %s, oldSurface: %s, isNeedRelease: %b", surface, r2.i, bl2);
        r2.a(surface, bl2);
    }

    static /* synthetic */ void a(r r2, RenderViewHelperInterface renderViewHelperInterface, ByteBuffer byteBuffer, int n2, int n3, TakeSnapshotListener takeSnapshotListener) {
        TextureView textureView = null;
        if (renderViewHelperInterface instanceof j) {
            textureView = ((j)renderViewHelperInterface).a;
        }
        Matrix matrix = textureView == null ? null : textureView.getTransform(new Matrix());
        r2.f.a(ab.a(r2, byteBuffer, n2, n3, matrix, takeSnapshotListener));
    }

    static /* synthetic */ void a(r r2, ByteBuffer byteBuffer, int n2, int n3, Matrix matrix, TakeSnapshotListener takeSnapshotListener) {
        TakeSnapshotListener takeSnapshotListener2 = takeSnapshotListener;
        Matrix matrix2 = matrix;
        int n4 = n3;
        int n5 = n2;
        ByteBuffer byteBuffer2 = byteBuffer;
        r r3 = r2;
        try {
            byteBuffer2.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer2);
            Matrix matrix3 = matrix2 == null ? new Matrix() : matrix2;
            matrix3.postScale(1.0f, -1.0f, (float)n5 / 2.0f, (float)n4 / 2.0f);
            bitmap = BitmapUtils.createBitmap(bitmap, matrix3, true);
            takeSnapshotListener2.onComplete(bitmap);
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(r3.a, "build snapshot bitmap failed.", throwable);
            takeSnapshotListener2.onComplete(null);
            return;
        }
    }

    static /* synthetic */ void a(r r2, boolean bl2) {
        if (r2.t != bl2) {
            LiteavLog.i(r2.a, "setVerticalMirror ".concat(String.valueOf(bl2)));
        }
        r2.t = bl2;
    }

    static /* synthetic */ void b(r r2, boolean bl2) {
        if (r2.s != bl2) {
            LiteavLog.i(r2.a, "setHorizontalMirror ".concat(String.valueOf(bl2)));
        }
        r2.s = bl2;
    }

    static /* synthetic */ void a(r r2, Rotation rotation) {
        if (r2.r != rotation) {
            LiteavLog.i(r2.a, "setRenderRotation ".concat(String.valueOf((Object)rotation)));
            r2.r = rotation;
        }
    }

    static /* synthetic */ void a(r r2, GLConstants.GLScaleType gLScaleType) {
        if (r2.q != gLScaleType) {
            LiteavLog.i(r2.a, "setScaleType ".concat(String.valueOf((Object)gLScaleType)));
            r2.q = gLScaleType;
        }
    }

    static /* synthetic */ void c(r r2, boolean bl2) {
        LiteavLog.i(r2.a, "enableZoomGesture enable:".concat(String.valueOf(bl2)));
        TXCloudVideoView tXCloudVideoView = r2.b();
        if (tXCloudVideoView != null) {
            boolean bl3 = bl2;
            TXCCloudVideoViewMethodInvoker.setZoomEnabled(tXCloudVideoView, bl3, bl3 ? r2 : null);
        }
        r2.F = bl2;
    }

    static /* synthetic */ void d(r r2, boolean bl2) {
        LiteavLog.i(r2.a, "enableTapToFocusGesture enable:".concat(String.valueOf(bl2)));
        TXCloudVideoView tXCloudVideoView = r2.b();
        if (tXCloudVideoView != null) {
            boolean bl3 = bl2;
            TXCCloudVideoViewMethodInvoker.setTouchToFocusEnabled(tXCloudVideoView, bl3, bl3 ? r2 : null);
        }
        r2.E = bl2;
    }

    static /* synthetic */ void a(r r2, float f2) {
        if (!r2.F) {
            return;
        }
        if (r2.B != null) {
            r2.B.onZoom(f2);
        }
    }

    static /* synthetic */ void a(r r2, int n2, int n3, int n4, int n5) {
        TXCloudVideoView tXCloudVideoView;
        if (!r2.E) {
            return;
        }
        Point point = OpenGlUtils.reverseMappingPoint(GLConstants.GLScaleType.a, r2.x, new Point(n2, n3), new Size(n4, n5), r2.w);
        if (r2.B != null) {
            r2.B.onFocusAtPoint(point.x, point.y, n4, n5);
        }
        if ((tXCloudVideoView = r2.b()) != null) {
            TXCCloudVideoViewMethodInvoker.showFocusView(tXCloudVideoView, n2, n3, n4, n5);
        }
    }

    static /* synthetic */ void a(r r2, TakeSnapshotListener takeSnapshotListener) {
        LiteavLog.i(r2.a, "takeSnapshot ");
        r2.A = takeSnapshotListener;
    }

    static /* synthetic */ void a(r r2, DisplayTarget displayTarget, boolean bl2) {
        r2.a(displayTarget, bl2);
    }

    static /* synthetic */ void e(r r2, boolean bl2) {
        LiteavLog.i(r2.a, "Stop,clearLastImage=".concat(String.valueOf(bl2)));
        if (!r2.y) {
            LiteavLog.w(r2.a, "renderer is not started!");
            return;
        }
        r2.y = false;
        r2.A = null;
        r2.a(bl2);
        if (r2.u != null && bl2) {
            r2.u.hideAll();
        }
        r2.o.b();
        r2.a();
        if (r2.j && r2.i != null) {
            r2.i.release();
            r2.j = false;
        }
        r2.i = null;
        r2.h.set(0, 0);
        r2.w.set(0, 0);
        r2.z = false;
    }

    static /* synthetic */ void a(r r2, VideoRenderListener videoRenderListener) {
        LiteavLog.i(r2.a, "Start");
        if (r2.y) {
            LiteavLog.w(r2.a, "renderer is started!");
            return;
        }
        r2.y = true;
        r2.B = videoRenderListener;
        if (r2.u != null) {
            r r3 = r2;
            r3.a(r3.u, true);
        }
        r2.G.a = SystemClock.elapsedRealtime();
    }

    static /* synthetic */ void c(r r2) {
        r r3;
        PixelFrame pixelFrame;
        r r4;
        block11: {
            r4 = r2;
            pixelFrame = r4.o.a();
            if (pixelFrame == null) {
                LiteavLog.d(r4.a, "renderFrameInternal pixelFrame is null!");
                return;
            }
            r4.w.set(pixelFrame.getWidth(), pixelFrame.getHeight());
            FrameMetaData frameMetaData = pixelFrame.getMetaData();
            if (frameMetaData != null) {
                r4.r = frameMetaData.getRenderRotation();
                r4.s = frameMetaData.isRenderMirrorHorizontal();
                r4.t = frameMetaData.isRenderMirrorVertical();
                r4.w.set(frameMetaData.getCaptureRealSize());
                r4.x = Rotation.a(frameMetaData.getCaptureRotation());
            }
            if (r4.G.a() && r4.v != null) {
                r4.v.checkViewAvailability();
            }
            if (!r4.a(pixelFrame)) {
                pixelFrame.release();
                return;
            }
            r4.c();
            r4.a(pixelFrame, r4.s, r4.t, r4.r, r4.q, true);
            if (r4.A != null) {
                OpenGlUtils.bindFramebuffer(36160, 0);
                r r5 = r4;
                int n2 = r4.h.height;
                int n3 = r5.h.width;
                r3 = r5;
                TakeSnapshotListener takeSnapshotListener = r5.A;
                if (takeSnapshotListener != null) {
                    ByteBuffer byteBuffer;
                    r3.A = null;
                    try {
                        byteBuffer = ByteBuffer.allocateDirect(n3 * n2 * 4).order(ByteOrder.nativeOrder());
                        byteBuffer.position(0);
                    }
                    catch (Throwable throwable) {
                        LiteavLog.e(r3.a, "can't alloc buffer, size: " + n3 * n2 * 4);
                        takeSnapshotListener.onComplete(null);
                        break block11;
                    }
                    GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
                    RenderViewHelperInterface renderViewHelperInterface = r3.v;
                    r3.b.post(com.tencent.liteav.videoconsumer.renderer.x.a(r3, renderViewHelperInterface, byteBuffer, n3, n2, takeSnapshotListener));
                }
            }
        }
        r4.d();
        PixelFrame pixelFrame2 = pixelFrame;
        r3 = r4;
        if (r3.B != null) {
            r3.B.onRenderFrame(pixelFrame2);
        }
        if (r4.C) {
            r4.d.notifyEvent(g.b.i, null, new Object[0]);
            if (r4.B != null) {
                r4.B.onRenderFirstFrameOnView(r4.h.width, r4.h.height);
            }
            r4.C = false;
        }
        pixelFrame.release();
    }
}

