/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.producer;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videoproducer.producer.CustomVideoProcessListener;

@JNINamespace(value="liteav::video")
public class NativeCustomVideoProcessListener
implements CustomVideoProcessListener {
    private long mNativeVideoCustomProcessListener = 0L;

    @CalledByNative
    private NativeCustomVideoProcessListener(long listener) {
        this.mNativeVideoCustomProcessListener = listener;
    }

    @CalledByNative
    private synchronized void reset() {
        this.mNativeVideoCustomProcessListener = 0L;
    }

    @CalledByNative
    private static void shadowCopy(PixelFrame sourceFrame, PixelFrame dstFrame) {
        if (sourceFrame == null || dstFrame == null) {
            return;
        }
        dstFrame.copy(sourceFrame);
    }

    @Override
    public synchronized void onProcessFrame(PixelFrame frame, PixelFrame dstFrame) {
        if (this.mNativeVideoCustomProcessListener != 0L) {
            NativeCustomVideoProcessListener nativeCustomVideoProcessListener = this;
            nativeCustomVideoProcessListener.nativeOnProcessFrame(nativeCustomVideoProcessListener.mNativeVideoCustomProcessListener, frame, dstFrame, frame.getWidth(), frame.getHeight(), frame.getTimestamp(), frame.getPixelFormatType().getValue());
        }
    }

    @Override
    public synchronized void onGLContextCreated() {
        if (this.mNativeVideoCustomProcessListener != 0L) {
            NativeCustomVideoProcessListener nativeCustomVideoProcessListener = this;
            nativeCustomVideoProcessListener.nativeOnGLContextCreated(nativeCustomVideoProcessListener.mNativeVideoCustomProcessListener);
        }
    }

    @Override
    public synchronized void onGLContextDestroy() {
        if (this.mNativeVideoCustomProcessListener != 0L) {
            NativeCustomVideoProcessListener nativeCustomVideoProcessListener = this;
            nativeCustomVideoProcessListener.nativeOnGLContextDestroy(nativeCustomVideoProcessListener.mNativeVideoCustomProcessListener);
        }
    }

    private native void nativeOnProcessFrame(long var1, PixelFrame var3, PixelFrame var4, int var5, int var6, long var7, int var9);

    private native void nativeOnGLContextCreated(long var1);

    private native void nativeOnGLContextDestroy(long var1);
}

