/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.route;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Process;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.List;

public final class s
extends BroadcastReceiver {
    private final a d;
    final Context a;
    b b = null;
    boolean c = false;

    public s(Context context, a a2) {
        this.a = context;
        this.d = a2;
    }

    public final void onReceive(Context context, Intent intent) {
        if (intent == null || context == null) {
            Log.e("AudioSystemBroadcastReceiver", "onReceive intent or context is null!", new Object[0]);
            return;
        }
        String string = intent.getAction();
        if (string == null) {
            return;
        }
        Log.i("AudioSystemBroadcastReceiver", "receive Action: %s", string);
        String string2 = string;
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1676458352: {
                if (!string2.equals("android.intent.action.HEADSET_PLUG")) break;
                n2 = 0;
                break;
            }
            case -1530327060: {
                if (!string2.equals("android.bluetooth.adapter.action.STATE_CHANGED")) break;
                n2 = 1;
                break;
            }
            case 545516589: {
                if (!string2.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) break;
                n2 = 2;
                break;
            }
            case -1435586571: {
                if (!string2.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) break;
                n2 = 3;
                break;
            }
            case -2114103349: {
                if (!string2.equals("android.hardware.usb.action.USB_DEVICE_ATTACHED")) break;
                n2 = 4;
                break;
            }
            case -1608292967: {
                if (!string2.equals("android.hardware.usb.action.USB_DEVICE_DETACHED")) break;
                n2 = 5;
            }
        }
        switch (n2) {
            case 0: {
                Intent intent2 = intent;
                s s2 = this;
                int n3 = s.a(intent2, "state", -1);
                if (n3 == -1) {
                    Log.e("AudioSystemBroadcastReceiver", "unknown headset state, ignore...", new Object[0]);
                    return;
                }
                s2.d.onWiredHeadsetConnectionChanged(n3 != 0);
                return;
            }
            case 1: {
                Intent intent3 = intent;
                s s3 = this;
                int n4 = s.a(intent3, "android.bluetooth.adapter.extra.STATE", 0);
                int n5 = s.a(intent3, "android.bluetooth.adapter.extra.PREVIOUS_STATE", 0);
                Log.i("AudioSystemBroadcastReceiver", "receive ACTION_STATE_CHANGED, EXTRA_STATE: %s, EXTRA_PREVIOUS_STATE: %s", s.a(n4), s.a(n5));
                if (n4 == 10) {
                    s3.d.onBluetoothConnectionChanged(false);
                }
                return;
            }
            case 2: {
                String string3;
                Intent intent4 = intent;
                s s4 = this;
                int n6 = s.a(intent4, "android.bluetooth.profile.extra.STATE", -1);
                Object[] objectArray = new Object[1];
                switch (n6) {
                    case 0: {
                        string3 = "STATE_DISCONNECTED";
                        break;
                    }
                    case 1: {
                        string3 = "STATE_CONNECTING";
                        break;
                    }
                    case 2: {
                        string3 = "STATE_CONNECTED";
                        break;
                    }
                    case 3: {
                        string3 = "STATE_DISCONNECTING";
                        break;
                    }
                    default: {
                        string3 = "unknown";
                    }
                }
                objectArray[0] = string3;
                Log.i("AudioSystemBroadcastReceiver", "receive bluetooth headset connection state changed: %s", objectArray);
                switch (n6) {
                    case 0: {
                        s4.d.onBluetoothConnectionChanged(false);
                        return;
                    }
                    case 2: {
                        s4.d.onBluetoothConnectionChanged(true);
                    }
                }
                return;
            }
            case 3: {
                Intent intent5 = intent;
                s s5 = this;
                int n7 = s.a(intent5, "android.bluetooth.profile.extra.STATE", 10);
                if (n7 == 12) {
                    Log.i("AudioSystemBroadcastReceiver", "receive bluetooth audio state changed to STATE_AUDIO_CONNECTED", new Object[0]);
                    s5.d.onBluetoothSCOConnected(true);
                    return;
                }
                if (n7 == 10) {
                    Log.i("AudioSystemBroadcastReceiver", "receive bluetooth audio state changed to STATE_AUDIO_DISCONNECTED", new Object[0]);
                    s5.d.onBluetoothSCOConnected(false);
                }
                return;
            }
            case 4: 
            case 5: {
                Intent intent6 = intent;
                s s6 = this;
                if (!s6.c) {
                    Log.i("AudioSystemBroadcastReceiver", "Do not enable usb device", new Object[0]);
                    return;
                }
                UsbDevice usbDevice = (UsbDevice)intent6.getParcelableExtra("device");
                if (usbDevice != null) {
                    if (LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
                        Log.i("AudioSystemBroadcastReceiver", "Usb device attached " + usbDevice.getProductName() + " manufacture " + usbDevice.getManufacturerName(), new Object[0]);
                    }
                    if (!s.a(usbDevice)) {
                        Log.i("AudioSystemBroadcastReceiver", "the attached usb device doesn't seem to support audio, ignore it", new Object[0]);
                        return;
                    }
                    if (intent6.getAction() == "android.hardware.usb.action.USB_DEVICE_ATTACHED") {
                        s6.d.onUsbConnectionChanged(true);
                        return;
                    }
                    if (intent6.getAction() == "android.hardware.usb.action.USB_DEVICE_DETACHED") {
                        s6.d.onUsbConnectionChanged(false);
                        return;
                    }
                    Log.i("AudioSystemBroadcastReceiver", "Unknown action, ignore it " + intent6.getAction(), new Object[0]);
                }
                return;
            }
        }
        Log.w("AudioSystemBroadcastReceiver", "ignore unknown Action: %s", string);
    }

    private static String a(int n2) {
        switch (n2) {
            case 10: {
                return "STATE_OFF";
            }
            case 11: {
                return "STATE_TURNING_ON";
            }
            case 12: {
                return "STATE_ON";
            }
            case 13: {
                return "STATE_TURNING_OFF";
            }
        }
        return "unknown";
    }

    static boolean a(UsbDevice usbDevice) {
        if (usbDevice == null) {
            return false;
        }
        try {
            for (int i2 = 0; i2 < usbDevice.getInterfaceCount(); ++i2) {
                if (usbDevice.getInterface(i2).getInterfaceClass() != 1) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            Log.i("AudioSystemBroadcastReceiver", "Get interface exception " + throwable.getMessage(), new Object[0]);
        }
        return false;
    }

    private static int a(Intent intent, String string, int n2) {
        int n3 = n2;
        try {
            n3 = intent.getIntExtra(string, n2);
        }
        catch (Exception exception) {
            LiteavLog.e("AudioSystemBroadcastReceiver", "getIntentIntExtra ".concat(String.valueOf(exception)));
        }
        return n3;
    }

    public static boolean a(Context context) {
        boolean bl2 = true;
        if (context != null && LiteavSystemInfo.getSystemOSVersionInt() >= 31) {
            bl2 = 0 == context.checkPermission("android.permission.BLUETOOTH_CONNECT", Process.myPid(), Process.myUid());
        }
        return bl2;
    }

    static final class b
    implements BluetoothProfile.ServiceListener {
        private final Context d;
        final BluetoothAdapter a;
        BluetoothProfile b = null;
        private AudioManager e;
        final Object c = new Object();

        public b(Context context) {
            this.d = context;
            this.a = com.tencent.liteav.audio.route.s$b.c();
            if (this.a != null) {
                try {
                    this.a.getProfileProxy(context, (BluetoothProfile.ServiceListener)this, 1);
                }
                catch (Throwable throwable) {
                    Log.w("AudioSystemBroadcastReceiver", "getProfileProxy " + throwable.getMessage(), new Object[0]);
                }
            } else {
                Log.i("AudioSystemBroadcastReceiver", "bluetooth adapter is null", new Object[0]);
            }
            this.e = (AudioManager)this.d.getSystemService("audio");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"NewApi"})
        public final boolean a() {
            boolean bl2 = false;
            if (this.a == null || !this.e()) {
                return false;
            }
            Object object = this.c;
            synchronized (object) {
                block13: {
                    if (this.b == null) {
                        try {
                            Log.i("AudioSystemBroadcastReceiver", "mBluetoothHeadsetProfile is null ,wait for 1000ms", new Object[0]);
                            this.c.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        if (this.b == null) {
                            return false;
                        }
                        Log.i("AudioSystemBroadcastReceiver", "mBluetoothHeadsetProfile service is connected now", new Object[0]);
                    }
                    try {
                        if (LiteavSystemInfo.getSystemOSVersionInt() > 30) {
                            for (AudioDeviceInfo audioDeviceInfo : this.e.getDevices(2)) {
                                if (audioDeviceInfo.getType() != 8 && audioDeviceInfo.getType() != 7) continue;
                                bl2 = true;
                                Log.i("AudioSystemBroadcastReceiver", "find bluetooth device", new Object[0]);
                                break block13;
                            }
                            break block13;
                        }
                        if (s.a(this.d)) {
                            List<BluetoothDevice> list = this.d();
                            bl2 = list != null && list.size() > 0;
                        }
                    }
                    catch (Exception exception) {
                        Log.e("AudioSystemBroadcastReceiver", "get connected bluetooth devices failed." + exception.getMessage(), new Object[0]);
                    }
                }
            }
            return bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1) {
                return;
            }
            Object object = this.c;
            synchronized (object) {
                if (this.a != null && this.b != null) {
                    Log.i("AudioSystemBroadcastReceiver", "BluetoohHeadset proxy changed from %s to %s", this.b, proxy);
                    this.b();
                    this.b = null;
                }
                this.b = proxy;
                this.c.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(int profile) {
            if (profile != 1) {
                return;
            }
            Object object = this.c;
            synchronized (object) {
                if (this.a != null && this.b != null) {
                    this.b();
                    this.b = null;
                }
                return;
            }
        }

        private static BluetoothAdapter c() {
            try {
                return BluetoothAdapter.getDefaultAdapter();
            }
            catch (Throwable throwable) {
                Log.w("AudioSystemBroadcastReceiver", "getDefaultAdapter exception " + throwable.getMessage(), new Object[0]);
                return null;
            }
        }

        final void b() {
            try {
                this.a.closeProfileProxy(1, this.b);
                return;
            }
            catch (Throwable throwable) {
                Log.w("AudioSystemBroadcastReceiver", "closeProfileProxy exception " + throwable.getMessage(), new Object[0]);
                return;
            }
        }

        private List<BluetoothDevice> d() {
            try {
                return this.b.getConnectedDevices();
            }
            catch (Throwable throwable) {
                Log.w("AudioSystemBroadcastReceiver", "getConnectedDevices exception " + throwable.getMessage(), new Object[0]);
                return null;
            }
        }

        private boolean e() {
            try {
                return this.a.isEnabled();
            }
            catch (Throwable throwable) {
                Log.w("AudioSystemBroadcastReceiver", "isEnabled exception " + throwable.getMessage(), new Object[0]);
                return false;
            }
        }
    }

    public static class a {
        public void onWiredHeadsetConnectionChanged(boolean connected) {
        }

        public void onBluetoothConnectionChanged(boolean connected) {
        }

        public void onBluetoothSCOConnected(boolean connected) {
        }

        public void onUsbConnectionChanged(boolean connected) {
        }
    }
}

