/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.frame;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.MirrorInfo;
import com.tencent.liteav.videobase.utils.Rotation;

@JNINamespace(value="liteav::video")
public class FrameMetaData {
    private final MirrorInfo mCaptureMirror = new MirrorInfo();
    private Rotation mCaptureRotation = Rotation.a;
    private boolean mIsFrontCamera = false;
    private final Size mCaptureRealFrameSize = new Size();
    private final MirrorInfo mPreprocessorMirror = new MirrorInfo();
    private Rotation mPreprocessorRotation = Rotation.a;
    private GLConstants.GLScaleType mPreprocessorScaleType = GLConstants.GLScaleType.a;
    private final MirrorInfo mRenderMirror = new MirrorInfo();
    private Rotation mRenderRotation = Rotation.a;
    private final Size mRenderSize = new Size();
    private final MirrorInfo mEncodeMirror = new MirrorInfo();
    private Rotation mEncodeRotation = Rotation.a;
    private final Size mEncodeSize = new Size();

    @CalledByNative
    public FrameMetaData() {
    }

    @CalledByNative
    public void setCaptureMetaData(boolean isHorizontal, boolean isVertical, int rotation, boolean isFrontCamera, int width, int height) {
        this.mCaptureMirror.isHorizontal = isHorizontal;
        this.mCaptureMirror.isVertical = isVertical;
        this.mCaptureRotation = Rotation.a(rotation);
        this.mIsFrontCamera = isFrontCamera;
        this.mCaptureRealFrameSize.width = width;
        this.mCaptureRealFrameSize.height = height;
    }

    @CalledByNative
    public boolean isCaptureMirrorHorizontal() {
        return this.mCaptureMirror.isHorizontal;
    }

    @CalledByNative
    public boolean isCaptureMirrorVertical() {
        return this.mCaptureMirror.isVertical;
    }

    @CalledByNative
    public int getCaptureRotation() {
        return this.mCaptureRotation.mValue;
    }

    @CalledByNative
    public boolean isFrontCamera() {
        return this.mIsFrontCamera;
    }

    public Size getCaptureRealSize() {
        return this.mCaptureRealFrameSize;
    }

    @CalledByNative
    public void setPreprocessorMetaData(boolean isHorizontal, boolean isVertical, int rotation, int scaleType) {
        this.mPreprocessorMirror.isHorizontal = isHorizontal;
        this.mPreprocessorMirror.isVertical = isVertical;
        this.mPreprocessorRotation = Rotation.a(rotation);
        this.mPreprocessorScaleType = GLConstants.GLScaleType.a(scaleType);
    }

    public void setPreprocessorMirror(MirrorInfo mirrorInfo) {
        if (mirrorInfo == null) {
            return;
        }
        this.mPreprocessorMirror.isHorizontal = mirrorInfo.isHorizontal;
        this.mPreprocessorMirror.isVertical = mirrorInfo.isVertical;
    }

    @CalledByNative
    public boolean isPreprocessorMirrorHorizontal() {
        return this.mPreprocessorMirror.isHorizontal;
    }

    @CalledByNative
    public boolean isPreprocessorMirrorVertical() {
        return this.mPreprocessorMirror.isVertical;
    }

    public void setPreprocessorRotation(Rotation rotation) {
        if (rotation == null) {
            return;
        }
        this.mPreprocessorRotation = rotation;
    }

    public Rotation getPreprocessorRotation() {
        return this.mPreprocessorRotation;
    }

    @CalledByNative
    public int getPreprocessorRotationValue() {
        return this.mPreprocessorRotation.mValue;
    }

    public void setPreprocessorScaleType(GLConstants.GLScaleType scaleType) {
        if (scaleType == null) {
            return;
        }
        this.mPreprocessorScaleType = scaleType;
    }

    public GLConstants.GLScaleType getPreprocessorScaleType() {
        return this.mPreprocessorScaleType;
    }

    @CalledByNative
    public int getPreprocessorScaleTypeValue() {
        return this.mPreprocessorScaleType.mValue;
    }

    @CalledByNative
    public void setRenderMetaData(boolean isHorizontal, boolean isVertical, int rotation, int width, int height) {
        this.mRenderMirror.isHorizontal = isHorizontal;
        this.mRenderMirror.isVertical = isVertical;
        this.mRenderRotation = Rotation.a(rotation);
        this.mRenderSize.width = width;
        this.mRenderSize.height = height;
    }

    public void setRenderMirror(MirrorInfo mirrorInfo) {
        if (mirrorInfo == null) {
            return;
        }
        this.mRenderMirror.isHorizontal = mirrorInfo.isHorizontal;
        this.mRenderMirror.isVertical = mirrorInfo.isVertical;
    }

    @CalledByNative
    public boolean isRenderMirrorHorizontal() {
        return this.mRenderMirror.isHorizontal;
    }

    @CalledByNative
    public boolean isRenderMirrorVertical() {
        return this.mRenderMirror.isVertical;
    }

    public void setRenderRotation(Rotation rotation) {
        if (rotation == null) {
            return;
        }
        this.mRenderRotation = rotation;
    }

    public Rotation getRenderRotation() {
        return this.mRenderRotation;
    }

    @CalledByNative
    public int getRenderRotationValue() {
        return this.mRenderRotation.mValue;
    }

    public void setRenderSize(Size size) {
        this.mRenderSize.set(size);
    }

    public Size getRenderSize() {
        return this.mRenderSize;
    }

    @CalledByNative
    public int getRenderWidth() {
        return this.mRenderSize.width;
    }

    @CalledByNative
    public int getRenderHeight() {
        return this.mRenderSize.height;
    }

    @CalledByNative
    public void setEncodeMetaData(boolean isHorizontal, boolean isVertical, int rotation, int width, int height) {
        this.mEncodeMirror.isHorizontal = isHorizontal;
        this.mEncodeMirror.isVertical = isVertical;
        this.mEncodeRotation = Rotation.a(rotation);
        this.mEncodeSize.width = width;
        this.mEncodeSize.height = height;
    }

    public void setEncodeMirror(MirrorInfo mirrorInfo) {
        if (mirrorInfo == null) {
            return;
        }
        this.mEncodeMirror.isHorizontal = mirrorInfo.isHorizontal;
        this.mEncodeMirror.isVertical = mirrorInfo.isVertical;
    }

    @CalledByNative
    public boolean isEncodeMirrorHorizontal() {
        return this.mEncodeMirror.isHorizontal;
    }

    @CalledByNative
    public boolean isEncodeMirrorVertical() {
        return this.mEncodeMirror.isVertical;
    }

    public void setEncodeRotation(Rotation rotation) {
        if (rotation == null) {
            return;
        }
        this.mEncodeRotation = rotation;
    }

    public Rotation getEncodeRotation() {
        return this.mEncodeRotation;
    }

    @CalledByNative
    public int getEncodeRotationValue() {
        return this.mEncodeRotation.mValue;
    }

    public void setEncodeSize(Size size) {
        this.mEncodeSize.set(size);
    }

    public Size getEncodeSize() {
        return this.mEncodeSize;
    }

    @CalledByNative
    public int getEncodeWidth() {
        return this.mEncodeSize.width;
    }

    @CalledByNative
    public int getEncodeHeight() {
        return this.mEncodeSize.height;
    }
}

