/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;

@JNINamespace(value="liteav::video")
class NativeVideoCaptureListener
implements IVideoReporter,
CaptureSourceInterface.CaptureSourceListener {
    private static final String TAG = "NativeVideoCaptureListener";
    private long mNativeHandler;

    @CalledByNative
    public NativeVideoCaptureListener(long nativeHandler) {
        this.mNativeHandler = nativeHandler;
    }

    @CalledByNative
    public synchronized void resetNativeHandle() {
        this.mNativeHandler = 0L;
    }

    @Override
    public synchronized void onStartFinish(boolean success) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnStartFinish(this.mNativeHandler, success);
        }
    }

    @Override
    public synchronized void onFrameAvailable(CaptureSourceInterface captureSource, PixelFrame pixelFrame) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnFrameAvailable(this.mNativeHandler, pixelFrame);
        }
    }

    @Override
    public synchronized void onCaptureError() {
    }

    @Override
    public synchronized void onScreenDisplayOrientationChanged(Rotation rotation) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnScreenDisplayOrientationChanged(this.mNativeHandler, Rotation.a(rotation));
        }
    }

    @Override
    public synchronized void onCameraTouchEnable(boolean enableTouch) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnAutoFocusEnabled(this.mNativeHandler, !enableTouch);
        }
    }

    @Override
    public synchronized void onCameraZoomEnable(boolean enableZoom) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnZoomEnabled(this.mNativeHandler, enableZoom);
        }
    }

    @Override
    public synchronized void onCaptureFirstFrame() {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnCaptureFirstFrame(this.mNativeHandler);
        }
    }

    @Override
    public synchronized void notifyEvent(h.b code, Object param, String msg) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        if (code == h.b.k) {
            NativeVideoCaptureListener.nativeOnCaptureFirstFrame(this.mNativeHandler);
            return;
        }
        if (code == h.b.o) {
            NativeVideoCaptureListener.nativeOnCapturePaused(this.mNativeHandler);
            return;
        }
        if (code == h.b.p) {
            NativeVideoCaptureListener.nativeOnCaptureResumed(this.mNativeHandler);
            return;
        }
        if (code == h.b.n) {
            NativeVideoCaptureListener.nativeOnCaptureStopped(this.mNativeHandler);
        }
    }

    @Override
    public void notifyEvent(h.b code, int index, String msg) {
    }

    @Override
    public synchronized void notifyWarning(h.c code, String msg) {
    }

    @Override
    public synchronized void notifyError(h.a code, String msg) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        int n2 = h.a(code);
        if (n2 != 0) {
            NativeVideoCaptureListener.nativeOnCaptureError(this.mNativeHandler, n2, msg);
            return;
        }
        LiteavLog.i(TAG, "notifyError error code:" + (Object)((Object)code) + ", do not need transfer to LiteAvCode:" + n2);
    }

    @Override
    public synchronized void updateStatus(i key, Object value) {
    }

    @Override
    public synchronized void updateStatus(i key, int index, Object value) {
    }

    private static native void nativeOnCapturePaused(long var0);

    private static native void nativeOnCaptureResumed(long var0);

    private static native void nativeOnCaptureStopped(long var0);

    private static native void nativeOnCaptureFirstFrame(long var0);

    private static native void nativeOnStartFinish(long var0, boolean var2);

    private static native void nativeOnFrameAvailable(long var0, PixelFrame var2);

    private static native void nativeOnCaptureError(long var0, int var2, String var3);

    private static native void nativeOnScreenDisplayOrientationChanged(long var0, int var2);

    private static native void nativeOnAutoFocusEnabled(long var0, boolean var2);

    private static native void nativeOnZoomEnabled(long var0, boolean var2);
}

