/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.decider;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;

@JNINamespace(value="liteav::video")
public class CaptureResolutionDecider {
    private long mNativePtr = 0L;

    public void initialize() {
        if (this.mNativePtr == 0L) {
            this.mNativePtr = CaptureResolutionDecider.nativeCreate();
        }
    }

    public void uninitialize() {
        if (this.mNativePtr != 0L) {
            CaptureResolutionDecider.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    public void setSourceType(CaptureSourceInterface.SourceType sourceType) {
        if (this.mNativePtr != 0L && sourceType != null) {
            CaptureResolutionDecider.nativeSetSourceType(this.mNativePtr, sourceType.mValue);
        }
    }

    public void setResolutionMode(GLConstants.ResolutionMode resolutionMode) {
        if (this.mNativePtr != 0L) {
            CaptureResolutionDecider.nativeSetResolutionMode(this.mNativePtr, resolutionMode == null ? -1 : resolutionMode.mValue);
        }
    }

    public void setEncodeSize(int width, int height) {
        if (this.mNativePtr != 0L) {
            CaptureResolutionDecider.nativeSetEncodeSize(this.mNativePtr, width, height);
        }
    }

    public void setEncodeRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            CaptureResolutionDecider.nativeSetEncodeRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    public void setManualCaptureSize(int width, int height) {
        if (this.mNativePtr != 0L) {
            CaptureResolutionDecider.nativeSetManualCaptureSize(this.mNativePtr, width, height);
        }
    }

    public void setCameraCaptureMode(VideoProducerDef.CameraCaptureMode mode) {
        if (this.mNativePtr != 0L && mode != null) {
            CaptureResolutionDecider.nativeSetCameraCaptureMode(this.mNativePtr, mode.mValue);
        }
    }

    public void setRealCaptureFrameSize(int width, int height, Rotation rotation, boolean isUpdateEncodeSize) {
        if (this.mNativePtr != 0L) {
            CaptureResolutionDecider.nativeSetRealCaptureFrameSize(this.mNativePtr, width, height, Rotation.a(rotation), isUpdateEncodeSize);
        }
    }

    @NonNull
    public Size getCaptureSize() {
        if (this.mNativePtr != 0L) {
            return CaptureResolutionDecider.nativeGetCaptureSize(this.mNativePtr);
        }
        return new Size();
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeSetSourceType(long var0, int var2);

    private static native void nativeSetResolutionMode(long var0, int var2);

    private static native void nativeSetEncodeSize(long var0, int var2, int var3);

    private static native void nativeSetEncodeRotation(long var0, int var2);

    private static native void nativeSetManualCaptureSize(long var0, int var2, int var3);

    private static native void nativeSetCameraCaptureMode(long var0, int var2);

    private static native void nativeSetRealCaptureFrameSize(long var0, int var2, int var3, int var4, boolean var5);

    private static native Size nativeGetCaptureSize(long var0);
}

