/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.decider;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;

@JNINamespace(value="liteav::video")
public class ResolutionDecider {
    private long mNativePtr = 0L;

    public void initialize() {
        if (this.mNativePtr == 0L) {
            this.mNativePtr = ResolutionDecider.nativeCreate();
        }
    }

    public void uninitialize() {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    public void setSourceType(CaptureSourceInterface.SourceType sourceType) {
        if (this.mNativePtr != 0L && sourceType != null) {
            ResolutionDecider.nativeSetSourceType(this.mNativePtr, sourceType.mValue);
        }
    }

    public void setCameraCaptureMode(VideoProducerDef.CameraCaptureMode mode) {
        if (this.mNativePtr != 0L && mode != null) {
            ResolutionDecider.nativeSetCameraCaptureMode(this.mNativePtr, mode.mValue);
        }
    }

    public void setHomeOrientation(VideoProducerDef.HomeOrientation homeOrientation) {
        if (this.mNativePtr != 0L && homeOrientation != null) {
            ResolutionDecider.nativeSetHomeOrientation(this.mNativePtr, homeOrientation.mValue);
        }
    }

    public void setScreenAutoRotateEnable(boolean enableAutoRotate) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetScreenAutoRotateEnable(this.mNativePtr, enableAutoRotate);
        }
    }

    public void setComplexFilterExist(boolean isComplex) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetComplexFilterExist(this.mNativePtr, isComplex);
        }
    }

    public void setResolutionMode(GLConstants.ResolutionMode resolutionMode) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetResolutionMode(this.mNativePtr, resolutionMode == null ? -1 : resolutionMode.mValue);
        }
    }

    public void setGSensorMode(VideoProducerDef.GSensorMode gSensorMode) {
        if (this.mNativePtr != 0L && gSensorMode != null) {
            ResolutionDecider.nativeSetGSensorMode(this.mNativePtr, gSensorMode.mValue);
        }
    }

    public void setScreenDisplayRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetScreenDisplayRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    public void setRealCaptureFrameSize(int width, int height, Rotation rotation, boolean isUpdateEncodeSize) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetRealCaptureFrameSize(this.mNativePtr, width, height, Rotation.a(rotation), isUpdateEncodeSize);
        }
    }

    public void setPreprocessRotation(Rotation rotationWithoutCapture) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetPreprocessRotation(this.mNativePtr, Rotation.a(rotationWithoutCapture));
        }
    }

    @NonNull
    public Size getRenderSize() {
        if (this.mNativePtr != 0L) {
            return ResolutionDecider.nativeGetRenderSize(this.mNativePtr);
        }
        return new Size();
    }

    public void setEncodeSize(int width, int height) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetEncodeSize(this.mNativePtr, width, height);
        }
    }

    public void setEncodeRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            ResolutionDecider.nativeSetEncodeRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    @NonNull
    public Size getEncodeSize() {
        if (this.mNativePtr != 0L) {
            return ResolutionDecider.nativeGetEncodeSize(this.mNativePtr);
        }
        return new Size();
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeSetSourceType(long var0, int var2);

    private static native void nativeSetCameraCaptureMode(long var0, int var2);

    private static native void nativeSetHomeOrientation(long var0, int var2);

    private static native void nativeSetScreenAutoRotateEnable(long var0, boolean var2);

    private static native void nativeSetComplexFilterExist(long var0, boolean var2);

    private static native void nativeSetResolutionMode(long var0, int var2);

    private static native void nativeSetGSensorMode(long var0, int var2);

    private static native void nativeSetScreenDisplayRotation(long var0, int var2);

    private static native void nativeSetRealCaptureFrameSize(long var0, int var2, int var3, int var4, boolean var5);

    private static native void nativeSetPreprocessRotation(long var0, int var2);

    private static native Size nativeGetRenderSize(long var0);

    private static native void nativeSetEncodeSize(long var0, int var2, int var3);

    private static native void nativeSetEncodeRotation(long var0, int var2);

    private static native Size nativeGetEncodeSize(long var0);
}

