/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.decider;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.MirrorInfo;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;

@JNINamespace(value="liteav::video")
public class VideoMirrorDecider {
    private long mNativePtr = 0L;

    public void initialize() {
        if (this.mNativePtr == 0L) {
            this.mNativePtr = VideoMirrorDecider.nativeCreate();
        }
    }

    public void uninitialize() {
        if (this.mNativePtr != 0L) {
            VideoMirrorDecider.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    public void setFront(boolean isFront) {
        if (this.mNativePtr != 0L) {
            VideoMirrorDecider.nativeSetFront(this.mNativePtr, isFront);
        }
    }

    public void setSourceType(CaptureSourceInterface.SourceType sourceType) {
        if (this.mNativePtr != 0L && sourceType != null) {
            VideoMirrorDecider.nativeSetSourceType(this.mNativePtr, sourceType.mValue);
        }
    }

    public void setHomeOrientation(VideoProducerDef.HomeOrientation homeOrientation) {
        if (this.mNativePtr != 0L && homeOrientation != null) {
            VideoMirrorDecider.nativeSetHomeOrientation(this.mNativePtr, homeOrientation.mValue);
        }
    }

    public void setResolutionMode(GLConstants.ResolutionMode resolutionMode) {
        if (this.mNativePtr != 0L && resolutionMode != null) {
            VideoMirrorDecider.nativeSetResolutionMode(this.mNativePtr, resolutionMode.mValue);
        }
    }

    public void setGSensorMode(VideoProducerDef.GSensorMode gSensorMode) {
        if (this.mNativePtr != 0L && gSensorMode != null) {
            VideoMirrorDecider.nativeSetGSensorMode(this.mNativePtr, gSensorMode.mValue);
        }
    }

    public void setSensorRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoMirrorDecider.nativeSetSensorRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    public void setDisplayRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoMirrorDecider.nativeSetDisplayRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    public void setCaptureRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoMirrorDecider.nativeSetCaptureRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    public void setCaptureMirror(boolean isHorizontal, boolean isVertical) {
        if (this.mNativePtr != 0L) {
            VideoMirrorDecider.nativeSetCaptureMirror(this.mNativePtr, isHorizontal, isVertical);
        }
    }

    @NonNull
    public MirrorInfo getPreprocessorMirrorInfo() {
        if (this.mNativePtr != 0L) {
            return VideoMirrorDecider.nativeGetPreprocessorMirrorInfo(this.mNativePtr);
        }
        return new MirrorInfo();
    }

    public void setRenderMirrorModeByUser(GLConstants.MirrorMode mirrorMode) {
        if (this.mNativePtr != 0L && mirrorMode != null) {
            VideoMirrorDecider.nativeSetRenderMirrorModeByUser(this.mNativePtr, mirrorMode.mValue);
        }
    }

    @NonNull
    public MirrorInfo getRenderMirrorInfo(Rotation preprocessorRotationWithoutCapture) {
        if (this.mNativePtr != 0L) {
            return VideoMirrorDecider.nativeGetRenderMirrorInfo(this.mNativePtr, Rotation.a(preprocessorRotationWithoutCapture));
        }
        return new MirrorInfo();
    }

    public void setEncodeMirrorByUser(boolean horizontalMirror) {
        if (this.mNativePtr != 0L) {
            VideoMirrorDecider.nativeSetEncodeMirrorByUser(this.mNativePtr, horizontalMirror);
        }
    }

    @NonNull
    public MirrorInfo getEncodeMirrorInfo() {
        if (this.mNativePtr != 0L) {
            return VideoMirrorDecider.nativeGetEncodeMirrorInfo(this.mNativePtr);
        }
        return new MirrorInfo();
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeSetFront(long var0, boolean var2);

    private static native void nativeSetSourceType(long var0, int var2);

    private static native void nativeSetHomeOrientation(long var0, int var2);

    private static native void nativeSetResolutionMode(long var0, int var2);

    private static native void nativeSetGSensorMode(long var0, int var2);

    private static native void nativeSetSensorRotation(long var0, int var2);

    private static native void nativeSetDisplayRotation(long var0, int var2);

    private static native void nativeSetCaptureRotation(long var0, int var2);

    private static native void nativeSetCaptureMirror(long var0, boolean var2, boolean var3);

    private static native MirrorInfo nativeGetPreprocessorMirrorInfo(long var0);

    private static native void nativeSetRenderMirrorModeByUser(long var0, int var2);

    private static native MirrorInfo nativeGetRenderMirrorInfo(long var0, int var2);

    private static native void nativeSetEncodeMirrorByUser(long var0, boolean var2);

    private static native MirrorInfo nativeGetEncodeMirrorInfo(long var0);
}

