/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.decider;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;

@JNINamespace(value="liteav::video")
public class VideoRotationDecider {
    private long mNativePtr = 0L;

    public void initialize() {
        if (this.mNativePtr == 0L) {
            this.mNativePtr = VideoRotationDecider.nativeCreate();
        }
    }

    public void uninitialize() {
        if (this.mNativePtr != 0L) {
            VideoRotationDecider.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    public void setFront(boolean isFront) {
        if (this.mNativePtr != 0L) {
            VideoRotationDecider.nativeSetFront(this.mNativePtr, isFront);
        }
    }

    public void setSourceType(CaptureSourceInterface.SourceType sourceType) {
        if (this.mNativePtr != 0L && sourceType != null) {
            VideoRotationDecider.nativeSetSourceType(this.mNativePtr, sourceType.mValue);
        }
    }

    public void setHomeOrientation(VideoProducerDef.HomeOrientation homeOrientation) {
        if (this.mNativePtr != 0L && homeOrientation != null) {
            VideoRotationDecider.nativeSetHomeOrientation(this.mNativePtr, homeOrientation.mValue);
        }
    }

    public void setResolutionMode(GLConstants.ResolutionMode resolutionMode) {
        if (this.mNativePtr != 0L && resolutionMode != null) {
            VideoRotationDecider.nativeSetResolutionMode(this.mNativePtr, resolutionMode.mValue);
        }
    }

    public void setGSensorMode(VideoProducerDef.GSensorMode gSensorMode) {
        if (this.mNativePtr != 0L && gSensorMode != null) {
            VideoRotationDecider.nativeSetGSensorMode(this.mNativePtr, gSensorMode.mValue);
        }
    }

    public void setSensorRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoRotationDecider.nativeSetSensorRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    public void setDisplayRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoRotationDecider.nativeSetDisplayRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    public void setCaptureRotation(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoRotationDecider.nativeSetCaptureRotation(this.mNativePtr, Rotation.a(rotation));
        }
    }

    @NonNull
    public Rotation getPreprocessorRotation(boolean withCaptureRotation) {
        if (this.mNativePtr != 0L) {
            return Rotation.a(VideoRotationDecider.nativeGetPreprocessorRotation(this.mNativePtr, withCaptureRotation));
        }
        return Rotation.a;
    }

    public void setRenderRotationByUser(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoRotationDecider.nativeSetRenderRotationByUser(this.mNativePtr, Rotation.a(rotation));
        }
    }

    @NonNull
    public Rotation getRenderRotation() {
        if (this.mNativePtr != 0L) {
            return Rotation.a(VideoRotationDecider.nativeGetRenderRotation(this.mNativePtr));
        }
        return Rotation.a;
    }

    public void setEncodeRotationByUser(Rotation rotation) {
        if (this.mNativePtr != 0L) {
            VideoRotationDecider.nativeSetEncodeRotationByUser(this.mNativePtr, Rotation.a(rotation));
        }
    }

    @NonNull
    public Rotation getEncodeRotation() {
        if (this.mNativePtr != 0L) {
            return Rotation.a(VideoRotationDecider.nativeGetEncodeRotation(this.mNativePtr));
        }
        return Rotation.a;
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeSetFront(long var0, boolean var2);

    private static native void nativeSetSourceType(long var0, int var2);

    private static native void nativeSetHomeOrientation(long var0, int var2);

    private static native void nativeSetResolutionMode(long var0, int var2);

    private static native void nativeSetGSensorMode(long var0, int var2);

    private static native void nativeSetSensorRotation(long var0, int var2);

    private static native void nativeSetDisplayRotation(long var0, int var2);

    private static native void nativeSetCaptureRotation(long var0, int var2);

    private static native int nativeGetPreprocessorRotation(long var0, boolean var2);

    private static native void nativeSetRenderRotationByUser(long var0, int var2);

    private static native int nativeGetRenderRotation(long var0);

    private static native void nativeSetEncodeRotationByUser(long var0, int var2);

    private static native int nativeGetEncodeRotation(long var0);
}

