/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.producer;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.HandlerThread;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoproducer.capture.CameraCaptureParams;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.ScreenCapturer;
import com.tencent.liteav.videoproducer.capture.VirtualCamera;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.preprocessor.BeautyProcessor;
import com.tencent.liteav.videoproducer.preprocessor.VideoPreprocessor;
import com.tencent.liteav.videoproducer.producer.CustomVideoProcessListener;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import com.tencent.liteav.videoproducer.producer.aa;
import com.tencent.liteav.videoproducer.producer.ab;
import com.tencent.liteav.videoproducer.producer.ac;
import com.tencent.liteav.videoproducer.producer.ad;
import com.tencent.liteav.videoproducer.producer.ae;
import com.tencent.liteav.videoproducer.producer.af;
import com.tencent.liteav.videoproducer.producer.ag;
import com.tencent.liteav.videoproducer.producer.am;
import com.tencent.liteav.videoproducer.producer.ar;
import com.tencent.liteav.videoproducer.producer.as;
import com.tencent.liteav.videoproducer.producer.at;
import com.tencent.liteav.videoproducer.producer.au;
import com.tencent.liteav.videoproducer.producer.av;
import com.tencent.liteav.videoproducer.producer.e;
import com.tencent.liteav.videoproducer.producer.f;
import com.tencent.liteav.videoproducer.producer.g;
import com.tencent.liteav.videoproducer.producer.h;
import com.tencent.liteav.videoproducer.producer.i;
import com.tencent.liteav.videoproducer.producer.j;
import com.tencent.liteav.videoproducer.producer.k;
import com.tencent.liteav.videoproducer.producer.l;
import com.tencent.liteav.videoproducer.producer.m;
import com.tencent.liteav.videoproducer.producer.n;
import com.tencent.liteav.videoproducer.producer.o;
import com.tencent.liteav.videoproducer.producer.p;
import com.tencent.liteav.videoproducer.producer.q;
import com.tencent.liteav.videoproducer.producer.r;
import com.tencent.liteav.videoproducer.producer.s;
import com.tencent.liteav.videoproducer.producer.t;
import com.tencent.liteav.videoproducer.producer.u;
import com.tencent.liteav.videoproducer.producer.v;
import com.tencent.liteav.videoproducer.producer.w;
import com.tencent.liteav.videoproducer.producer.x;
import com.tencent.liteav.videoproducer.producer.y;
import com.tencent.liteav.videoproducer.producer.z;

@JNINamespace(value="liteav::video")
public class VideoProducerProxy {
    private final e mProducer;

    @CalledByNative
    public VideoProducerProxy(boolean isEnterpriseProEnabled, @NonNull IVideoReporter reporter) {
        this(ContextUtils.getApplicationContext(), isEnterpriseProEnabled, reporter);
    }

    public VideoProducerProxy(@NonNull Context context, boolean isEnterpriseProEnabled, @NonNull IVideoReporter reporter) {
        this.mProducer = new e(context, isEnterpriseProEnabled, reporter);
    }

    @CalledByNative
    public static VideoEncoderDef.EncodeAbility getEncodeAbility() {
        return e.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void initialize() {
        e e2;
        e e3 = e2 = this.mProducer;
        synchronized (e2) {
            if (e2.f) {
                LiteavLog.w(e2.a, "videoproducer already initialized.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HandlerThread handlerThread = new HandlerThread("videoProducer_" + e2.hashCode());
            handlerThread.start();
            e2.e = new CustomHandler(handlerThread.getLooper());
            e2.f = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            e2.e.runAndWaitDone(f.a(e2));
            return;
        }
    }

    @CalledByNative
    public void uninitialize() {
        e e2 = this.mProducer;
        e2.a(q.a(e2));
    }

    @CalledByNative
    public BeautyProcessor getBeautyProcessor() {
        return this.mProducer.d;
    }

    @CalledByNative
    public void setServerConfig(ServerVideoProducerConfig serverConfig) {
        e e2 = this.mProducer;
        ServerVideoProducerConfig serverVideoProducerConfig = serverConfig;
        e2.a(ab.a(e2, serverVideoProducerConfig));
    }

    @CalledByNative
    public void startCapture(CaptureSourceInterface.SourceType sourceType, VideoProducerDef.CameraCaptureMode mode, CaptureSourceInterface.CaptureParams captureParams) {
        CaptureSourceInterface.CaptureParams captureParams2 = captureParams;
        VideoProducerDef.CameraCaptureMode cameraCaptureMode = mode;
        CaptureSourceInterface.SourceType sourceType2 = sourceType;
        e e2 = this.mProducer;
        if (sourceType2 != CaptureSourceInterface.SourceType.b && sourceType2 != CaptureSourceInterface.SourceType.c && sourceType2 != CaptureSourceInterface.SourceType.d) {
            throw new IllegalArgumentException("type: ".concat(String.valueOf((Object)sourceType2)));
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.b && !(captureParams2 instanceof CameraCaptureParams)) {
            throw new IllegalArgumentException("CaptureParams is not CameraCaptureParams");
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.c) {
            if (!(captureParams2 instanceof ScreenCapturer.ScreenCaptureParams)) {
                throw new IllegalArgumentException("CaptureParams is not ScreenCaptureParams");
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
                e2.b.notifyError(h.a.h, "not support screen capture");
            }
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.d && !(captureParams2 instanceof VirtualCamera.VirtualCameraParams)) {
            throw new IllegalArgumentException("CaptureParams is not VirtualCameraParams");
        }
        e e3 = e2;
        e3.a(am.a(e3, sourceType2, cameraCaptureMode, captureParams2));
    }

    @CalledByNative
    public void stopCapture(int waitingTimeMs) {
        e e2 = this.mProducer;
        e2.a(ar.a(e2), waitingTimeMs);
    }

    @CalledByNative
    public void setCaptureParams(CaptureSourceInterface.SourceType sourceType, VideoProducerDef.CameraCaptureMode mode, CaptureSourceInterface.CaptureParams captureParams) {
        e e2 = this.mProducer;
        CaptureSourceInterface.CaptureParams captureParams2 = captureParams;
        VideoProducerDef.CameraCaptureMode cameraCaptureMode = mode;
        CaptureSourceInterface.SourceType sourceType2 = sourceType;
        e2.a(as.a(e2, sourceType2, cameraCaptureMode, captureParams2));
    }

    @CalledByNative
    public void setPausedImage(Bitmap bitmap, int framerate) {
        e e2 = this.mProducer;
        Bitmap bitmap2 = bitmap;
        e2.a(at.a(e2, bitmap2, framerate));
    }

    @CalledByNative
    public void pauseCapture() {
        e e2 = this.mProducer;
        e2.a(au.a(e2));
    }

    @CalledByNative
    public void resumeCapture() {
        e e2 = this.mProducer;
        e2.a(av.a(e2));
    }

    @CalledByNative
    public void setDisplayView(DisplayTarget displayTarget) {
        e e2 = this.mProducer;
        DisplayTarget displayTarget2 = displayTarget;
        e2.a(g.a(e2, displayTarget2));
    }

    @CalledByNative
    public void startEncodeStream(VideoProducerDef.StreamType streamType, VideoEncodeParams params, VideoEncoderDef.VideoEncoderDataListener listener) {
        e e2 = this.mProducer;
        VideoEncoderDef.VideoEncoderDataListener videoEncoderDataListener = listener;
        VideoEncodeParams videoEncodeParams = params;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(h.a(e2, streamType2, videoEncodeParams, videoEncoderDataListener));
    }

    @CalledByNative
    public void stopEncodeStream(VideoProducerDef.StreamType streamType) {
        e e2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(i.a(e2, streamType2), 2000L);
    }

    @CalledByNative
    public VideoPreprocessor getVideoPreprocessor() {
        return this.mProducer.c;
    }

    @CalledByNative
    public void setEncodeStrategy(VideoProducerDef.StreamType streamType, VideoEncoderDef.EncodeStrategy encodeStrategy) {
        e e2 = this.mProducer;
        VideoEncoderDef.EncodeStrategy encodeStrategy2 = encodeStrategy;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(j.a(e2, streamType2, encodeStrategy2));
    }

    @CalledByNative
    public void setEncodeMirrorEnabled(boolean enable) {
        e e2 = this.mProducer;
        e2.a(k.a(e2, enable));
    }

    @CalledByNative
    public void setEncodeRotation(Rotation rotation) {
        e e2 = this.mProducer;
        Rotation rotation2 = rotation;
        e2.a(l.a(e2, rotation2));
    }

    @CalledByNative
    public void setHWEncoderDeviceRelatedParams(String params) {
        String string = params;
        e e2 = this.mProducer;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            e e3 = e2;
            e3.a(m.a(e3, string));
        }
    }

    @CalledByNative
    public int setCameraFocusPosition(int x2, int y2) {
        e e2 = this.mProducer;
        e2.a(n.a(e2, x2, y2));
        return 0;
    }

    @CalledByNative
    public void setGSensorMode(VideoProducerDef.GSensorMode mode) {
        e e2 = this.mProducer;
        VideoProducerDef.GSensorMode gSensorMode = mode;
        e2.a(o.a(e2, gSensorMode));
    }

    @CalledByNative
    public void setHomeOrientation(VideoProducerDef.HomeOrientation mode) {
        e e2 = this.mProducer;
        VideoProducerDef.HomeOrientation homeOrientation = mode;
        e2.a(p.a(e2, homeOrientation));
    }

    @CalledByNative
    public void setEncodeParams(VideoProducerDef.StreamType streamType, VideoEncodeParams params, GLConstants.ResolutionMode orientation) {
        e e2 = this.mProducer;
        GLConstants.ResolutionMode resolutionMode = orientation;
        VideoEncodeParams videoEncodeParams = params;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(r.a(e2, streamType2, videoEncodeParams, resolutionMode));
    }

    @CalledByNative
    public void setRPSIFrameFPS(VideoProducerDef.StreamType streamType, int fps) {
        e e2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(s.a(e2, fps, streamType2));
    }

    @CalledByNative
    public void setRPSNearestREFSize(VideoProducerDef.StreamType streamType, int referenceSize) {
        e e2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(t.a(e2, referenceSize, streamType2));
    }

    @CalledByNative
    public void ackRPSRecvFrameIndex(VideoProducerDef.StreamType streamType, int ackedFrameId, int bitmap) {
        e e2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(u.a(e2, streamType2, ackedFrameId, bitmap));
    }

    @CalledByNative
    public void requestKeyFrame(VideoProducerDef.StreamType streamType) {
        e e2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        e2.a(v.a(e2, streamType2));
    }

    @CalledByNative
    public void setRenderMirrorMode(GLConstants.MirrorMode mirrorMode) {
        e e2 = this.mProducer;
        GLConstants.MirrorMode mirrorMode2 = mirrorMode;
        e2.a(w.a(e2, mirrorMode2));
    }

    @CalledByNative
    public void setRenderScaleType(GLConstants.GLScaleType scaleType) {
        e e2 = this.mProducer;
        GLConstants.GLScaleType gLScaleType = scaleType;
        e2.a(x.a(e2, gLScaleType));
    }

    @CalledByNative
    public void setRenderRotation(Rotation rotation) {
        e e2 = this.mProducer;
        Rotation rotation2 = rotation;
        e2.a(y.a(e2, rotation2));
    }

    @CalledByNative
    public void takeSnapshot(SnapshotSourceType sourceType, TakeSnapshotListener listener) {
        e e2 = this.mProducer;
        TakeSnapshotListener takeSnapshotListener = listener;
        SnapshotSourceType snapshotSourceType = sourceType;
        e2.a(z.a(e2, snapshotSourceType, takeSnapshotListener));
    }

    @CalledByNative
    public void startCustomCapture() {
        e e2 = this.mProducer;
        e2.a(aa.a(e2));
    }

    @CalledByNative
    public void appendCustomCaptureFrame(PixelFrame frame) {
        PixelFrame pixelFrame = frame;
        e e2 = this.mProducer;
        if (pixelFrame == null || !pixelFrame.isFrameDataValid()) {
            LiteavLog.w(e2.a, "appendCustomCaptureFrame: frame is not valid.");
            return;
        }
        pixelFrame.getProducerChainTimestamp().setCaptureTimestamp(TimeUtil.a());
        pixelFrame.retain();
        e e3 = e2;
        if (!e3.a(ac.a(e3, pixelFrame))) {
            pixelFrame.release();
        }
    }

    @CalledByNative
    public void stopCustomCapture() {
        e e2 = this.mProducer;
        e2.a(ad.a(e2));
    }

    @CalledByNative
    public void setCustomRenderListener(GLConstants.PixelFormatType pixelFormat, GLConstants.PixelBufferType bufferType, VideoRenderListener listener) {
        e e2 = this.mProducer;
        VideoRenderListener videoRenderListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = pixelFormat;
        e2.a(ae.a(e2, pixelFormatType, pixelBufferType, videoRenderListener));
    }

    @CalledByNative
    public void setWatermark(Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        e e2 = this.mProducer;
        Bitmap bitmap = watermark;
        e2.a(af.a(e2, bitmap, xOffsetRatio, yOffsetRatio, widthRatio));
    }

    @CalledByNative
    public void setCustomVideoProcessListener(GLConstants.PixelFormatType pixelFormat, GLConstants.PixelBufferType bufferType, CustomVideoProcessListener listener) {
        e e2 = this.mProducer;
        CustomVideoProcessListener customVideoProcessListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = pixelFormat;
        e2.a(ag.a(e2, pixelFormatType, pixelBufferType, customVideoProcessListener));
    }
}

