/*
 * Decompiled with CFR 0.152.
 */
package com.liteav.audio2.route;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import androidx.annotation.RequiresApi;
import com.liteav.audio2.route.a;
import com.liteav.audio2.route.b;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.util.List;

@JNINamespace(value="liteav::audio")
public class AudioDeviceProperty
implements a.a {
    private static final String TAG = "AudioDeviceProperty";
    private static final int RECORDING_CONFIGS_LIMIT = 10;
    private a mAudioEventBroadcastReceiver;
    private b mBluetoothHeadsetListener;
    private long mNativeAudioDeviceProperty;
    private final AudioManager mAudioManager;
    private final Context mContext;
    private AudioManager.AudioRecordingCallback mAudioRecordingCallback;

    @CalledByNative
    public AudioDeviceProperty(long nativeAudioDeviceProperty) {
        this.mNativeAudioDeviceProperty = nativeAudioDeviceProperty;
        this.mContext = ContextUtils.getApplicationContext();
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    @CalledByNative
    public void start() {
        a a2 = this.mAudioEventBroadcastReceiver = new a(this.mContext, this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        a2.a.registerReceiver((BroadcastReceiver)a2, intentFilter);
        this.mBluetoothHeadsetListener = new b(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void stop() {
        Object object;
        if (this.mAudioEventBroadcastReceiver != null) {
            object = this.mAudioEventBroadcastReceiver;
            if (((a)((Object)object)).a != null) {
                try {
                    ((a)((Object)object)).a.unregisterReceiver((BroadcastReceiver)object);
                }
                catch (Exception exception) {}
            }
        }
        this.mAudioEventBroadcastReceiver = null;
        if (this.mBluetoothHeadsetListener != null) {
            object = this.mBluetoothHeadsetListener;
            Object object2 = ((b)object).c;
            synchronized (object2) {
                if (((b)object).a != null && ((b)object).b != null) {
                    ((b)object).b();
                    ((b)object).b = null;
                }
            }
        }
        this.mBluetoothHeadsetListener = null;
    }

    @CalledByNative
    public void setVoip(boolean isVoip) {
        try {
            int n2 = isVoip ? 3 : 0;
            this.mAudioManager.setMode(n2);
            Log.i(TAG, "setMode ".concat(String.valueOf(n2)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "Set mode exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    @CalledByNative
    public int getMode() {
        try {
            return this.mAudioManager.getMode();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "Get mode exception " + throwable.getMessage(), new Object[0]);
            return 0;
        }
    }

    @CalledByNative
    public boolean isSpeakerphoneOn() {
        try {
            return this.mAudioManager.isSpeakerphoneOn();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "isSpeakerphoneOn exception " + throwable.getMessage(), new Object[0]);
            return false;
        }
    }

    @CalledByNative
    public void setSpeakerphoneOn(boolean on) {
        try {
            this.mAudioManager.setSpeakerphoneOn(on);
            Log.i(TAG, "setSpeakerphoneOn ".concat(String.valueOf(on)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "setSpeakerphoneOn exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    @CalledByNative
    public boolean isWiredHeadsetOn() {
        try {
            return this.mAudioManager.isWiredHeadsetOn();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "isWiredHeadsetOn exception " + throwable.getMessage(), new Object[0]);
            return false;
        }
    }

    @CalledByNative
    public void setWiredHeadsetOn(boolean on) {
        try {
            this.mAudioManager.setWiredHeadsetOn(on);
            Log.i(TAG, "setWiredHeadsetOn ".concat(String.valueOf(on)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "setWiredHeadsetOn exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    @CalledByNative
    public void setBluetoothScoOn(boolean on) {
        try {
            this.mAudioManager.setBluetoothScoOn(on);
            Log.i(TAG, "setBluetoothScoOn ".concat(String.valueOf(on)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "setBluetoothScoOn exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    @CalledByNative
    public boolean isBluetoothScoOn() {
        try {
            return this.mAudioManager.isBluetoothScoOn();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "isBluetoothScoOn exception " + throwable.getMessage(), new Object[0]);
            return false;
        }
    }

    @CalledByNative
    public void startBluetoothSco() {
        try {
            this.mAudioManager.startBluetoothSco();
            Log.i(TAG, "startBluetoothSco", new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "startBluetoothSco exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    @CalledByNative
    public void stopBluetoothSco() {
        try {
            this.mAudioManager.stopBluetoothSco();
            Log.i(TAG, "stopBluetoothSco", new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "stopBluetoothSco exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    @CalledByNative
    public boolean isBluetoothHeadsetConnected() {
        if (this.mBluetoothHeadsetListener == null) {
            Log.e(TAG, "mBluetoothHeadsetListener is null", new Object[0]);
            return false;
        }
        return this.mBluetoothHeadsetListener.a();
    }

    @Override
    public void onWiredHeadsetConnectionChanged(boolean connected) {
        AudioDeviceProperty.nativeNotifyWiredHeadsetConnectionChangedFromJava(this.mNativeAudioDeviceProperty, connected);
    }

    @Override
    public void onBluetoothConnectionChanged(boolean connected) {
        AudioDeviceProperty.nativeNotifyBluetoothConnectionChangedFromJava(this.mNativeAudioDeviceProperty, connected);
    }

    @CalledByNative
    @SuppressLint(value={"NewApi"})
    public void registerAudioRecordingCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (this.mAudioRecordingCallback == null) {
            this.buildAudioRecordingCallback();
        }
        this.mAudioManager.registerAudioRecordingCallback(this.mAudioRecordingCallback, null);
    }

    @CalledByNative
    @SuppressLint(value={"NewApi"})
    public void unregisterAudioRecordingCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (this.mAudioRecordingCallback == null) {
            return;
        }
        this.mAudioManager.unregisterAudioRecordingCallback(this.mAudioRecordingCallback);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=24)
    private void buildAudioRecordingCallback() {
        if (this.mAudioRecordingCallback != null) {
            return;
        }
        this.mAudioRecordingCallback = new AudioManager.AudioRecordingCallback(){

            public final void onRecordingConfigChanged(List<AudioRecordingConfiguration> configList) {
                int n2 = Math.min(configList.size(), 10);
                RecordingConfig[] recordingConfigArray = new RecordingConfig[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    recordingConfigArray[i2] = new RecordingConfig();
                    AudioRecordingConfiguration audioRecordingConfiguration = configList.get(i2);
                    recordingConfigArray[i2].a = audioRecordingConfiguration.getClientAudioSessionId();
                    recordingConfigArray[i2].b = LiteavSystemInfo.getSystemOSVersionInt() >= 29 ? audioRecordingConfiguration.isClientSilenced() : false;
                }
                AudioDeviceProperty.nativeNotifyAudioRecordingConfigChangedFromJava(AudioDeviceProperty.this.mNativeAudioDeviceProperty, recordingConfigArray);
            }
        };
    }

    @Override
    public void onBluetoothScoConnected(boolean connected) {
        AudioDeviceProperty.nativeNotifyBluetoothScoConnectedFromJava(this.mNativeAudioDeviceProperty, connected);
    }

    private static native void nativeNotifyWiredHeadsetConnectionChangedFromJava(long var0, boolean var2);

    private static native void nativeNotifyBluetoothConnectionChangedFromJava(long var0, boolean var2);

    private static native void nativeNotifyBluetoothScoConnectedFromJava(long var0, boolean var2);

    private static native void nativeNotifyAudioRecordingConfigChangedFromJava(long var0, RecordingConfig[] var2);

    static class RecordingConfig {
        int a;
        boolean b;

        @CalledByNative(value="RecordingConfig")
        public int getSessionId() {
            return this.a;
        }

        @CalledByNative(value="RecordingConfig")
        public boolean isSilenced() {
            return this.b;
        }
    }
}

