/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.j;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.beauty.TXBeautyManagerImpl;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.device.TXDeviceManagerImpl;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePusher;
import com.tencent.live2.V2TXLivePusherObserver;
import com.tencent.live2.impl.a.b;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGLContext;
import org.json.JSONArray;
import org.json.JSONObject;

@JNINamespace(value="liteav")
public class V2TXLivePusherJni
extends V2TXLivePusher {
    private static final String TAG = "V2TXLivePusherJni";
    private long mNativeV2TXLivePusherJni;
    private V2TXLivePusherObserver mObserver;
    private TXAudioEffectManager mAudioEffectManager;
    private TXBeautyManager mBeautyManager;
    private TXDeviceManager mDeviceManager;

    public V2TXLivePusherJni(Context context, int mode) {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mNativeV2TXLivePusherJni = V2TXLivePusherJni.nativeCreate(new WeakReference<V2TXLivePusherJni>(this), mode);
        this.mAudioEffectManager = new TXAudioEffectManagerImpl(V2TXLivePusherJni.nativeCreateAudioEffectManager(this.mNativeV2TXLivePusherJni));
        this.mBeautyManager = new TXBeautyManagerImpl(V2TXLivePusherJni.nativeCreateBeautyManager(this.mNativeV2TXLivePusherJni));
        this.mDeviceManager = new TXDeviceManagerImpl(V2TXLivePusherJni.nativeCreateDeviceManager(this.mNativeV2TXLivePusherJni));
        if (context instanceof Activity) {
            j.a().a((Activity)context);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public void release() {
        if (this.mNativeV2TXLivePusherJni != 0L) {
            V2TXLivePusherJni.nativeDestroy(this.mNativeV2TXLivePusherJni);
            this.mNativeV2TXLivePusherJni = 0L;
        }
    }

    @Override
    public void setObserver(V2TXLivePusherObserver observer) {
        this.mObserver = observer;
        if (observer != null && observer instanceof b) {
            V2TXLivePusherJni.nativeEnableExtensionCallback(this.mNativeV2TXLivePusherJni, true);
        }
    }

    @Override
    public int setRenderView(TXCloudVideoView view) {
        return V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(view));
    }

    @Override
    public int setRenderView(TextureView view) {
        return V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(view));
    }

    @Override
    public int setRenderView(SurfaceView view) {
        return V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(view));
    }

    @Override
    public int setRenderMirror(V2TXLiveDef.V2TXLiveMirrorType mirrorType) {
        return V2TXLivePusherJni.nativeSetRenderMirror(this.mNativeV2TXLivePusherJni, mirrorType.ordinal());
    }

    @Override
    public int setEncoderMirror(boolean mirror) {
        return V2TXLivePusherJni.nativeSetEncoderMirror(this.mNativeV2TXLivePusherJni, mirror);
    }

    @Override
    public int setRenderRotation(V2TXLiveDef.V2TXLiveRotation liveRotation) {
        Rotation rotation;
        switch (liveRotation) {
            case V2TXLiveRotation90: {
                rotation = Rotation.b;
                break;
            }
            case V2TXLiveRotation180: {
                rotation = Rotation.c;
                break;
            }
            case V2TXLiveRotation270: {
                rotation = Rotation.d;
                break;
            }
            default: {
                rotation = Rotation.a;
            }
        }
        return V2TXLivePusherJni.nativeSetRenderRotation(this.mNativeV2TXLivePusherJni, rotation.mValue);
    }

    @Override
    public int startCamera(boolean frontCamera) {
        return V2TXLivePusherJni.nativeStartCamera(this.mNativeV2TXLivePusherJni, frontCamera);
    }

    @Override
    public int stopCamera() {
        return V2TXLivePusherJni.nativeStopCamera(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startMicrophone() {
        return V2TXLivePusherJni.nativeStartMicrophone(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int stopMicrophone() {
        return V2TXLivePusherJni.nativeStopMicrophone(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startVirtualCamera(Bitmap image) {
        return V2TXLivePusherJni.nativeStartVirtualCamera(this.mNativeV2TXLivePusherJni, image);
    }

    @Override
    public int stopVirtualCamera() {
        return V2TXLivePusherJni.nativeStopVirtualCamera(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startScreenCapture() {
        return V2TXLivePusherJni.nativeStartScreenCapture(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int stopScreenCapture() {
        return V2TXLivePusherJni.nativeStopScreenCapture(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int pauseAudio() {
        return V2TXLivePusherJni.nativePauseAudio(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int resumeAudio() {
        return V2TXLivePusherJni.nativeResumeAudio(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int pauseVideo() {
        return V2TXLivePusherJni.nativePauseVideo(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int resumeVideo() {
        return V2TXLivePusherJni.nativeResumeVideo(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startPush(String url) {
        return V2TXLivePusherJni.nativeStartPush(this.mNativeV2TXLivePusherJni, url);
    }

    @Override
    public int stopPush() {
        return V2TXLivePusherJni.nativeStopPush(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int isPushing() {
        return V2TXLivePusherJni.nativeIsPushing(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int setAudioQuality(V2TXLiveDef.V2TXLiveAudioQuality quality) {
        return V2TXLivePusherJni.nativeSetAudioQuality(this.mNativeV2TXLivePusherJni, quality.ordinal());
    }

    @Override
    public int setVideoQuality(V2TXLiveDef.V2TXLiveVideoEncoderParam param) {
        return V2TXLivePusherJni.nativeSetVideoQuality(this.mNativeV2TXLivePusherJni, param.videoResolution.ordinal(), param.videoResolutionMode.ordinal(), param.videoFps, param.videoBitrate, param.minVideoBitrate);
    }

    @Override
    public TXAudioEffectManager getAudioEffectManager() {
        return this.mAudioEffectManager;
    }

    @Override
    public TXBeautyManager getBeautyManager() {
        return this.mBeautyManager;
    }

    @Override
    public TXDeviceManager getDeviceManager() {
        return this.mDeviceManager;
    }

    @Override
    public int snapshot() {
        return V2TXLivePusherJni.nativeSnapshot(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int setWatermark(Bitmap image, float x2, float y2, float scale) {
        return V2TXLivePusherJni.nativeSetWatermark(this.mNativeV2TXLivePusherJni, image, x2, y2, scale);
    }

    @Override
    public int enableVolumeEvaluation(int intervalMs) {
        return V2TXLivePusherJni.nativeEnableVolumeEvaluation(this.mNativeV2TXLivePusherJni, intervalMs);
    }

    @Override
    public int enableCustomVideoProcess(boolean enable, V2TXLiveDef.V2TXLivePixelFormat pixelFormat, V2TXLiveDef.V2TXLiveBufferType bufferType) {
        return V2TXLivePusherJni.nativeEnableCustomVideoProcess(this.mNativeV2TXLivePusherJni, enable, pixelFormat.ordinal(), bufferType.ordinal());
    }

    @Override
    public int enableCustomVideoCapture(boolean enable) {
        return V2TXLivePusherJni.nativeEnableCustomVideoCapture(this.mNativeV2TXLivePusherJni, enable);
    }

    @Override
    public int sendCustomVideoFrame(V2TXLiveDef.V2TXLiveVideoFrame videoFrame) {
        GLConstants.PixelBufferType pixelBufferType;
        GLConstants.PixelFormatType pixelFormatType;
        int n2 = -1;
        Object object = null;
        switch (videoFrame.pixelFormat) {
            case V2TXLivePixelFormatI420: {
                pixelFormatType = GLConstants.PixelFormatType.a;
                break;
            }
            case V2TXLivePixelFormatTexture2D: {
                pixelFormatType = GLConstants.PixelFormatType.f;
                break;
            }
            default: {
                return -1;
            }
        }
        switch (videoFrame.bufferType) {
            case V2TXLiveBufferTypeTexture: {
                pixelBufferType = GLConstants.PixelBufferType.b;
                if (videoFrame.texture != null) {
                    n2 = videoFrame.texture.textureId;
                    object = V2TXLivePusherJni.getEglContextFromLiveVideoFrame(videoFrame);
                    break;
                }
                return -1;
            }
            case V2TXLiveBufferTypeByteArray: {
                pixelBufferType = GLConstants.PixelBufferType.d;
                break;
            }
            case V2TXLiveBufferTypeByteBuffer: {
                pixelBufferType = GLConstants.PixelBufferType.a;
                break;
            }
            default: {
                return -1;
            }
        }
        return V2TXLivePusherJni.nativeSendCustomVideoFrame(this.mNativeV2TXLivePusherJni, videoFrame.width, videoFrame.height, pixelBufferType.mValue, pixelFormatType.getValue(), videoFrame.rotation, n2, object, videoFrame.data, videoFrame.buffer);
    }

    @Override
    public int enableCustomAudioCapture(boolean enable) {
        return V2TXLivePusherJni.nativeEnableCustomAudioCapture(this.mNativeV2TXLivePusherJni, enable);
    }

    @Override
    public int sendCustomAudioFrame(V2TXLiveDef.V2TXLiveAudioFrame audioFrame) {
        return V2TXLivePusherJni.nativeSendCustomAudioFrame(this.mNativeV2TXLivePusherJni, audioFrame.data, audioFrame.sampleRate, audioFrame.channel, audioFrame.timestamp);
    }

    @Override
    public int enableAudioProcessObserver(boolean enable, V2TXLiveDef.V2TXLiveAudioFrameObserverFormat format) {
        return V2TXLivePusherJni.nativeEnableAudioProcessObserver(this.mNativeV2TXLivePusherJni, enable, format.sampleRate, format.channel, format.samplesPerCall, format.mode.ordinal());
    }

    @Override
    public int sendSeiMessage(int payloadType, byte[] data) {
        return V2TXLivePusherJni.nativeSendSeiMessage(this.mNativeV2TXLivePusherJni, payloadType, data);
    }

    @Override
    public void showDebugView(boolean isShow) {
        V2TXLivePusherJni.nativeShowDebugView(this.mNativeV2TXLivePusherJni, isShow);
    }

    @Override
    public int setProperty(String key, Object value) {
        String string = key;
        int n2 = -1;
        switch (string.hashCode()) {
            case 1120433643: {
                if (!string.equals("setSurface")) break;
                n2 = 0;
                break;
            }
            case 480042124: {
                if (!string.equals("setSurfaceSize")) break;
                n2 = 1;
                break;
            }
            case -631683741: {
                if (!string.equals("enableANS")) break;
                n2 = 2;
                break;
            }
            case -631683974: {
                if (!string.equals("enableAGC")) break;
                n2 = 3;
                break;
            }
            case 2085561276: {
                if (!string.equals("setFramework")) break;
                n2 = 4;
                break;
            }
            case 1309735633: {
                if (!string.equals("enableRealtimeMode")) break;
                n2 = 5;
                break;
            }
            case 2048424571: {
                if (!string.equals("enableCameraZoom")) break;
                n2 = 6;
                break;
            }
            case -2131574212: {
                if (!string.equals("setAudioCodecType")) break;
                n2 = 7;
                break;
            }
            case -2119647997: {
                if (!string.equals("enableHevcEncode")) break;
                n2 = 8;
                break;
            }
            case 1538362833: {
                if (!string.equals("setMetaData")) break;
                n2 = 9;
                break;
            }
            case 2132058329: {
                if (!string.equals("setVideoQualityEx")) break;
                n2 = 10;
            }
        }
        switch (n2) {
            case 0: {
                if (value == null) {
                    V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, null);
                    break;
                }
                if (value instanceof Surface) {
                    Surface surface = (Surface)value;
                    V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(surface));
                    break;
                }
                LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                return -2;
            }
            case 1: {
                LiteavLog.i(TAG, "set surface size is unnecessary");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return V2TXLivePusherJni.nativeSetProperty(this.mNativeV2TXLivePusherJni, key, value);
            }
            default: {
                LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                return -2;
            }
        }
        return 0;
    }

    @Override
    public int setMixTranscodingConfig(V2TXLiveDef.V2TXLiveTranscodingConfig config) {
        String string = "";
        if (config != null) {
            JSONObject jSONObject = null;
            try {
                jSONObject = new JSONObject();
                jSONObject.put("videoWidth", config.videoWidth);
                jSONObject.put("videoHeight", config.videoHeight);
                jSONObject.put("videoBitrate", config.videoBitrate);
                jSONObject.put("videoFramerate", config.videoFramerate);
                jSONObject.put("videoGOP", config.videoGOP);
                jSONObject.put("backgroundColor", config.backgroundColor);
                jSONObject.put("backgroundImage", (Object)(TextUtils.isEmpty((CharSequence)config.backgroundImage) ? "" : config.backgroundImage));
                jSONObject.put("audioSampleRate", config.audioSampleRate);
                jSONObject.put("audioBitrate", config.audioBitrate);
                jSONObject.put("audioChannels", config.audioChannels);
                jSONObject.put("outputStreamId", (Object)(TextUtils.isEmpty((CharSequence)config.outputStreamId) ? "" : config.outputStreamId));
                JSONArray jSONArray = new JSONArray();
                ArrayList<V2TXLiveDef.V2TXLiveMixStream> arrayList = config.mixStreams;
                if (arrayList != null) {
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        V2TXLiveDef.V2TXLiveMixStream v2TXLiveMixStream = (V2TXLiveDef.V2TXLiveMixStream)arrayList.get(i2);
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put("userId", (Object)(TextUtils.isEmpty((CharSequence)v2TXLiveMixStream.userId) ? "" : v2TXLiveMixStream.userId));
                        jSONObject2.put("streamId", (Object)(TextUtils.isEmpty((CharSequence)v2TXLiveMixStream.streamId) ? "" : v2TXLiveMixStream.streamId));
                        jSONObject2.put("x", v2TXLiveMixStream.x);
                        jSONObject2.put("y", v2TXLiveMixStream.y);
                        jSONObject2.put("width", v2TXLiveMixStream.width);
                        jSONObject2.put("height", v2TXLiveMixStream.height);
                        jSONObject2.put("zOrder", v2TXLiveMixStream.zOrder);
                        jSONObject2.put("inputType", v2TXLiveMixStream.inputType.ordinal());
                        jSONArray.put((Object)jSONObject2);
                    }
                }
                jSONObject.put("mixStreamList", (Object)jSONArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (jSONObject != null) {
                string = jSONObject.toString();
            }
        }
        return V2TXLivePusherJni.nativeSetMixTranscodingConfig(this.mNativeV2TXLivePusherJni, string);
    }

    @Override
    public int startSystemAudioLoopback() {
        return V2TXLivePusherJni.nativeStartSystemAudioLoopback(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int stopSystemAudioLoopback() {
        return V2TXLivePusherJni.nativeStopSystemAudioLoopback(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startLocalRecording(V2TXLiveDef.V2TXLiveLocalRecordingParams params) {
        return V2TXLivePusherJni.nativeStartRecord(this.mNativeV2TXLivePusherJni, params.filePath, params.recordMode.ordinal(), params.interval);
    }

    @Override
    public void stopLocalRecording() {
        V2TXLivePusherJni.nativeStopRecord(this.mNativeV2TXLivePusherJni);
    }

    @CalledByNative
    public void onError(int code, String msg, Bundle extraInfo) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onError(code, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onWarning(int code, String msg, Bundle extraInfo) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onWarning(code, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onProcessAudioFrame(byte[] data, long timestamp, int sampleRate, int channels) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver == null) {
            return;
        }
        V2TXLiveDef.V2TXLiveAudioFrame v2TXLiveAudioFrame = new V2TXLiveDef.V2TXLiveAudioFrame();
        new V2TXLiveDef.V2TXLiveAudioFrame().data = data;
        v2TXLiveAudioFrame.sampleRate = sampleRate;
        v2TXLiveAudioFrame.channel = channels;
        v2TXLiveAudioFrame.timestamp = timestamp;
        v2TXLivePusherObserver.onProcessAudioFrame(v2TXLiveAudioFrame);
    }

    @CalledByNative
    public void onCaptureFirstAudioFrame() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onCaptureFirstAudioFrame();
        }
    }

    @CalledByNative
    public void onCaptureFirstVideoFrame() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onCaptureFirstVideoFrame();
        }
    }

    @CalledByNative
    public void onMicrophoneVolumeUpdate(int volume) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onMicrophoneVolumeUpdate(volume);
        }
    }

    @CalledByNative
    public void onPushStatusUpdate(int statusCode, String msg, Bundle extraInfo) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        V2TXLiveDef.V2TXLivePushStatus v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusDisconnected;
        switch (statusCode) {
            case 0: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusConnecting;
                msg = "connecting to the server.";
                break;
            }
            case 1: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusConnectSuccess;
                msg = "connected to the server successfully.";
                break;
            }
            case 2: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusReconnecting;
                msg = "reconnecting to the server.";
                break;
            }
            case 3: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusDisconnected;
                msg = "disconnected from the server.";
            }
        }
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onPushStatusUpdate(v2TXLivePushStatus, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onStatisticsUpdate(int appCpu, int systemCpu, int width, int height, int fps, int videoBitrate, int audioBitrate, int rtt) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            V2TXLiveDef.V2TXLivePusherStatistics v2TXLivePusherStatistics = new V2TXLiveDef.V2TXLivePusherStatistics();
            new V2TXLiveDef.V2TXLivePusherStatistics().appCpu = appCpu;
            v2TXLivePusherStatistics.systemCpu = systemCpu;
            v2TXLivePusherStatistics.width = width;
            v2TXLivePusherStatistics.height = height;
            v2TXLivePusherStatistics.fps = fps;
            v2TXLivePusherStatistics.videoBitrate = videoBitrate;
            v2TXLivePusherStatistics.audioBitrate = audioBitrate;
            v2TXLivePusherStatistics.rtt = rtt;
            v2TXLivePusherObserver.onStatisticsUpdate(v2TXLivePusherStatistics);
        }
    }

    @CalledByNative
    public void onSnapshotComplete(Bitmap image) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onSnapshotComplete(image);
        }
    }

    @CalledByNative
    public void onGLContextCreated() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onGLContextCreated();
        }
    }

    @CalledByNative
    public int onCustomPreprocessFrame(V2TXLiveDef.V2TXLiveVideoFrame srcFrame, V2TXLiveDef.V2TXLiveVideoFrame dstFrame) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            return v2TXLivePusherObserver.onProcessVideoFrame(srcFrame, dstFrame);
        }
        return -1;
    }

    @CalledByNative
    public V2TXLiveDef.V2TXLiveVideoFrame createV2TXLiveVideoFrame(int width, int height, int bufferType, int pixelFormat, int rotation, int textureId, Object glContext, byte[] data, ByteBuffer buffer) {
        V2TXLiveDef.V2TXLiveVideoFrame v2TXLiveVideoFrame = new V2TXLiveDef.V2TXLiveVideoFrame();
        switch (GLConstants.PixelFormatType.a(pixelFormat)) {
            case a: {
                v2TXLiveVideoFrame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420;
                break;
            }
            case f: {
                v2TXLiveVideoFrame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D;
                break;
            }
            default: {
                return null;
            }
        }
        switch (GLConstants.PixelBufferType.a(bufferType)) {
            case b: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture;
                v2TXLiveVideoFrame.texture = new V2TXLiveDef.V2TXLiveTexture();
                v2TXLiveVideoFrame.texture.textureId = textureId;
                if (glContext instanceof EGLContext) {
                    v2TXLiveVideoFrame.texture.eglContext10 = (EGLContext)glContext;
                    break;
                }
                if (Build.VERSION.SDK_INT < 17 || !(glContext instanceof android.opengl.EGLContext)) break;
                v2TXLiveVideoFrame.texture.eglContext14 = (android.opengl.EGLContext)glContext;
                break;
            }
            case d: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray;
                v2TXLiveVideoFrame.data = data;
                break;
            }
            case a: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer;
                v2TXLiveVideoFrame.buffer = buffer;
                break;
            }
            default: {
                return null;
            }
        }
        v2TXLiveVideoFrame.width = width;
        v2TXLiveVideoFrame.height = height;
        v2TXLiveVideoFrame.rotation = rotation;
        return v2TXLiveVideoFrame;
    }

    @CalledByNative
    public int getFrameWidth(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        return frame.width;
    }

    @CalledByNative
    public int getFrameHeight(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        return frame.height;
    }

    @CalledByNative
    public int getFramePixelFormat(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        GLConstants.PixelFormatType pixelFormatType = GLConstants.PixelFormatType.a;
        switch (frame.pixelFormat) {
            case V2TXLivePixelFormatI420: {
                pixelFormatType = GLConstants.PixelFormatType.a;
                break;
            }
            case V2TXLivePixelFormatTexture2D: {
                pixelFormatType = GLConstants.PixelFormatType.f;
            }
        }
        return pixelFormatType.getValue();
    }

    @CalledByNative
    public int getFrameBufferType(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        GLConstants.PixelBufferType pixelBufferType = GLConstants.PixelBufferType.a;
        switch (frame.bufferType) {
            case V2TXLiveBufferTypeTexture: {
                pixelBufferType = GLConstants.PixelBufferType.b;
                break;
            }
            case V2TXLiveBufferTypeByteArray: {
                pixelBufferType = GLConstants.PixelBufferType.d;
                break;
            }
            case V2TXLiveBufferTypeByteBuffer: {
                pixelBufferType = GLConstants.PixelBufferType.a;
            }
        }
        return pixelBufferType.mValue;
    }

    @CalledByNative
    public int getFrameRotation(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        return frame.rotation;
    }

    @CalledByNative
    public byte[] getFrameByteArray(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        return frame.data;
    }

    @CalledByNative
    public ByteBuffer getFrameByteBuffer(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        return frame.buffer;
    }

    @CalledByNative
    public int getFrameTextureId(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        if (frame == null || frame.texture == null) {
            return -1;
        }
        return frame.texture.textureId;
    }

    @CalledByNative
    public Object getFrameEglContext(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        EGLContext eGLContext = null;
        if (frame == null || frame.texture == null) {
            return null;
        }
        if (frame.texture.eglContext10 != null) {
            eGLContext = frame.texture.eglContext10;
        }
        if (frame.texture.eglContext14 != null) {
            eGLContext = frame.texture.eglContext14;
        }
        return eGLContext;
    }

    @CalledByNative
    public void onGLContextDestroyed() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onGLContextDestroyed();
        }
    }

    @CalledByNative
    public void onSetMixTranscodingConfig(int code, String msg) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onSetMixTranscodingConfig(code, msg);
        }
    }

    @CalledByNative
    public static V2TXLivePusherJni weakToStrongReference(WeakReference<V2TXLivePusherJni> weakReference) {
        return (V2TXLivePusherJni)weakReference.get();
    }

    private static native long nativeCreate(WeakReference<V2TXLivePusherJni> var0, int var1);

    private static native void nativeDestroy(long var0);

    private static native void nativeEnableExtensionCallback(long var0, boolean var2);

    private static native int nativeSetRenderView(long var0, DisplayTarget var2);

    private static native int nativeSetRenderMirror(long var0, int var2);

    private static native int nativeSetEncoderMirror(long var0, boolean var2);

    private static native int nativeSetRenderRotation(long var0, int var2);

    private static native int nativeStartCamera(long var0, boolean var2);

    private static native int nativeStopCamera(long var0);

    private static native int nativeStartMicrophone(long var0);

    private static native int nativeStopMicrophone(long var0);

    private static native int nativeStartVirtualCamera(long var0, Bitmap var2);

    private static native int nativeStopVirtualCamera(long var0);

    private static native int nativeStartScreenCapture(long var0);

    private static native int nativeStopScreenCapture(long var0);

    private static native int nativePauseAudio(long var0);

    private static native int nativeResumeAudio(long var0);

    private static native int nativePauseVideo(long var0);

    private static native int nativeResumeVideo(long var0);

    private static native int nativeStartPush(long var0, String var2);

    private static native int nativeStopPush(long var0);

    private static native int nativeIsPushing(long var0);

    private static native int nativeSetAudioQuality(long var0, int var2);

    private static native int nativeSetVideoQuality(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native long nativeCreateAudioEffectManager(long var0);

    private static native long nativeCreateBeautyManager(long var0);

    private static native long nativeCreateDeviceManager(long var0);

    private static native int nativeSnapshot(long var0);

    private static native int nativeSetWatermark(long var0, Bitmap var2, float var3, float var4, float var5);

    private static native int nativeEnableVolumeEvaluation(long var0, int var2);

    private static native int nativeEnableCustomVideoProcess(long var0, boolean var2, int var3, int var4);

    private static native int nativeEnableCustomVideoCapture(long var0, boolean var2);

    private static native int nativeSendCustomVideoFrame(long var0, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, byte[] var9, ByteBuffer var10);

    private static native int nativeEnableCustomAudioCapture(long var0, boolean var2);

    private static native int nativeSendCustomAudioFrame(long var0, byte[] var2, int var3, int var4, long var5);

    private static native int nativeEnableAudioProcessObserver(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native int nativeSendSeiMessage(long var0, int var2, byte[] var3);

    private static native void nativeShowDebugView(long var0, boolean var2);

    private static native int nativeSetMixTranscodingConfig(long var0, String var2);

    private static native int nativeSetProperty(long var0, String var2, Object var3);

    private static native int nativeStartSystemAudioLoopback(long var0);

    private static native int nativeStopSystemAudioLoopback(long var0);

    private static native int nativeStartRecord(long var0, String var2, int var3, int var4);

    private static native void nativeStopRecord(long var0);

    private static Object getEglContextFromLiveVideoFrame(V2TXLiveDef.V2TXLiveVideoFrame videoFrame) {
        EGLContext eGLContext = null;
        if (videoFrame.texture.eglContext10 != null) {
            eGLContext = videoFrame.texture.eglContext10;
        }
        if (videoFrame.texture.eglContext14 != null) {
            eGLContext = videoFrame.texture.eglContext14;
        }
        if (eGLContext == null) {
            eGLContext = EGL14.eglGetCurrentContext();
        }
        return eGLContext;
    }

    @CalledByNative
    public void onPushEvent(int code, Bundle params) {
    }

    @CalledByNative
    public void onPushNetStatus(Bundle params) {
    }

    @CalledByNative
    public void onNetworkQuality(int quality) {
    }

    @CalledByNative
    public void onEnterRoom(int result, String msg) {
    }

    @CalledByNative
    public void onExitRoom(int reason, String msg) {
    }

    @CalledByNative
    public void onUserOnline(String userId) {
    }

    @CalledByNative
    public void onUserOffline(String userId) {
    }

    @CalledByNative
    public void onUserVideoAvailable(String userId, int streamType, boolean available) {
    }

    @CalledByNative
    public void onUserAudioAvailable(String userId, boolean available) {
    }

    @CalledByNative
    public void onScreenCaptureStarted() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onScreenCaptureStarted();
        }
    }

    @CalledByNative
    public void onScreenCaptureStoped(int reason) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onScreenCaptureStopped(reason);
        }
    }

    @CalledByNative
    public void onRecordBegin(int code, String storagePath) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onLocalRecordBegin(code, storagePath);
        }
    }

    @CalledByNative
    public void onRecordProgress(long durationMs, String storagePath) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onLocalRecording(durationMs, storagePath);
        }
    }

    @CalledByNative
    public void onRecordComplete(int code, String storagePath) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onLocalRecordComplete(code, storagePath);
        }
    }
}

