/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.utils;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.utils.e;
import com.tencent.liteav.videobase.utils.p;

@JNINamespace(value="liteav::video")
public class SurfaceTextureHolder
implements SurfaceTexture.OnFrameAvailableListener {
    private final String mTag = "SurfaceTextureHolder_" + Integer.toHexString(this.hashCode());
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private CustomHandler mCallbackHandler;
    @Nullable
    private SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener;
    @Nullable
    private Surface mSurface;

    @CalledByNative
    public SurfaceTextureHolder(int texName, boolean createSurface) {
        this.mSurfaceTexture = new SurfaceTexture(texName);
        if (createSurface) {
            this.mSurface = new Surface(this.mSurfaceTexture);
        }
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public void setOnFrameAvailableListener(@Nullable SurfaceTexture.OnFrameAvailableListener listener, @Nullable Handler callbackHandler) {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mTag, "setOnFrameAvailableListener, surface texture is released!");
            return;
        }
        Looper looper = callbackHandler != null ? callbackHandler.getLooper() : Looper.getMainLooper();
        this.mCallbackHandler = new CustomHandler(looper);
        this.mOnFrameAvailableListener = listener;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
            SurfaceTextureHolder surfaceTextureHolder = this;
            this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)surfaceTextureHolder, (Handler)surfaceTextureHolder.mCallbackHandler);
            return;
        }
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
    }

    @CalledByNative
    public Surface getSurface() {
        return this.mSurface;
    }

    @CalledByNative
    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    @CalledByNative
    public void updateTexImage() {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mTag, "updateTexImage, surface texture is released!");
            return;
        }
        this.mSurfaceTexture.updateTexImage();
    }

    @CalledByNative
    public void setDefaultBufferSize(int width, int height) {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mTag, "setDefaultBufferSize, surface texture is released!");
            return;
        }
        this.mSurfaceTexture.setDefaultBufferSize(width, height);
    }

    @CalledByNative
    public void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
    }

    @CalledByNative
    public float[] getTransformMatrix(boolean needCrop, float transX, float transY, float scaleX, float scaleY) {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mTag, "getTransformMatrix, surface texture is released!");
            return null;
        }
        float[] fArray = new float[16];
        this.mSurfaceTexture.getTransformMatrix(fArray);
        if (needCrop) {
            if (!e.a(transX, 0.0f) || !e.a(transY, 0.0f)) {
                Matrix.translateM((float[])fArray, (int)0, (float)transX, (float)transY, (float)0.0f);
            }
            if (!e.a(scaleX, 1.0f) || !e.a(scaleY, 1.0f)) {
                Matrix.scaleM((float[])fArray, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
            }
        }
        return fArray;
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        CustomHandler customHandler = this.mCallbackHandler;
        if (customHandler != null) {
            customHandler.runOrPost(p.a(this, surfaceTexture));
        }
    }

    static /* synthetic */ void lambda$onFrameAvailable$0(SurfaceTextureHolder this_, SurfaceTexture surfaceTexture) {
        SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener = this_.mOnFrameAvailableListener;
        if (onFrameAvailableListener != null) {
            onFrameAvailableListener.onFrameAvailable(surfaceTexture);
        }
    }
}

