/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.consumer;

import android.graphics.PointF;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videobase.utils.e;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videoconsumer.consumer.VideoConsumerServerConfig;
import com.tencent.liteav.videoconsumer.consumer.aa;
import com.tencent.liteav.videoconsumer.consumer.ac;
import com.tencent.liteav.videoconsumer.consumer.ad;
import com.tencent.liteav.videoconsumer.consumer.ae;
import com.tencent.liteav.videoconsumer.consumer.af;
import com.tencent.liteav.videoconsumer.consumer.j;
import com.tencent.liteav.videoconsumer.consumer.l;
import com.tencent.liteav.videoconsumer.consumer.m;
import com.tencent.liteav.videoconsumer.consumer.n;
import com.tencent.liteav.videoconsumer.consumer.o;
import com.tencent.liteav.videoconsumer.consumer.p;
import com.tencent.liteav.videoconsumer.consumer.q;
import com.tencent.liteav.videoconsumer.consumer.r;
import com.tencent.liteav.videoconsumer.consumer.s;
import com.tencent.liteav.videoconsumer.consumer.t;
import com.tencent.liteav.videoconsumer.consumer.u;
import com.tencent.liteav.videoconsumer.consumer.w;
import com.tencent.liteav.videoconsumer.consumer.x;
import com.tencent.liteav.videoconsumer.consumer.z;
import com.tencent.liteav.videoconsumer.decoder.SoftwareVideoDecoder;
import com.tencent.liteav.videoconsumer.decoder.VideoDecodeController;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.b;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import java.util.List;

@JNINamespace(value="liteav::video")
public class VideoConsumerProxy {
    private final j mConsumer;

    @CalledByNative
    public VideoConsumerProxy(@NonNull IVideoReporter reporter) {
        this.mConsumer = new j(reporter);
    }

    @CalledByNative
    public void setServerConfig(VideoConsumerServerConfig config) {
        j j2 = this.mConsumer;
        VideoConsumerServerConfig videoConsumerServerConfig = config;
        j2.a(z.a(j2, videoConsumerServerConfig), true);
    }

    @CalledByNative
    public void start() {
        j j2 = this.mConsumer;
        j2.a(aa.a(j2), false);
    }

    @CalledByNative
    public void stop(boolean isNeedClear) {
        this.mConsumer.a(isNeedClear);
    }

    @CalledByNative
    public void pause() {
        j j2 = this.mConsumer;
        j2.a(ac.a(j2), false);
    }

    @CalledByNative
    public void resume() {
        j j2 = this.mConsumer;
        j2.a(ad.a(j2), false);
    }

    @CalledByNative
    public int getWritableState() {
        VideoDecodeController videoDecodeController = this.mConsumer.g;
        int n2 = videoDecodeController.e();
        return (!videoDecodeController.s.get() ? (n2 > 0 ? VideoDecoderDef.a.e : VideoDecoderDef.a.d) : (n2 > 0 ? VideoDecoderDef.a.c : VideoDecoderDef.a.b)).mValue;
    }

    @CalledByNative
    public void appendNALPacket(EncodedVideoFrame packet) {
        EncodedVideoFrame encodedVideoFrame = packet;
        j j2 = this.mConsumer;
        if (encodedVideoFrame == null || encodedVideoFrame.data == null) {
            LiteavLog.w(j2.a, "packet or packet.data is null,packet={%s}", encodedVideoFrame);
            return;
        }
        encodedVideoFrame.consumerChainTimestamp.setDeliverTimestamp(TimeUtil.a());
        j j3 = j2;
        j3.a(ae.a(j3, encodedVideoFrame), false);
    }

    @CalledByNative
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
        j j2 = this.mConsumer;
        VideoDecoderDef.ConsumerScene consumerScene = scene;
        j2.a(af.a(j2, consumerScene), false);
    }

    @CalledByNative
    public void setRenderMirrorEnabled(boolean enabled) {
        j j2 = this.mConsumer;
        j2.a(l.a(j2, enabled), true);
    }

    @CalledByNative
    public void setRenderRotation(Rotation rotation) {
        j j2 = this.mConsumer;
        Rotation rotation2 = rotation;
        j2.a(m.a(j2, rotation2), true);
    }

    @CalledByNative
    public void setScaleType(GLConstants.GLScaleType scaleType) {
        j j2 = this.mConsumer;
        GLConstants.GLScaleType gLScaleType = scaleType;
        j2.a(n.a(j2, gLScaleType), true);
    }

    @CalledByNative
    public void setDecoderStrategy(VideoDecodeController.DecodeStrategy decodeStrategy) {
        j j2 = this.mConsumer;
        VideoDecodeController.DecodeStrategy decodeStrategy2 = decodeStrategy;
        j2.a(o.a(j2, decodeStrategy2), true);
    }

    @CalledByNative
    public void setDisplayTarget(DisplayTarget target) {
        j j2 = this.mConsumer;
        DisplayTarget displayTarget = target;
        j2.a(p.a(j2, displayTarget), true);
    }

    @CalledByNative
    public void takeSnapshot(SnapshotSourceType sourceType, TakeSnapshotListener listener) {
        j j2 = this.mConsumer;
        TakeSnapshotListener takeSnapshotListener = listener;
        SnapshotSourceType snapshotSourceType = sourceType;
        j2.a(q.a(j2, snapshotSourceType, takeSnapshotListener), false);
    }

    @CalledByNative
    public void setHWDecoderDeviceRelatedParams(String params) {
        String string = params;
        j j2 = this.mConsumer;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            j j3 = j2;
            j3.a(r.a(j3, string), true);
        }
    }

    @CalledByNative
    public void setCustomRenderListener(GLConstants.PixelFormatType formatType, GLConstants.PixelBufferType bufferType, VideoRenderListener listener) {
        j j2 = this.mConsumer;
        VideoRenderListener videoRenderListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = formatType;
        j2.a(s.a(j2, pixelFormatType, pixelBufferType, videoRenderListener), false);
    }

    @CalledByNative
    public void setSharedEGLContext(Object sharedContext) {
        Object object = sharedContext;
        j j2 = this.mConsumer;
        LiteavLog.i(j2.a, "setSharedEGLContext(object:" + object + ")");
        j j3 = j2;
        j3.a(t.a(j3, object), false);
    }

    @CalledByNative
    public void setPerspectiveCorrectionPoints(float[] srcPoints, float[] dstPoints) {
        j j2 = this.mConsumer;
        List<PointF> list = e.a(dstPoints);
        List<PointF> list2 = e.a(srcPoints);
        j2.a(x.a(j2, list2, list), false);
    }

    @CalledByNative
    public void initialize() {
        j j2 = this.mConsumer;
        LiteavLog.i(j2.a, "initialize videoConsumer");
        j j3 = j2;
        j3.a(u.a(j3), false);
    }

    @CalledByNative
    public void uninitialize() {
        j j2 = this.mConsumer;
        j2.a(false);
        j j3 = j2;
        j3.a(w.a(j3), false);
    }

    @CalledByNative
    public long getCurrentRenderTimeStamp() {
        return this.mConsumer.w.get();
    }

    @CalledByNative
    public static VideoDecoderDef.DecodeAbility getDecodeAbility() {
        b b2 = b.a.a();
        b.a.a().a.a = SoftwareVideoDecoder.nativeIsRpsDecodeSupport();
        return b2.a;
    }
}

