/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Looper;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.ak;
import com.tencent.liteav.videoproducer.encoder.bp;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import com.tencent.liteav.videoproducer2.HWEncoderServerConfig;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@JNINamespace(value="liteav::video")
public class HardwareVideoEncoder2 {
    private final String mTAG = "HardwareVideoEncoder2_" + this.hashCode();
    private static final int MAX_WAITE_TIME_MS = 2000;
    @NonNull
    private final Size mSurfaceSize = new Size(0, 0);
    private final AtomicBoolean mNeedRestart = new AtomicBoolean(false);
    private final VideoEncodeParams mParams;
    private final Bundle mSessionStates = new Bundle();
    private final b mThrottlers = new b();
    private HWEncoderServerConfig mServerConfig;
    private long mNativeHandler;
    private Surface mInputSurface;
    private EGLCore mEGLCore;
    private j mPixelFrameRenderer;
    private ak mSurfaceInputVideoEncoder;
    private long mPreFrameTimeStamp = 0L;
    private Object mSharedContext;
    private final bp.a mVideoEncoderListener = new bp.a(){

        @Override
        public final void a() {
            HardwareVideoEncoder2.this.mNeedRestart.set(true);
        }

        @Override
        public final void onEncodedFail(h.a code) {
            HardwareVideoEncoder2.this.notifyEncodeFail();
        }

        @Override
        public final synchronized void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
            if (HardwareVideoEncoder2.this.mNativeHandler != 0L && !isEos) {
                EncodedVideoFrame encodedVideoFrame = nal;
                HardwareVideoEncoder2.this.nativeOnEncodedNAL(HardwareVideoEncoder2.this.mNativeHandler, encodedVideoFrame, encodedVideoFrame.data, nal.nalType.mValue, nal.profileType.mValue, nal.codecType.mValue, nal.rotation, nal.dts, nal.pts, nal.gopIndex, nal.gopFrameIndex, nal.frameIndex, nal.refFrameIndex, nal.width, nal.height, nal.svcInfo != null, nal.svcInfo == null ? 0 : nal.svcInfo);
                return;
            }
            LiteavLog.d(HardwareVideoEncoder2.this.mTAG, "onEncodedNAL mNativeHandler=%d,isEos=%b", HardwareVideoEncoder2.this.mNativeHandler, isEos);
        }
    };

    @CalledByNative
    public HardwareVideoEncoder2(long nativeHandler, VideoEncodeParams params) {
        this.mNativeHandler = nativeHandler;
        this.mParams = params;
    }

    @CalledByNative
    public void setHWEncoderServerConfig(@NonNull HWEncoderServerConfig serverConfig) {
        this.mServerConfig = serverConfig;
        if (this.mSurfaceInputVideoEncoder != null) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            this.mSurfaceInputVideoEncoder.a(hardwareVideoEncoder2.getServerVideoProducerConfig(hardwareVideoEncoder2.mServerConfig));
        }
    }

    private ServerVideoProducerConfig getServerVideoProducerConfig(HWEncoderServerConfig hwEncoderServerConfig) {
        ServerVideoProducerConfig serverVideoProducerConfig = new ServerVideoProducerConfig();
        serverVideoProducerConfig.setHardwareEncodeType(hwEncoderServerConfig.getHardwareEncodeType());
        serverVideoProducerConfig.setHardwareEncoderHighProfileEnable(hwEncoderServerConfig.getHardwareEncoderHighProfileEnable());
        serverVideoProducerConfig.setHardwareEncoderHighProfileSupport(hwEncoderServerConfig.getHardwareEncoderHighProfileSupport());
        Boolean bl2 = hwEncoderServerConfig.isHardwareEncoderBitrateModeCBRSupported();
        if (bl2 != null) {
            serverVideoProducerConfig.setHardwareEncoderBitrateModeCBRSupported(bl2);
        }
        return serverVideoProducerConfig;
    }

    private boolean start() {
        if (this.mSurfaceInputVideoEncoder != null) {
            return this.mInputSurface != null;
        }
        LiteavLog.i(this.mTAG, "Start hw video encoder. %s", this.mParams);
        this.mSurfaceInputVideoEncoder = new ak(this.mSessionStates, new com.tencent.liteav.videobase.videobase.f(), VideoProducerDef.StreamType.a);
        this.mSurfaceInputVideoEncoder.a();
        HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
        this.mSurfaceInputVideoEncoder.a(hardwareVideoEncoder2.getServerVideoProducerConfig(hardwareVideoEncoder2.mServerConfig));
        Pair<Surface, Size> pair = this.mSurfaceInputVideoEncoder.a(this.mParams, this.mVideoEncoderListener);
        this.mInputSurface = (Surface)pair.first;
        this.mSurfaceSize.set((Size)pair.second);
        if (this.mInputSurface == null) {
            this.notifyStartEncodedFail();
            return false;
        }
        return true;
    }

    private boolean restart() {
        LiteavLog.d(this.mTAG, "reStart");
        this.stop();
        return this.start();
    }

    @CalledByNative
    public static PixelFrame createPixelFrameByTexture(int width, int height, int bufferType, int formatType, long pts, int rotation, boolean isMirrorHorizontal, boolean isMirrorVertical, int textureId, Object glContext) {
        if (bufferType != GLConstants.PixelBufferType.b.mValue) {
        }
        GLConstants.PixelFormatType.f.getValue();
        PixelFrame pixelFrame = new PixelFrame(width, height, 0, bufferType, formatType);
        pixelFrame.setMirrorHorizontal(isMirrorHorizontal);
        pixelFrame.setMirrorVertical(isMirrorVertical);
        pixelFrame.setTextureId(textureId);
        pixelFrame.setGLContext(glContext);
        pixelFrame.setRotation(Rotation.a(rotation));
        pixelFrame.setTimestamp(pts);
        return pixelFrame;
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static Object getCurrentContext() {
        return OpenGlUtils.getCurrentContext();
    }

    @CalledByNative
    public static boolean isInUIThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    @CalledByNative
    public void encodeFrame(PixelFrame frame) {
        if (frame == null) {
            return;
        }
        if (this.mNeedRestart.getAndSet(false) && !this.restart()) {
            return;
        }
        if (this.mSurfaceInputVideoEncoder == null && !this.start()) {
            return;
        }
        frame.getGLContext();
        if (!CommonUtil.equals(frame.getGLContext(), this.mSharedContext)) {
            this.uninitOpenGLComponents();
        }
        if (this.mEGLCore == null && !this.initOpenGLComponents(frame.getGLContext(), this.mInputSurface)) {
            return;
        }
        try {
            this.mEGLCore.makeCurrent();
            PixelFrame pixelFrame = new PixelFrame(frame);
            if (pixelFrame.getRotation() == Rotation.b || pixelFrame.getRotation() == Rotation.d) {
                PixelFrame pixelFrame2 = pixelFrame;
                pixelFrame2.setMirrorHorizontal(!pixelFrame2.isMirrorHorizontal());
            } else {
                PixelFrame pixelFrame3 = pixelFrame;
                pixelFrame3.setMirrorVertical(!pixelFrame3.isMirrorVertical());
            }
            OpenGlUtils.glViewport(0, 0, this.mSurfaceSize.width, this.mSurfaceSize.height);
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a(pixelFrame, GLConstants.GLScaleType.a, null);
            }
            this.mSurfaceInputVideoEncoder.a(pixelFrame.getTimestamp());
            if (pixelFrame.getTimestamp() < this.mPreFrameTimeStamp) {
                LiteavLog.e(this.mTAG, "timestamp is not increase. pre: " + this.mPreFrameTimeStamp + ", cur: " + pixelFrame.getTimestamp());
            }
            this.mPreFrameTimeStamp = pixelFrame.getTimestamp();
            this.mEGLCore.setPresentationTime(TimeUnit.MILLISECONDS.toNanos(pixelFrame.getTimestamp()));
            this.mEGLCore.swapBuffers();
            return;
        }
        catch (f f2) {
            String string = "VideoEncode: swapBuffer error, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage();
            LiteavLog.e(this.mThrottlers.a("EncodeFrameError"), this.mTAG, "makeCurrent failed. error = ".concat(String.valueOf(string)), f2);
            this.notifyEncodeFail();
            return;
        }
    }

    private boolean initOpenGLComponents(Object sharedContext, Surface surface) {
        if (surface == null) {
            LiteavLog.w(this.mThrottlers.a("NoSurface"), this.mTAG, "init opengl: surface is null.", new Object[0]);
            return false;
        }
        LiteavLog.d(this.mThrottlers.a("initGL"), this.mTAG, "initOpenGLComponents", new Object[0]);
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(sharedContext, surface, this.mSurfaceSize.width, this.mSurfaceSize.height);
        }
        catch (f f2) {
            String string = "VideoEncode: create EGLCore failed, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage();
            LiteavLog.e(this.mThrottlers.a("initGLError"), this.mTAG, "create EGLCore failed. error = ".concat(String.valueOf(string)), f2);
            this.notifyStartEncodedFail();
            this.mEGLCore = null;
            return false;
        }
        this.mSharedContext = sharedContext;
        this.mPixelFrameRenderer = new j(this.mSurfaceSize.width, this.mSurfaceSize.height);
        return true;
    }

    @CalledByNative
    public void signalEndOfStream() {
        if (this.mSurfaceInputVideoEncoder != null) {
            this.mSurfaceInputVideoEncoder.b();
        }
    }

    @CalledByNative
    public synchronized void release() {
        LiteavLog.d(this.mTAG, "release");
        this.mNativeHandler = 0L;
        this.stop();
    }

    private void stop() {
        this.uninitOpenGLComponents();
        if (this.mInputSurface != null) {
            this.mInputSurface.release();
            this.mInputSurface = null;
        }
        if (this.mSurfaceInputVideoEncoder != null) {
            this.mSurfaceInputVideoEncoder.c();
            this.mSurfaceInputVideoEncoder.d();
            this.mSurfaceInputVideoEncoder = null;
        }
    }

    private void uninitOpenGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        LiteavLog.d(this.mThrottlers.a("uninitGL"), this.mTAG, "uninitOpenGLComponents", new Object[0]);
        try {
            this.mEGLCore.makeCurrent();
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.b();
                this.mPixelFrameRenderer = null;
            }
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("unintGLError"), this.mTAG, "makeCurrent failed.", f2);
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    @CalledByNative
    public void setBitrate(int bitrate) {
        LiteavLog.i(this.mTAG, "SetBitrate ".concat(String.valueOf(bitrate)));
        if (this.mSurfaceInputVideoEncoder == null) {
            this.mParams.bitrate = bitrate;
            return;
        }
        this.mSurfaceInputVideoEncoder.a(bitrate);
    }

    public synchronized void notifyEncodeFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    public synchronized void notifyStartEncodedFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnStartEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    private native void nativeOnEncodedNAL(long var1, EncodedVideoFrame var3, ByteBuffer var4, int var5, int var6, int var7, int var8, long var9, long var11, long var13, long var15, long var17, long var19, int var21, int var22, boolean var23, int var24);

    private native void nativeOnEncodedFail(long var1);

    private native void nativeOnStartEncodedFail(long var1);
}

