/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.os.Looper;
import android.view.OrientationEventListener;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.SystemUtil;
import com.tencent.liteav.base.util.w;

@JNINamespace(value="liteav::video")
public class SystemNotificationMonitor
extends OrientationEventListener
implements w.a {
    private volatile w mTimer = null;
    private volatile long mListenerPtr = 0L;
    private Rotation mSensorRotation = null;
    private Rotation mDisplayRotation = null;

    @CalledByNative
    public SystemNotificationMonitor() {
        super(ContextUtils.getApplicationContext());
    }

    @CalledByNative
    public synchronized void initialize(long listenerPtr) {
        this.mListenerPtr = listenerPtr;
        if (this.mTimer != null) {
            return;
        }
        super.enable();
        this.mTimer = new w(Looper.getMainLooper(), this);
        this.mTimer.a(0, 1000);
    }

    @CalledByNative
    public synchronized void uninitialize() {
        super.disable();
        this.mListenerPtr = 0L;
        if (this.mTimer != null) {
            this.mTimer.a();
            this.mTimer = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onOrientationChanged(int orientation) {
        if (orientation == -1) {
            return;
        }
        if (orientation <= 45) ** GOTO lbl-1000
        if (orientation <= 135) {
            var2_2 = Rotation.b;
        } else if (orientation <= 225) {
            var2_2 = Rotation.c;
        } else if (orientation <= 315) {
            var2_2 = Rotation.d;
        } else lbl-1000:
        // 2 sources

        {
            var2_2 = Rotation.a;
        }
        if (this.mSensorRotation == var2_2) {
            return;
        }
        this.mSensorRotation = var2_2;
        this.mDisplayRotation = Rotation.a(SystemUtil.getDisplayRotationDegree());
        this.notifyOrientationChanged();
    }

    @Override
    public void onTimeout() {
        Rotation rotation = Rotation.a(SystemUtil.getDisplayRotationDegree());
        if (this.mDisplayRotation == rotation) {
            return;
        }
        this.mDisplayRotation = rotation;
        if (this.mSensorRotation == null) {
            this.mSensorRotation = this.getSensorRotationByDisplayRotation(rotation);
        }
        this.notifyOrientationChanged();
    }

    private synchronized void notifyOrientationChanged() {
        if (this.mListenerPtr == 0L) {
            return;
        }
        int n2 = this.mSensorRotation != null ? this.mSensorRotation.mValue : 0;
        int n3 = this.mDisplayRotation != null ? this.mDisplayRotation.mValue : 0;
        SystemNotificationMonitor.nativeSensorChanged(this.mListenerPtr, n2, n3);
    }

    private Rotation getSensorRotationByDisplayRotation(Rotation displayRotation) {
        if (displayRotation == null) {
            return Rotation.a;
        }
        switch (displayRotation) {
            case b: {
                return Rotation.d;
            }
            case c: {
                return Rotation.c;
            }
            case d: {
                return Rotation.b;
            }
        }
        return Rotation.a;
    }

    private static native void nativeSensorChanged(long var0, int var2, int var3);
}

