/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.consumer;

import android.graphics.PointF;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videoconsumer.consumer.VideoConsumerServerConfig;
import com.tencent.liteav.videoconsumer.consumer.b;
import com.tencent.liteav.videoconsumer.consumer.d;
import com.tencent.liteav.videoconsumer.consumer.e;
import com.tencent.liteav.videoconsumer.consumer.f;
import com.tencent.liteav.videoconsumer.consumer.g;
import com.tencent.liteav.videoconsumer.consumer.h;
import com.tencent.liteav.videoconsumer.consumer.i;
import com.tencent.liteav.videoconsumer.consumer.j;
import com.tencent.liteav.videoconsumer.consumer.k;
import com.tencent.liteav.videoconsumer.consumer.l;
import com.tencent.liteav.videoconsumer.consumer.m;
import com.tencent.liteav.videoconsumer.consumer.o;
import com.tencent.liteav.videoconsumer.consumer.p;
import com.tencent.liteav.videoconsumer.consumer.q;
import com.tencent.liteav.videoconsumer.consumer.s;
import com.tencent.liteav.videoconsumer.consumer.t;
import com.tencent.liteav.videoconsumer.consumer.u;
import com.tencent.liteav.videoconsumer.consumer.w;
import com.tencent.liteav.videoconsumer.consumer.x;
import com.tencent.liteav.videoconsumer.consumer.y;
import com.tencent.liteav.videoconsumer.decoder.SoftwareVideoDecoder;
import com.tencent.liteav.videoconsumer.decoder.VideoDecodeController;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.b;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import java.util.List;

@JNINamespace(value="liteav::video")
public class VideoConsumerProxy {
    private final b mConsumer;

    @CalledByNative
    public VideoConsumerProxy(@NonNull IVideoReporter reporter) {
        this.mConsumer = new b(reporter);
    }

    @CalledByNative
    public void preloadDecoder(int codecType) {
        b b2 = this.mConsumer;
        CodecType codecType2 = CodecType.a(codecType);
        b2.a(t.a(b2, codecType2), false);
    }

    @CalledByNative
    public void setServerConfig(VideoConsumerServerConfig config) {
        b b2 = this.mConsumer;
        VideoConsumerServerConfig videoConsumerServerConfig = config;
        b2.a(s.a(b2, videoConsumerServerConfig), true);
    }

    @CalledByNative
    public void start() {
        b b2 = this.mConsumer;
        b2.a(u.a(b2), false);
    }

    @CalledByNative
    public void stop(boolean isNeedClear) {
        this.mConsumer.a(isNeedClear);
    }

    @CalledByNative
    public void pause() {
        b b2 = this.mConsumer;
        b2.a(w.a(b2), false);
    }

    @CalledByNative
    public void resume() {
        b b2 = this.mConsumer;
        b2.a(x.a(b2), false);
    }

    @CalledByNative
    public int getWritableState() {
        VideoDecodeController videoDecodeController = this.mConsumer.g;
        int n2 = videoDecodeController.d();
        return (!videoDecodeController.u.get() ? (n2 > 0 ? VideoDecoderDef.a.e : VideoDecoderDef.a.d) : (n2 > 0 ? VideoDecoderDef.a.c : VideoDecoderDef.a.b)).mValue;
    }

    @CalledByNative
    public void appendNALPacket(EncodedVideoFrame packet) {
        EncodedVideoFrame encodedVideoFrame = packet;
        b b2 = this.mConsumer;
        if (encodedVideoFrame == null || encodedVideoFrame.data == null) {
            LiteavLog.w(b2.a, "packet or packet.data is null,packet={%s}", encodedVideoFrame);
            return;
        }
        encodedVideoFrame.consumerChainTimestamp.setDeliverTimestamp(TimeUtil.a());
        b b3 = b2;
        b3.a(y.a(b3, encodedVideoFrame), false);
    }

    @CalledByNative
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
        b b2 = this.mConsumer;
        VideoDecoderDef.ConsumerScene consumerScene = scene;
        b2.a(d.a(b2, consumerScene), false);
    }

    @CalledByNative
    public void setRenderMirrorEnabled(boolean enabled) {
        b b2 = this.mConsumer;
        b2.a(e.a(b2, enabled), true);
    }

    @CalledByNative
    public void setRenderRotation(Rotation rotation) {
        b b2 = this.mConsumer;
        Rotation rotation2 = rotation;
        b2.a(f.a(b2, rotation2), true);
    }

    @CalledByNative
    public void setScaleType(GLConstants.GLScaleType scaleType) {
        b b2 = this.mConsumer;
        GLConstants.GLScaleType gLScaleType = scaleType;
        b2.a(g.a(b2, gLScaleType), true);
    }

    @CalledByNative
    public void setDecoderStrategy(VideoDecodeController.DecodeStrategy decodeStrategy) {
        b b2 = this.mConsumer;
        VideoDecodeController.DecodeStrategy decodeStrategy2 = decodeStrategy;
        b2.a(h.a(b2, decodeStrategy2), true);
    }

    @CalledByNative
    public void setDisplayTarget(DisplayTarget target) {
        b b2 = this.mConsumer;
        DisplayTarget displayTarget = target;
        b2.a(i.a(b2, displayTarget), false);
    }

    @CalledByNative
    public void takeSnapshot(SnapshotSourceType sourceType, TakeSnapshotListener listener) {
        b b2 = this.mConsumer;
        TakeSnapshotListener takeSnapshotListener = listener;
        SnapshotSourceType snapshotSourceType = sourceType;
        b2.a(j.a(b2, snapshotSourceType, takeSnapshotListener), false);
    }

    @CalledByNative
    public void setHWDecoderDeviceRelatedParams(String params) {
        String string = params;
        b b2 = this.mConsumer;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            b b3 = b2;
            b3.a(k.a(b3, string), true);
        }
    }

    @CalledByNative
    public void setCustomRenderListener(GLConstants.PixelFormatType formatType, GLConstants.PixelBufferType bufferType, VideoRenderListener listener) {
        b b2 = this.mConsumer;
        VideoRenderListener videoRenderListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = formatType;
        b2.a(l.a(b2, pixelFormatType, pixelBufferType, videoRenderListener), false);
    }

    @CalledByNative
    public void setSharedEGLContext(Object sharedContext) {
        Object object = sharedContext;
        b b2 = this.mConsumer;
        LiteavLog.i(b2.a, "setSharedEGLContext(object:" + object + ")");
        b b3 = b2;
        b3.a(m.a(b3, object), false);
    }

    @CalledByNative
    public void setPerspectiveCorrectionPoints(float[] srcPoints, float[] dstPoints) {
        b b2 = this.mConsumer;
        List<PointF> list = com.tencent.liteav.videobase.utils.e.a(dstPoints);
        List<PointF> list2 = com.tencent.liteav.videobase.utils.e.a(srcPoints);
        b2.a(q.a(b2, list2, list), false);
    }

    @CalledByNative
    public void initialize() {
        b b2 = this.mConsumer;
        LiteavLog.i(b2.a, "initialize videoConsumer");
        b b3 = b2;
        b3.a(o.a(b3), false);
    }

    @CalledByNative
    public void uninitialize() {
        b b2 = this.mConsumer;
        b2.a(false);
        b b3 = b2;
        b3.a(p.a(b3), false);
    }

    @CalledByNative
    public long getCurrentRenderTimeStamp() {
        return this.mConsumer.y.get();
    }

    @CalledByNative
    public static VideoDecoderDef.DecodeAbility getDecodeAbility() {
        com.tencent.liteav.videoconsumer.decoder.b b2 = b.a.a();
        b.a.a().a.a = SoftwareVideoDecoder.nativeIsRpsDecodeSupport();
        return b2.a;
    }
}

