/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.producer;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;

@JNINamespace(value="liteav::video")
public class ServerVideoProducerConfig {
    static final String mTAG = "ServerVideoProducerConfig";
    private int hardwareEncodeType = 2;
    private boolean hardwareEncoderHighProfileEnable = true;
    private boolean hardwareEncoderHighProfileSupport = true;
    private int camera2SupportMinApiLevel = Integer.MAX_VALUE;
    private Rotation frontCameraRealRotation = null;
    private Rotation backCameraRealRotation = null;
    private Boolean hardwareEncoderBitrateModeCBRSupported;
    private Rotation gsensorRotationCorrection;
    private boolean mEnableCameraFpsCorrectionLogic = true;

    public static boolean isHWHevcEncodeAllowed() {
        return ServerVideoProducerConfig.nativeIsHardwareHevcEncodeAllowed();
    }

    @CalledByNative
    public ServerVideoProducerConfig() {
    }

    @CalledByNative
    public void setHardwareEncodeType(int value) {
        this.hardwareEncodeType = value;
    }

    @CalledByNative
    public void setCamera2SupportMinApiLevel(int value) {
        this.camera2SupportMinApiLevel = value;
    }

    @CalledByNative
    public void setHardwareEncoderHighProfileEnable(boolean value) {
        this.hardwareEncoderHighProfileEnable = value;
    }

    @CalledByNative
    public void setHardwareEncoderHighProfileSupport(boolean value) {
        this.hardwareEncoderHighProfileSupport = value;
    }

    @CalledByNative
    public void setHardwareEncoderBitrateModeCBRSupported(boolean supported) {
        this.hardwareEncoderBitrateModeCBRSupported = supported;
    }

    @CalledByNative
    public void setCameraRealRotation(int frontRotation, int backRotation) {
        this.frontCameraRealRotation = Rotation.b(frontRotation) ? Rotation.a(frontRotation) : null;
        this.backCameraRealRotation = Rotation.b(backRotation) ? Rotation.a(backRotation) : null;
    }

    @CalledByNative
    public void setGSensorRotationCorrection(int value) {
        if (value < 0 || value > 3) {
            return;
        }
        this.gsensorRotationCorrection = Rotation.a(value * 90);
    }

    @CalledByNative
    public void setCameraFpsCorrectionLogicEnabled(boolean value) {
        this.mEnableCameraFpsCorrectionLogic = value;
        LiteavLog.i(mTAG, "set camera fps correction logic enabled value is ".concat(String.valueOf(value)));
    }

    public int getCamera2SupportMinApiLevel() {
        return this.camera2SupportMinApiLevel;
    }

    public boolean isHardwareEncoderAllowed() {
        return this.hardwareEncodeType != 0;
    }

    public boolean isCameraFpsCorrectionLogicEnabled() {
        return this.mEnableCameraFpsCorrectionLogic;
    }

    public boolean isHardwareEncoderHighProfileAllowed() {
        return this.hardwareEncodeType == 2 && this.hardwareEncoderHighProfileEnable && this.hardwareEncoderHighProfileSupport;
    }

    public Rotation getCameraRealRotation(boolean frontCamera) {
        if (frontCamera) {
            return this.frontCameraRealRotation;
        }
        return this.backCameraRealRotation;
    }

    public Boolean isHardwareEncoderBitrateModeCBRSupported() {
        return this.hardwareEncoderBitrateModeCBRSupported;
    }

    @Nullable
    public Rotation getGsensorRotationCorrection() {
        return this.gsensorRotationCorrection;
    }

    private static native boolean nativeIsHardwareHevcEncodeAllowed();

    @NonNull
    public String toString() {
        return "hardwareEncodeType: " + this.hardwareEncodeType + ", hardwareEncoderHighProfileEnable: " + this.hardwareEncoderHighProfileEnable + ", hardwareEncoderHighProfileSupport: " + this.hardwareEncoderHighProfileSupport + ", camera2SupportMinApiLevel: " + this.camera2SupportMinApiLevel + ", frontCameraRealRotation: " + (Object)((Object)this.frontCameraRealRotation) + ", backCameraRealRotation: " + (Object)((Object)this.backCameraRealRotation) + ", hardwareEncoderBitrateModeCBRSupported: " + this.hardwareEncoderBitrateModeCBRSupported + ", gsensorRotationCorrection: " + (Object)((Object)this.gsensorRotationCorrection);
    }
}

